/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBitwiseOperatorUsageInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                IElementType sign = node.getOperationSign();
                if (!JSTokenTypes.AND.equals(sign) && !JSTokenTypes.OR.equals(sign)) {
                    return;
                }
                JSType type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node);
                if (!(type instanceof JSBooleanType)) {
                    return;
                }
                JSExpression rOperand = node.getROperand();
                JSExpression lOperand = node.getLOperand();
                JSType rType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getElementJSType((PsiElement)rOperand, false));
                JSType lType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getElementJSType((PsiElement)lOperand, false));
                if (JSBitwiseOperatorUsageInspection.isAcceptableTypeForBitwiseOperation(rType) && JSBitwiseOperatorUsageInspection.isAcceptableTypeForBitwiseOperation(lType)) {
                    return;
                }
                ASTNode astNode = node.getNode();
                JSBinaryExpression problemNode = astNode != null ? astNode.findChildByType(sign).getPsi() : node;
                holder.registerProblem((PsiElement)problemNode, JavaScriptBundle.message((String)"js.bitwise.operator.usage.popup", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceBitwiseOperatorQuickFix(sign)});
            }
        };
    }

    private static boolean isAcceptableTypeForBitwiseOperation(@Nullable JSType rType) {
        if (rType == null) {
            return false;
        }
        if (rType instanceof JSNumberType) {
            return true;
        }
        if (rType instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)rType).resolveType();
            return info.isEnum() || info.isEnumLiteral();
        }
        return false;
    }

    static class ReplaceBitwiseOperatorQuickFix
    implements LocalQuickFix {
        @NotNull
        private final IElementType myNewOperator;
        private final String myNewOperatorText;

        ReplaceBitwiseOperatorQuickFix(IElementType originalOperator) {
            Object object = JSTokenTypes.AND.equals(originalOperator) ? JSTokenTypes.ANDAND : (this.myNewOperator = JSTokenTypes.OR.equals(originalOperator) ? JSTokenTypes.OROR : null);
            if (this.myNewOperator == null) {
                throw new IllegalArgumentException("Replace bitwise operator must be & or |");
            }
            this.myNewOperatorText = JSTokenTypes.ANDAND.equals(this.myNewOperator) ? "&&" : "||";
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.bitwise.operator.usage.quickfix", (Object[])new Object[]{this.myNewOperatorText});
            if (string == null) {
                ReplaceBitwiseOperatorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ReplaceBitwiseOperatorQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceBitwiseOperatorQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) instanceof LeafElement) {
                LeafElement oldLeaf = (LeafElement)element;
                LeafElement newLeaf = ASTFactory.leaf((IElementType)this.myNewOperator, (CharSequence)this.myNewOperatorText);
                CodeEditUtil.setNodeGenerated((ASTNode)newLeaf, (boolean)true);
                oldLeaf.getTreeParent().replaceChild((ASTNode)oldLeaf, (ASTNode)newLeaf);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection$ReplaceBitwiseOperatorQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection$ReplaceBitwiseOperatorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

