/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6AssignmentProperty;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ShorthandObjectPropertyInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    public static final String SHORT_NAME = ES6ShorthandObjectPropertyInspection.calcShortNameFromClass(ES6ShorthandObjectPropertyInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSDestructuringProperty(JSDestructuringProperty property) {
                boolean canBeShorthanded;
                if (!ES6ShorthandObjectPropertyInspection.isES6((PsiElement)property)) {
                    return;
                }
                boolean isShorthand = property instanceof JSDestructuringShorthandedProperty;
                if (isShorthand) {
                    this.registerExpandFix((JSElement)property, (LocalQuickFix)new ExpandShorthandQuickFix((PsiElement)property));
                    return;
                }
                JSInitializerOwner destructuringElement = property.getDestructuringElement();
                boolean bl = canBeShorthanded = destructuringElement instanceof JSVariable && !property.isRest() && StringUtil.equals((CharSequence)destructuringElement.getName(), (CharSequence)property.getName());
                if (canBeShorthanded) {
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JavaScriptBundle.message((String)"js.property.can.be.replaced.with.shorthand", (Object[])new Object[0]), (LocalQuickFix)new ReplaceWithShorthandQuickFix((PsiElement)property));
                }
            }

            public void visitJSProperty(JSProperty property) {
                boolean canBeShorthanded;
                boolean isShorthand;
                if (!ES6ShorthandObjectPropertyInspection.isES6((PsiElement)property)) {
                    return;
                }
                if (property.isGetProperty() || property.isSetProperty()) {
                    return;
                }
                boolean bl = isShorthand = property instanceof ES6Property && ((ES6Property)property).isShorthanded() || property instanceof ES6AssignmentProperty;
                if (isShorthand || property instanceof JSFunctionProperty) {
                    LocalQuickFixOnPsiElement fix = property instanceof JSFunctionProperty ? new ExpandFunctionPropertyQuickFix((PsiElement)property) : new ExpandShorthandQuickFix((PsiElement)property);
                    this.registerExpandFix((JSElement)property, (LocalQuickFix)fix);
                    return;
                }
                String name = property.getName();
                if (StringUtil.isEmpty((String)name) || !StringUtil.isJavaIdentifier((String)name)) {
                    return;
                }
                JSExpression value = property.getValue();
                JSAssignmentExpression assignment = value instanceof JSAssignmentExpression ? (JSAssignmentExpression)value : null;
                boolean bl2 = canBeShorthanded = ES6ShorthandObjectPropertyInspection.referenceExpressionMatchesName(value, property.getName()) || assignment != null && assignment.getDefinitionExpression() != null && ES6ShorthandObjectPropertyInspection.referenceExpressionMatchesName(assignment.getDefinitionExpression().getExpression(), property.getName());
                if (canBeShorthanded) {
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JavaScriptBundle.message((String)"js.property.can.be.replaced.with.shorthand", (Object[])new Object[0]), (LocalQuickFix)new ReplaceWithShorthandQuickFix((PsiElement)property));
                    return;
                }
                if (value instanceof JSFunctionExpression && !property.isGetProperty() && !property.isSetProperty()) {
                    ProblemHighlightType highlightType = ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                    JSFunctionExpression function2 = (JSFunctionExpression)value;
                    if (function2.isArrowFunction()) {
                        if (!holder.isOnTheFly() || function2.isReferencesThis()) {
                            return;
                        }
                        highlightType = ProblemHighlightType.INFORMATION;
                    }
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JavaScriptBundle.message((String)"js.property.can.be.replaced.with.shorthand.method", (Object[])new Object[0]), (LocalQuickFix)new ReplaceWithFunctionPropertyQuickFix((PsiElement)property), highlightType);
                }
            }

            private void registerShorthandFix(PsiNameIdentifierOwner element, @NotNull @InspectionMessage String description, @NotNull LocalQuickFix fix) {
                if (description == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fix == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.registerShorthandFix(element, description, fix, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            }

            private void registerShorthandFix(@NotNull PsiNameIdentifierOwner element, @NotNull @InspectionMessage String description, @NotNull LocalQuickFix fix, @NotNull ProblemHighlightType highlightType) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (description == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (fix == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (highlightType == null) {
                    1.$$$reportNull$$$0(5);
                }
                InspectionManager inspectionManager = holder.getManager();
                Couple<PsiElement> range = this.findElementsRange(element, highlightType);
                if (range == null) {
                    return;
                }
                ProblemDescriptor problemDescriptor = inspectionManager.createProblemDescriptor((PsiElement)range.first, (PsiElement)range.second, description, highlightType, holder.isOnTheFly(), new LocalQuickFix[]{fix});
                holder.registerProblem(problemDescriptor);
            }

            @Nullable
            private Couple<PsiElement> findElementsRange(@NotNull PsiNameIdentifierOwner element, @NotNull ProblemHighlightType highlightType) {
                PsiElement startElement;
                if (element == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (highlightType == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((startElement = element.getNameIdentifier()) == null) {
                    return null;
                }
                PsiElement endElement = null;
                if (element instanceof JSProperty && this.isInFixOnlyMode(highlightType)) {
                    JSExpression expression = ((JSProperty)element).getInitializer();
                    if (expression instanceof JSFunctionExpression) {
                        JSFunctionExpression function2 = (JSFunctionExpression)expression;
                        if (!function2.isShorthandArrowFunction()) {
                            JSBlockStatement block = function2.getBlock();
                            endElement = block != null ? block.getFirstChild() : null;
                        } else {
                            ASTNode arrowNode = function2.getNode().findChildByType(JSTokenTypes.ARROWS);
                            if (arrowNode != null) {
                                endElement = arrowNode.getPsi();
                            }
                        }
                    } else if (expression instanceof JSReferenceExpression) {
                        endElement = expression;
                    }
                }
                if (endElement == null) {
                    PsiElement nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)startElement);
                    endElement = nextSibling != null && nextSibling.getNode().getElementType() == JSTokenTypes.COLON ? nextSibling : startElement;
                }
                return Couple.of((Object)startElement, endElement);
            }

            private boolean isInFixOnlyMode(@NotNull ProblemHighlightType highlightType) {
                HighlightDisplayKey toolKey;
                if (highlightType == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (highlightType == ProblemHighlightType.INFORMATION) {
                    return true;
                }
                Project project = holder.getProject();
                PsiFile file2 = holder.getFile();
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
                return profile.getErrorLevel(toolKey = HighlightDisplayKey.find((String)SHORT_NAME), (PsiElement)file2) == HighlightDisplayLevel.DO_NOT_SHOW;
            }

            private void registerExpandFix(JSElement element, LocalQuickFix fix) {
                if (holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)element, fix.getFamilyName(), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "description";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fix";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "highlightType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerShorthandFix";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findElementsRange";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInFixOnlyMode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isES6(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(2);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && (dialect.isECMA6 || dialect.isTypeScript);
    }

    private static boolean referenceExpressionMatchesName(@Nullable JSExpression value, @Nullable String name) {
        return value instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)value, name);
    }

    private static <T extends JSElement> void transformProperty(@Nullable T sourceProperty, @NotNull NullableFunction<? super T, ? extends JSElement> createReplacement) {
        if (createReplacement == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(3);
        }
        if (sourceProperty == null) {
            return;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment(sourceProperty);
        JSElement replacement = (JSElement)createReplacement.fun(sourceProperty);
        if (replacement == null) {
            return;
        }
        JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)replacement);
        FormatFixer.create((PsiElement)replacement, FormatFixer.Mode.Reformat).fixFormat();
    }

    private static JSProperty replacePropertyWithText(@NotNull JSProperty property, @NotNull String propertyText) {
        JSObjectLiteralExpression dummyObjectLiteral;
        if (property == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(4);
        }
        if (propertyText == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(5);
        }
        if ((dummyObjectLiteral = JSPsiElementFactory.createJSExpression("{" + propertyText + "}", (PsiElement)property, JSObjectLiteralExpression.class)).getFirstProperty() == null) {
            return null;
        }
        return (JSProperty)property.replace((PsiElement)dummyObjectLiteral.getFirstProperty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createReplacement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isES6";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "transformProperty";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "replacePropertyWithText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExpandFunctionPropertyQuickFix
    extends LocalQuickFixOnPsiElement {
        protected ExpandFunctionPropertyQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.expand.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSFunctionProperty property;
            if (project == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(6);
            }
            if ((property = (JSFunctionProperty)startElement).getName() == null) {
                return;
            }
            ES6ShorthandObjectPropertyInspection.transformProperty(property, prop -> {
                JSFunctionExpression result2 = JSFunctionsRefactoringUtil.createAnonymousFunctionExpression((JSFunction)prop);
                JSProperty resultProp = ES6ShorthandObjectPropertyInspection.replacePropertyWithText((JSProperty)prop, prop.getName() + ": " + result2.getText());
                if (resultProp == null) {
                    return null;
                }
                return resultProp;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandFunctionPropertyQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandFunctionPropertyQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceWithFunctionPropertyQuickFix
    extends LocalQuickFixOnPsiElement {
        protected ReplaceWithFunctionPropertyQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.replace.with.shorthand.method.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(6);
            }
            JSProperty property = (JSProperty)startElement;
            ES6ShorthandObjectPropertyInspection.transformProperty(property, prop -> {
                JSFunctionExpression function2;
                JSFunctionExpression jSFunctionExpression = function2 = prop != null && prop.getValue() instanceof JSFunctionExpression ? (JSFunctionExpression)prop.getValue() : null;
                if (function2 == null || prop.getName() == null) {
                    return null;
                }
                JSFunctionProperty result2 = JSFunctionsRefactoringUtil.createFunctionProperty(function2, prop.getName());
                return (JSProperty)prop.replace((PsiElement)result2);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithFunctionPropertyQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithFunctionPropertyQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExpandShorthandQuickFix
    extends LocalQuickFixOnPsiElement {
        protected ExpandShorthandQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.expand.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            ES6Property es6Property;
            if (project == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(6);
            }
            if ((es6Property = (ES6Property)ObjectUtils.tryCast((Object)startElement, ES6Property.class)) != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty(es6Property, prop -> prop.getName() == null || prop.getValue() == null ? null : ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)prop, prop.getName()));
                return;
            }
            ES6AssignmentProperty assignmentProperty = (ES6AssignmentProperty)ObjectUtils.tryCast((Object)startElement, ES6AssignmentProperty.class);
            if (assignmentProperty != null && assignmentProperty.getName() != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty(assignmentProperty, prop -> ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)assignmentProperty, assignmentProperty.getText()));
                return;
            }
            JSDestructuringShorthandedProperty destructuringProperty = (JSDestructuringShorthandedProperty)ObjectUtils.tryCast((Object)startElement, JSDestructuringShorthandedProperty.class);
            if (destructuringProperty != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty(destructuringProperty, ES6ChangeUtil::expandDestructuringProperty);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandShorthandQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandShorthandQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceWithShorthandQuickFix
    extends LocalQuickFixOnPsiElement {
        protected ReplaceWithShorthandQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.replace.with.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSProperty property;
            if (project == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(6);
            }
            if ((property = (JSProperty)ObjectUtils.tryCast((Object)startElement, JSProperty.class)) != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty(property, ES6ChangeUtil::replaceWithShorthand);
                return;
            }
            JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)ObjectUtils.tryCast((Object)startElement, JSDestructuringProperty.class);
            if (destructuringProperty != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty(destructuringProperty, ES6ChangeUtil::replaceWithShorthand);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithShorthandQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithShorthandQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

