/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.ES6MakeFunctionAsyncFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ES6PossiblyAsyncFunctionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSFunction parentFunction;
                if (!DialectDetector.hasFeature((PsiElement)node, JSLanguageFeature.ASYNC_AWAIT)) {
                    return;
                }
                if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "await") && (parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class})) != null && node.resolve() == null) {
                    this.registerProblem((PsiElement)node, parentFunction);
                }
                super.visitJSReferenceExpression(node);
            }

            private void registerProblem(@NotNull PsiElement node, @NotNull JSFunction parentFunction) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (parentFunction == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalQuickFix[] fixes = new LocalQuickFix[]{new ES6MakeFunctionAsyncFix(parentFunction)};
                holder.registerProblem(node, JavaScriptBundle.message((String)"js.await.in.synchronous.function", (Object[])new Object[0]), fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parentFunction";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection$1";
                objectArray[2] = "registerProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

