/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6DestructuringVariablesMergeInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6DestructuringVariablesMergeInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6DestructuringVariablesMergeInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSDestructuringObject(JSDestructuringObject destructuringObject) {
                this.annotateObject(destructuringObject);
                super.visitJSDestructuringObject(destructuringObject);
            }

            private void annotateObject(JSDestructuringObject object) {
                MultiMap properties = MultiMap.createLinkedSet();
                for (JSDestructuringProperty property : object.getProperties()) {
                    String name = property.getName();
                    if (name == null) {
                        return;
                    }
                    properties.putValue((Object)name, (Object)property);
                }
                for (Map.Entry entry : properties.entrySet()) {
                    Collection allProperties = (Collection)entry.getValue();
                    if (!ES6DestructuringVariablesMergeInspection.canMergeProperties(allProperties)) continue;
                    for (JSDestructuringProperty property : allProperties) {
                        holder.registerProblem((PsiElement)property, JavaScriptBundle.message((String)"js.destructuring.merge.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{new MergeDestructuringPropertiesFix()});
                    }
                }
            }
        };
    }

    private static boolean canMergeProperties(Collection<JSDestructuringProperty> properties) {
        Iterator<JSDestructuringProperty> iterator = properties.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        JSDestructuringProperty firstProperty = iterator.next();
        if (!iterator.hasNext()) {
            return false;
        }
        while (iterator.hasNext()) {
            JSDestructuringProperty nextProperty = iterator.next();
            if (ES6DestructuringVariablesMergeInspection.canMergePatterns(firstProperty.getDestructuringElement(), nextProperty.getDestructuringElement())) continue;
            return false;
        }
        return true;
    }

    private static boolean canMergePatterns(JSInitializerOwner first, JSInitializerOwner second) {
        if (first == null || second == null || first.getInitializer() != null || second.getInitializer() != null) {
            return false;
        }
        if (first instanceof JSVariable) {
            return second instanceof JSVariable;
        }
        if (first instanceof JSDestructuringElement && second instanceof JSDestructuringElement) {
            JSDestructuringContainer firstTarget = ((JSDestructuringElement)first).getTarget();
            JSDestructuringContainer secondTarget = ((JSDestructuringElement)second).getTarget();
            if (firstTarget instanceof JSDestructuringObject && secondTarget instanceof JSDestructuringObject) {
                JSDestructuringProperty[] firstProperties = ((JSDestructuringObject)firstTarget).getProperties();
                Pair<Set<String>, Boolean> firstNames = ES6DestructuringVariablesMergeInspection.getNamesAndRest(firstProperties);
                JSDestructuringProperty[] secondProperties = ((JSDestructuringObject)secondTarget).getProperties();
                Pair<Set<String>, Boolean> secondNames = ES6DestructuringVariablesMergeInspection.getNamesAndRest(secondProperties);
                if (!((Boolean)firstNames.second).booleanValue() && !((Boolean)secondNames.second).booleanValue()) {
                    return true;
                }
                return ((Set)firstNames.first).containsAll((Collection)secondNames.first) && ((Set)secondNames.first).containsAll((Collection)firstNames.first);
            }
            if (firstTarget instanceof JSDestructuringArray && secondTarget instanceof JSDestructuringArray) {
                JSInitializerOwner[] firstElements = ((JSDestructuringArray)firstTarget).getElements();
                JSInitializerOwner[] secondElements = ((JSDestructuringArray)secondTarget).getElements();
                JSDestructuringArrayRestElement firstRest = ((JSDestructuringArray)firstTarget).getRestElement();
                JSDestructuringArrayRestElement secondRest = ((JSDestructuringArray)secondTarget).getRestElement();
                if (firstRest != null && firstRest.getVariable() == null) {
                    return false;
                }
                if (secondRest != null && secondRest.getVariable() == null) {
                    return false;
                }
                return firstElements.length == secondElements.length || firstRest == null && secondRest == null;
            }
            return false;
        }
        return false;
    }

    private static Pair<Set<String>, Boolean> getNamesAndRest(JSDestructuringProperty[] firstProperties) {
        HashSet<String> firstNames = new HashSet<String>(firstProperties.length);
        boolean firstHasRest = false;
        for (JSDestructuringProperty property : firstProperties) {
            if (property.isRest()) {
                firstHasRest = true;
                continue;
            }
            firstNames.add(property.getName());
        }
        return Pair.create(firstNames, (Object)firstHasRest);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/ES6DestructuringVariablesMergeInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MergeDestructuringPropertiesFix
    implements LocalQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.destructuring.merge.inspection.fix", (Object[])new Object[0]);
            if (string == null) {
                MergeDestructuringPropertiesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                MergeDestructuringPropertiesFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MergeDestructuringPropertiesFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor2.getPsiElement();
            assert (element instanceof JSDestructuringProperty);
            String name = ((JSDestructuringProperty)element).getName();
            JSDestructuringObject object = (JSDestructuringObject)ObjectUtils.tryCast((Object)element.getParent(), JSDestructuringObject.class);
            assert (object != null);
            Stream<JSDestructuringProperty> properties = Arrays.stream(object.getProperties());
            MergeDestructuringPropertiesFix.mergeProperties(name, properties);
        }

        private static void mergeProperties(String name, Stream<JSDestructuringProperty> properties) {
            List<JSDestructuringProperty> sameNamedProperties = properties.filter(p -> Objects.equals(name, p.getName())).collect(Collectors.toList());
            assert (sameNamedProperties.size() > 1);
            List<JSInitializerOwner> destructuringElement = MergeDestructuringPropertiesFix.createMergedProperties(name, sameNamedProperties);
            JSDestructuringProperty firstProperty = sameNamedProperties.get(0);
            Objects.requireNonNull(firstProperty.getDestructuringElement()).replace((PsiElement)destructuringElement.get(0));
            for (int i = 1; i < sameNamedProperties.size(); ++i) {
                sameNamedProperties.get(i).delete();
            }
        }

        private static List<JSInitializerOwner> createMergedProperties(String key, Collection<JSDestructuringProperty> sameNamedProperties) {
            List sorted = ContainerUtil.sorted(sameNamedProperties, Comparator.comparing(e -> key.equals(e.getName()) ? "__" + key : e.getName()));
            Iterator iterator = sorted.iterator();
            JSInitializerOwner destructuringElement = ((JSDestructuringProperty)iterator.next()).getDestructuringElement();
            assert (destructuringElement != null);
            LinkedList<JSInitializerOwner> allResults = new LinkedList<JSInitializerOwner>();
            while (iterator.hasNext()) {
                JSInitializerOwner nextElement = ((JSDestructuringProperty)iterator.next()).getDestructuringElement();
                assert (nextElement != null);
                if (ES6DestructuringVariablesMergeInspection.canMergePatterns(destructuringElement, nextElement)) {
                    destructuringElement = MergeDestructuringPropertiesFix.merge(destructuringElement, nextElement);
                    continue;
                }
                allResults.add(nextElement);
            }
            allResults.add(0, destructuringElement);
            return allResults;
        }

        @NotNull
        private static JSInitializerOwner merge(@NotNull JSInitializerOwner first, @NotNull JSInitializerOwner second) {
            if (first == null) {
                MergeDestructuringPropertiesFix.$$$reportNull$$$0(3);
            }
            if (second == null) {
                MergeDestructuringPropertiesFix.$$$reportNull$$$0(4);
            }
            if (first instanceof JSVariable) {
                assert (second instanceof JSVariable);
                ReferencesSearch.search((PsiElement)second).forEach(r -> r.bindToElement((PsiElement)first));
                JSInitializerOwner jSInitializerOwner = first;
                if (jSInitializerOwner == null) {
                    MergeDestructuringPropertiesFix.$$$reportNull$$$0(5);
                }
                return jSInitializerOwner;
            }
            assert (first instanceof JSDestructuringElement);
            assert (second instanceof JSDestructuringElement);
            JSDestructuringContainer firstTarget = ((JSDestructuringElement)first).getTarget();
            JSDestructuringContainer secondTarget = ((JSDestructuringElement)second).getTarget();
            if (firstTarget instanceof JSDestructuringArray) {
                int i;
                assert (secondTarget instanceof JSDestructuringArray);
                JSInitializerOwner[] firstElements = ((JSDestructuringArray)firstTarget).getElements();
                JSDestructuringArrayRestElement firstRest = ((JSDestructuringArray)firstTarget).getRestElement();
                JSInitializerOwner[] secondElements = ((JSDestructuringArray)secondTarget).getElements();
                JSDestructuringArrayRestElement secondRest = ((JSDestructuringArray)secondTarget).getRestElement();
                int length = Math.max(firstElements.length, secondElements.length);
                StringBuilder builder = new StringBuilder("[");
                for (i = 0; i < length; ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    JSInitializerOwner firstItem = MergeDestructuringPropertiesFix.getArrayElement(firstElements, i);
                    JSInitializerOwner secondItem = MergeDestructuringPropertiesFix.getArrayElement(secondElements, i);
                    if (firstItem == null && secondItem == null) continue;
                    if (firstItem != null && secondItem != null) {
                        builder.append(MergeDestructuringPropertiesFix.merge(firstItem, secondItem).getText());
                        continue;
                    }
                    JSInitializerOwner notNull = firstItem == null ? secondItem : firstItem;
                    builder.append(notNull.getText());
                }
                if (firstRest != null && secondRest != null) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append("...").append(MergeDestructuringPropertiesFix.merge((JSInitializerOwner)Objects.requireNonNull(firstRest.getVariable()), (JSInitializerOwner)Objects.requireNonNull(secondRest.getVariable())).getText());
                } else if (firstRest != null || secondRest != null) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append("...").append(Objects.requireNonNull(((JSDestructuringArrayRestElement)ObjectUtils.coalesce((Object)firstRest, (Object)secondRest)).getVariable()).getText());
                }
                builder.append("]");
                JSVarStatement varStatement = JSPsiElementFactory.createJSStatement("var " + builder, (PsiElement)firstTarget, JSVarStatement.class);
                JSInitializerOwner jSInitializerOwner = varStatement.getDeclarations()[0];
                if (jSInitializerOwner == null) {
                    MergeDestructuringPropertiesFix.$$$reportNull$$$0(6);
                }
                return jSInitializerOwner;
            }
            if (firstTarget instanceof JSDestructuringObject) {
                assert (secondTarget instanceof JSDestructuringObject);
                MultiMap allProperties = MultiMap.createLinkedSet();
                JSDestructuringProperty firstRest = null;
                JSDestructuringProperty secondRest = null;
                for (JSDestructuringProperty property : ((JSDestructuringObject)firstTarget).getProperties()) {
                    if (property.isRest()) {
                        firstRest = property;
                        continue;
                    }
                    allProperties.putValue((Object)property.getName(), (Object)property);
                }
                for (JSDestructuringProperty property : ((JSDestructuringObject)secondTarget).getProperties()) {
                    if (property.isRest()) {
                        secondRest = property;
                        continue;
                    }
                    allProperties.putValue((Object)property.getName(), (Object)property);
                }
                StringBuilder builder = new StringBuilder("{");
                boolean isFirst = true;
                for (Map.Entry entry : allProperties.entrySet()) {
                    if (!isFirst) {
                        builder.append(", ");
                    }
                    String key = (String)entry.getKey();
                    List<JSInitializerOwner> mergedProperties = MergeDestructuringPropertiesFix.createMergedProperties(key, (Collection)entry.getValue());
                    boolean isInnerFirst = true;
                    for (JSInitializerOwner mergedProperty : mergedProperties) {
                        String propText;
                        if (!isInnerFirst) {
                            builder.append(", ");
                        }
                        if (key.equals(propText = mergedProperty.getText())) {
                            builder.append(key);
                        } else {
                            builder.append(key).append(": ").append(propText);
                        }
                        isInnerFirst = false;
                    }
                    isFirst = false;
                }
                if (firstRest != null && secondRest != null) {
                    if (!isFirst) {
                        builder.append(", ");
                    }
                    builder.append("...").append(MergeDestructuringPropertiesFix.merge(Objects.requireNonNull(firstRest.getDestructuringElement()), Objects.requireNonNull(secondRest.getDestructuringElement())).getText());
                } else if (firstRest != null || secondRest != null) {
                    if (!isFirst) {
                        builder.append(", ");
                    }
                    builder.append(((JSDestructuringProperty)ObjectUtils.coalesce((Object)firstRest, (Object)secondRest)).getText());
                }
                builder.append("}");
                JSVarStatement varStatement = JSPsiElementFactory.createJSStatement("var " + builder, (PsiElement)firstTarget, JSVarStatement.class);
                JSInitializerOwner jSInitializerOwner = varStatement.getDeclarations()[0];
                if (jSInitializerOwner == null) {
                    MergeDestructuringPropertiesFix.$$$reportNull$$$0(7);
                }
                return jSInitializerOwner;
            }
            throw new UnsupportedOperationException("Unknown target: " + (firstTarget == null ? first.getClass() : firstTarget.getClass()));
        }

        @Nullable
        private static JSInitializerOwner getArrayElement(JSInitializerOwner[] items, int index) {
            if (index >= items.length) {
                return null;
            }
            JSInitializerOwner item = items[index];
            return item instanceof JSEmptyExpression ? null : item;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6DestructuringVariablesMergeInspection$MergeDestructuringPropertiesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "second";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6DestructuringVariablesMergeInspection$MergeDestructuringPropertiesFix";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

