/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JSConvertToForEachIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.control.JSSimplifyIfStatementFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertForInToForOfQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private final SmartPsiElementPointer<JSForInStatement> myPointer;

    public ES6ConvertForInToForOfQuickFix(@NotNull JSForInStatement node) {
        if (node == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(0);
        }
        this.myPointer = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"js.convert.for.in.to.for.of.text", (Object[])new Object[0]);
        if (string == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.convert.for.in.to.for.of.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        JSForInStatement element;
        if (project == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(4);
        }
        if ((element = (JSForInStatement)this.myPointer.getElement()) == null || !element.isValid()) {
            return false;
        }
        return new MyReferences(element).findReferences();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(5);
        }
        this.applyImpl();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(7);
        }
        this.applyImpl();
    }

    private void applyImpl() {
        JSForInStatement forInStatement = (JSForInStatement)this.myPointer.getElement();
        if (forInStatement == null || !forInStatement.isValid()) {
            return;
        }
        assert (!forInStatement.isForEach());
        MyReferences references = new MyReferences(forInStatement).keepReferences();
        if (!references.findReferences()) {
            return;
        }
        ASTNode inNode = forInStatement.getNode().findChildByType(JSTokenTypes.IN_KEYWORD);
        if (inNode == null) {
            return;
        }
        String newVarName = ES6ConvertForInToForOfQuickFix.getNewVarName(forInStatement, references);
        ES6ConvertForInToForOfQuickFix.replaceReferences(references, newVarName);
        ES6ConvertForInToForOfQuickFix.replaceHasOwnProperty(references);
        ES6ConvertForInToForOfQuickFix.replaceVariable(forInStatement, references, newVarName);
        ES6ConvertForInToForOfQuickFix.replaceInToOf(forInStatement);
    }

    private static void replaceHasOwnProperty(MyReferences references) {
        Collection<JSCallExpression> ownPropertyColl = references.getHasOwnPropertyCollection();
        if (!ownPropertyColl.isEmpty()) {
            JSLiteralExpression trueLiteral = JSPsiElementFactory.createJSExpression("true", (PsiElement)references.myElement, JSLiteralExpression.class);
            ArrayList<JSIfStatement> ifs = new ArrayList<JSIfStatement>();
            for (JSCallExpression expression : ownPropertyColl) {
                if (expression.getParent() instanceof JSIfStatement) {
                    ifs.add((JSIfStatement)expression.getParent());
                }
                expression.replace((JSExpression)trueLiteral);
            }
            if (!ifs.isEmpty()) {
                for (JSIfStatement anIf : ifs) {
                    JSSimplifyIfStatementFix.simplifyConstantStatement((JSStatement)anIf, ControlFlowUtils.isFalse(anIf.getCondition()));
                }
            }
        }
    }

    private static void replaceInToOf(JSForInStatement forInStatement) {
        ASTNode inNode = forInStatement.getNode().findChildByType(JSTokenTypes.IN_KEYWORD);
        if (inNode == null) {
            return;
        }
        PsiElement of = JSChangeUtil.createTokenElement((PsiElement)forInStatement, JSTokenTypes.OF_KEYWORD, "of");
        inNode.getPsi().replace(of);
    }

    private static void replaceVariable(JSForInStatement forInStatement, MyReferences references, String newVarName) {
        JSVarStatement varStatement = JSPsiElementFactory.createJSStatement("const " + newVarName, (PsiElement)forInStatement, JSVarStatement.class);
        PsiElement holder = references.getVariableHolder();
        holder.replace((PsiElement)varStatement);
    }

    private static void replaceReferences(MyReferences references, String newVarName) {
        Collection<JSIndexedPropertyAccessExpression> accessExpressions = references.getReferences();
        if (!accessExpressions.isEmpty()) {
            JSReferenceExpression newVarRef = JSPsiElementFactory.createJSExpression(newVarName, (PsiElement)accessExpressions.iterator().next(), JSReferenceExpression.class);
            for (JSIndexedPropertyAccessExpression expression : accessExpressions) {
                expression.replace((JSExpression)newVarRef);
            }
        }
    }

    @NotNull
    private static String getNewVarName(JSForInStatement forInStatement, MyReferences references) {
        String collectionName = references.getCollectionExpressionName();
        String newVarName = collectionName == null ? null : StringUtil.unpluralize((String)collectionName);
        String string = newVarName = newVarName == null ? JSChangeUtil.generateNewVarName(collectionName + "Item", JSChangeUtil.getScopeElementInFile((PsiElement)forInStatement)) : newVarName;
        if (string == null) {
            ES6ConvertForInToForOfQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewVarName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReferences {
        private final JSForInStatement myElement;
        private Collection<JSIndexedPropertyAccessExpression> myReferences;
        private Collection<JSCallExpression> myHasOwnPropertyCollection;
        private String myCollectionExpressionName;
        private PsiElement myVariableHolder;

        MyReferences(JSForInStatement element) {
            this.myElement = element;
        }

        public MyReferences keepReferences() {
            this.myReferences = new HashSet<JSIndexedPropertyAccessExpression>();
            this.myHasOwnPropertyCollection = new HashSet<JSCallExpression>();
            return this;
        }

        public boolean findReferences() {
            JSExpression iterableExpression = this.myElement.getCollectionExpression();
            Object object = iterableExpression = iterableExpression instanceof JSReferenceExpression ? (JSElement)((JSReferenceExpression)iterableExpression).resolve() : iterableExpression;
            if (iterableExpression == null || !iterableExpression.isValid()) {
                return false;
            }
            this.myCollectionExpressionName = iterableExpression instanceof JSNamedElement ? iterableExpression.getName() : null;
            JSStatement loopBody = this.myElement.getBody();
            if (loopBody == null) {
                return false;
            }
            this.myVariableHolder = MyReferences.findLoopIterationExpression(this.myElement);
            if (this.myVariableHolder == null) {
                return false;
            }
            PsiElement searchTarget = JSConvertToForEachIntention.resolveForInLoopIterationVariable(this.myElement);
            if (searchTarget == null || !searchTarget.isValid()) {
                return false;
            }
            Collection all2 = ReferencesSearch.search((PsiElement)searchTarget, (SearchScope)new LocalSearchScope((PsiElement)loopBody)).findAll();
            for (PsiReference reference : all2) {
                JSReferenceExpression method;
                PsiElement grand;
                if (!(reference instanceof PsiElement)) {
                    return false;
                }
                PsiElement parent = ((PsiElement)reference).getParent();
                if (parent instanceof JSIndexedPropertyAccessExpression) {
                    PsiElement resolve;
                    JSExpression qualifier = ((JSIndexedPropertyAccessExpression)parent).getQualifier();
                    if (qualifier instanceof JSReferenceExpression && iterableExpression.equals(resolve = ((JSReferenceExpression)qualifier).resolve())) {
                        if (this.myReferences == null) continue;
                        this.myReferences.add((JSIndexedPropertyAccessExpression)parent);
                        continue;
                    }
                } else if (parent instanceof JSArgumentList && (grand = parent.getParent()) instanceof JSCallExpression && ((JSCallExpression)grand).getMethodExpression() instanceof JSReferenceExpression && (method = (JSReferenceExpression)((JSCallExpression)grand).getMethodExpression()).getQualifier() instanceof JSReferenceExpression && iterableExpression.equals(((JSReferenceExpression)method.getQualifier()).resolve()) && "hasOwnProperty".equals(method.getReferenceName())) {
                    if (this.myHasOwnPropertyCollection == null) continue;
                    this.myHasOwnPropertyCollection.add((JSCallExpression)grand);
                    continue;
                }
                return false;
            }
            return true;
        }

        @Nullable
        private static PsiElement findLoopIterationExpression(@NotNull JSForInStatement forInStatement) {
            JSVarStatement varStatement;
            if (forInStatement == null) {
                MyReferences.$$$reportNull$$$0(0);
            }
            if ((varStatement = forInStatement.getVarDeclaration()) != null) {
                return varStatement;
            }
            return forInStatement.getVariableExpression();
        }

        public PsiElement getVariableHolder() {
            return this.myVariableHolder;
        }

        public Collection<JSIndexedPropertyAccessExpression> getReferences() {
            return this.myReferences;
        }

        public Collection<JSCallExpression> getHasOwnPropertyCollection() {
            return this.myHasOwnPropertyCollection;
        }

        public String getCollectionExpressionName() {
            return this.myCollectionExpressionName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forInStatement", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix$MyReferences", "findLoopIterationExpression"));
        }
    }
}

