/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspection.dataflow.JSControlFlowProcessor;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedAssignmentInspection
extends JSInspection {
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.visitJSFunctionDeclaration((JSFunction)node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                this.processDataFlow((JSExecutionScope)node);
            }

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                this.processDataFlow((JSExecutionScope)embeddedContent);
            }

            public void visitJSFile(JSFile file2) {
                if (file2.getContext() == null) {
                    this.processDataFlow((JSExecutionScope)file2);
                }
            }

            private void processDataFlow(JSExecutionScope scope) {
                THashMap variablesReadWithoutInitialization = new THashMap(2);
                THashMap variablesWritten = new THashMap();
                THashMap variablesOverwritten = new THashMap(2);
                THashSet variablesReferencedInInners = new THashSet(2);
                THashSet variablesWrittenInInners = new THashSet(2);
                THashSet readAtLeastOnce = new THashSet();
                JSControlFlowProcessor.processControlFlow(scope, new JSControlFlowProcessor((Map<JSVariable, Set<JSExpression>>)variablesWritten, (Map<JSExpression, JSVariable>)variablesReadWithoutInitialization, (Set<? super JSVariable>)readAtLeastOnce, (Set<String>)variablesReferencedInInners, (Set<String>)variablesWrittenInInners, (Map<JSVariable, Set<JSExpression>>)variablesOverwritten));
                HashSet<Object> reportedExpressions = new HashSet<Object>();
                for (Map.Entry e2 : variablesReadWithoutInitialization.entrySet()) {
                    if (!this.isElementFromProperScope((JSVariable)e2.getValue(), scope) || variablesWrittenInInners.contains(((JSVariable)e2.getValue()).getName())) continue;
                    JSExpression jSExpression = (JSExpression)e2.getKey();
                    holder.registerProblem((PsiElement)jSExpression, JavaScriptBundle.message((String)"js.variable.might.not.been.initialized", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
                HashMap<JSExpression, List<JSVariable>> destructuringPatterns = new HashMap<JSExpression, List<JSVariable>>();
                for (JSVariable jSVariable : variablesWritten.keySet()) {
                    if (scope instanceof JSFile || scope instanceof JSEmbeddedContent || !this.isElementFromProperScope(jSVariable, scope)) continue;
                    Set values = (Set)variablesWritten.get(jSVariable);
                    for (JSExpression expression : values) {
                        PsiElement eParent;
                        String name;
                        if (reportedExpressions.contains(expression) || variablesReferencedInInners.contains(name = jSVariable.getName()) || expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isNullLiteral() || this.isPlaceWeNotWorkingReliablyIn(expression, scope) || ((eParent = expression.getParent()) == jSVariable || PsiTreeUtil.findCommonParent((PsiElement)expression, (PsiElement)jSVariable) == eParent) && !readAtLeastOnce.contains(jSVariable) || this.postponeDestructuring(destructuringPatterns, expression, jSVariable)) continue;
                        this.reportUnusedValueProblem((JSElement)expression, true, false);
                        reportedExpressions.add(expression);
                    }
                }
                variablesOverwritten.forEach((arg_0, arg_1) -> this.lambda$processDataFlow$0(reportedExpressions, scope, (Set)variablesReferencedInInners, destructuringPatterns, arg_0, arg_1));
                for (Map.Entry entry : destructuringPatterns.entrySet()) {
                    List problems = (List)entry.getValue();
                    JSElement pattern = JSUnusedAssignmentInspection.getDestructuringAssignmentTarget((JSExpression)entry.getKey());
                    if (pattern == null || problems.isEmpty()) continue;
                    ArrayList<JSElement> reported = new ArrayList<JSElement>();
                    Set problemVarNames = ContainerUtil.map2Set((Collection)problems, p -> p.getName());
                    this.collectReportedElements(pattern, problemVarNames, reported);
                    problemVarNames.removeAll(ContainerUtil.map2Set(reported, e -> e instanceof JSReferenceExpression ? ((JSReferenceExpression)e).getReferenceName() : e.getName()));
                    boolean allInDestructuring = problemVarNames.isEmpty();
                    for (JSElement element : reported) {
                        if (reportedExpressions.contains(element)) continue;
                        this.reportUnusedValueProblem(element, true, allInDestructuring);
                        reportedExpressions.add(element);
                    }
                }
            }

            private void collectReportedElements(@NotNull JSElement destructuringPart, @NotNull Set<String> variableNames, @NotNull List<JSElement> reported) {
                if (destructuringPart == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (variableNames == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (reported == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (destructuringPart instanceof JSDestructuringObject) {
                    for (JSDestructuringProperty property : ((JSDestructuringObject)destructuringPart).getProperties()) {
                        this.addFromDestructuringElement(variableNames, reported, property.getDestructuringElement());
                    }
                } else if (destructuringPart instanceof JSDestructuringArray) {
                    for (JSInitializerOwner element : ((JSDestructuringArray)destructuringPart).getElements()) {
                        this.addFromDestructuringElement(variableNames, reported, element);
                    }
                } else if (destructuringPart instanceof JSObjectLiteralExpression) {
                    for (JSProperty property : ((JSObjectLiteralExpression)destructuringPart).getProperties()) {
                        JSExpression expression = property.getValue();
                        if (expression == null) continue;
                        this.addFromExpression(variableNames, reported, expression);
                    }
                } else if (destructuringPart instanceof JSArrayLiteralExpression) {
                    for (JSExpression expression : ((JSArrayLiteralExpression)destructuringPart).getExpressions()) {
                        if (expression == null) continue;
                        this.addFromExpression(variableNames, reported, expression);
                    }
                } else if (destructuringPart instanceof JSReferenceExpression && variableNames.contains(((JSReferenceExpression)destructuringPart).getReferenceName())) {
                    reported.add(destructuringPart);
                }
            }

            private void addFromDestructuringElement(@NotNull Set<String> variableNames, @NotNull List<JSElement> reported, JSInitializerOwner element) {
                if (variableNames == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (reported == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (element instanceof JSVariable) {
                    if (variableNames.contains(element.getName())) {
                        reported.add((JSElement)element);
                    }
                } else if (element instanceof JSDestructuringElement) {
                    JSDestructuringContainer target = ((JSDestructuringElement)element).getTarget();
                    if (target != null) {
                        this.collectReportedElements((JSElement)target, variableNames, reported);
                    }
                } else if (element != null) {
                    this.collectReportedElements((JSElement)element, variableNames, reported);
                }
            }

            private void addFromExpression(@NotNull Set<String> variableNames, @NotNull List<JSElement> reported, @NotNull JSExpression expression) {
                if (variableNames == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (reported == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (expression == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!(expression instanceof JSReferenceExpression)) {
                    this.collectReportedElements((JSElement)expression, variableNames, reported);
                    return;
                }
                if (variableNames.contains(((JSReferenceExpression)expression).getReferenceName())) {
                    reported.add((JSElement)expression);
                }
            }

            private boolean isIIFE(JSExecutionScope scope) {
                return scope instanceof JSFunction && JSPsiImplUtils.isIIFE((JSFunction)scope);
            }

            private boolean postponeDestructuring(@NotNull HashMap<JSExpression, List<JSVariable>> destructuringAssignments, @NotNull JSExpression expression, @NotNull JSVariable variable) {
                JSElement pattern;
                if (destructuringAssignments == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (expression == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (variable == null) {
                    1.$$$reportNull$$$0(10);
                }
                if ((pattern = JSUnusedAssignmentInspection.getDestructuringAssignmentTarget(expression)) == null) {
                    return false;
                }
                ((List)ContainerUtil.getOrCreate(destructuringAssignments, (Object)expression, () -> new ArrayList())).add(variable);
                return true;
            }

            private boolean isPlaceWeNotWorkingReliablyIn(JSExpression key, JSExecutionScope scope) {
                JSElement place = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)key, (Class[])new Class[]{JSLoopStatement.class, JSSwitchStatement.class, scope.getClass()});
                if (place != null && place != scope) {
                    return !(place instanceof JSForInStatement) || ((JSForInStatement)place).getCollectionExpression() != key;
                }
                return false;
            }

            private boolean isElementFromProperScope(JSVariable v, JSExecutionScope scope) {
                if (PsiTreeUtil.getContextOfType((PsiElement)v, (Class[])new Class[]{JSExecutionScope.class}) != scope) {
                    return false;
                }
                return !(JSResolveUtil.findParent((PsiElement)v) instanceof JSClass);
            }

            private void reportUnusedValueProblem(@NotNull JSElement assignedExpression, boolean unused, boolean allInDestructuring) {
                if (assignedExpression == null) {
                    1.$$$reportNull$$$0(11);
                }
                PsiElement declarationOrAssignmentExpression = assignedExpression.getParent();
                JSFixFactory fixFactory = JSFixFactory.getInstance();
                if (!unused && declarationOrAssignmentExpression instanceof JSVariable) {
                    holder.registerProblem((PsiElement)assignedExpression, JavaScriptBundle.message((String)"js.variable.initializer.is.redundant", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fixFactory.removeInitializerFix()});
                } else {
                    PsiElement toHighlight = JSUnusedAssignmentInspection.getHighlightTarget(assignedExpression);
                    if (toHighlight != null) {
                        String name = toHighlight instanceof JSReferenceExpression ? ((JSReferenceExpression)toHighlight).getReferenceName() : (toHighlight instanceof PsiNamedElement ? ((PsiNamedElement)toHighlight).getName() : null);
                        String message = name != null ? JavaScriptBundle.message((String)"js.value.assigned.to.is.never.used", (Object[])new Object[]{name}) : JavaScriptBundle.message((String)"js.value.assigned.is.never.used", (Object[])new Object[0]);
                        holder.registerProblem(toHighlight, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fixFactory.removeUnusedAssignmentFix(declarationOrAssignmentExpression, allInDestructuring)});
                    }
                }
            }

            private /* synthetic */ void lambda$processDataFlow$0(Set reportedExpressions, JSExecutionScope scope, Set variablesReferencedInInners, HashMap destructuringPatterns, JSVariable variable, Set set) {
                for (JSExpression expression : set) {
                    if (reportedExpressions.contains(expression) || !this.isElementFromProperScope(variable, scope) && !this.isIIFE(scope) || variablesReferencedInInners.contains(variable.getName()) || this.isPlaceWeNotWorkingReliablyIn(expression, scope) || this.postponeDestructuring(destructuringPatterns, expression, variable)) continue;
                    this.reportUnusedValueProblem((JSElement)expression, false, false);
                    reportedExpressions.add(expression);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "destructuringPart";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variableNames";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reported";
                        break;
                    }
                    case 7: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "destructuringAssignments";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignedExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspection/JSUnusedAssignmentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "collectReportedElements";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addFromDestructuringElement";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addFromExpression";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "postponeDestructuring";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportUnusedValueProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static PsiElement getHighlightTarget(@NotNull JSElement e) {
        if (e == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(2);
        }
        PsiElement parent = e.getParent();
        PsiElement messageTarget = null;
        if (parent instanceof JSAssignmentExpression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression) {
                lOperand = ((JSDefinitionExpression)lOperand).getExpression();
            }
            messageTarget = lOperand;
        } else if (parent instanceof JSVariable) {
            messageTarget = ((JSVariable)parent).getNameIdentifier();
        } else if (parent instanceof JSDestructuringElement) {
            messageTarget = ((JSDestructuringElement)parent).getTarget();
        } else if (parent instanceof JSForInStatement) {
            JSVarStatement statement = ((JSForInStatement)parent).getVarDeclaration();
            if (statement != null) {
                return null;
            }
            messageTarget = ((JSForInStatement)parent).getVariableExpression();
        }
        if (messageTarget == null) {
            messageTarget = e;
        }
        return messageTarget;
    }

    @Nullable
    private static JSElement getDestructuringAssignmentTarget(@NotNull JSExpression assigned) {
        PsiElement assignedParent;
        JSElement assignment;
        if (assigned == null) {
            JSUnusedAssignmentInspection.$$$reportNull$$$0(3);
        }
        if ((assignment = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)assigned, (Class[])new Class[]{JSDestructuringElement.class, JSAssignmentExpression.class})) instanceof JSDestructuringElement) {
            return ((JSDestructuringElement)assignment).getTarget();
        }
        if (assignment instanceof JSAssignmentExpression) {
            JSExpression lOperand;
            JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)assignment).getDefinitionExpression();
            JSExpression jSExpression = lOperand = definitionExpression != null ? definitionExpression.getExpression() : null;
            if (lOperand instanceof JSArrayLiteralExpression || lOperand instanceof JSObjectLiteralExpression) {
                return lOperand;
            }
        }
        if ((assignedParent = assigned.getParent()) instanceof JSForInStatement) {
            JSExpression variableExpression = ((JSForInStatement)assignedParent).getVariableExpression();
            return variableExpression instanceof JSArrayLiteralExpression || variableExpression instanceof JSObjectLiteralExpression ? variableExpression : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assigned";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspection/JSUnusedAssignmentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHighlightTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDestructuringAssignmentTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

