/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.injections;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSInXmlLanguagesInjector
implements MultiHostInjector {
    @NonNls
    private static final String JAVASCRIPT_PREFIX = "javascript:";
    @NonNls
    public static final String JSP_URI = "http://java.sun.com/JSP/Page";

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends PsiElement>> list2 = Arrays.asList(XmlText.class, XmlAttributeValue.class);
        if (list2 == null) {
            JSInXmlLanguagesInjector.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        String name;
        XmlTag tag;
        String localName;
        PsiElement _tag;
        if (registrar == null) {
            JSInXmlLanguagesInjector.$$$reportNull$$$0(1);
        }
        if (host == null) {
            JSInXmlLanguagesInjector.$$$reportNull$$$0(2);
        }
        if (host instanceof XmlAttributeValue) {
            PsiElement attribute = host.getParent();
            PsiElement tag2 = attribute.getParent();
            if (attribute instanceof XmlAttribute && tag2 instanceof XmlTag) {
                String value;
                if (host.getTextLength() == 0) {
                    return;
                }
                @NonNls String attrName = ((XmlAttribute)attribute).getName();
                @NonNls String tagName = ((XmlTag)tag2).getName();
                if (tag2 instanceof HtmlTag) {
                    attrName = StringUtil.toLowerCase((String)attrName);
                    tagName = StringUtil.toLowerCase((String)tagName);
                }
                if (("href".equals(attrName) && "a".equals(tagName) || "action".equals(attrName) && "form".equals(tagName)) && StringUtil.startsWithIgnoreCase((String)(value = ((XmlAttributeValue)host).getValue()), (String)JAVASCRIPT_PREFIX)) {
                    JSInXmlLanguagesInjector.injectJSIntoAttributeValue(registrar, (XmlAttributeValue)host, true);
                }
            }
        } else if (host instanceof XmlText && (_tag = host.getParent()) instanceof XmlTag && "attribute".equals(localName = (tag = (XmlTag)_tag).getLocalName()) && JSP_URI.equals(tag.getNamespace()) && (name = tag.getAttributeValue("name")) != null && name.startsWith("on")) {
            JavascriptLanguage language = JavascriptLanguage.INSTANCE;
            JSInXmlLanguagesInjector.injectToXmlText(registrar, host, (Language)language, null, null);
        }
    }

    public static void injectToXmlText(MultiHostRegistrar registrar, PsiElement host, Language language, String prefix, String suffix) {
        TextRange range = new TextRange(0, host.getTextLength());
        registrar.startInjecting(language).addPlace(prefix, suffix, (PsiLanguageInjectionHost)host, range).doneInjecting();
    }

    public static void injectJSIntoAttributeValue(MultiHostRegistrar registrar, XmlAttributeValue host, boolean startsWithPrefix) {
        PsiElement valueChild;
        PsiElement[] myChildren = host.getChildren();
        int valueIndex = myChildren.length - 2;
        int valueTokenNumber = 1;
        if (valueIndex < 0) {
            valueIndex = 0;
            valueTokenNumber = 0;
        }
        if ((valueChild = myChildren[valueIndex]) instanceof XmlToken && ((XmlToken)valueChild).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            SmartList ownTextRanges = new SmartList();
            TextRange range = new TextRange(valueTokenNumber + (startsWithPrefix ? JAVASCRIPT_PREFIX.length() : 0), host.getTextLength() - valueTokenNumber);
            if (range.getLength() < 0) {
                return;
            }
            ownTextRanges.add(range);
            if (valueIndex != valueTokenNumber) {
                int hostOffset = host.getTextRange().getStartOffset();
                for (int i = valueTokenNumber; i < valueIndex; ++i) {
                    TextRange rightRange;
                    PsiElement currentElement = myChildren[i];
                    if (!(currentElement instanceof OuterLanguageElement)) continue;
                    TextRange currentElementRange = currentElement.getTextRange().shiftRight(-hostOffset);
                    TextRange lastRange = (TextRange)ownTextRanges.remove(ownTextRanges.size() - 1);
                    TextRange leftRange = new TextRange(lastRange.getStartOffset(), currentElementRange.getStartOffset());
                    if (leftRange.getLength() > 0) {
                        ownTextRanges.add(leftRange);
                    }
                    if ((rightRange = new TextRange(currentElementRange.getEndOffset(), lastRange.getEndOffset())).getLength() <= 0) continue;
                    ownTextRanges.add(rightRange);
                }
            }
            JavascriptLanguage language = JavascriptLanguage.INSTANCE;
            registrar.startInjecting((Language)language);
            for (TextRange textRange : ownTextRanges) {
                registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, textRange);
            }
            registrar.doneInjecting();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/injections/JSInXmlLanguagesInjector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/injections/JSInXmlLanguagesInjector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

