/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.evaluation.JSExpressionTypeFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSUnwrapPromiseType;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLocalTypeEvaluatorBase
implements JSExpressionTypeFactory {
    @Nullable
    public JSType evaluate(@Nullable JSExpression expression) {
        JSType typeFromComment;
        if (expression != null && (typeFromComment = this.evaluateTypeFromInlineComment(expression)) != null) {
            return typeFromComment;
        }
        if (expression instanceof JSPrefixExpression) {
            JSType awaitedType;
            JSExpression awaitedExpr;
            if (JSSymbolUtil.isLiteralOrLiteralWithSign(expression)) {
                return JSTypeEvaluator.getTypeFromConstant(expression);
            }
            if (((JSPrefixExpression)expression).getOperationSign() == JSTokenTypes.AWAIT_KEYWORD && (awaitedExpr = ((JSPrefixExpression)expression).getExpression()) != null && (awaitedType = this.evaluate(awaitedExpr)) != null) {
                return new JSUnwrapPromiseType(awaitedType, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression));
            }
            return this.getPsiBasedExpressionType(expression);
        }
        if (expression instanceof JSLiteralExpression) {
            return this.getLiteralExpressionType(expression);
        }
        if (expression instanceof JSArrayLiteralExpression) {
            return this.getArrayLiteralExpressionType((JSArrayLiteralExpression)expression);
        }
        if (expression instanceof JSObjectLiteralExpression) {
            return this.getObjectLiteralExpressionType((JSObjectLiteralExpression)expression);
        }
        if (expression instanceof JSConditionalExpression) {
            return this.getConditionalExpressionType((JSConditionalExpression)expression);
        }
        if (expression instanceof JSParenthesizedExpression) {
            return this.evaluate(((JSParenthesizedExpression)expression).getInnerExpression());
        }
        if (expression instanceof JSAssignmentExpression) {
            return this.getAssignmentExpressionType((JSAssignmentExpression)expression);
        }
        if (expression instanceof JSIndexedPropertyAccessExpression) {
            return this.getIndexedPropertyAccessExpressionType((JSIndexedPropertyAccessExpression)expression);
        }
        if (expression == null) {
            return new JSUndefinedType(JSLocalTypeEvaluatorBase.createTypeSource(null));
        }
        if (expression instanceof JSNewExpression) {
            return this.getNewExpressionType((JSNewExpression)expression);
        }
        if (expression instanceof JSCallExpression) {
            return this.getCallExpressionType((JSCallExpression)expression);
        }
        if (expression instanceof ES6TaggedTemplateExpression) {
            return this.getTaggedTemplateExpressionType((ES6TaggedTemplateExpression)expression);
        }
        if (expression instanceof JSReferenceExpression) {
            return this.getReferenceExpressionType((JSReferenceExpression)expression);
        }
        if (expression instanceof JSFunctionExpression) {
            return JSLocalTypeEvaluatorBase.getFunctionExpressionType((JSFunctionExpression)expression);
        }
        if (expression instanceof JSThisExpression) {
            return this.getThisExpressionType(expression);
        }
        if (expression instanceof JSBinaryExpression) {
            return this.getBinaryExpressionType((JSBinaryExpression)expression);
        }
        if (expression instanceof JSClassExpression) {
            return this.getClassExpressionType((JSClassExpression)expression);
        }
        if (expression instanceof ES6ImportCall) {
            return this.getImportCallType((ES6ImportCall)expression);
        }
        return this.getPsiBasedExpressionType(expression);
    }

    @Nullable
    public JSType getPsiBasedExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    protected JSType getTaggedTemplateExpressionType(@NotNull ES6TaggedTemplateExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(1);
        }
        JSExpression tag = expression.getTag();
        return this.getCallLikeExpressionType((JSCallLikeExpression)expression, tag);
    }

    @Nullable
    protected JSType getCallExpressionType(@NotNull JSCallExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(2);
        }
        JSExpression methodExpression = expression.getMethodExpression();
        return this.getCallLikeExpressionType((JSCallLikeExpression)expression, methodExpression);
    }

    @Nullable
    protected JSType getAssignmentExpressionType(@NotNull JSAssignmentExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(3);
        }
        return this.evaluate(expression.getROperand());
    }

    @Nullable
    protected JSType getLiteralExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(4);
        }
        return JSTypeEvaluator.getTypeFromConstant(expression);
    }

    protected JSType getClassExpressionType(@NotNull JSClassExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(5);
        }
        return new JSClassExpressionType(expression, JSTypeContext.STATIC);
    }

    @Nullable
    protected JSType getBinaryExpressionType(@NotNull JSBinaryExpression expression) {
        ASTNode node;
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(6);
        }
        if ((node = expression.getOperationNode()) == null) {
            return null;
        }
        IElementType sign = node.getElementType();
        if (JSTokenTypes.BOOLEAN_RESULT_OPERATIONS.contains(sign)) {
            return new JSBooleanType(true, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression), JSTypeContext.INSTANCE);
        }
        if (sign == JSTokenTypes.PLUS) {
            JSExpression lOperand = expression.getLOperand();
            JSType lType = this.evaluate(lOperand);
            if (lType instanceof JSStringType) {
                return JSLocalTypeEvaluatorBase.createPrimitiveStringType(expression);
            }
            JSExpression rOperand = expression.getROperand();
            JSType rType = this.evaluate(rOperand);
            JSType type = JSLocalTypeEvaluatorBase.evaluatePlusForExpandedTypes((PsiElement)expression, lType, rType);
            if (type != null) {
                return type;
            }
        }
        return null;
    }

    @NotNull
    private static JSStringType createPrimitiveStringType(@NotNull JSBinaryExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(7);
        }
        return new JSStringType(true, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression), JSTypeContext.INSTANCE);
    }

    @Nullable
    private static JSType getFunctionExpressionType(@NotNull JSFunctionExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(8);
        }
        if (expression instanceof StubBasedPsiElement) {
            return JSStubBasedExpressionType.forExpression((StubBasedPsiElement)expression);
        }
        return null;
    }

    @NotNull
    protected static JSTypeSource createTypeSource(@Nullable PsiElement context) {
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource(context, true);
        if (jSTypeSource == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(9);
        }
        return jSTypeSource;
    }

    @Nullable
    protected JSType getThisExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Nullable
    protected JSType getNewExpressionType(@NotNull JSNewExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Nullable
    protected JSType getReferenceExpressionType(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Nullable
    protected JSType getIndexedPropertyAccessExpressionType(@NotNull JSIndexedPropertyAccessExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Nullable
    protected JSType getObjectLiteralExpressionType(@NotNull JSObjectLiteralExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(14);
        }
        if (expression instanceof StubBasedPsiElement) {
            return JSStubBasedExpressionType.forExpression((StubBasedPsiElement)expression);
        }
        return null;
    }

    @Nullable
    protected JSType getArrayLiteralExpressionType(@NotNull JSArrayLiteralExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    protected JSType getConditionalExpressionType(@NotNull JSConditionalExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Nullable
    protected JSType getCallLikeExpressionType(@NotNull JSCallLikeExpression expression, @Nullable JSExpression methodExpression) {
        JSType innerType;
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(17);
        }
        if (expression instanceof JSCallExpression && ((JSCallExpression)expression).isRequireCall()) {
            return this.qetRequireCallType((JSCallExpression)expression);
        }
        JSType jSType = innerType = methodExpression != null ? this.evaluate(methodExpression) : null;
        if (innerType != null && !(innerType instanceof JSAnyType)) {
            List argumentTypes = expression.getArgumentTypes((JSExpressionTypeFactory)this);
            return new JSApplyCallType(innerType, argumentTypes, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression));
        }
        return null;
    }

    @Nullable
    private JSType qetRequireCallType(@NotNull JSCallExpression requireCall) {
        JSType module;
        if (requireCall == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(18);
        }
        if (!requireCall.isRequireCall()) {
            return null;
        }
        List arguments = requireCall.getArgumentTypes((JSExpressionTypeFactory)this);
        if (arguments.size() >= 1 && (module = (JSType)arguments.get(0)) != null) {
            return new JSRequireCallExpressionType(module, JSTypeSourceFactory.createTypeSource((PsiElement)requireCall, true));
        }
        return null;
    }

    @Nullable
    public static JSType evaluatePlusForExpandedTypes(@NotNull PsiElement context, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (context == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(19);
        }
        if (lProcType instanceof JSStringType || rProcType instanceof JSStringType) {
            return new JSStringType(true, JSLocalTypeEvaluatorBase.createTypeSource(context), JSTypeContext.INSTANCE);
        }
        if ((lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
            return new JSIntType(true, JSLocalTypeEvaluatorBase.createTypeSource(context), JSTypeContext.INSTANCE);
        }
        if ((lProcType instanceof JSNumberType || lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSNumberType || rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
            return new JSNumberType(true, JSLocalTypeEvaluatorBase.createTypeSource(context), JSTypeContext.INSTANCE);
        }
        if (lProcType instanceof JSBigIntType && rProcType instanceof JSBigIntType) {
            return new JSBigIntType(true, JSLocalTypeEvaluatorBase.createTypeSource(context), JSTypeContext.INSTANCE);
        }
        return null;
    }

    @Nullable
    protected List<JSType> getArrayNestedTypes(@NotNull JSArrayLiteralExpression expression, int limit, boolean widen) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(20);
        }
        SmartList types2 = new SmartList();
        for (JSExpression element : StreamEx.of((Stream)expression.getExpressionStream())) {
            JSType locallyEvaluatedType;
            if (element instanceof JSSpreadExpression) {
                return null;
            }
            JSType evaluate = this.evaluate(element);
            JSType jSType = locallyEvaluatedType = widen ? JSWidenType.createWidening(evaluate, null) : evaluate;
            if (locallyEvaluatedType == null) {
                return null;
            }
            types2.add(locallyEvaluatedType);
            if (types2.size() <= limit) continue;
            return null;
        }
        return types2;
    }

    @Nullable
    protected JSType evaluateTypeFromInlineComment(@NotNull JSExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(21);
        }
        return JSDocumentationUtils.findTypeFromInlineComment((PsiElement)expression);
    }

    @Nullable
    protected JSType getImportCallType(@NotNull ES6ImportCall expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(22);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluatorBase";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireCall";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluatorBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiBasedExpressionType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTaggedTemplateExpressionType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCallExpressionType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentExpressionType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralExpressionType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClassExpressionType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryExpressionType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPrimitiveStringType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionExpressionType";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getThisExpressionType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNewExpressionType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessExpressionType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getObjectLiteralExpressionType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getArrayLiteralExpressionType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getConditionalExpressionType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCallLikeExpressionType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "qetRequireCallType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusForExpandedTypes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getArrayNestedTypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypeFromInlineComment";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getImportCallType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

