/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSCustomIndexer;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndexContent {
    public static final String REQUIRE_DATA_MAIN_KEY = "js.require.data.main";
    private static final Key<JSIndexContent> ourJSIndexContent = Key.create((String)"js.index.content");
    @NotNull
    public final Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> myImplicitElements;
    @NotNull
    public final Map<String, String> myCustomSingleEntries;
    @NotNull
    private final Map<Key, Object> myAdditionalData;

    public JSIndexContent(@NotNull JSIndexContentBuilder builder) {
        if (builder == null) {
            JSIndexContent.$$$reportNull$$$0(0);
        }
        this.myImplicitElements = builder.myImplicitElements;
        this.myCustomSingleEntries = builder.myCustomSingleEntries;
        this.myAdditionalData = builder.myAdditionalData;
    }

    @NotNull
    public Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> getImplicitElements() {
        Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> map2 = this.myImplicitElements;
        if (map2 == null) {
            JSIndexContent.$$$reportNull$$$0(1);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static JSIndexContent indexFile(FileContent content) {
        JSIndexContent indexContent = (JSIndexContent)content.getUserData(ourJSIndexContent);
        if (indexContent != null) {
            JSIndexContent jSIndexContent = indexContent;
            if (jSIndexContent != null) return jSIndexContent;
            JSIndexContent.$$$reportNull$$$0(2);
            return jSIndexContent;
        }
        FileContent fileContent = content;
        // MONITORENTER : fileContent
        indexContent = (JSIndexContent)content.getUserData(ourJSIndexContent);
        if (indexContent != null) {
            JSIndexContent jSIndexContent = indexContent;
            // MONITOREXIT : fileContent
            if (jSIndexContent != null) return jSIndexContent;
            JSIndexContent.$$$reportNull$$$0(3);
            return jSIndexContent;
        }
        indexContent = JSIndexContent.isIgnoredIndexableFile(content.getFile()) ? new JSIndexContent(new JSIndexContentBuilder()) : JSIndexContent.get(JSIndexContent.getPsiFileForIndexing(content));
        content.putUserData(ourJSIndexContent, (Object)indexContent);
        JSIndexContent jSIndexContent = indexContent;
        // MONITOREXIT : fileContent
        if (jSIndexContent != null) return jSIndexContent;
        JSIndexContent.$$$reportNull$$$0(4);
        return jSIndexContent;
    }

    @NotNull
    private static PsiFile getPsiFileForIndexing(FileContent content) {
        PsiFile psiFile = content.getPsiFile();
        if (psiFile == null) {
            JSIndexContent.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @NotNull
    private static JSIndexContent createFromFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSIndexContent.$$$reportNull$$$0(6);
        }
        JSIndexContentBuilder indexBuilder = new JSIndexContentBuilder();
        JSCustomIndexer indexer = JSDialectSpecificHandlersFactory.forElement((PsiElement)file2).createCustomIndexer(file2, indexBuilder);
        JSIndexContent.acceptChildren(file2, (PsiElementVisitor)indexer);
        if (file2 instanceof JSFile) {
            indexer.processJsFile((JSFile)file2);
        }
        return new JSIndexContent(indexBuilder);
    }

    public static void acceptChildren(PsiFile file2, PsiElementVisitor visitor) {
        if (file2 instanceof JSFile) {
            return;
        }
        if (file2 instanceof XmlFile) {
            file2.acceptChildren(visitor);
            return;
        }
        FileViewProvider provider = file2.getViewProvider();
        if (!JSImplicitElementsIndex.Holder.containFileType(file2.getFileType())) {
            PsiFile psiFile = provider.getPsi((Language)HTMLLanguage.INSTANCE);
            if (psiFile != null) {
                psiFile.acceptChildren(visitor);
            }
            return;
        }
        for (PsiFile psiFile : provider.getAllFiles()) {
            psiFile.acceptChildren(visitor);
        }
    }

    @Nullable
    public <T> T getAdditionalData(@NotNull Key<T> key) {
        if (key == null) {
            JSIndexContent.$$$reportNull$$$0(7);
        }
        return (T)this.myAdditionalData.get(key);
    }

    @NotNull
    public static JSIndexContent get(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSIndexContent.$$$reportNull$$$0(8);
        }
        JSIndexContent jSIndexContent = (JSIndexContent)CachedValuesManager.getCachedValue((PsiElement)file2, () -> new CachedValueProvider.Result((Object)JSIndexContent.createFromFile(file2), new Object[]{file2}));
        if (jSIndexContent == null) {
            JSIndexContent.$$$reportNull$$$0(9);
        }
        return jSIndexContent;
    }

    public static boolean isIgnoredIndexableFile(@Nullable VirtualFile file2) {
        return file2 != null && (Boolean.TRUE.equals(file2.getUserData(JSPredefinedLibraryProvider.BUNDLED_LIBRARY_FILE)) || JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file2) || JSCorePredefinedLibrariesProvider.getFlowJSPredefinedLibraryFiles().contains(file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSIndexContent";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSIndexContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFileForIndexing";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFromFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

