/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.highlighting.DefaultJSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSemanticHighlightingUtil {
    @NonNls
    public static final String INSTANCE_FIELD = "instance field";
    @NonNls
    public static final String INSTANCE_METHOD = "instance method";
    @NonNls
    public static final String PARAMETER_MESSAGE = "parameter";
    private static final Set<String> PREDEFINED_LOCAL_VARS = ContainerUtil.newHashSet((Object[])new String[]{"exports", "require", "module", "__filename", "__dirname"});
    private static final boolean debug = ApplicationManager.getApplication().isUnitTestMode();

    protected JSSemanticHighlightingUtil() {
    }

    private static boolean isClassContext(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement context = element.getContext();
        if (context instanceof JSClass) {
            return true;
        }
        return context instanceof JSFile && context.getContext() != null;
    }

    private static boolean isTypeScriptInterfaceReference(PsiElement element) {
        return element instanceof TypeScriptObjectType && JSSemanticHighlightingUtil.isClassContext(element);
    }

    private static JSTextAttributeKeysProvider getTextAttributeKeysProvider(PsiElement element) {
        Language lang;
        JSTextAttributeKeysProvider attributeKeysProvider;
        JSTextAttributeKeysProvider result2 = DefaultJSTextAttributeKeysProvider.getInstance();
        if (element != null && (attributeKeysProvider = (JSTextAttributeKeysProvider)JSTextAttributeKeysProvider.INSTANCE.forLanguage(lang = DialectDetector.languageOfElement(element))) != null) {
            result2 = attributeKeysProvider;
        }
        return result2;
    }

    public static void highlight(JSPsiReferenceElement node, JSHighlighter highlighter, AnnotationHolder holder) {
        TextAttributeKeyInfo info;
        if (!JSSemanticHighlightingUtil.isAcceptableReferenceForHighlighting(node)) {
            return;
        }
        JSPsiReferenceElement results = node.multiResolve(false);
        if (((ResolveResult[])results).length == 0) {
            return;
        }
        if (JSResolveResult.isTooManyCandidatesResult((ResolveResult[])results) && node instanceof JSReferenceExpression) {
            TextAttributeKeyInfo info2 = JSSemanticHighlightingUtil.guessHighlightingForReference((JSReferenceExpression)node, highlighter);
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info2.type, info2.text, holder);
            return;
        }
        if (JSSemanticHighlightingUtil.isGlobalUndefined(node)) {
            holder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).textAttributes(highlighter.getMappedKey(JSHighlighter.JS_KEYWORD)).create();
            return;
        }
        if (JSSemanticHighlightingUtil.isActionScriptClass(highlighter, (ResolveResult[])results) && (info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(Objects.requireNonNull(results[0].getElement()), (PsiElement)node, highlighter)) != null) {
            JSPsiReferenceElement element;
            ASTNode genericSignature = node.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
            Object object = element = genericSignature == null ? node : node.getReferenceNameElement();
            if (element != null) {
                JSSemanticHighlightingUtil.createBuilderForHighlight(holder, info.getText()).range((PsiElement)element).textAttributes(info.getType()).create();
                return;
            }
        }
        Object2IntOpenHashMap countByTypes = new Object2IntOpenHashMap();
        boolean tsdOccurred = false;
        for (ResolveResult r : results) {
            TextAttributeKeyInfo info3;
            boolean isFromTsd;
            PsiElement resolve = r.getElement();
            if (resolve == null) continue;
            PsiFile file2 = resolve.getContainingFile();
            boolean bl = isFromTsd = file2 != null && TypeScriptUtil.isDefinitionFile(file2);
            if (isFromTsd && !tsdOccurred) {
                tsdOccurred = true;
                countByTypes = new Object2IntOpenHashMap();
            }
            if (tsdOccurred && !isFromTsd || (info3 = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, (PsiElement)node, highlighter)) == null) continue;
            countByTypes.put((Object)info3, countByTypes.getInt((Object)info3) + 1);
        }
        IntRef maxCount = new IntRef(0);
        TextAttributeKeyInfo info4 = null;
        for (Object2IntMap.Entry entry : countByTypes.object2IntEntrySet()) {
            TextAttributeKeyInfo key = (TextAttributeKeyInfo)entry.getKey();
            int count = entry.getIntValue();
            if (count > maxCount.get()) {
                maxCount.set(count);
                info4 = key;
                continue;
            }
            if (count != maxCount.get() || info4 == null || info4.text.compareTo(key.text) <= 0) continue;
            info4 = key;
        }
        if (info4 != null) {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info4.type, info4.text, holder);
        }
    }

    private static boolean isAcceptableReferenceForHighlighting(JSPsiReferenceElement node) {
        if (!(node instanceof JSReferenceExpression)) {
            return true;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)node;
        PsiElement parent = node.getParent();
        if (parent instanceof ES6Decorator || parent instanceof JSCallExpression && parent.getParent() instanceof ES6Decorator) {
            return false;
        }
        if (referenceExpression.getQualifier() != null) {
            return true;
        }
        return node.getNode().findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter) == null || !JSResolveUtil.isExprInTypeContext(referenceExpression);
    }

    private static boolean isGlobalUndefined(@NotNull JSPsiReferenceElement node) {
        if (node == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(0);
        }
        return "undefined".equals(node.getReferenceName()) && node instanceof JSQualifiedExpression && ((JSQualifiedExpression)node).getQualifier() == null;
    }

    private static boolean isActionScriptClass(@NotNull JSHighlighter highlighter, ResolveResult @NotNull [] results) {
        if (highlighter == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(1);
        }
        if (results == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(2);
        }
        return results.length == 1 && highlighter.getDialectOptionsHolder() == DialectOptionHolder.ECMA_4 && results[0].getElement() instanceof JSClass;
    }

    @NotNull
    private static TextAttributeKeyInfo guessHighlightingForReference(@NotNull JSReferenceExpression referenceExpression, JSHighlighter highlighter) {
        boolean isGlobal;
        PsiElement parent;
        if (referenceExpression == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(3);
        }
        boolean isMethod = (parent = referenceExpression.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == referenceExpression;
        boolean bl = isGlobal = referenceExpression.getQualifier() == null;
        if (isMethod) {
            TextAttributeKeyInfo textAttributeKeyInfo = isGlobal ? TextAttributeKeyInfo.globalFunction(highlighter) : TextAttributeKeyInfo.instanceMethod(highlighter, (PsiElement)referenceExpression);
            if (textAttributeKeyInfo == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(4);
            }
            return textAttributeKeyInfo;
        }
        TextAttributeKeyInfo textAttributeKeyInfo = isGlobal ? TextAttributeKeyInfo.globalVariable(highlighter, JSSemanticHighlightingUtil.getTextAttributeKeysProvider((PsiElement)referenceExpression)) : TextAttributeKeyInfo.instanceMemberVariable(highlighter);
        if (textAttributeKeyInfo == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(5);
        }
        return textAttributeKeyInfo;
    }

    public static void highlight(@NotNull PsiElement place, @NotNull PsiElement resolve, JSHighlighter highlighter, AnnotationHolder holder) {
        TextAttributeKeyInfo info;
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(6);
        }
        if (resolve == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(7);
        }
        if ((info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, place, highlighter)) != null) {
            JSSemanticHighlightingUtil.lineMarker(place, info.type, info.text, holder);
        }
    }

    @Nullable
    public static TextAttributeKeyInfo buildHighlightForResolveResult(@NotNull PsiElement resolve, @NotNull PsiElement place, JSHighlighter highlighter) {
        PsiElement targetElement;
        TextAttributeKeyInfo targetElementInfo;
        if (resolve == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(8);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(9);
        }
        return (targetElementInfo = JSSemanticHighlightingUtil.buildHighlightForElement(targetElement = JSSemanticHighlightingUtil.calculateMeaningfulElementForHighlighting(resolve), place, highlighter)) != null ? targetElementInfo : JSSemanticHighlightingUtil.buildHighlightForElement(resolve, place, highlighter);
    }

    private static TextAttributeKeyInfo buildHighlightForElement(@NotNull PsiElement resolve, @NotNull PsiElement place, JSHighlighter highlighter) {
        if (resolve == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(10);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(11);
        }
        boolean isStatic = false;
        boolean isMethod = false;
        boolean isFunction = false;
        boolean isField = false;
        TextAttributeKeyInfo info = null;
        JSTextAttributeKeysProvider attributesKeyProvider = JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place);
        TextAttributeKeyInfo dialectSpecificInfo = attributesKeyProvider.getTextAttributeKeyInfoForResolveResult(resolve, highlighter);
        if (dialectSpecificInfo != null) {
            return dialectSpecificInfo;
        }
        if (resolve instanceof JSImplicitElement) {
            PsiElement provider;
            JSImplicitElement.Type kind;
            JSImplicitElement implicitElement = (JSImplicitElement)resolve;
            if (implicitElement instanceof JSLocalImplicitElementImpl && (kind = ((JSLocalImplicitElementImpl)implicitElement).getExplicitKind()) == null && (provider = implicitElement.getParent()) != null && !(provider instanceof JSImplicitElement)) {
                return JSSemanticHighlightingUtil.buildHighlightForElement(provider, place, highlighter);
            }
            JSImplicitElement.Type type = implicitElement.getType();
            switch (type) {
                case Class: {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(resolve, place, false, highlighter);
                }
                case Interface: {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(resolve, place, true, highlighter);
                }
                case Function: {
                    if (implicitElement.getNamespace() == null) {
                        isFunction = true;
                    } else {
                        isMethod = true;
                    }
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                    break;
                }
                case Method: {
                    isMethod = true;
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                    break;
                }
                case Namespace: {
                    info = TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
                    break;
                }
                case Variable: {
                    if (implicitElement.getNamespace() == null && implicitElement.isNamespaceExplicitlyDeclared()) {
                        info = TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
                        break;
                    }
                }
                case Property: 
                case Tag: {
                    isField = true;
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                }
            }
        } else {
            if (resolve instanceof JSProperty) {
                return JSSemanticHighlightingUtil.buildHighlightForInitializerOwner((JSProperty)resolve, place, highlighter);
            }
            if (resolve instanceof JSDefinitionExpression) {
                return JSSemanticHighlightingUtil.buildHighlightForInitializerOwner((JSDefinitionExpression)resolve, place, highlighter);
            }
            if (resolve instanceof JSAttributeListOwner) {
                if (resolve instanceof JSFieldVariable) {
                    return JSSemanticHighlightingUtil.buildHighlightForVariable((JSFieldVariable)resolve, place, highlighter);
                }
                if (resolve instanceof JSClass) {
                    if (resolve instanceof TypeScriptTypeAlias) {
                        return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_TYPE_ALIAS), "alias");
                    }
                    return JSSemanticHighlightingUtil.buildHighlightForClass(resolve, place, ((JSClass)resolve).isInterface(), highlighter);
                }
                if (resolve instanceof TypeScriptModule) {
                    return TextAttributeKeyInfo.exportedVariable(highlighter);
                }
                JSAttributeList attributeList = ((JSAttributeListOwner)resolve).getAttributeList();
                if (attributeList != null) {
                    isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                }
                DialectOptionHolder dialect = DialectDetector.dialectOfElement(resolve);
                boolean bl = isMethod = resolve instanceof JSFunction && (!((JSFunction)resolve).isConstructor() || dialect != null && dialect.isJavaScript());
                if (isMethod && !JSSemanticHighlightingUtil.isClassContext(resolve) && !JSSemanticHighlightingUtil.isTypeScriptInterfaceReference(resolve.getContext())) {
                    isMethod = false;
                    isFunction = true;
                }
                if (JSResolveUtil.isConstructorFunction(resolve)) {
                    if (place == resolve && "constructor".equals(((JSAttributeListOwner)resolve).getName())) {
                        info = TextAttributeKeyInfo.constructor(highlighter);
                    } else {
                        PsiElement context = resolve.getContext();
                        return JSSemanticHighlightingUtil.buildHighlightForClass(context instanceof JSClass ? context : resolve, place, false, highlighter);
                    }
                }
            }
        }
        if (isMethod) {
            info = isStatic ? TextAttributeKeyInfo.staticMethod(highlighter) : TextAttributeKeyInfo.instanceMethod(highlighter, place);
        } else if (isFunction) {
            info = JSSemanticHighlightingUtil.getFunctionHighlighter(resolve, highlighter);
        } else if (isField) {
            info = TextAttributeKeyInfo.field(highlighter, attributesKeyProvider);
        }
        return info;
    }

    @NotNull
    private static TextAttributeKeyInfo getFunctionHighlighter(@NotNull PsiElement resolve, @NotNull JSHighlighter highlighter) {
        if (resolve == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(12);
        }
        if (highlighter == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(13);
        }
        TextAttributeKeyInfo textAttributeKeyInfo = JSSemanticHighlightingUtil.isExported(resolve) ? TextAttributeKeyInfo.exportedFunction(highlighter) : (resolve.getUseScope() instanceof LocalSearchScope ? TextAttributeKeyInfo.localFunction(highlighter) : TextAttributeKeyInfo.globalFunction(highlighter));
        if (textAttributeKeyInfo == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(14);
        }
        return textAttributeKeyInfo;
    }

    @NotNull
    private static TextAttributeKeyInfo buildHighlightForClass(@NotNull PsiElement resolve, @NotNull PsiElement place, boolean isInterface, JSHighlighter highlighter) {
        if (resolve == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(15);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(16);
        }
        if (!isInterface && JSSemanticHighlightingUtil.isExported(resolve)) {
            TextAttributeKeyInfo textAttributeKeyInfo = TextAttributeKeyInfo.exportedClass(highlighter);
            if (textAttributeKeyInfo == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(17);
            }
            return textAttributeKeyInfo;
        }
        TextAttributesKey type = highlighter.getMappedKey(isInterface ? JSHighlighter.JS_INTERFACE : JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForClass());
        return new TextAttributeKeyInfo(type, isInterface ? "interface" : "class");
    }

    @NotNull
    private static TextAttributeKeyInfo buildHighlightForVariable(@NotNull JSFieldVariable element, @NotNull PsiElement place, JSHighlighter highlighter) {
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(18);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(19);
        }
        JSTextAttributeKeysProvider attributesKeyProvider = JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place);
        if (element instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            TextAttributeKeyInfo textAttributeKeyInfo = TextAttributeKeyInfo.parameter(highlighter, attributesKeyProvider);
            if (textAttributeKeyInfo == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(20);
            }
            return textAttributeKeyInfo;
        }
        JSFunctionItem item = JSPsiImplUtils.calculatePossibleFunction((PsiElement)element, place, true);
        if (item != null && JSSemanticHighlightingUtil.isFunctionOnly(item)) {
            return item instanceof JSField || item instanceof JSProperty || item.getContext() instanceof JSProperty ? (item instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)item, JSAttributeList.ModifierType.STATIC) ? TextAttributeKeyInfo.staticMethod(highlighter) : TextAttributeKeyInfo.instanceMethod(highlighter, place)) : JSSemanticHighlightingUtil.getFunctionHighlighter((PsiElement)element, highlighter);
        }
        if (JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)element) instanceof JSFunctionItem) {
            return JSSemanticHighlightingUtil.getFunctionHighlighter((PsiElement)element, highlighter);
        }
        if (JSSemanticHighlightingUtil.isExported((PsiElement)element)) {
            TextAttributeKeyInfo textAttributeKeyInfo = TextAttributeKeyInfo.exportedVariable(highlighter);
            if (textAttributeKeyInfo == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(21);
            }
            return textAttributeKeyInfo;
        }
        if (JSSemanticHighlightingUtil.isClassContext(element.getContext()) || element.getNamespace() != null || element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            boolean isStatic = element.getJSContext() == JSContext.STATIC;
            TextAttributeKeyInfo textAttributeKeyInfo = isStatic ? TextAttributeKeyInfo.staticMemberVariable(highlighter) : TextAttributeKeyInfo.instanceMemberVariable(highlighter);
            if (textAttributeKeyInfo == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(22);
            }
            return textAttributeKeyInfo;
        }
        if (JSSemanticHighlightingUtil.isArgumentsVariable((PsiElement)element)) {
            TextAttributeKeyInfo textAttributeKeyInfo = TextAttributeKeyInfo.parameter(highlighter, attributesKeyProvider);
            if (textAttributeKeyInfo == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(23);
            }
            return textAttributeKeyInfo;
        }
        if (JSSemanticHighlightingUtil.isLocalVariable(element, place)) {
            TextAttributeKeyInfo textAttributeKeyInfo = TextAttributeKeyInfo.localVariable(highlighter, attributesKeyProvider);
            if (textAttributeKeyInfo == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(24);
            }
            return textAttributeKeyInfo;
        }
        TextAttributeKeyInfo textAttributeKeyInfo = TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
        if (textAttributeKeyInfo == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(25);
        }
        return textAttributeKeyInfo;
    }

    private static boolean isFunctionOnly(JSFunctionItem item) {
        if (item instanceof JSExpression) {
            return true;
        }
        TypeScriptCallSignature signature = (TypeScriptCallSignature)ObjectUtils.tryCast((Object)item, TypeScriptCallSignature.class);
        if (signature == null || signature.hasNew()) {
            return false;
        }
        PsiElement context = item.getContext();
        return !(context instanceof TypeScriptObjectType) || ContainerUtil.and((Object[])((TypeScriptObjectType)context).getTypeMembers(), e -> e instanceof TypeScriptCallSignature && !((TypeScriptCallSignature)e).hasNew());
    }

    public static boolean isArgumentsVariable(@NotNull PsiElement element) {
        JSType type;
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(26);
        }
        return element instanceof ImplicitJSVariableImpl && JSNamedType.isNamedTypeWithName(type = ((ImplicitJSVariableImpl)element).getJSType(), "IArguments");
    }

    public static boolean isLocalVariable(@NotNull JSFieldVariable element, @NotNull PsiElement place) {
        PsiElement node;
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(27);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(28);
        }
        return (node = JSUseScopeProvider.getUseScopeElement((JSNamedElement)element)) != null && (!(node instanceof JSFile) || !DialectDetector.isActionScript(node)) || JSSemanticHighlightingUtil.isPredefinedLocalVariable((PsiElement)element, place);
    }

    private static boolean isPredefinedLocalVariable(@NotNull PsiElement resolvedElement, @NotNull PsiElement place) {
        JSReferenceExpression ref;
        if (resolvedElement == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(29);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(30);
        }
        if ((ref = (JSReferenceExpression)ObjectUtils.tryCast((Object)place, JSReferenceExpression.class)) != null && PREDEFINED_LOCAL_VARS.contains(ref.getReferenceName())) {
            VirtualFile file2 = resolvedElement.getContainingFile().getViewProvider().getVirtualFile();
            String path = file2.getPath();
            return path.endsWith("/@types/node/index.d.ts") || path.endsWith("/@types/node/globals.d.ts");
        }
        return false;
    }

    public static void highlight(JSLabeledStatement labeledStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    public static void highlight(JSStatementWithLabelReference labeledStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    protected static void lineMarker(@NotNull PsiElement element, TextAttributesKey attrKey, @NotNull String debugName, AnnotationHolder holder) {
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(31);
        }
        if (debugName == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(32);
        }
        if (attrKey == null) {
            return;
        }
        PsiElement markedNode = element.getLastChild();
        if (markedNode == null) {
            markedNode = element;
        }
        while (markedNode.getNode().getElementType() != JSTokenTypes.IDENTIFIER && !(markedNode instanceof ES6ComputedName) && markedNode.getPrevSibling() != null) {
            markedNode = markedNode.getPrevSibling();
        }
        if (element instanceof JSAttribute) {
            markedNode = element;
        } else if (element instanceof JSNamedElement) {
            PsiElement nameElement = ((JSNamedElement)element).getNameIdentifier();
            if (nameElement != null) {
                markedNode = nameElement;
            } else if (element instanceof ES6Property) {
                markedNode = null;
            }
        }
        if (markedNode == null) {
            return;
        }
        AnnotationBuilder builder = JSSemanticHighlightingUtil.createBuilderForHighlight(holder, debugName);
        builder.range(markedNode).textAttributes(attrKey).create();
    }

    @NotNull
    private static AnnotationBuilder createBuilderForHighlight(@NotNull AnnotationHolder holder, @NotNull String debugName) {
        if (holder == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(33);
        }
        if (debugName == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(34);
        }
        AnnotationBuilder annotationBuilder = debug ? holder.newAnnotation(HighlightSeverity.INFORMATION, debugName) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        if (annotationBuilder == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(35);
        }
        return annotationBuilder;
    }

    public static HighlightInfo justLineMarker(PsiElement markedNode, TextAttributesKey attrKey, @Nullable String debugName) {
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(markedNode).textAttributes(attrKey);
        if (debug && debugName != null) {
            builder.descriptionAndTooltip(debugName);
        }
        return builder.create();
    }

    public static void highlight(JSProperty node, JSHighlighter highlighter, AnnotationHolder holder) {
        if (node instanceof ES6Property && ((ES6Property)node).isShorthanded()) {
            return;
        }
        if (node instanceof JSFunction) {
            return;
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForInitializerOwner(node, (PsiElement)node, highlighter);
        JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
    }

    public static void highlight(JSDestructuringProperty node, JSHighlighter highlighter, AnnotationHolder holder) {
        if (node instanceof JSDestructuringShorthandedProperty || node.isRest()) {
            return;
        }
        TextAttributeKeyInfo info = TextAttributeKeyInfo.field(highlighter, JSSemanticHighlightingUtil.getTextAttributeKeysProvider((PsiElement)node));
        JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
    }

    private static <T extends JSQualifiedNamedElement & JSInitializerOwner> TextAttributeKeyInfo buildHighlightForInitializerOwner(@NotNull T node, PsiElement place, JSHighlighter highlighter) {
        if (node == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(36);
        }
        boolean isExported = JSSemanticHighlightingUtil.isExported(node);
        JSExpression initializer = ((JSInitializerOwner)node).getInitializerOrStub();
        if (initializer instanceof JSClass) {
            return isExported ? TextAttributeKeyInfo.exportedClass(highlighter) : JSSemanticHighlightingUtil.buildHighlightForClass((PsiElement)initializer, place, false, highlighter);
        }
        if (JSPsiImplUtils.calculatePossibleFunction(node, place, true) != null) {
            return isExported ? TextAttributeKeyInfo.exportedFunction(highlighter) : TextAttributeKeyInfo.instanceMethod(highlighter, place);
        }
        return isExported ? TextAttributeKeyInfo.exportedVariable(highlighter) : TextAttributeKeyInfo.field(highlighter, JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place));
    }

    public static void highlight(JSVariable node, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement nameIdentifier;
        if (!(node instanceof JSParameter) && ((nameIdentifier = node.getNameIdentifier()) == null || nameIdentifier instanceof JSReferenceExpression)) {
            return;
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForResolveResult((PsiElement)node, (PsiElement)node, highlighter);
        if (info != null) {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
        }
    }

    public static void highlight(TypeScriptPropertySignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript property signature", holder);
    }

    public static void highlight(TypeScriptFunctionSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "TypeScript function signature", holder);
    }

    public static void highlight(JSFunctionSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "function signature", holder);
    }

    public static void highlight(TypeScriptGenericOrMappedTypeParameter parameter, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)parameter, highlighter.getMappedKey(TypeScriptHighlighter.TS_TYPE_PARAMETER), "TypeScript type parameter", holder);
    }

    public static void highlight(TypeScriptIndexSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement element = signature.getParameterNameElement();
        if (element != null) {
            JSSemanticHighlightingUtil.lineMarker(element, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript function signature", holder);
        }
    }

    public static void highlight(@NotNull TypeScriptModule module, JSHighlighter highlighter, AnnotationHolder holder) {
        if (module == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(37);
        }
        if (DialectDetector.isTypeScript((PsiElement)module)) {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)module, highlighter.getMappedKey(TypeScriptHighlighter.TS_MODULE_NAME), "moduleName", holder);
        } else {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)module, highlighter.getMappedKey(JSHighlighter.JS_MODULE_NAME), "moduleName", holder);
        }
    }

    public static void highlight(@NotNull Es6MetaProperty property, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement nameIdentifier;
        if (property == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(38);
        }
        if ((nameIdentifier = property.getNameIdentifier()) != null) {
            JSSemanticHighlightingUtil.lineMarker(nameIdentifier, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "meta property", holder);
        }
    }

    public static void highlight(@NotNull JSClass jsClass, JSHighlighter highlighter, AnnotationHolder holder) {
        TextAttributeKeyInfo info;
        if (jsClass == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(39);
        }
        if ((info = JSSemanticHighlightingUtil.buildHighlightForElement((PsiElement)jsClass, (PsiElement)jsClass, highlighter)) != null) {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)jsClass, info.type, info.text, holder);
        }
    }

    @NotNull
    private static PsiElement calculateMeaningfulElementForHighlighting(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(40);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(41);
            }
            return psiElement;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        PsiElement psiElement = file2 != null && (index.isInContent(file2) || index.isInLibrarySource(file2)) ? JSStubBasedPsiTreeUtil.calculateTargetElementForHighlighting(element) : element;
        if (psiElement == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(42);
        }
        return psiElement;
    }

    private static boolean isExported(@NotNull PsiElement element) {
        List<? extends PsiElement> exportedElements;
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(43);
        }
        if (ES6ImportHandler.isExportedWithNameOrDefaultOrAssignment(element)) {
            return true;
        }
        if (!(element instanceof JSElementBase)) {
            return false;
        }
        JSElementBase namedElement = (JSElementBase)element;
        if (CommonJSUtil.isExportNamespace(namedElement.getNamespace()) || CommonJSUtil.isModuleExportsAssigmentTarget(namedElement)) {
            return true;
        }
        if (namedElement.getJSNamespace().getQualifiedName() != null || !namedElement.getJSNamespace().isSourceStrict()) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof JSFile && (((JSFile)file2).getModuleStatus() == JSFile.ModuleStatus.COMMONJS || ((JSFile)file2).getModuleStatus() == JSFile.ModuleStatus.MAYBE_COMMONJS) && (exportedElements = JSResolveUtil.getExportedElements((JSExecutionScope)((JSFile)file2))).size() == 1) {
            PsiElement exportedElement = (PsiElement)ContainerUtil.getFirstItem(exportedElements);
            return JSSemanticHighlightingUtil.calculateMeaningfulElementForHighlighting(exportedElement) == element;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 35: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 35: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 35: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 18: 
            case 26: 
            case 27: 
            case 31: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "guessHighlightingForReference";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionHighlighter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHighlightForClass";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHighlightForVariable";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderForHighlight";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElementForHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalUndefined";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isActionScriptClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "guessHighlightingForReference";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 35: 
            case 41: 
            case 42: {
                break;
            }
            case 6: 
            case 7: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForResolveResult";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionHighlighter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForClass";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForVariable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentsVariable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isLocalVariable";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedLocalVariable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lineMarker";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForHighlight";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForInitializerOwner";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElementForHighlighting";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isExported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 35: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class TextAttributeKeyInfo {
        private final TextAttributesKey type;
        private final String text;

        public TextAttributeKeyInfo(@NotNull TextAttributesKey type, @NotNull String text) {
            if (type == null) {
                TextAttributeKeyInfo.$$$reportNull$$$0(0);
            }
            if (text == null) {
                TextAttributeKeyInfo.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.text = text;
        }

        @NotNull
        public TextAttributesKey getType() {
            TextAttributesKey textAttributesKey = this.type;
            if (textAttributesKey == null) {
                TextAttributeKeyInfo.$$$reportNull$$$0(2);
            }
            return textAttributesKey;
        }

        @NotNull
        public String getText() {
            String string = this.text;
            if (string == null) {
                TextAttributeKeyInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        public static TextAttributeKeyInfo localVariable(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForLocalVariable()), "local variable");
        }

        public static TextAttributeKeyInfo staticMemberVariable(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_STATIC_MEMBER_VARIABLE), "static field");
        }

        public static TextAttributeKeyInfo parameter(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForParameter()), JSSemanticHighlightingUtil.PARAMETER_MESSAGE);
        }

        public static TextAttributeKeyInfo field(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getTextAttributesKeyForInstanceField()), JSSemanticHighlightingUtil.INSTANCE_FIELD);
        }

        public static TextAttributeKeyInfo instanceMemberVariable(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "field");
        }

        public static TextAttributeKeyInfo globalFunction(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_GLOBAL_FUNCTION), "global function");
        }

        public static TextAttributeKeyInfo localFunction(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_LOCAL_FUNCTION), "local function");
        }

        public static TextAttributeKeyInfo instanceMethod(JSHighlighter highlighter, PsiElement place) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForInstanceMethod()), JSSemanticHighlightingUtil.INSTANCE_METHOD);
        }

        public static TextAttributeKeyInfo staticMethod(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_STATIC_MEMBER_FUNCTION), "static method");
        }

        public static TextAttributeKeyInfo constructor(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_KEYWORD), "constructor");
        }

        public static TextAttributeKeyInfo globalVariable(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForGlobalVariable()), "global variable");
        }

        public static TextAttributeKeyInfo exportedVariable(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_EXPORTED_VARIABLE), "exported variable");
        }

        public static TextAttributeKeyInfo exportedFunction(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_EXPORTED_FUNCTION), "exported function");
        }

        public static TextAttributeKeyInfo exportedClass(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_EXPORTED_CLASS), "exported class");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextAttributeKeyInfo info = (TextAttributeKeyInfo)o;
            if (!this.type.equals((Object)info.type)) {
                return false;
            }
            return this.text.equals(info.text);
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = 31 * result2 + this.text.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

