/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactPropTypesRenameProcessor
extends JSDefaultRenameProcessor {
    public static final String[] INTERESTING_PROPERTIES = new String[]{"defaultProps", "getDefaultProps", "propTypes"};

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(0);
        }
        if (!DialectDetector.isJSX(element)) {
            return false;
        }
        return element instanceof JSImplicitElement && JSXPropTypesUtil.isNamespaceMember((JSPsiElementBase)((JSImplicitElement)element), "props") || element instanceof JSProperty && JSXPropTypesUtil.isNamespaceMember((JSPsiElementBase)((JSProperty)element), INTERESTING_PROPERTIES);
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        JSImplicitElement implicitElement;
        if (element == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(1);
        }
        if (element instanceof JSProperty && (implicitElement = JSXPropTypesUtil.substitutePropTypesPropDeclaration((JSProperty)element)) != null) {
            return implicitElement;
        }
        return element;
    }

    @Override
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(3);
        }
        if (allRenames == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(5);
        }
        super.prepareRenaming(element, newName, allRenames, scope);
        if (element instanceof JSPsiElementBase) {
            for (String property : INTERESTING_PROPERTIES) {
                ReactPropTypesRenameProcessor.processNamespaceMembers((JSPsiElementBase)element, property, allRenames, newName);
            }
        }
    }

    private static void processNamespaceMembers(@NotNull JSPsiElementBase element, @NotNull String propDeclarationName, @NotNull Map<PsiElement, String> allRenames, @NotNull String newName) {
        JSQualifiedName namespace;
        if (element == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(6);
        }
        if (propDeclarationName == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(7);
        }
        if (allRenames == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            ReactPropTypesRenameProcessor.$$$reportNull$$$0(9);
        }
        if ((namespace = element.getNamespace()) == null) {
            return;
        }
        JSQualifiedName namespaceParent = namespace.getParent();
        if (namespaceParent == null) {
            return;
        }
        GlobalSearchScope resolveScope = element.getResolveScope();
        JSClassResolver jsClassResolver = JSClassResolver.getInstance();
        String nameToSearch = namespaceParent.getQualifiedName() + "." + propDeclarationName + "." + element.getName();
        Collection<JSPsiElementBase> elements = jsClassResolver.findElementsByQNameIncludingImplicit(nameToSearch, resolveScope);
        for (JSPsiElementBase toRename : elements) {
            allRenames.put((PsiElement)toRename, newName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propDeclarationName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactPropTypesRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteElementToRename";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processNamespaceMembers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

