/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.editorActions.XmlTagNameSynchronizer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSImportCompletionUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.references.JSXNamespaceReference;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactComponentCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        boolean needComponents;
        if (parameters == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(1);
        }
        PrefixMatcher matcher = result2.getPrefixMatcher();
        String prefix = matcher.getPrefix();
        String capitalized = StringUtil.capitalize((String)prefix);
        boolean bl = needComponents = StringUtil.isEmpty((String)prefix) || JSXResolveUtil.isComponentName(prefix) || JSXResolveUtil.isComponentName(capitalized) && matcher.prefixMatches(capitalized);
        if (!needComponents) {
            return;
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result2, (reference, set) -> {
            if (!(reference instanceof TagNameReference)) {
                return;
            }
            TagNameReference tagNameReference = (TagNameReference)reference;
            PsiElement element = tagNameReference.getElement();
            if (element instanceof XmlTag && tagNameReference.isStartTagFlag() && !ReactXmlExtension.nonJsxTag((XmlTag)element)) {
                HashSet<String> collectedNames = new HashSet<String>();
                XmlTag tag = (XmlTag)element;
                boolean isTypeScript = DialectDetector.isTypeScript(element);
                if (ReactXmlExtension.hasQualifiedName(tag)) {
                    ReactComponentCompletionContributor.addExportedComponentForNamespace(result2, tag, collectedNames, isTypeScript);
                } else {
                    ReactComponentCompletionContributor.addLocalVariants(result2, tag, collectedNames);
                    ReactComponentCompletionContributor.addExportedComponents(result2, tag, collectedNames);
                }
            }
        });
    }

    private static void addExportedComponentForNamespace(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, Set<String> collectedNames, boolean isStrict) {
        JSXNamespaceReference reference;
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((reference = ReactXmlExtension.getQualifierReference(tag)) == null) {
            return;
        }
        Collection<PsiElement> elements = JSXResolveUtil.expandReferenceElements((PsiElement)tag, reference);
        if (elements.isEmpty()) {
            return;
        }
        JSResolveProcessor processor = ReactComponentCompletionContributor.createCompletionProcessor(result2, collectedNames);
        ReactComponentCompletionContributor.processNestedComponentInScopes(tag, reference, processor, elements);
        if (!isStrict) {
            ReactComponentCompletionContributor.processNestedComponentsFromIndex(tag, processor);
        }
    }

    private static void processNestedComponentsFromIndex(@NotNull XmlTag tag, @NotNull JSResolveProcessor processor) {
        GlobalSearchScope scope;
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(5);
        }
        if ((scope = ReactXmlExtension.getResolveScopeForIndexProcessing(tag, true)) == null) {
            return;
        }
        String parentQualifier = tag.getNamespacePrefix();
        if (!StringUtil.isEmpty((String)parentQualifier)) {
            JSClassResolver.getInstance().processNamespaceMembers(parentQualifier, scope, (Processor<? super JSPsiElementBase>)((Processor)el -> processor.execute((PsiElement)el, ResolveState.initial())));
        }
    }

    private static void processNestedComponentInScopes(@NotNull XmlTag tag, @NotNull JSXNamespaceReference prevRef, @NotNull PsiScopeProcessor processor, @NotNull Collection<PsiElement> elements) {
        List<PsiElement> results;
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(6);
        }
        if (prevRef == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(9);
        }
        JSModuleElementsResolveProcessor moduleProcessor = new JSModuleElementsResolveProcessor(processor);
        QualifiedItemProcessor<?> localProcessor = ReactComponentCompletionContributor.createQualifiedLocalProcessor(tag, prevRef);
        for (PsiElement element : elements) {
            if (!ES6PsiUtil.isExportScope(element)) {
                if (element instanceof JSClass) {
                    element.processDeclarations(localProcessor, ResolveState.initial(), element, (PsiElement)tag);
                    continue;
                }
                JSTypeEvaluator.evaluateExpressionOrElementTypes(tag.getContainingFile(), localProcessor, element);
                continue;
            }
            if (ES6PsiUtil.processExportDeclarationInScope((JSElement)element, moduleProcessor)) continue;
            break;
        }
        if ((results = localProcessor.getResults()) == null) {
            return;
        }
        for (PsiElement el : results) {
            if (processor.execute(el, ResolveState.initial())) continue;
            return;
        }
    }

    @NotNull
    private static QualifiedItemProcessor<?> createQualifiedLocalProcessor(@NotNull XmlTag tag, @NotNull JSXNamespaceReference prevRef) {
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(10);
        }
        if (prevRef == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(11);
        }
        QualifiedItemProcessor<? extends ResultSink> localProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)tag).createCompletionItemProcessor(new CompletionResultSink((PsiElement)tag, null), tag.getContainingFile());
        localProcessor.setLocalResolve(true);
        localProcessor.getAccessibilityProcessingHandler().setProcessStatics(!prevRef.isThisQualifier());
        QualifiedItemProcessor<? extends ResultSink> qualifiedItemProcessor = localProcessor;
        if (qualifiedItemProcessor == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(12);
        }
        return qualifiedItemProcessor;
    }

    private static void addExportedComponents(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull Set<String> localNames) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(13);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(14);
        }
        if (localNames == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(15);
        }
        PrefixMatcher prefixMatcher = result2.getPrefixMatcher();
        JSImportPlaceInfo info = new JSImportPlaceInfo((PsiElement)tag);
        Predicate<String> keyFilter = name -> JSXResolveUtil.isComponentName(name) && prefixMatcher.prefixMatches(name) && !localNames.contains(name);
        List<JSImportCandidatesProvider> providers = JSImportCandidatesProvider.getProviders(info);
        JSImportCompletionUtil.processExportedElements((PsiElement)tag, providers, keyFilter, (PairProcessor<? super Collection<? extends JSImportCandidate>, ? super String>)((PairProcessor)(elements, name) -> {
            JSImportCandidate candidate = elements.size() == 1 ? (JSImportCandidate)ContainerUtil.getFirstItem((Collection)elements) : null;
            JSElement element = candidate != null ? candidate.getElement() : null;
            LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup(name, candidate, (PsiElement)element);
            result2.addElement((LookupElement)(candidate == null || candidate.useAutoImport() ? ReactComponentCompletionContributor.addReactImportInsertHandler(lookup) : lookup));
            return true;
        }));
        ReactComponentCompletionContributor.addFragmentComponent(result2, tag, localNames);
    }

    private static void addFragmentComponent(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull Set<String> names) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(16);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(17);
        }
        if (names == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(18);
        }
        if (names.contains("Fragment")) {
            return;
        }
        Collection<PsiElement> react = JSFileReferencesUtil.resolveModuleReference((PsiElement)tag.getContainingFile(), "react");
        for (PsiElement element : react) {
            VirtualFile file2;
            ResolveResult[] fragments;
            PsiElement item;
            if (!(element instanceof JSElement) || !((item = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(fragments = ES6PsiUtil.resolveSymbolInModule("Fragment", (PsiElement)tag, (JSElement)element)))) instanceof JSElement) || (file2 = PsiUtilCore.getVirtualFile((PsiElement)item)) == null) continue;
            JSImportCandidateDescriptor descriptor2 = new JSImportCandidateDescriptor(JSImportCandidate.SourceType.ES6, "react", "Fragment", null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.SPECIFIER);
            LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup("Fragment", descriptor2, element);
            result2.addElement((LookupElement)ReactComponentCompletionContributor.addReactImportInsertHandler(lookup));
        }
    }

    private static void addLocalVariants(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, Set<String> collectedNames) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(19);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(20);
        }
        JSResolveProcessor processor = ReactComponentCompletionContributor.createCompletionProcessor(result2, collectedNames);
        JSResolveUtil.treeWalkUp(processor, (PsiElement)tag, null, (PsiElement)tag);
    }

    @NotNull
    private static JSResolveProcessor createCompletionProcessor(final @NotNull CompletionResultSet result2, final @NotNull Set<String> collectedNames) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(21);
        }
        if (collectedNames == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(22);
        }
        final PrefixMatcher matcher = result2.getPrefixMatcher();
        return new JSResolveProcessor(){

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof JSDefinitionExpression) {
                    return true;
                }
                String name = ResolveProcessor.getName(element);
                if (JSXResolveUtil.isComponentName(name) && !collectedNames.contains(name) && matcher.prefixMatches(name) && !"React".equals(name)) {
                    Collection<PsiElement> elementsByImport = ReactXmlExtension.getElementsByImport(element);
                    collectedNames.add(name);
                    for (PsiElement candidate : elementsByImport) {
                        ProgressManager.checkCanceled();
                        boolean isComponent = element instanceof JSClass ? ReactXmlExtension.isReactComponent(candidate) : ReactXmlExtension.isPossibleReactComponent(candidate);
                        if (!isComponent) continue;
                        ReactComponentCompletionContributor.addLookupElement(name, candidate, result2);
                        break;
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void addLookupElement(@NotNull String name, @Nullable PsiElement candidate, @NotNull CompletionResultSet result2) {
        if (name == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(24);
        }
        LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup(name, null, candidate);
        result2.addElement((LookupElement)lookup);
    }

    @NotNull
    private static LookupElementBuilder addReactImportInsertHandler(LookupElementBuilder lookup) {
        LookupElementBuilder lookupElementBuilder = lookup = lookup.withInsertHandler((context, item) -> {
            PsiFile originalFile = context.getFile();
            PsiElement originalElement = originalFile.findElementAt(context.getStartOffset());
            if (originalElement != null) {
                XmlTagNameSynchronizer.runWithoutCancellingSyncTagsEditing((Document)context.getDocument(), () -> {
                    Object object = item.getObject();
                    JSImportCompletionUtil.insertLookupItem(context, item, (JSImportCandidate)ObjectUtils.tryCast((Object)object, JSImportCandidate.class), (Consumer<? super JSImportCandidate>)((Consumer)el -> {
                        if (el != null) {
                            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                            PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
                            XmlTagInsertHandler.INSTANCE.handleInsert(context, item);
                        }
                    }));
                });
            }
        });
        if (lookupElementBuilder == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(25);
        }
        return lookupElementBuilder;
    }

    private static LookupElementBuilder createLookup(@NotNull String name, @Nullable JSImportCandidate importCandidate, @Nullable PsiElement el) {
        ItemPresentation presentation;
        if (name == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(26);
        }
        ItemPresentation itemPresentation = presentation = el instanceof JSNamedElement ? ((JSNamedElement)el).getPresentation() : null;
        LookupElementBuilder lookup = (importCandidate == null && el == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)(importCandidate != null ? importCandidate : el), (String)name)).withTypeText(presentation != null ? presentation.getLocationString() : null, true).withIcon(JavaScriptLanguageIcons.Logos.Jsx_16);
        lookup = lookup.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
        return lookup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedNames";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedLocalProcessor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addReactImportInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExportedComponentForNamespace";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNestedComponentsFromIndex";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processNestedComponentInScopes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedLocalProcessor";
                break;
            }
            case 12: 
            case 25: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addExportedComponents";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addFragmentComponent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addLocalVariants";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionProcessor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addLookupElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLookup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

