/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ReactComponent {
    private static final String DEFAULT_PROPS = "default.props";
    @NotNull
    private final String myNamespace;
    @NotNull
    private final XmlTag myTag;
    @NotNull
    private final Collection<? extends PsiElement> myElements;
    private final boolean myIsWeakResolve;
    private final boolean myIsResolvedComponent;
    @NotNull
    private final NullableLazyValue<JSRecordType> myProps;

    ReactComponent(@NotNull XmlTag tag, @NotNull Collection<? extends PsiElement> elements, @NotNull String namespace, boolean isWeakResolve, boolean isResolvedComponent) {
        if (tag == null) {
            ReactComponent.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ReactComponent.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            ReactComponent.$$$reportNull$$$0(2);
        }
        this.myProps = NullableLazyValue.createValue(() -> this.overrideOptional(this.resolvePropsNoCache()));
        this.myTag = tag;
        this.myElements = elements;
        this.myNamespace = namespace;
        this.myIsWeakResolve = isWeakResolve;
        this.myIsResolvedComponent = isResolvedComponent;
    }

    public boolean isWeakResolve() {
        return this.myIsWeakResolve;
    }

    public boolean isResolvedComponent() {
        return this.myIsResolvedComponent;
    }

    @NotNull
    public Collection<? extends PsiElement> getElements() {
        Collection<? extends PsiElement> collection = this.myElements;
        if (collection == null) {
            ReactComponent.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public String getNamespace() {
        String string = this.myNamespace;
        if (string == null) {
            ReactComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public JSRecordType getProps() {
        return (JSRecordType)this.myProps.getValue();
    }

    @Nullable
    private JSRecordType resolvePropsNoCache() {
        JSRecordType signatureType = ReactComponent.asPropsResult(JSXPropTypesUtil.getGenericPropType(this.myTag, this));
        if (ReactComponent.isAcceptableResult(signatureType)) {
            return signatureType;
        }
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)this.myTag);
        if (isTypeScript && this.myElements.isEmpty()) {
            return null;
        }
        GlobalSearchScope scope = this.getPropsNamespaceScope();
        Collection<JSPsiElementBase> propsNamespaceMembers = JSClassResolver.getInstance().findNamespaceMembers(this.getNamespace(), scope);
        Stream<JSPsiElementBase> resolvedNamespaceMembers = JSXPropTypesUtil.resolveNamespacePropTypes(this, scope);
        List defaultNamespaces = this.isExportDefault() ? JSClassResolver.getInstance().findNamespaceMembersIncludingLocal(DEFAULT_PROPS, GlobalSearchScope.filesScope((Project)this.myTag.getProject(), this.getCorrespondingFiles())) : Collections.emptyList();
        Stream<JSPsiElementBase> propsStream = Stream.concat(Stream.concat(propsNamespaceMembers.stream(), defaultNamespaces.stream()), resolvedNamespaceMembers);
        LinkedHashMap<String, JSRecordType.PropertySignature> result2 = new LinkedHashMap<String, JSRecordType.PropertySignature>();
        if (signatureType != null) {
            signatureType.getProperties().forEach(el -> result2.put(el.getMemberName(), (JSRecordType.PropertySignature)el));
        }
        this.mergeProperties(result2, propsStream);
        return result2.isEmpty() ? null : new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)this.myTag, true), new ArrayList(result2.values()));
    }

    private boolean isExportDefault() {
        return this.myElements.stream().allMatch(el -> el instanceof JSPsiElementBase && ((JSPsiElementBase)el).isExportedWithDefault());
    }

    @NotNull
    private static JSRecordType.PropertySignature makeOptional(@NotNull JSRecordType.PropertySignature el) {
        if (el == null) {
            ReactComponent.$$$reportNull$$$0(5);
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(el.getMemberName(), el.getJSType(), true, el.isConst(), el.getMemberSource());
    }

    @Nullable
    private JSRecordType overrideOptional(@Nullable JSRecordType type) {
        if (type == null || !type.hasMembers()) {
            return type;
        }
        Collection<String> defaultProps = this.getDefaultProps();
        if (defaultProps.isEmpty() && !this.isWeakResolve()) {
            return type;
        }
        List newMembers = ContainerUtil.map((Collection)type.getProperties(), el -> !el.isOptional() && (this.isWeakResolve() || defaultProps.contains(el.getMemberName())) ? ReactComponent.makeOptional(el) : el);
        return new JSRecordTypeImpl(type.getSource(), newMembers);
    }

    private void mergeProperties(@NotNull Map<String, JSRecordType.PropertySignature> result2, @NotNull Stream<JSPsiElementBase> propsStream) {
        if (result2 == null) {
            ReactComponent.$$$reportNull$$$0(6);
        }
        if (propsStream == null) {
            ReactComponent.$$$reportNull$$$0(7);
        }
        propsStream.filter(el -> el.getName() != null).forEach(el -> {
            String name = el.getName();
            JSRecordType.PropertySignature oldSignature = (JSRecordType.PropertySignature)result2.get(name);
            JSRecordTypeImpl.PropertySignatureImpl newSignature = this.createSignature((JSPsiElementBase)el);
            if (oldSignature != null && (newSignature.isOptional() || JSTypeUtils.isNullOrAny(newSignature.getJSType()))) {
                return;
            }
            result2.put(name, newSignature);
        });
    }

    private static boolean isAcceptableResult(@Nullable JSRecordType type) {
        if (type == null || !type.hasProperties() || !type.isSourceStrict()) {
            return false;
        }
        int size = type.getProperties().size();
        int extendedMin = type.hasProperty("children") ? 1 : 0;
        return size > extendedMin;
    }

    @NotNull
    private JSRecordTypeImpl.PropertySignatureImpl createSignature(@NotNull JSPsiElementBase el) {
        if (el == null) {
            ReactComponent.$$$reportNull$$$0(8);
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(Objects.requireNonNull(el.getName()), ReactXmlExtension.getPropType((PsiElement)el), this.isWeakResolve(), false, (PsiElement)el);
    }

    @Nullable
    private static JSRecordType asPropsResult(@Nullable JSType type) {
        if (type != null) {
            if (type instanceof JSContextualUnionTypeImpl) {
                List<JSType> types2 = ((JSContextualUnionTypeImpl)type).getTypes();
                ArrayList<JSRecordType> objects = new ArrayList<JSRecordType>();
                for (JSType jsType : types2) {
                    objects.add(jsType.asRecordType());
                }
                type = JSCompositeTypeFactory.createContextualUnionType(objects, type.getSource());
            }
            JSType expanded = JSTypeUtils.getValuableType(type);
            return expanded.asRecordType();
        }
        return null;
    }

    @NotNull
    public GlobalSearchScope getPropsNamespaceScope() {
        if (this.useRestrictedByFilePropsNamespaceScope()) {
            return this.getRestrictedByFilePropsNamespaceScope();
        }
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this.myTag);
        if (globalSearchScope == null) {
            ReactComponent.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    private boolean useRestrictedByFilePropsNamespaceScope() {
        if (DialectDetector.isTypeScript((PsiElement)this.myTag)) {
            return true;
        }
        if (!this.isResolvedComponent() || this.getElements().isEmpty()) {
            return false;
        }
        for (PsiElement psiElement : this.getElements()) {
            PsiFile psiFile = psiElement.getContainingFile();
            if (!(psiFile instanceof JSFile)) {
                return false;
            }
            JSFile jsFile = (JSFile)psiFile;
            if (!jsFile.isCommonJSModule()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Collection<String> getDefaultProps() {
        Collection<? extends PsiElement> elements = this.getElements();
        if (elements.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ReactComponent.$$$reportNull$$$0(10);
            }
            return set;
        }
        HashSet<String> objects = new HashSet<String>();
        for (PsiElement psiElement : this.getElements()) {
            JSType type;
            JSField props;
            if (!(psiElement instanceof JSClass) || (props = ((JSClass)psiElement).findFieldByName("defaultProps")) == null || (type = JSTypeUtils.getTypeOfElement((PsiElement)props)) == null || type instanceof JSEvaluableOnlyType && type.isJavaScript()) continue;
            objects.addAll(type.asRecordType().getPropertyNames());
        }
        if (objects.isEmpty()) {
            objects.addAll(this.getDefaultPropsFromIndex(this.myTag.getName()));
        }
        HashSet<String> hashSet = objects;
        if (hashSet == null) {
            ReactComponent.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @NotNull
    private Collection<String> getDefaultPropsFromIndex(@NotNull String tagName) {
        if (tagName == null) {
            ReactComponent.$$$reportNull$$$0(12);
        }
        HashSet<String> props = new HashSet<String>();
        Processor literalProperties = CommonProcessors.processAll(base -> {
            JSExpression root = null;
            if (base instanceof JSInitializerOwner) {
                root = ((JSInitializerOwner)base).getInitializerOrStub();
            }
            if (root instanceof JSObjectLiteralExpression) {
                JSProperty[] properties;
                for (JSProperty property : properties = ((JSObjectLiteralExpression)root).getProperties()) {
                    props.add(property.getName());
                }
            }
        });
        GlobalSearchScope scope = this.getPropsNamespaceScope();
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(tagName + ".defaultProps", scope, (Processor<? super JSPsiElementBase>)literalProperties);
        ArrayList types2 = new ArrayList();
        Processor functionProperties = CommonProcessors.processAll(base -> {
            if (base instanceof JSFunctionItem) {
                JSType type = ((JSFunctionItem)base).getReturnType();
                ContainerUtil.addIfNotNull((Collection)types2, (Object)type);
            }
        });
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(tagName + ".getDefaultProps", scope, (Processor<? super JSPsiElementBase>)functionProperties);
        for (JSType type : types2) {
            props.addAll(type.asRecordType().getPropertyNames());
        }
        HashSet<String> hashSet = props;
        if (hashSet == null) {
            ReactComponent.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    private GlobalSearchScope getRestrictedByFilePropsNamespaceScope() {
        GlobalSearchScope defaultScope = JSResolveUtil.getResolveScope((PsiElement)this.myTag);
        final List<VirtualFile> files = this.getCorrespondingFiles();
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = defaultScope;
            if (globalSearchScope == null) {
                ReactComponent.$$$reportNull$$$0(14);
            }
            return globalSearchScope;
        }
        final PsiManager manager2 = this.myTag.getManager();
        return new DelegatingGlobalSearchScope(defaultScope){

            public boolean contains(@NotNull VirtualFile candidate) {
                if (candidate == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(candidate)) {
                    return false;
                }
                PsiFile psiFile = manager2.findFile(candidate);
                if (!(psiFile instanceof JSFile)) {
                    return false;
                }
                JSFile jsCandidateFile = (JSFile)psiFile;
                return !jsCandidateFile.isCommonJSModule() || files.contains(candidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/frameworks/react/ReactComponent$1", "contains"));
            }
        };
    }

    @NotNull
    private List<VirtualFile> getCorrespondingFiles() {
        List<VirtualFile> list2 = this.getElements().stream().map(el -> PsiUtilCore.getVirtualFile((PsiElement)el)).filter(el -> el != null).collect(Collectors.toList());
        if (list2 == null) {
            ReactComponent.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactComponent";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propsStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsNamespaceScope";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProps";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPropsFromIndex";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestrictedByFilePropsNamespaceScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeOptional";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSignature";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropsFromIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

