/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.editor.ES6CopyPasteProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.frameworks.react.JSXAttributeCustomMapping;
import com.intellij.lang.javascript.frameworks.react.JSXCopyPasteTagProcessor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J*\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J8\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/frameworks/react/JSXCopyPasteTagProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "()V", "buildNewTextWithReplacedAttributes", "", "originalText", "attributes", "", "Lcom/intellij/lang/javascript/frameworks/react/JSXCopyPasteTagProcessor$AttributeToReplace;", "collectAttributes", "tag", "Lcom/intellij/psi/xml/XmlTag;", "isFileAcceptable", "", "file", "Lcom/intellij/psi/PsiFile;", "isPossibleContentWithTag", "text", "preprocessOnCopy", "startOffsets", "", "endOffsets", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "requiresAllDocumentsToBeCommitted", "AttributeToReplace", "intellij.javascript.impl"})
public final class JSXCopyPasteTagProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file2, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return null;
    }

    private final boolean isFileAcceptable(PsiFile file2) {
        return file2 instanceof JSFile || file2 instanceof HtmlFileImpl;
    }

    @NotNull
    public String preprocessOnPaste(@Nullable Project project, @Nullable PsiFile file2, @Nullable Editor editor, @NotNull String text, @Nullable RawText rawText) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (project == null || file2 == null || !this.isFileAcceptable(file2) || !JSEditorOptions.getInstance().CONVERT_HTML_TO_JSX || editor == null) {
            return text;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement psiElement = ES6CopyPasteProcessor.getContextElementOrFile(file2, offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getContextElementOrFile(file, offset)");
        PsiElement context = psiElement;
        if (!DialectDetector.isJSX(context) || ES6CopyPasteProcessor.isStringLiteralOrCommentContext(file2, offset) || !this.isPossibleContentWithTag(text)) {
            return text;
        }
        ASTNode aSTNode = JSChangeUtil.createStatementFromTextWithContext("<>" + text + "</>", context);
        if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
            return text;
        }
        ASTNode parentStatement = aSTNode;
        PsiElement fragmentCandidate = parentStatement.getFirstChild();
        if (!(fragmentCandidate instanceof JSXmlLiteralExpression)) {
            return text;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)fragmentCandidate, PsiErrorElement.class) != null) {
            return text;
        }
        List<AttributeToReplace> attributes = this.collectAttributes((XmlTag)fragmentCandidate);
        if (attributes.isEmpty()) {
            return text;
        }
        return this.buildNewTextWithReplacedAttributes(text, attributes);
    }

    private final String buildNewTextWithReplacedAttributes(String originalText, List<AttributeToReplace> attributes) {
        StringBuilder stringBuilder = new StringBuilder();
        int prevOffset = 0;
        Iterable $this$forEach$iv = attributes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AttributeToReplace it = (AttributeToReplace)element$iv;
            boolean bl = false;
            int startOffsetInOriginalText = it.getStartOffsetInOriginalText();
            stringBuilder.append(originalText.subSequence(prevOffset, startOffsetInOriginalText));
            stringBuilder.append(it.getNewName());
            prevOffset = it.getEndOffsetInOriginalText();
        }
        stringBuilder.append(originalText.subSequence(prevOffset, originalText.length()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AttributeToReplace> collectAttributes(XmlTag tag) {
        boolean bl = false;
        List list2 = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)tag)).traverse().filter(XmlTag.class).filter((Condition)collectAttributes.tagList.1.INSTANCE).sort(new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                XmlTag it = (XmlTag)a;
                boolean bl2 = false;
                XmlTag xmlTag = it;
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"it");
                it = (XmlTag)b;
                Comparable comparable = Integer.valueOf(xmlTag.getTextOffset());
                bl2 = false;
                XmlTag xmlTag2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag2, (String)"it");
                Comparable comparable2 = Integer.valueOf(xmlTag2.getTextOffset());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)comparable2);
            }
        }).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"psiTraverser(tag).traver\u2026Offset })\n      .toList()");
        List tagList2 = list2;
        if (tagList2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean bl2 = false;
        List result2 = new ArrayList();
        Project project = tag.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"tag.project");
        JSXAttributeCustomMapping mapping = JSXAttributeCustomMapping.Companion.getMapping(project);
        Iterable $this$forEach$iv = tagList2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$associateByTo$iv$iv;
            XmlElementDescriptor tagDescriptor;
            XmlTag it = (XmlTag)element$iv;
            boolean bl3 = false;
            XmlTag xmlTag = it;
            Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"it");
            if (xmlTag.getDescriptor() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)tagDescriptor, (String)"it.descriptor ?: return@forEach");
            XmlAttributeDescriptor[] attributesDescriptors = tagDescriptor.getAttributesDescriptors(it);
            Intrinsics.checkNotNullExpressionValue((Object)attributesDescriptors, (String)"attributesDescriptors");
            XmlAttributeDescriptor[] $this$associateBy$iv = attributesDescriptors;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            String string = $this$associateByTo$iv$iv;
            int n = ((void)string).length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3;
                void it2;
                void element$iv$iv;
                void var23_28 = element$iv$iv = string[i];
                Map map2 = destination$iv$iv;
                boolean bl4 = false;
                void v3 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)v3.getName(), (String)"it.name");
                boolean bl5 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                map2.put(string2, element$iv$iv);
            }
            Map namesFromTag = destination$iv$iv;
            for (XmlAttribute attribute : it.getAttributes()) {
                String realAttrName;
                Intrinsics.checkNotNullExpressionValue((Object)attribute.getName(), (String)"attribute.name");
                string = realAttrName;
                n = 0;
                String string5 = string;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                XmlAttributeDescriptor descriptor2 = (XmlAttributeDescriptor)namesFromTag.get(string6);
                if (descriptor2 == null) {
                    String mappedName = mapping.getMappedAttribute(realAttrName);
                    if (mappedName == null) continue;
                    result2.add(new AttributeToReplace(attribute, mappedName));
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)descriptor2.getName(), (Object)realAttrName) ^ true)) continue;
                String string7 = descriptor2.getName();
                String string8 = descriptor2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"descriptor.name");
                string = string8;
                n = 0;
                String string9 = string;
                if (string9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase()");
                if (!(Intrinsics.areEqual((Object)string7, (Object)string10) ^ true)) continue;
                String string11 = descriptor2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"descriptor.name");
                result2.add(new AttributeToReplace(attribute, string11));
            }
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPossibleContentWithTag(String text) {
        char firstLetter;
        String string = text;
        char c = '\u0000';
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String trimmedText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)trimmedText, (String)"<", (boolean)false, (int)2, null)) return false;
        if (!StringsKt.endsWith$default((String)trimmedText, (String)">", (boolean)false, (int)2, null)) {
            return false;
        }
        c = firstLetter = trimmedText.charAt(1);
        boolean bl = false;
        if (!Character.isLetter(c)) return false;
        c = firstLetter;
        bl = false;
        if (!Character.isLowerCase(c)) return false;
        return true;
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/frameworks/react/JSXCopyPasteTagProcessor$AttributeToReplace;", "", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "newName", "", "(Lcom/intellij/psi/xml/XmlAttribute;Ljava/lang/String;)V", "endOffsetInOriginalText", "", "getEndOffsetInOriginalText", "()I", "getNewName", "()Ljava/lang/String;", "startOffsetInOriginalText", "getStartOffsetInOriginalText", "intellij.javascript.impl"})
    public static final class AttributeToReplace {
        private final int startOffsetInOriginalText;
        private final int endOffsetInOriginalText;
        @NotNull
        private final String newName;

        public final int getStartOffsetInOriginalText() {
            return this.startOffsetInOriginalText;
        }

        public final int getEndOffsetInOriginalText() {
            return this.endOffsetInOriginalText;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        public AttributeToReplace(@NotNull XmlAttribute attribute, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            this.newName = newName;
            this.startOffsetInOriginalText = attribute.getTextOffset() - 2;
            this.endOffsetInOriginalText = attribute.getTextOffset() + attribute.getName().length() - 2;
        }
    }
}

