/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flow.FlowJSResolveScopeProvider;
import com.intellij.lang.javascript.frameworks.modules.JSBaseModuleReferenceContributor;
import com.intellij.lang.javascript.frameworks.modules.JSResolvableModuleReference;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfoImpl;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J=\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/ReactLibraryModuleReferenceContributor;", "Lcom/intellij/lang/javascript/frameworks/modules/JSBaseModuleReferenceContributor;", "()V", "getImportDescriptors", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportDescriptor;", "configuration", "Lcom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfiguration;", "Lorg/jetbrains/annotations/NotNull;", "baseDescriptor", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "unquotedRefText", "", "host", "Lcom/intellij/psi/PsiElement;", "offset", "", "provider", "Lcom/intellij/psi/PsiReferenceProvider;", "isCommonJS", "", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;ILcom/intellij/psi/PsiReferenceProvider;Z)[Lcom/intellij/psi/PsiReference;", "isApplicable", "intellij.javascript.impl"})
public final class ReactLibraryModuleReferenceContributor
extends JSBaseModuleReferenceContributor {
    @Override
    @NotNull
    protected PsiReference[] getReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider, boolean isCommonJS) {
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (Intrinsics.areEqual((Object)unquotedRefText, (Object)"react") ^ true) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        VirtualFile virtualFile = JSCorePredefinedLibrariesProvider.getReactLibraryFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"JSCorePredefinedLibrarie\u2026der.getReactLibraryFile()");
        VirtualFile react = virtualFile;
        return new PsiReference[]{(PsiReference)new JSResolvableModuleReference(react, host, unquotedRefText, offset, host, unquotedRefText, offset){
            final /* synthetic */ VirtualFile $react;
            final /* synthetic */ PsiElement $host;
            final /* synthetic */ String $unquotedRefText;
            final /* synthetic */ int $offset;

            @NotNull
            protected ResolveResult[] doResolve(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiFile file2 = element.getManager().findFile(this.$react);
                return new ResolveResult[]{new JSResolveResult((PsiElement)file2)};
            }

            public int getWeight() {
                return JSModuleBaseReference.ModuleTypes.DEFAULT.weight();
            }

            @NotNull
            public PsiElement handleElementRename(@NotNull String newElementName) {
                Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
                PsiElement psiElement = this.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
                return psiElement;
            }
            {
                this.$react = $captured_local_variable$0;
                this.$host = $captured_local_variable$1;
                this.$unquotedRefText = $captured_local_variable$2;
                this.$offset = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        }};
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return DialectDetector.isJavaScript(host) && !FlowJSResolveScopeProvider.useFlowPredefinedLibrary(host.getContainingFile());
    }

    @Override
    @NotNull
    public List<JSImportDescriptor> getImportDescriptors(@NotNull JSImportPathConfiguration configuration, @NotNull JSImportDescriptor baseDescriptor) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)baseDescriptor, (String)"baseDescriptor");
        JSModuleDescriptor jSModuleDescriptor = baseDescriptor.getModuleDescriptor();
        if (!(jSModuleDescriptor instanceof JSModuleNameInfo)) {
            jSModuleDescriptor = null;
        }
        JSModuleNameInfo jSModuleNameInfo = (JSModuleNameInfo)jSModuleDescriptor;
        if (jSModuleNameInfo == null) {
            return CollectionsKt.emptyList();
        }
        JSModuleNameInfo info = jSModuleNameInfo;
        VirtualFile virtualFile = info.getResolvedFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"info.resolvedFile");
        VirtualFile resolvedModuleFile = virtualFile;
        if (Intrinsics.areEqual((Object)resolvedModuleFile, (Object)JSCorePredefinedLibrariesProvider.getReactLibraryFile())) {
            return CollectionsKt.listOf((Object)new JSSimpleImportDescriptor(new JSModuleNameInfoImpl("react", resolvedModuleFile, configuration.getPlace()), baseDescriptor));
        }
        return CollectionsKt.emptyList();
    }
}

