/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfigurationImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.modules.JSMappingReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSModuleReferenceBase;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReferencePathUpdater {
    @NotNull
    private final JSModuleReferenceBase myReference;
    @NotNull
    private final PsiElement myBind;
    private final boolean myAbsolute;

    public JSReferencePathUpdater(@NotNull JSModuleReferenceBase reference, @NotNull PsiElement toBind, boolean isAbsolute) {
        if (reference == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(0);
        }
        if (toBind == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(1);
        }
        this.myReference = reference;
        this.myBind = toBind;
        this.myAbsolute = isAbsolute;
    }

    @Nullable
    public PsiElement bind() {
        boolean isBindTypeScript;
        String[] extensions;
        PsiElement element = this.myReference.getElement();
        if (!element.isValid() || !this.myReference.isLast() || this.myAbsolute) {
            return null;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)this.myBind);
        if (file2 == null || file2.isDirectory()) {
            return null;
        }
        boolean isRelative = this.myReference.isRelativeCommonPath();
        if (!isRelative && JSFileReference.checkReferencedFileFromNodeModules(this.myBind)) {
            return element;
        }
        FileReferenceSet set = this.myReference.getFileReferenceSet();
        String path = set.getPathString();
        String extension = JSFileReference.findExtension(path, extensions = this.myReference.getSortedByLengthImplicitExtensions());
        final boolean hasExtension = extension != null;
        JSImportPathConfigurationImpl configuration = new JSImportPathConfigurationImpl(element, file2, isBindTypeScript = DialectDetector.isTypeScript(this.myBind), extension, isRelative, set){
            final /* synthetic */ boolean val$isBindTypeScript;
            final /* synthetic */ String val$extension;
            final /* synthetic */ boolean val$isRelative;
            final /* synthetic */ FileReferenceSet val$set;
            {
                this.val$isBindTypeScript = bl2;
                this.val$extension = string;
                this.val$isRelative = bl3;
                this.val$set = fileReferenceSet;
                super(arg0, arg1);
            }

            @Override
            public boolean forceExtension() {
                return hasExtension;
            }

            @Override
            @NotNull
            public JSModuleNameInfo.ExtensionSettings getPathSettings() {
                if (hasExtension && this.val$isBindTypeScript && TypeScriptFileImportsResolver.isTsExtension(this.val$extension)) {
                    JSModuleNameInfo.ExtensionSettings extensionSettings = JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
                    if (extensionSettings == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return extensionSettings;
                }
                if (hasExtension && DialectDetector.isTypeScript(this.getPlace()) && !this.val$isBindTypeScript) {
                    JSModuleNameInfo.ExtensionSettings extensionSettings = JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
                    if (extensionSettings == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return extensionSettings;
                }
                JSModuleNameInfo.ExtensionSettings extensionSettings = super.getPathSettings();
                if (extensionSettings == null) {
                    1.$$$reportNull$$$0(2);
                }
                return extensionSettings;
            }

            @Override
            public boolean isProcessRootPaths() {
                return !this.val$isRelative && !JSReferencePathUpdater.this.isMappingSet(this.val$set) || super.isProcessRootPaths();
            }

            @Override
            public boolean relativeForSamePathMappings() {
                if (!this.usePathMappings()) {
                    return false;
                }
                if (this.val$isRelative) {
                    return true;
                }
                return super.relativeForSamePathMappings();
            }

            @Override
            public String @NotNull [] extensions() {
                String[] stringArray = JSReferencePathUpdater.this.myReference.getImplicitExtensions();
                if (stringArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return stringArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/frameworks/modules/JSReferencePathUpdater$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPathSettings";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "extensions";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        JSImportPathBuilder builder = JSImportPathBuilder.createBuilder(configuration);
        JSModuleNameInfo name = ES6CreateImportUtil.getExternalFileModuleName(builder);
        if (name == null) {
            return null;
        }
        return this.remapForInfo(name, element, set);
    }

    @Nullable
    public PsiElement remapForInfo(@NotNull JSModuleNameInfo name, @NotNull PsiElement element, @NotNull FileReferenceSet set) {
        if (name == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(3);
        }
        if (set == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(4);
        }
        int startOffsetInHost = set.getStartInElement();
        if (this.isMappingSet(set)) {
            JSMappingReferenceSet.MappingFileReferenceSet mappingSet = (JSMappingReferenceSet.MappingFileReferenceSet)set;
            startOffsetInHost = mappingSet.getStartOffsetInHost();
        }
        TextRange range = new TextRange(startOffsetInHost, this.myReference.getRangeInElement().getEndOffset());
        return JSReferencePathUpdater.renameWithManipulator(element, range, name.getModuleName());
    }

    public boolean isMappingSet(@NotNull FileReferenceSet set) {
        if (set == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(5);
        }
        return set instanceof JSMappingReferenceSet.MappingFileReferenceSet;
    }

    @Nullable
    public static PsiElement renameWithManipulator(@NotNull PsiElement element, @NotNull TextRange range, @NotNull String newName) {
        if (element == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(6);
        }
        if (range == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(7);
        }
        if (newName == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(8);
        }
        return CachingReference.getManipulator((PsiElement)element).handleContentChange(element, range, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSReferencePathUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "remapForInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMappingSet";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "renameWithManipulator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

