/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.punctuation;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class JSCodeStylePunctuationPanel
extends CodeStyleAbstractPanel {
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private ComboBox myQuotesTypeCombobox;
    private ComboBox myEnforceQuotesCombobox;
    protected ComboBox myEnforceSemicolonsCombobox;
    private ComboBox myUseSemicolonsCombobox;
    private ComboBox myTrailingCommaComboBox;
    private boolean myInsideUpdate = false;

    public JSCodeStylePunctuationPanel(Language language, CodeStyleSettings settings, boolean showAddTrailingComma) {
        super(language, null, settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        this.addPanelToWatch(this.myPanel);
        ItemListener listener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JSCodeStylePunctuationPanel.this.myInsideUpdate) {
                    JSCodeStylePunctuationPanel.this.somethingChanged();
                }
            }
        };
        this.myQuotesTypeCombobox.addItemListener(listener2);
        this.myEnforceQuotesCombobox.addItemListener(listener2);
        this.myEnforceSemicolonsCombobox.addItemListener(listener2);
        this.myUseSemicolonsCombobox.addItemListener(listener2);
        JSCodeStylePunctuationPanel.initCombobox((JComboBox)this.myQuotesTypeCombobox, JavaScriptBundle.message((String)"settings.code.style.double", (Object[])new Object[0]), JavaScriptBundle.message((String)"settings.code.style.single", (Object[])new Object[0]));
        JSCodeStylePunctuationPanel.initCombobox((JComboBox)this.myEnforceQuotesCombobox, JavaScriptBundle.message((String)"settings.code.style.in.new.code", (Object[])new Object[0]), JavaScriptBundle.message((String)"settings.code.style.always", (Object[])new Object[0]));
        JSCodeStylePunctuationPanel.initCombobox((JComboBox)this.myUseSemicolonsCombobox, JavaScriptBundle.message((String)"settings.code.style.option.use", (Object[])new Object[0]), JavaScriptBundle.message((String)"settings.code.style.dont.use", (Object[])new Object[0]));
        JSCodeStylePunctuationPanel.initCombobox((JComboBox)this.myEnforceSemicolonsCombobox, JavaScriptBundle.message((String)"settings.code.style.in.new.code", (Object[])new Object[0]), JavaScriptBundle.message((String)"settings.code.style.always", (Object[])new Object[0]));
        ArrayList trailingCommaOptions = ContainerUtil.newArrayList((Object[])new SimpleComboboxItem[]{new SimpleComboboxItem<JSCodeStyleSettings.TrailingCommaOption>(JSCodeStyleSettings.TrailingCommaOption.Keep, JavaScriptBundle.message((String)"js.trailing.comma.keep", (Object[])new Object[0])), new SimpleComboboxItem<JSCodeStyleSettings.TrailingCommaOption>(JSCodeStyleSettings.TrailingCommaOption.Remove, JavaScriptBundle.message((String)"js.trailing.comma.remove", (Object[])new Object[0]))});
        if (showAddTrailingComma) {
            trailingCommaOptions.add(new SimpleComboboxItem<JSCodeStyleSettings.TrailingCommaOption>(JSCodeStyleSettings.TrailingCommaOption.WhenMultiline, JavaScriptBundle.message((String)"js.trailing.comma.whenMultiline", (Object[])new Object[0])));
        }
        JSCodeStylePunctuationPanel.initCombobox((JComboBox)this.myTrailingCommaComboBox, trailingCommaOptions);
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(this.getFileType())).getEditorHighlighter(ProjectUtil.guessCurrentProject((JComponent)this.getPanel()), this.getFileType(), null, scheme);
    }

    protected int getRightMargin() {
        return 60;
    }

    @NotNull
    protected abstract FileType getFileType();

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = JavaScriptBundle.message((String)"js.code.style.punctuation.tab.title", (Object[])new Object[0]);
        if (string == null) {
            JSCodeStylePunctuationPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected String getPreviewText() {
        return "/*\n Multiline\n C-style\n Comment\n */\nvar myLink = {\n      img: \"btn.gif\",\n      text: \"Button\",\n      width: 128\n    },\n    local = true,\n    initial = -1;\nvar cssClasses = [\"bold\", \"red\",]\nvar selector = \"#id\";\n\nvar color = \"red\";\nvar offset = 10;\n\nvarName = val;";
    }

    public void apply(CodeStyleSettings settings) {
        Project project;
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        boolean useSemicolons = this.useSemicolonSelected();
        if (useSemicolons != jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT && !(project = ProjectUtil.guessCurrentProject((JComponent)this.getPanel())).isDefault()) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
        jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT = useSemicolons;
        jsCodeStyleSettings.FORCE_SEMICOLON_STYLE = this.enforceSemicolonsSelected();
        jsCodeStyleSettings.ENFORCE_TRAILING_COMMA = (JSCodeStyleSettings.TrailingCommaOption)((Object)JSCodeStylePunctuationPanel.getComboboxValue((JComboBox)this.myTrailingCommaComboBox));
        jsCodeStyleSettings.USE_DOUBLE_QUOTES = this.doubleQuotesSelected();
        jsCodeStyleSettings.FORCE_QUOTE_STYlE = this.enforceQuotesSelected();
    }

    public boolean isModified(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        return jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT != this.useSemicolonSelected() || jsCodeStyleSettings.ENFORCE_TRAILING_COMMA != JSCodeStylePunctuationPanel.getComboboxValue((JComboBox)this.myTrailingCommaComboBox) || jsCodeStyleSettings.USE_DOUBLE_QUOTES != this.doubleQuotesSelected() || jsCodeStyleSettings.FORCE_QUOTE_STYlE != this.enforceQuotesSelected() || jsCodeStyleSettings.FORCE_SEMICOLON_STYLE != this.enforceSemicolonsSelected();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    @NotNull
    public Set<String> processListOptions() {
        HashSet<String> options = new HashSet<String>(super.processListOptions());
        options.add(JavaScriptBundle.message((String)"settings.code.style.single", (Object[])new Object[0]));
        options.add(JavaScriptBundle.message((String)"settings.code.style.double", (Object[])new Object[0]));
        options.add(JavaScriptBundle.message((String)"settings.code.style.always", (Object[])new Object[0]));
        options.add(JavaScriptBundle.message((String)"settings.code.style.in.new.code", (Object[])new Object[0]));
        HashSet<String> hashSet = options;
        if (hashSet == null) {
            JSCodeStylePunctuationPanel.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        try {
            this.myInsideUpdate = true;
            JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
            JSCodeStylePunctuationPanel.selectComboboxValue((JComboBox)this.myTrailingCommaComboBox, jsCodeStyleSettings.ENFORCE_TRAILING_COMMA);
            JSCodeStylePunctuationPanel.selectComboboxValue((JComboBox)this.myQuotesTypeCombobox, jsCodeStyleSettings.USE_DOUBLE_QUOTES ? JavaScriptBundle.message((String)"settings.code.style.double", (Object[])new Object[0]) : JavaScriptBundle.message((String)"settings.code.style.single", (Object[])new Object[0]));
            JSCodeStylePunctuationPanel.selectComboboxValue((JComboBox)this.myEnforceQuotesCombobox, jsCodeStyleSettings.FORCE_QUOTE_STYlE ? JavaScriptBundle.message((String)"settings.code.style.always", (Object[])new Object[0]) : JavaScriptBundle.message((String)"settings.code.style.in.new.code", (Object[])new Object[0]));
            JSCodeStylePunctuationPanel.selectComboboxValue((JComboBox)this.myEnforceSemicolonsCombobox, jsCodeStyleSettings.FORCE_SEMICOLON_STYLE ? JavaScriptBundle.message((String)"settings.code.style.always", (Object[])new Object[0]) : JavaScriptBundle.message((String)"settings.code.style.in.new.code", (Object[])new Object[0]));
            JSCodeStylePunctuationPanel.selectComboboxValue((JComboBox)this.myUseSemicolonsCombobox, jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT ? JavaScriptBundle.message((String)"settings.code.style.option.use", (Object[])new Object[0]) : JavaScriptBundle.message((String)"settings.code.style.dont.use", (Object[])new Object[0]));
        }
        finally {
            this.myInsideUpdate = false;
        }
    }

    private boolean enforceQuotesSelected() {
        return JSCodeStylePunctuationPanel.getComboboxValue((JComboBox)this.myEnforceQuotesCombobox) == JavaScriptBundle.message((String)"settings.code.style.always", (Object[])new Object[0]);
    }

    private boolean enforceSemicolonsSelected() {
        return JSCodeStylePunctuationPanel.getComboboxValue((JComboBox)this.myEnforceSemicolonsCombobox) == JavaScriptBundle.message((String)"settings.code.style.always", (Object[])new Object[0]);
    }

    protected boolean useSemicolonSelected() {
        return JSCodeStylePunctuationPanel.getComboboxValue((JComboBox)this.myUseSemicolonsCombobox) == JavaScriptBundle.message((String)"settings.code.style.option.use", (Object[])new Object[0]);
    }

    private boolean doubleQuotesSelected() {
        return JSCodeStylePunctuationPanel.getComboboxValue((JComboBox)this.myQuotesTypeCombobox) == JavaScriptBundle.message((String)"settings.code.style.double", (Object[])new Object[0]);
    }

    private JSCodeStyleSettings getCustomJSSettings(CodeStyleSettings settings) {
        return (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.getDefaultLanguage()));
    }

    private static void initCombobox(JComboBox combobox, String ... items) {
        JSCodeStylePunctuationPanel.initCombobox(combobox, ContainerUtil.map((Object[])items, s -> new SimpleComboboxItem<String>((String)s, (String)s)));
    }

    private static <T> void initCombobox(JComboBox combobox, List<SimpleComboboxItem<T>> items) {
        for (SimpleComboboxItem<T> object : items) {
            combobox.addItem(object);
        }
        if (items.size() > 0) {
            combobox.setSelectedItem(items.get(0));
        }
    }

    private static <T> T getComboboxValue(JComboBox combobox) {
        return ((SimpleComboboxItem)combobox.getSelectedItem()).getValue();
    }

    private static <T> void selectComboboxValue(JComboBox combobox, T value) {
        for (int i = 0; i < combobox.getItemCount(); ++i) {
            Object item = combobox.getItemAt(i);
            if (!(item instanceof SimpleComboboxItem) || ((SimpleComboboxItem)item).getValue() != value) continue;
            combobox.setSelectedIndex(i);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/formatter/punctuation/JSCodeStylePunctuationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        ComboBox comboBox4;
        ComboBox comboBox5;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), 10, -1, false, false));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(0, 10, 0, 0), (String)"", (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 1, 1, 0, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSCodeStylePunctuationPanel.class).getString("settings.code.style.semicolon.to.terminate.statements"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myEnforceSemicolonsCombobox = comboBox5 = new ComboBox();
        jPanel4.add((Component)comboBox5, new GridConstraints(0, 2, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myUseSemicolonsCombobox = comboBox4 = new ComboBox();
        jPanel4.add((Component)comboBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSCodeStylePunctuationPanel.class).getString("settings.code.style.use"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myQuotesTypeCombobox = comboBox3 = new ComboBox();
        jPanel5.add((Component)comboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSCodeStylePunctuationPanel.class).getString("settings.code.style.quotes"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnforceQuotesCombobox = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 3, 1, 3, 8, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 6, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSCodeStylePunctuationPanel.class).getString("settings.code.style.Trailing.comma"));
        jPanel6.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTrailingCommaComboBox = comboBox = new ComboBox();
        jPanel6.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 5, 1, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox4);
        jLabel.setLabelFor((Component)comboBox3);
        jLabel2.setLabelFor((Component)comboBox2);
        jBLabel2.setLabelFor((Component)comboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class SimpleComboboxItem<T> {
        private final String myTitle;
        private final T myValue;

        SimpleComboboxItem(T value, String title) {
            this.myValue = value;
            this.myTitle = title;
        }

        public T getValue() {
            return this.myValue;
        }

        public String toString() {
            return this.myTitle;
        }
    }
}

