/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.FormattableInjectedBlockInJS;
import com.intellij.lang.javascript.formatter.JSBinaryExpressionBlock;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSBlockEx;
import com.intellij.lang.javascript.formatter.blocks.JSParameterBlock;
import com.intellij.lang.javascript.formatter.blocks.JSParameterListBlock;
import com.intellij.lang.javascript.formatter.blocks.JSSpacingStrategy;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.injections.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.typescript.formatter.TypedJSSpacingProcessor;
import com.intellij.lang.typescript.formatter.blocks.TypedJSSubBlockVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.formatter.chainedMethods.CallChainDotBlock;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlockContext {
    @NotNull
    private final CommonCodeStyleSettings myCommonSettings;
    @NotNull
    private final CodeStyleSettings myTopSettings;
    @NotNull
    private final Language myDialect;
    @Nullable
    protected XmlFormattingPolicy myPolicy;
    @NotNull
    private final JSCodeStyleSettings myDialectSettings;
    @NotNull
    private final FormattingMode myFormattingMode;

    public JSBlockContext(@NotNull CodeStyleSettings topSettings, @NotNull Language dialect, @Nullable JSCodeStyleSettings explicitSettings, @NotNull FormattingMode formattingMode) {
        if (topSettings == null) {
            JSBlockContext.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            JSBlockContext.$$$reportNull$$$0(1);
        }
        if (formattingMode == null) {
            JSBlockContext.$$$reportNull$$$0(2);
        }
        this.myTopSettings = topSettings;
        this.myFormattingMode = formattingMode;
        this.myDialectSettings = (JSCodeStyleSettings)((Object)ObjectUtils.coalesce((Object)((Object)explicitSettings), (Object)((Object)((JSCodeStyleSettings)topSettings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(dialect))))));
        this.myCommonSettings = topSettings.getCommonSettings(dialect);
        this.myDialect = dialect;
    }

    public void setXmlFormattingPolicy(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myPolicy = xmlFormattingPolicy;
    }

    @NotNull
    public static JSBlockContext createDefault(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JSBlockContext.$$$reportNull$$$0(3);
        }
        return new JSBlockContext(settings, (Language)JavascriptLanguage.INSTANCE, null, FormattingMode.REFORMAT);
    }

    @NotNull
    public FormattingMode getFormattingMode() {
        FormattingMode formattingMode = this.myFormattingMode;
        if (formattingMode == null) {
            JSBlockContext.$$$reportNull$$$0(4);
        }
        return formattingMode;
    }

    @NotNull
    public CodeStyleSettings getTopSettings() {
        CodeStyleSettings codeStyleSettings = this.myTopSettings;
        if (codeStyleSettings == null) {
            JSBlockContext.$$$reportNull$$$0(5);
        }
        return codeStyleSettings;
    }

    @NotNull
    public Language getDialect() {
        Language language = this.myDialect;
        if (language == null) {
            JSBlockContext.$$$reportNull$$$0(6);
        }
        return language;
    }

    @NotNull
    public JSCodeStyleSettings getDialectSettings() {
        JSCodeStyleSettings jSCodeStyleSettings = this.myDialectSettings;
        if (jSCodeStyleSettings == null) {
            JSBlockContext.$$$reportNull$$$0(7);
        }
        return jSCodeStyleSettings;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = this.myCommonSettings;
        if (commonCodeStyleSettings == null) {
            JSBlockContext.$$$reportNull$$$0(8);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public Block createBlock(@NotNull ASTNode child, @Nullable Wrap wrap, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @Nullable JSBlock parentBlock) {
        Block templateLanguageBlock;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(9);
        }
        if (child instanceof JSXmlLiteralExpression && this.myPolicy != null) {
            return new SubBlockVisitor.JSXmlTagBlock(child, wrap, childAlignment, this.myPolicy, childIndent, parentBlock);
        }
        if (child.getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION && parentBlock != null && parentBlock.processInjections() && JSFormattableInjectionUtil.hostContainsFormattableInjection(child.getPsi())) {
            return new FormattableInjectedBlockInJS(child, childAlignment, childIndent, wrap, this.myTopSettings);
        }
        if (child.getPsi() instanceof OuterLanguageElement && (templateLanguageBlock = TemplateFormatUtil.buildTemplateLanguageBlock((OuterLanguageElement)((OuterLanguageElement)child.getPsi()), (CodeStyleSettings)this.myTopSettings, (Indent)childIndent)) != null) {
            Block block = templateLanguageBlock;
            if (block == null) {
                JSBlockContext.$$$reportNull$$$0(10);
            }
            return block;
        }
        JSBlock jSBlock = this.createSubBlock(child, childAlignment, childIndent, wrap, alignmentFactory, parentBlock);
        if (jSBlock == null) {
            JSBlockContext.$$$reportNull$$$0(11);
        }
        return jSBlock;
    }

    @NotNull
    protected JSBlock createSubBlock(@NotNull ASTNode child, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @Nullable JSBlock parentBlock) {
        IElementType childType;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(12);
        }
        if ((childType = child.getElementType()) == JSElementTypes.BINARY_EXPRESSION) {
            return JSBlockContext.indentEachBinaryOperandSeparately(child, parentBlock) ? new JSBinaryExpressionBlock(child, childAlignment, Indent.getNoneIndent(), wrap, true, sharedAlignmentFactory, this) : new JSBinaryExpressionBlock(child, childAlignment, childIndent, wrap, false, sharedAlignmentFactory, this);
        }
        if (childType == JSElementTypes.ARGUMENT_LIST) {
            return this.createParameterListBLock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
        }
        ASTNode parent = child.getTreeParent();
        if (parent != null) {
            IElementType parentType = parent.getElementType();
            if (parentType == JSElementTypes.ARGUMENT_LIST) {
                if (childType != JSTokenTypes.LPAR && (childType != JSTokenTypes.RPAR || JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child)) && childType != JSTokenTypes.COMMA) {
                    return this.createParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
                }
            } else if ((parentType == JSElementTypes.REFERENCE_EXPRESSION || parentType == ES6ElementTypes.BIND_EXPRESSION) && JSBlock.CALL_CHAIN_DOT_LIKE_TYPES.contains(childType)) {
                return new JSDotBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
            }
        }
        return this.createDefaultBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
    }

    private static boolean indentEachBinaryOperandSeparately(@NotNull ASTNode child, JSBlock parentBlock) {
        ASTNode parent;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(13);
        }
        if ((parent = child.getTreeParent()) == null || parentBlock == null) {
            return false;
        }
        IElementType parentElementType = parent.getElementType();
        return parentElementType == JSStubElementTypes.RETURN_STATEMENT || parentElementType == JSElementTypes.ARGUMENT_LIST || parentElementType == JSElementTypes.PARENTHESIZED_EXPRESSION && !SubBlockVisitor.shouldIndentParenthesized(parent) || parentElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION || JSElementTypes.FUNCTION_EXPRESSIONS.contains(parentElementType) || JSStubElementTypes.PROPERTY == parentElementType || JSElementTypes.IF_STATEMENT == parentElementType || JSElementTypes.BODY_VARIABLES.contains(parentElementType) || parentElementType == JSElementTypes.CONDITIONAL_EXPRESSION && child != parent.getFirstChildNode();
    }

    @NotNull
    public JSSpacingStrategy createSpacingStrategy(@NotNull ASTNode node) {
        if (node == null) {
            JSBlockContext.$$$reportNull$$$0(14);
        }
        return new JSSpacingStrategy(this.myDialectSettings, this.getCommonSettings(), (child1, child2) -> this.createSpacingProcessor(node, (ASTNode)child1, (ASTNode)child2).calcSpacing());
    }

    @NotNull
    private JSSpacingProcessor createSpacingProcessor(ASTNode node, ASTNode child1, ASTNode child2) {
        return JSBlockContext.isTypedJSDialect(this.myDialect) ? new TypedJSSpacingProcessor(node, child1, child2, this.getTopSettings(), this.getDialect(), this.myDialectSettings) : new JSSpacingProcessor(node, child1, child2, this.getTopSettings(), this.getDialect(), this.myDialectSettings);
    }

    @NotNull
    public SubBlockVisitor createSubBlockVisitor(@NotNull JSBlock parentBlock, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory) {
        if (parentBlock == null) {
            JSBlockContext.$$$reportNull$$$0(15);
        }
        return JSBlockContext.isTypedJSDialect(this.myDialect) ? new TypedJSSubBlockVisitor(parentBlock, alignmentFactory, this) : new SubBlockVisitor(parentBlock, alignmentFactory, this);
    }

    @NotNull
    private JSBlock createParameterListBLock(@NotNull ASTNode child, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(16);
        }
        return new JSParameterListBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
    }

    @NotNull
    private JSBlock createParameterBlock(@NotNull ASTNode child, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(17);
        }
        return new JSParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
    }

    @NotNull
    private JSBlock createDefaultBlock(@NotNull ASTNode child, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(18);
        }
        return new JSBlockEx(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
    }

    private static boolean isTypedJSDialect(@NotNull Language dialect) {
        if (dialect == null) {
            JSBlockContext.$$$reportNull$$$0(19);
        }
        return dialect == JavaScriptSupportLoader.FLOW_JS || dialect.isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topSettings";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSBlockContext";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSBlockContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattingMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefault";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createBlock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSubBlock";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "indentEachBinaryOperandSeparately";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSpacingStrategy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSubBlockVisitor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createParameterListBLock";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createParameterBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBlock";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTypedJSDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSDotBlock
    extends JSBlockEx
    implements CallChainDotBlock {
        JSDotBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSBlockContext jsBlockContext) {
            if (node == null) {
                JSDotBlock.$$$reportNull$$$0(0);
            }
            if (jsBlockContext == null) {
                JSDotBlock.$$$reportNull$$$0(1);
            }
            super(node, alignment, indent, wrap, sharedAlignmentFactory, jsBlockContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jsBlockContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/formatter/JSBlockContext$JSDotBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

