/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.lsp.FlowJSHighlightingCache;
import com.intellij.lang.javascript.flow.lsp.FlowJSLanguageClient;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspServiceKt;
import com.intellij.lang.javascript.flow.lsp.FlowJSOpenedFilesTracker;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSLanguageServerConnector
implements JSLanguageServiceConnector,
Disposable {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final FlowJSConfig myConfig;
    @NotNull
    private final FlowJSLanguageClient myLanguageClient;
    @Nullable
    @Nls
    private String myInitializeError;
    @Nullable
    private LanguageServer myServer;
    @NotNull
    final FlowJSHighlightingCache myHighlightingCache;
    @NotNull
    final FlowJSOpenedFilesTracker myOpenedFilesTracker;
    private static final ThreadFactory ourThreadFactory = ConcurrencyUtil.newNamedThreadFactory((String)"LSP messages reader");
    @NotNull
    private static final BaseOutputReader.Options LSP_READER_OPTIONS = new BaseOutputReader.Options(){

        public boolean splitToLines() {
            return false;
        }

        public BaseDataReader.SleepingPolicy policy() {
            return BaseDataReader.SleepingPolicy.BLOCKING;
        }
    };

    public FlowJSLanguageServerConnector(@NotNull Project project, @NotNull FlowJSConfig config2) {
        if (project == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(0);
        }
        if (config2 == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConfig = config2;
        this.myHighlightingCache = new FlowJSHighlightingCache(project, config2, this);
        this.myOpenedFilesTracker = new FlowJSOpenedFilesTracker(this);
        this.myLanguageClient = new FlowJSLanguageClient(this.myHighlightingCache);
    }

    @NotNull
    private GeneralCommandLine createCommandLine() {
        FlowJSSettings.FlowJSExecutable executable = this.getFlowExecutable();
        if (executable == null) {
            this.myInitializeError = JavaScriptBundle.message((String)"can.t.find.flow.executable", (Object[])new Object[0]);
            throw new RuntimeException(this.myInitializeError);
        }
        GeneralCommandLine line = executable.createCommandLine(this.myProject);
        line.addParameter("lsp");
        line.setWorkDirectory(this.myConfig.getConfigDirectory().getPath());
        GeneralCommandLine generalCommandLine = line;
        if (generalCommandLine == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    @Override
    @Nullable
    public ProcessHandler connect() throws Exception {
        GeneralCommandLine line = this.createCommandLine();
        return new FlowJSLspProcessHandler(line);
    }

    @Override
    public boolean awaitReadyNotification(@NotNull ProcessHandler _processHandler) throws InterruptedException {
        LanguageServer remoteProxy;
        if (_processHandler == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(3);
        }
        OSProcessHandler processHandler = (OSProcessHandler)_processHandler;
        this.myServer = remoteProxy = this.createLanguageServer(processHandler);
        processHandler.startNotify();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        InitializeParams params = new InitializeParams();
        params.setRootUri(FlowJSLspServiceKt.toURI(this.myConfig.getConfigDirectory()));
        remoteProxy.initialize(params).thenAccept(initializeResult -> {
            remoteProxy.initialized(new InitializedParams());
            countDownLatch.countDown();
        });
        return countDownLatch.await(30L, TimeUnit.SECONDS);
    }

    @NotNull
    private LanguageServer createLanguageServer(final OSProcessHandler processHandler) {
        PipedInputStream pipedInputStream;
        LinkedHashMap supportedMethods = new LinkedHashMap(ServiceEndpoints.getSupportedMethods(LanguageServer.class));
        supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(this.myLanguageClient.getClass()));
        final MessageJsonHandler jsonHandler = new MessageJsonHandler(supportedMethods);
        StreamMessageConsumer baseStream = new StreamMessageConsumer(processHandler.getProcessInput(), jsonHandler);
        MessageConsumer outGoingMessageStream = new MessageConsumer((MessageConsumer)baseStream){
            final /* synthetic */ MessageConsumer val$baseStream;
            {
                this.val$baseStream = messageConsumer;
            }

            public void consume(Message message) {
                if (processHandler instanceof FlowJSLspProcessHandler) {
                    ((FlowJSLspProcessHandler)processHandler).processInputMessage(jsonHandler.serialize(message));
                }
                this.val$baseStream.consume(message);
            }
        };
        RemoteEndpoint serverEndpoint = new RemoteEndpoint(outGoingMessageStream, ServiceEndpoints.toEndpoint((Object)this.myLanguageClient));
        jsonHandler.setMethodProvider((MethodProvider)serverEndpoint);
        LanguageServer remoteProxy = (LanguageServer)ServiceEndpoints.toServiceObject((Endpoint)serverEndpoint, LanguageServer.class);
        final PipedOutputStream pipedOutputStream = new PipedOutputStream();
        final OutputStreamWriter writer = new OutputStreamWriter((OutputStream)pipedOutputStream, StandardCharsets.UTF_8);
        try {
            pipedInputStream = new PipedInputStream(pipedOutputStream);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        final StreamMessageProducer messageProducer = new StreamMessageProducer((InputStream)pipedInputStream, jsonHandler);
        ourThreadFactory.newThread(() -> messageProducer.listen((MessageConsumer)serverEndpoint)).start();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                String text = event.getText();
                if (ProcessOutputType.isStdout((Key)outputType)) {
                    try {
                        writer.write(text);
                        writer.flush();
                    }
                    catch (IOException e) {
                        JSLanguageServiceQueue.LOGGER.error((Throwable)e);
                    }
                } else if (ProcessOutputType.isStderr((Key)outputType)) {
                    JSLanguageServiceQueue.LOGGER.warn("Flow LSP stderr: " + text);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                try {
                    messageProducer.close();
                    pipedInputStream.close();
                    pipedOutputStream.close();
                }
                catch (IOException e) {
                    JSLanguageServiceQueue.LOGGER.error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/flow/lsp/FlowJSLanguageServerConnector$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LanguageServer languageServer = remoteProxy;
        if (languageServer == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(4);
        }
        return languageServer;
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    @Nullable
    LanguageServer getServer() {
        return this.myServer;
    }

    @Nullable
    private FlowJSSettings.FlowJSExecutable getFlowExecutable() {
        return FlowJSSettingsManager.getInstance(this.myProject).getRawSettings().getFlowExecutable();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/lsp/FlowJSLanguageServerConnector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/lsp/FlowJSLanguageServerConnector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "awaitReadyNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FlowJSLspProcessHandler
    extends OSProcessHandler {
        @NotNull
        private final Collection<Consumer<String>> myInputListeners;

        public FlowJSLspProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                FlowJSLspProcessHandler.$$$reportNull$$$0(0);
            }
            super(commandLine);
            this.myInputListeners = new ConcurrentLinkedQueue<Consumer<String>>();
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = LSP_READER_OPTIONS;
            if (options == null) {
                FlowJSLspProcessHandler.$$$reportNull$$$0(1);
            }
            return options;
        }

        public void subscribeToInputStream(@NotNull Consumer<String> listener2) {
            if (listener2 == null) {
                FlowJSLspProcessHandler.$$$reportNull$$$0(2);
            }
            this.myInputListeners.add(listener2);
        }

        public void processInputMessage(String message) {
            for (Consumer<String> listener2 : this.myInputListeners) {
                listener2.accept(message);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flow/lsp/FlowJSLanguageServerConnector$FlowJSLspProcessHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flow/lsp/FlowJSLanguageServerConnector$FlowJSLspProcessHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "subscribeToInputStream";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

