/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JavaScriptResolveScopeProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSResolveScopeProvider
extends JavaScriptResolveScopeProvider {
    private static final Key<Set<VirtualFile>> FLOW_PREDEFINED_LIBRARY_SCOPE_KEY = Key.create((String)"js.flow.predefined.library.scope");

    @Override
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file2, Project project) {
        if (file2 == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (!FlowJSResolveScopeProvider.isApplicable(file2)) {
            return null;
        }
        if (!FlowJSResolveScopeProvider.useFlowPredefinedLibrary(file2, project)) {
            return super.getResolveScope(file2, project);
        }
        Set<VirtualFile> flowPredefinedFiles = (Set<VirtualFile>)project.getUserData(FLOW_PREDEFINED_LIBRARY_SCOPE_KEY);
        if (flowPredefinedFiles == null) {
            flowPredefinedFiles = FlowJSResolveScopeProvider.getPredefinedFlowLibraryFiles();
            project.putUserData(FLOW_PREDEFINED_LIBRARY_SCOPE_KEY, flowPredefinedFiles);
        }
        Set libraryFilesToExclude = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            SyntheticLibrary library;
            ScriptingLibraryModel nodeLibrary;
            HashSet result2 = new HashSet();
            ScriptingLibraryModel htmlLibrary = JSLibraryManager.getInstance(project).getLibraryByName("HTML");
            if (htmlLibrary != null) {
                result2.addAll(htmlLibrary.getSourceFiles());
            }
            if ((nodeLibrary = JSLibraryManager.getInstance(project).getLibraryByName("Node.js Core")) instanceof ScriptingLibraryModelBackedBySyntheticLibrary && (library = ((ScriptingLibraryModelBackedBySyntheticLibrary)nodeLibrary).getSyntheticLibrary()) != null) {
                result2.addAll(library.getSourceRoots());
            }
            return new CachedValueProvider.Result(result2, new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
        });
        return this.getProjectAndLibrariesScope(file2, project, flowPredefinedFiles, libraryFilesToExclude);
    }

    private static boolean useFlowPredefinedLibrary(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        return FlowJSResolveScopeProvider.useFlowPredefinedLibrary(psiFile);
    }

    public static boolean useFlowPredefinedLibrary(@Nullable PsiFile file2) {
        return file2 instanceof JSFile && DialectDetector.isFlow((PsiElement)file2) && (FlowJSAnnotation.hasFlowAnnotation(file2) || FlowJSResolveScopeProvider.getPredefinedFlowLibraryFiles().contains(file2.getOriginalFile().getVirtualFile()));
    }

    @NotNull
    private static Set<VirtualFile> getPredefinedFlowLibraryFiles() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getFlowJSPredefinedLibraryFiles());
        files.addAll(JSCorePredefinedLibrariesProvider.getFlowJSCorePredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSResolveScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSResolveScopeProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedFlowLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "useFlowPredefinedLibrary";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

