/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.FlowJSErrorsParser;
import com.intellij.lang.javascript.flow.FlowJSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSAutocompleteCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCheckContentsCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCommandWithArgument;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCoverageCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSFindModuleCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSGetDefinitionCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSStatusCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSTypeInfoCommand;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSCliService
extends FlowJSServerService
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance(FlowJSServerService.class);
    public static final long LARGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    @NotNull
    private final JSLanguageServiceDefaultCacheData myCacheData;
    private static final ImmutableList<JSAnnotationError> HAS_UNSAVED_FILES_RESULT = ContainerUtil.immutableList((Object[])new JSAnnotationError[]{new JSLanguageServiceAnnotationResult(JavaScriptBundle.message((String)"js.flow.has.unsaved.files", (Object[])new Object[0]), null, null, null, 0, 0, 0, 0)});

    FlowJSCliService(@NotNull FlowJSConfig config2, @NotNull Project project, @NotNull String consoleId) {
        if (config2 == null) {
            FlowJSCliService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlowJSCliService.$$$reportNull$$$0(1);
        }
        if (consoleId == null) {
            FlowJSCliService.$$$reportNull$$$0(2);
        }
        super(config2, project, consoleId);
        this.myCacheData = new JSLanguageServiceDefaultCacheData(){

            @Override
            @Nullable
            public <T> T getValueFromCache(@NotNull JSLanguageServiceCacheableCommand input) {
                if (input == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map<JSLanguageServiceCacheableCommand, JsonObject> cache2 = this.getCache();
                return (T)cache2.get(input);
            }

            @Override
            public <T> void putCacheValue(@NotNull JSLanguageServiceCacheableCommand input, @Nullable JSLanguageServiceAnswer answer, @Nullable T value) {
                if (input == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (value == null) {
                    return;
                }
                Map<JSLanguageServiceCacheableCommand, JsonObject> cache2 = this.getCache();
                cache2.put(input, (JsonObject)value);
            }

            @Override
            public void clear() {
                this.getCache().clear();
            }

            private Map<JSLanguageServiceCacheableCommand, JsonObject> getCache() {
                return (Map)CachedValuesManager.getManager((Project)FlowJSCliService.this.myProject).getCachedValue((UserDataHolder)FlowJSCliService.this.myProject, () -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            }

            @Override
            @NotNull
            public JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
                if (input == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new JSLanguageServiceObject(){};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "input";
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSCliService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getValueFromCache";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "putCacheValue";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCacheAndGetServiceObject";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    protected long getAliveCheckTimeout() {
        return TimeUnit.MINUTES.toMillis(3L);
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        FlowJSStandardOutputProtocol protocol = new FlowJSStandardOutputProtocol(this.myProject, this.myConfig);
        return new FlowJSLanguageServiceQueueImpl(this.myProject, protocol, this.myProcessConnector, (JSLanguageServiceQueue.ServiceInfoReporter)this.createDefaultReporter(), (JSLanguageServiceCacheData)this.myCacheData);
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue getProcess() {
        return (JSLanguageServiceQueue)super.getProcess();
    }

    @Nullable
    private JsonObject awaitCommand(@NotNull JSLanguageServiceCacheableCommand command, long timeoutMillis) {
        JSLanguageServiceQueue process;
        if (command == null) {
            FlowJSCliService.$$$reportNull$$$0(3);
        }
        if ((process = this.getProcess()) == null || !process.isValid()) {
            return null;
        }
        CompletableFuture<JsonObject> future = process.executeWithCache(command, new JSLanguageServiceCacheableCommandProcessor<JsonObject>(){

            @Override
            @NotNull
            public JsonObject process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceObject objectToSend, @NotNull JSLanguageServiceAnswer answer) {
                if (command == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (objectToSend == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (answer == null) {
                    2.$$$reportNull$$$0(2);
                }
                JsonObject jsonObject = answer.getElement();
                if (jsonObject == null) {
                    2.$$$reportNull$$$0(3);
                }
                return jsonObject;
            }

            @Override
            @NotNull
            public JsonObject processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JsonObject result2) {
                if (command == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (result2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                JsonObject jsonObject = result2;
                if (jsonObject == null) {
                    2.$$$reportNull$$$0(6);
                }
                return jsonObject;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "objectToSend";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "answer";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSCliService$2";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSCliService$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "process";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processFromCache";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "processFromCache";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMillis);
    }

    @Nullable
    private <T> CompletableFuture<T> sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        JSLanguageServiceQueue process;
        if (command == null) {
            FlowJSCliService.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            FlowJSCliService.$$$reportNull$$$0(5);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        if (!process.isValid()) {
            return null;
        }
        return process.execute(command, processor);
    }

    @Override
    @Nullable
    public PsiElement getDefinitionOfElement(@NotNull Document document2, @NotNull PsiElement element) {
        if (document2 == null) {
            FlowJSCliService.$$$reportNull$$$0(6);
        }
        if (element == null) {
            FlowJSCliService.$$$reportNull$$$0(7);
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document2.getLineNumber(offset) + 1;
        int column = offset - document2.getLineStartOffset(line - 1) + element.getTextLength();
        FlowJSCliService.setCommandLineParams(request, this.myConfig);
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        PsiFile file2 = element.getContainingFile();
        FlowJSCliService.checkHasUnsavedFiles(file2);
        VirtualFile virtualFile = file2.getViewProvider().getVirtualFile();
        VirtualFile parent = virtualFile.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSGetDefinitionCommand commandWithArgument = new FlowJSGetDefinitionCommand(request, document2.getText(), path);
        JsonObject requestAnswer = this.awaitCommand(commandWithArgument, DEFINITION_TIMEOUT_MILLIS);
        return this.getPsiElementFromDefinitionCommandAnswer(requestAnswer, virtualFile);
    }

    @Nullable
    private PsiElement getPsiElementFromDefinitionCommandAnswer(@Nullable JsonObject answerJson, @NotNull VirtualFile currentFile) {
        VirtualFile virtualFile;
        if (currentFile == null) {
            FlowJSCliService.$$$reportNull$$$0(8);
        }
        if (answerJson == null) {
            return null;
        }
        JsonElement path = answerJson.get("path");
        if (path.getAsString().isEmpty()) {
            return null;
        }
        int startLine = answerJson.get("line").getAsInt() - 1;
        int startColumn = answerJson.get("start").getAsInt() - 1;
        if (startLine >= 0 && startColumn >= 0 && (virtualFile = !path.getAsString().equals("-") ? LocalFileSystem.getInstance().findFileByPath(path.getAsString()) : currentFile) != null) {
            return this.getElementByPosition(virtualFile, startLine, startColumn);
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement findModuleOfElement(@NotNull Document document2, @NotNull PsiElement element) {
        if (document2 == null) {
            FlowJSCliService.$$$reportNull$$$0(9);
        }
        if (element == null) {
            FlowJSCliService.$$$reportNull$$$0(10);
        }
        VirtualFile file2 = element.getContainingFile().getVirtualFile();
        ArrayList<String> request = new ArrayList<String>();
        FlowJSCliService.setCommandLineParams(request, this.myConfig);
        request.add(StringUtil.unquoteString((String)element.getText()));
        request.add(file2.getPath());
        VirtualFile parent = file2.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSFindModuleCommand commandWithArgument = new FlowJSFindModuleCommand(request, path);
        JsonObject requestAnswer = this.awaitCommand(commandWithArgument, DEFINITION_TIMEOUT_MILLIS);
        return this.getPsiElementFromFindModuleCommandAnswer(requestAnswer);
    }

    @Nullable
    private PsiElement getPsiElementFromFindModuleCommandAnswer(@Nullable JsonObject answer) {
        if (answer != null && answer.has("file")) {
            String path = answer.get("file").getAsString();
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null) {
                return PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getTypeOfElement(@NotNull JSElement element) {
        PsiFile file2;
        Document document2;
        if (element == null) {
            FlowJSCliService.$$$reportNull$$$0(11);
        }
        if ((document2 = (file2 = element.getContainingFile()).getViewProvider().getDocument()) == null) {
            return null;
        }
        FlowJSCliService.checkHasUnsavedFiles(file2);
        VirtualFile virtualFile = file2.getVirtualFile();
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int oneBasedLine = document2.getLineNumber(offset) + 1;
        int oneBasedColumn = offset - document2.getLineStartOffset(oneBasedLine - 1) + (element instanceof JSReferenceExpression ? element.getTextLength() : 1);
        FlowJSCliService.setCommandLineParams(request, this.myConfig);
        request.add("--path");
        request.add(virtualFile.getName());
        request.add(String.valueOf(oneBasedLine));
        request.add(String.valueOf(oneBasedColumn));
        VirtualFile parent = virtualFile.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSTypeInfoCommand commandWithArgument = new FlowJSTypeInfoCommand(request, document2.getText(), path);
        JsonObject requestAnswer = this.awaitCommand(commandWithArgument, TYPEOF_TIMEOUT_MILLIS);
        return FlowJSCliService.getTypeFromAnswer(requestAnswer);
    }

    private static void checkHasUnsavedFiles(@NotNull PsiFile file2) {
        List<Document> toSave;
        if (file2 == null) {
            FlowJSCliService.$$$reportNull$$$0(12);
        }
        if (!(toSave = FlowJSCliService.getUnsavedFlowDocuments(file2)).isEmpty()) {
            LOGGER.info("Some files are unsaved, type info results may be invalid.");
        }
    }

    @NotNull
    private static String getTypeFromAnswer(@Nullable JsonObject answerJson) {
        String type = "";
        if (answerJson != null && answerJson.has("type")) {
            type = answerJson.get("type").getAsString();
        }
        String string = type;
        if (string == null) {
            FlowJSCliService.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static void setCommandLineParams(List<? super String> request, FlowJSConfig config2) {
        request.add("--root");
        request.add(config2.getConfigDirectory().getPath());
        request.add("--json");
        request.add("--no-auto-start");
    }

    @Override
    @NotNull
    public Map<String, String> getCompletionOfElement(@NotNull PsiFile originalFile, @NotNull Document document2, @NotNull CompletionParameters parameters, @NotNull String text) {
        String filePath;
        if (originalFile == null) {
            FlowJSCliService.$$$reportNull$$$0(14);
        }
        if (document2 == null) {
            FlowJSCliService.$$$reportNull$$$0(15);
        }
        if (parameters == null) {
            FlowJSCliService.$$$reportNull$$$0(16);
        }
        if (text == null) {
            FlowJSCliService.$$$reportNull$$$0(17);
        }
        ArrayList<String> request = new ArrayList<String>();
        FlowJSCliService.setCommandLineParams(request, this.myConfig);
        request.add(originalFile.getVirtualFile().getCanonicalPath());
        PsiDirectory directory = originalFile.getContainingDirectory();
        String string = filePath = directory != null ? directory.getVirtualFile().getPath() : originalFile.getProject().getBasePath();
        if (filePath == null) {
            Map<String, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                FlowJSCliService.$$$reportNull$$$0(18);
            }
            return map2;
        }
        int line = document2.getLineNumber(parameters.getOffset());
        request.add(String.valueOf(line + 1));
        request.add(String.valueOf(parameters.getOffset() - document2.getLineStartOffset(line) + "IntellijIdeaRulezzz ".length()));
        FlowJSAutocompleteCommand commandWithArgument = new FlowJSAutocompleteCommand(request, text, filePath);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        CompletableFuture<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()));
        JSLanguageServiceUtil.awaitFuture(future, COMPLETION_TIMEOUT_MILLIS, 5L, null);
        return FlowJSCliService.parseCompletionAnswer(requestAnswer);
    }

    @NotNull
    private static Map<String, String> parseCompletionAnswer(List<JsonObject> requestAnswer) {
        HashMap<String, String> names = new HashMap<String, String>();
        try {
            JsonObject parse = new JsonObject();
            if (requestAnswer.size() > 0) {
                parse = requestAnswer.get(0).get("result");
            }
            if (parse instanceof JsonArray) {
                for (JsonElement e : (JsonArray)parse) {
                    if (!(e instanceof JsonObject)) continue;
                    JsonObject object = (JsonObject)e;
                    names.put(object.get("name").getAsString(), object.get("type").getAsString());
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn(e);
        }
        HashMap<String, String> hashMap = names;
        if (hashMap == null) {
            FlowJSCliService.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public List<JSAnnotationError> getAllErrors() {
        String basePath = this.myConfig.getConfigDirectory().getPath();
        FlowJSStatusCommand commandWithArgument = new FlowJSStatusCommand(basePath);
        JsonObject requestAnswer = this.awaitCommand(commandWithArgument, LARGE_TIMEOUT);
        List<JSAnnotationError> list2 = requestAnswer == null ? Collections.emptyList() : FlowJSErrorsParser.Companion.parseFlowErrors(null, basePath, requestAnswer);
        if (list2 == null) {
            FlowJSCliService.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JSAnnotationError> getCoverageOfFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            FlowJSCliService.$$$reportNull$$$0(21);
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        FlowJSCliService.setCommandLineParams(parameterList, this.myConfig);
        parameterList.add(originalFile.getVirtualFile().getPath());
        FlowJSCoverageCommand commandWithArgument = new FlowJSCoverageCommand(parameterList, originalFile.getText(), this.myConfig.getConfigDirectory().getPath());
        JsonObject requestAnswer = this.awaitCommand(commandWithArgument, LARGE_TIMEOUT);
        ArrayList<JSAnnotationError> errors = new ArrayList<JSAnnotationError>();
        if (requestAnswer != null) {
            errors.addAll(FlowJSCliService.parseCoverageError(requestAnswer));
        }
        ArrayList<JSAnnotationError> arrayList = errors;
        if (arrayList == null) {
            FlowJSCliService.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static List<JSLanguageServiceAnnotationResult> parseCoverageError(@NotNull JsonObject json) {
        if (json == null) {
            FlowJSCliService.$$$reportNull$$$0(23);
        }
        ArrayList<JSLanguageServiceAnnotationResult> listOfErrors = new ArrayList<JSLanguageServiceAnnotationResult>();
        JsonElement expression = json.get("expressions");
        if (expression != null) {
            try {
                JsonArray errorArray = expression.getAsJsonObject().getAsJsonArray("uncovered_locs");
                for (JsonElement error : errorArray) {
                    if (!error.isJsonObject()) continue;
                    JsonObject errorObject = error.getAsJsonObject();
                    String source = errorObject.get("source").getAsString();
                    JsonObject start = errorObject.get("start").getAsJsonObject();
                    JsonObject end = errorObject.get("end").getAsJsonObject();
                    int line = start.get("line").getAsInt();
                    int column = start.get("column").getAsInt();
                    int lineEnd = end.get("line").getAsInt();
                    int columnEnd = end.get("column").getAsInt();
                    JSLanguageServiceAnnotationResult annotationResult = new JSLanguageServiceAnnotationResult(JavaScriptBundle.message((String)"js.flowjs.coverage.inspection.error.text", (Object[])new Object[0]), null, source != null ? source : "", "Warning", line, column, lineEnd, columnEnd);
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    @NotNull
    private static List<Document> getUnsavedFlowDocuments(@NotNull PsiFile exceptThis) {
        if (exceptThis == null) {
            FlowJSCliService.$$$reportNull$$$0(24);
        }
        List<Document> list2 = FlowJSCliService.getUnsavedFlowDocuments(exceptThis.getProject(), exceptThis.getVirtualFile());
        if (list2 == null) {
            FlowJSCliService.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @Override
    @Nullable
    public CompletableFuture<List<JSAnnotationError>> highlight(@NotNull PsiFile file2) {
        FlowJSCommandWithArgument commandWithArgument;
        List<Document> toSave;
        if (file2 == null) {
            FlowJSCliService.$$$reportNull$$$0(26);
        }
        if (!(toSave = FlowJSCliService.getUnsavedFlowDocuments(file2)).isEmpty()) {
            if (FlowJSSettingsManager.isAutoSaveEnabled(this.myProject)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    LOGGER.debug("Save and restart flow highlighting");
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file2);
                    FlowJSCliService.saveFiles(toSave);
                }, this.myProject.getDisposed());
            } else {
                ApplicationManager.getApplication().invokeLater(() -> {
                    JSLanguageServiceToolWindowManager jsLanguageServiceToolWindowManager = FlowJSToolWindowProvider.getToolWindow(file2.getProject());
                    if (jsLanguageServiceToolWindowManager != null) {
                        jsLanguageServiceToolWindowManager.logCurrentErrors((List<JSAnnotationError>)HAS_UNSAVED_FILES_RESULT, false);
                    }
                }, this.myProject.getDisposed());
            }
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        String fileName = virtualFile.getPath();
        Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document2 == null || FileDocumentManager.getInstance().isDocumentUnsaved(document2)) {
            String text = file2.getText();
            String fileDir = virtualFile.getParent().getPath();
            commandWithArgument = new FlowJSCheckContentsCommand(fileName, fileDir, this.myConfig, text);
        } else {
            String configPath = this.getConfig().getConfigDirectory().getPath();
            commandWithArgument = new FlowJSStatusCommand(configPath);
        }
        return this.sendCommand(commandWithArgument, (serviceObject, answer) -> {
            JSLanguageServiceToolWindowManager jsLanguageServiceToolWindowManager = FlowJSToolWindowProvider.getToolWindow(file2.getProject());
            String basePath = this.myConfig.getConfigDirectory().getPath();
            List<JSAnnotationError> annotationResult = FlowJSErrorsParser.Companion.parseFlowErrors(fileName, basePath, answer.getElement());
            if (jsLanguageServiceToolWindowManager != null) {
                ApplicationManager.getApplication().invokeLater(() -> jsLanguageServiceToolWindowManager.logCurrentErrors((List<JSAnnotationError>)ContainerUtil.immutableList((List)annotationResult), false));
            }
            return annotationResult;
        });
    }

    @Override
    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        List<Document> toSave;
        if (context == null) {
            FlowJSCliService.$$$reportNull$$$0(27);
        }
        if (FlowJSSettingsManager.isAutoSaveEnabled(context.getProject()) && !(toSave = FlowJSCliService.getUnsavedFlowDocuments(context.getFile())).isEmpty()) {
            FlowJSCliService.saveFiles(toSave);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSCliService";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptThis";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSCliService";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromAnswer";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionOfElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCompletionAnswer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllErrors";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageOfFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedFlowDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "awaitCommand";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionOfElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementFromDefinitionCommandAnswer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findModuleOfElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkHasUnsavedFiles";
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionOfElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageOfFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseCoverageError";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getUnsavedFlowDocuments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

