/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptTypedHandlerBase
extends TypedHandlerDelegate {
    private boolean myJavaScriptLTTyped;

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(2);
        }
        if (!JavaScriptTypedHandlerBase.charOfInterest(charTyped)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(3);
            }
            return result2;
        }
        EditorAndFile editorAndFile = this.updateEditorAndFile(project, editor, file2);
        if (editorAndFile == null) {
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
            if (result3 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(4);
            }
            return result3;
        }
        editor = editorAndFile.editor;
        file2 = editorAndFile.file;
        int offset = editor.getCaretModel().getOffset();
        if (JavaScriptTypedHandlerBase.isNotApplicableByLexer(charTyped, editor, offset)) {
            TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.CONTINUE;
            if (result4 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(5);
            }
            return result4;
        }
        if (file2.getContext() == null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
        return JavaScriptTypedHandlerBase.checkAutoPopupByChar(charTyped, project, editor, file2, offset);
    }

    @NotNull
    private static TypedHandlerDelegate.Result checkAutoPopupByChar(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        if (project == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(8);
        }
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project);
        PsiElement at = file2.findElementAt(offset);
        if (charTyped == '/') {
            if (at instanceof LeafPsiElement && ((LeafPsiElement)at).getElementType() == JSTokenTypes.STRING_LITERAL && JavaScriptTypedHandlerBase.isImportOrRequireCall(at = at.getParent())) {
                autoPopupController.autoPopupMemberLookup(editor, null);
                TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
                if (result2 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(9);
                }
                return result2;
            }
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
            if (result3 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(10);
            }
            return result3;
        }
        if (charTyped == ' ' || charTyped == ',') {
            if (at != null && at.getParent() instanceof JSArgumentList) {
                autoPopupController.autoPopupParameterInfo(editor, null);
                TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                if (result4 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(11);
                }
                return result4;
            }
            if (charTyped == ',') {
                TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.STOP;
                if (result5 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(12);
                }
                return result5;
            }
        }
        if (at != null) {
            if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{PsiComment.class, JSLiteralExpression.class, JSConditionalExpression.class}) != null || at.getParent() instanceof JSSwitchStatement) {
                TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.CONTINUE;
                if (result6 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(13);
                }
                return result6;
            }
            if (at instanceof PsiWhiteSpace) {
                at = PsiTreeUtil.prevLeaf((PsiElement)at);
            }
            if (at == null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{JSConditionalExpression.class}) != null) {
                TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.CONTINUE;
                if (result7 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(14);
                }
                return result7;
            }
        }
        if (charTyped == '<') {
            Document document2 = editor.getDocument();
            if (offset > 0 && offset <= document2.getTextLength() && document2.getCharsSequence().charAt(offset - 1) != '.') {
                TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.CONTINUE;
                if (result8 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(15);
                }
                return result8;
            }
        }
        autoPopupController.autoPopupMemberLookup(editor, null);
        TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.STOP;
        if (result9 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(16);
        }
        return result9;
    }

    private static boolean isImportOrRequireCall(@Nullable PsiElement at) {
        if (at == null) {
            return false;
        }
        if (at instanceof ES6FromClause || at instanceof ES6ImportDeclaration || at.getParent() instanceof ES6ImportCall) {
            return true;
        }
        if (!(at instanceof JSLiteralExpression)) {
            return false;
        }
        PsiElement parent = at.getParent();
        if (parent == null) {
            return false;
        }
        PsiElement callCandidate = parent.getParent();
        return callCandidate instanceof JSCallExpression && ((JSCallExpression)callCandidate).isRequireCall();
    }

    private static boolean isNotApplicableByLexer(char charTyped, Editor editor, int offset) {
        if (charTyped == ' ') {
            Document document2 = editor.getDocument();
            CharSequence charSequence = document2.getCharsSequence();
            if (offset > 3 && offset <= document2.getTextLength() && (charSequence.charAt(offset - 1) != 'w' || charSequence.charAt(offset - 2) != 'e' || charSequence.charAt(offset - 3) != 'n') && charSequence.charAt(offset - 1) != ':' && charSequence.charAt(offset - 1) != ',') {
                return true;
            }
        }
        if (offset == 0) {
            return true;
        }
        HighlighterIterator iterator = JavaScriptTypedHandlerBase.createHighlighterIterator(editor, offset - 1);
        IElementType tokenType = iterator.getTokenType();
        return JSTokenTypes.COMMENTS.contains(tokenType) || tokenType instanceof JSDocElementType || StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tokenType) || JSTokenTypes.STRING_LITERALS.contains(tokenType) && charTyped != '/';
    }

    private static boolean charOfInterest(char charTyped) {
        return charTyped == '<' || charTyped == ' ' || charTyped == ',' || charTyped == '.' || charTyped == '/' || charTyped == '#';
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull FileType fileType) {
        DialectOptionHolder holder;
        EditorAndFile editorAndFile;
        if (project == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(19);
        }
        if (fileType == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(20);
        }
        if ((editorAndFile = this.updateEditorAndFile(project, editor, file2)) == null) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(21);
            }
            return result2;
        }
        file2 = editorAndFile.file;
        editor = editorAndFile.editor;
        boolean bl = this.myJavaScriptLTTyped = '<' == c && !(file2 instanceof HtmlFileImpl) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && (holder = DialectDetector.dialectOfElement((PsiElement)file2)) != null && holder.hasFeature(JSLanguageFeature.GENERICS) && JavaScriptTypedHandlerBase.shouldMatchGenericBraces(editor, false);
        if ('>' == c && !(file2 instanceof HtmlFileImpl) && (holder = DialectDetector.dialectOfElement((PsiElement)file2)) != null) {
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && holder.hasFeature(JSLanguageFeature.GENERICS) && TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)JSTokenTypes.LT, (IElementType)JSTokenTypes.GT, (TokenSet)Holder.INVALID_INSIDE_REFERENCE)) {
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
                if (result3 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(22);
                }
                return result3;
            }
            WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
            if (webEditorOptions != null && webEditorOptions.isAutomaticallyInsertClosingTag() && holder.hasFeature(JSLanguageFeature.E4X)) {
                IElementType tokenType;
                PsiElement previousElement;
                PsiElement element;
                FileViewProvider provider = file2.getViewProvider();
                int offset = editor.getCaretModel().getOffset();
                if (offset < editor.getDocument().getTextLength() && (element = provider.findElementAt(offset, XMLLanguage.class)) instanceof PsiWhiteSpace && (previousElement = provider.findElementAt(offset - 1, XMLLanguage.class)) instanceof XmlToken && (tokenType = ((XmlToken)previousElement).getTokenType()) == XmlTokenType.XML_START_TAG_START) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"</>", (boolean)false, (int)0);
                    TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.DEFAULT;
                    if (result4 == null) {
                        JavaScriptTypedHandlerBase.$$$reportNull$$$0(23);
                    }
                    return result4;
                }
            }
        }
        if (c == '.') {
            PsiElement at;
            int offset = editor.getCaretModel().getOffset();
            Object object = offset < editor.getDocument().getTextLength() ? file2.findElementAt(offset) : (at = offset > 0 ? file2.findElementAt(offset - 1) : null);
            if (at != null && at.getParent().getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && !JavaScriptTypedHandlerBase.isNotApplicableByLexer(c, editor, offset)) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
            }
        }
        if (c == ';' && JavaScriptTypedHandlerBase.handleSemicolon(editor)) {
            TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.STOP;
            if (result5 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(24);
            }
            return result5;
        }
        TypedHandlerDelegate.Result result6 = super.beforeCharTyped(c, project, editor, file2, fileType);
        if (result6 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(25);
        }
        return result6;
    }

    public static boolean shouldMatchGenericBraces(@NotNull Editor editor, boolean isBackspace) {
        IElementType tokenType;
        if (editor == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(26);
        }
        int offset = editor.getCaretModel().getOffset();
        if (isBackspace) {
            --offset;
        }
        if (TypedHandlerUtil.isAfterClassLikeIdentifierOrDot((int)offset, (Editor)editor, (IElementType)JSTokenTypes.DOT, (IElementType)JSTokenTypes.IDENTIFIER, (boolean)false)) {
            return true;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (offset != iterator.getEnd() && iterator.getStart() > 0) {
            iterator.retreat();
        }
        if ((tokenType = iterator.getTokenType()) != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        iterator.advance();
        if (isBackspace) {
            if (iterator.atEnd() || iterator.getTokenType() != JSTokenTypes.LT) {
                return false;
            }
            iterator.advance();
            if (iterator.atEnd() || iterator.getTokenType() != JSTokenTypes.GT) {
                return false;
            }
            iterator.advance();
        }
        return !iterator.atEnd() && iterator.getTokenType() == JSTokenTypes.LPAR;
    }

    private static boolean handleSemicolon(Editor editor) {
        CharSequence sequence;
        int offset = editor.getCaretModel().getOffset();
        if (offset >= (sequence = editor.getDocument().getCharsSequence()).length()) {
            return false;
        }
        char charAt = sequence.charAt(offset);
        if (charAt != ';') {
            return false;
        }
        HighlighterIterator hi = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (hi.atEnd() || hi.getTokenType() != JSTokenTypes.SEMICOLON) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        int startOffset;
        HighlighterIterator iterator;
        IElementType tokenType;
        EditorAndFile editorAndFile;
        if (project == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(27);
        }
        if (editor == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(29);
        }
        if ((editorAndFile = this.updateEditorAndFile(project, editor, file2)) == null) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(30);
            }
            return result2;
        }
        file2 = editorAndFile.file;
        editor = editorAndFile.editor;
        if (this.myJavaScriptLTTyped) {
            this.myJavaScriptLTTyped = false;
            TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)JSTokenTypes.LT, (IElementType)JSTokenTypes.GT, (TokenSet)Holder.INVALID_INSIDE_REFERENCE);
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
            if (result3 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(31);
            }
            return result3;
        }
        if (c == '<' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(editor.getCaretModel().getOffset());
            iterator2.retreat();
            if (!iterator2.atEnd() && iterator2.getTokenType() == JSDocTokenTypes.DOC_LT) {
                TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)JSDocTokenTypes.DOC_LT, (IElementType)JSDocTokenTypes.DOC_GT, (TokenSet)Holder.INVALID_INSIDE_JSDOC_GENERIC);
                TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                if (result4 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(32);
                }
                return result4;
            }
        }
        if (!JavaScriptTypedHandlerBase.isJSDialectAtCaret(editor, file2)) {
            TypedHandlerDelegate.Result result5 = super.charTyped(c, project, editor, file2);
            if (result5 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(33);
            }
            return result5;
        }
        if (c == ',' || c == ':' || c == '.' && JavaScriptTypedHandlerBase.isIndentChainedCalls(file2)) {
            PsiElement parent;
            int offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement at = file2.findElementAt(offset - 1);
            PsiElement psiElement = parent = at != null ? at.getParent() : null;
            if (parent != null) {
                int indentPos = -1;
                IElementType parentType = parent.getNode().getElementType();
                if (JSElementTypes.VAR_STATEMENTS.contains(parentType) || parentType == JSElementTypes.REFERENCE_EXPRESSION) {
                    indentPos = at.getTextOffset() - 1;
                } else if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(parentType)) {
                    indentPos = parent.getTextOffset() - 1;
                }
                if (indentPos >= 0 && JavaScriptTypedHandlerBase.isAfterLineStart(indentPos, editor.getDocument())) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, indentPos);
                    TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.STOP;
                    if (result6 == null) {
                        JavaScriptTypedHandlerBase.$$$reportNull$$$0(34);
                    }
                    return result6;
                }
            }
        } else if (c == '$' && JSEditorOptions.getInstance().START_STRING_INTERPOLATION_ON_TYPING && (tokenType = (iterator = JavaScriptTypedHandlerBase.createHighlighterIterator(editor, (startOffset = editor.getCaretModel().getOffset()) - 1)).getTokenType()) == JSTokenTypes.STRING_TEMPLATE_PART) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{}");
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.STOP;
            if (result7 == null) {
                JavaScriptTypedHandlerBase.$$$reportNull$$$0(35);
            }
            return result7;
        }
        TypedHandlerDelegate.Result result8 = super.charTyped(c, project, editor, file2);
        if (result8 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(36);
        }
        return result8;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(37);
        }
        if (editor == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(38);
        }
        if (file2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(39);
        }
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        if (c == '$' && JSEditorOptions.getInstance().START_STRING_INTERPOLATION_ON_TYPING && editor.getSelectionModel().hasSelection() && JavaScriptTypedHandlerBase.isJSDialectAtOffset(file2, endOffset)) {
            boolean caretBefore = editor.getCaretModel().getOffset() <= startOffset;
            HighlighterIterator iterator = JavaScriptTypedHandlerBase.createHighlighterIterator(editor, startOffset);
            if (iterator.getTokenType() == JSTokenTypes.STRING_TEMPLATE_PART && iterator.getEnd() >= endOffset) {
                String insertedText = "${" + editor.getSelectionModel().getSelectedText() + "}";
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)insertedText);
                if (caretBefore) {
                    editor.getCaretModel().moveCaretRelatively(-insertedText.length(), 0, false, false, true);
                }
                TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
                if (result2 == null) {
                    JavaScriptTypedHandlerBase.$$$reportNull$$$0(40);
                }
                return result2;
            }
        }
        TypedHandlerDelegate.Result result3 = super.beforeSelectionRemoved(c, project, editor, file2);
        if (result3 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(41);
        }
        return result3;
    }

    @NotNull
    private static HighlighterIterator createHighlighterIterator(@NotNull Editor editor, int offset) {
        if (editor == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(42);
        }
        HighlighterIterator highlighterIterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (highlighterIterator == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(43);
        }
        return highlighterIterator;
    }

    private static boolean isJSDialectAtCaret(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(44);
        }
        if (file2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(45);
        }
        int offset = editor.getCaretModel().getOffset();
        return JavaScriptTypedHandlerBase.isJSDialectAtOffset(file2, offset);
    }

    private static boolean isJSDialectAtOffset(@NotNull PsiFile file2, int offset) {
        PsiElement at;
        if (file2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(46);
        }
        Object object = offset < file2.getTextLength() ? file2.findElementAt(offset) : (at = offset > 0 ? file2.findElementAt(offset - 1) : null);
        if (at == null) {
            return false;
        }
        Language language = PsiUtilCore.findLanguageFromElement((PsiElement)at);
        return language instanceof JSLanguageDialect;
    }

    private static boolean isIndentChainedCalls(@NotNull PsiFile file2) {
        if (file2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(47);
        }
        JSCodeStyleSettings settings = (JSCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file2, JSCodeStyleSettings.class);
        return settings.INDENT_CHAINED_CALLS;
    }

    private static boolean isAfterLineStart(int indentPos, @NotNull Document document2) {
        if (document2 == null) {
            JavaScriptTypedHandlerBase.$$$reportNull$$$0(48);
        }
        int firstNonSpace = CharArrayUtil.shiftBackward((CharSequence)document2.getCharsSequence(), (int)indentPos, (String)" \t");
        return document2.getCharsSequence().charAt(firstNonSpace) == '\n';
    }

    @Nullable
    protected EditorAndFile updateEditorAndFile(Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        if (!(file2 instanceof JSFile) || editor == null) {
            return null;
        }
        return new EditorAndFile(editor, file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 18: 
            case 26: 
            case 28: 
            case 38: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 19: 
            case 29: 
            case 39: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JavaScriptTypedHandlerBase";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JavaScriptTypedHandlerBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopupByChar";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighterIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopupByChar";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldMatchGenericBraces";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighterIterator";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isJSDialectAtCaret";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isJSDialectAtOffset";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isIndentChainedCalls";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isAfterLineStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class EditorAndFile {
        @NotNull
        private final Editor editor;
        @NotNull
        private final PsiFile file;

        public EditorAndFile(@NotNull Editor editor, @NotNull PsiFile file2) {
            if (editor == null) {
                EditorAndFile.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                EditorAndFile.$$$reportNull$$$0(1);
            }
            this.editor = editor;
            this.file = file2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/editing/JavaScriptTypedHandlerBase$EditorAndFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Holder {
        public static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.SEMICOLON, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE});
        public static final TokenSet INVALID_INSIDE_JSDOC_GENERIC = TokenSet.create((IElementType[])new IElementType[]{JSDocTokenTypes.DOC_COMMENT_END});
    }
}

