/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSInsertThisFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    private final boolean myStatic;

    public JSInsertThisFix(JSExpression node) {
        super((PsiElement)node);
        this.myStatic = JSResolveUtil.calculateStaticFromContext((PsiElement)node);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)(this.myStatic ? "insert.class.fix.name" : "insert.this.keyword.fix.name"), (Object[])new Object[0]);
        if (string == null) {
            JSInsertThisFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static boolean isThisFixAvailable(JSReferenceExpression expression) {
        PsiElement context;
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return false;
        }
        JSExpression qualifier = expression.getQualifier();
        if (qualifier != null) {
            return false;
        }
        String name = expression.getReferenceName();
        if (name == null) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{JSFunction.class, JSProperty.class});
        if (parent instanceof JSFunction && (context = parent.getContext()) instanceof JSProperty) {
            parent = context;
        }
        if (parent instanceof JSProperty) {
            if (expression != ((JSProperty)parent).getNameIdentifier()) {
                return JSInsertThisFix.checkObjectLiteralProperty(name, parent.getContext());
            }
        } else {
            JSClass jsClass = JSUtils.getMemberContainingClass(parent);
            if (jsClass != null) {
                return !jsClass.findMembersByName(name).isEmpty();
            }
        }
        return false;
    }

    private static boolean checkObjectLiteralProperty(@NotNull String name, PsiElement objectLiteralCandidate) {
        JSObjectLiteralExpression literalExpression;
        if (name == null) {
            JSInsertThisFix.$$$reportNull$$$0(1);
        }
        if ((literalExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)objectLiteralCandidate, JSObjectLiteralExpression.class)) == null) {
            return false;
        }
        return literalExpression.findProperty(name) != null;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSInsertThisFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSInsertThisFix.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            JSInsertThisFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            JSInsertThisFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            JSInsertThisFix.$$$reportNull$$$0(6);
        }
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
            JSClass context;
            String qualifier = "this";
            if (this.myStatic && (context = JSResolveUtil.getClassOfContext(startElement)) != null && context.getName() != null) {
                qualifier = context.getName();
            }
            JSInsertThisFix.insertQualifier((JSExpression)startElement, null, qualifier);
        });
    }

    public static JSExpression insertThisQualifier(JSExpression expression, Editor editor) {
        return JSInsertThisFix.insertQualifier(expression, editor, "this");
    }

    public static JSExpression insertQualifier(JSExpression expression, @Nullable Editor editor, String qualifier) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Ref result2 = Ref.create((Object)expression);
        ApplicationManager.getApplication().runWriteAction(() -> {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Runnable runnable = () -> {
                JSExpression newExpression = JSChangeUtil.replaceExpression(expression, JSPsiElementFactory.createJSExpression(qualifier + "." + expression.getText(), (PsiElement)expression));
                PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)expression.getProject());
                if (editor != null) {
                    instance.doPostponedOperationsAndUnblockDocument(editor.getDocument());
                }
                result2.set((Object)newExpression);
            };
            commandProcessor.runUndoTransparentAction(runnable);
        });
        return (JSExpression)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/JSInsertThisFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/JSInsertThisFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectLiteralProperty";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

