/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionUtil;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.completion.JSSymbolCompletionUtil;
import com.intellij.lang.javascript.completion.TextReferencePropertiesCollector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JSStringLiteralWordsIndex;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptTextReference;
import com.intellij.lang.javascript.psi.impl.ActionScriptTextReferenceResolver;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSTextReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final boolean myJSDoc;

    public JSTextReferenceCompletionProvider(boolean isJSDoc) {
        this.myJSDoc = isJSDoc;
    }

    public boolean isJSDoc() {
        return this.myJSDoc;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(2);
        }
        JSCompletionUtil.addCompletions(parameters, result2, JSTextReference.class, JSTextReferenceCompletionProvider::addVariants);
    }

    public static void addVariants(@NotNull JSTextReference reference, @NotNull CompletionParameters completionParameters, @NotNull CompletionResultSet resultSet) {
        if (reference == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(3);
        }
        if (completionParameters == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(4);
        }
        if (resultSet == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(5);
        }
        PsiElement element = reference.getElement();
        PsiFile containingFile = element.getContainingFile();
        List<LookupElement> localResults = null;
        boolean newResolveAndCompletion = reference.useActionScriptIndex(containingFile);
        if (newResolveAndCompletion) {
            String[] baseClassFqns;
            CompletionResultSink resultSink = new CompletionResultSink((PsiElement)containingFile, resultSet.getPrefixMatcher());
            String[] stringArray = baseClassFqns = reference instanceof ActionScriptTextReference ? ((ActionScriptTextReference)reference).getBaseClassFqns() : ArrayUtilRt.EMPTY_STRING_ARRAY;
            if (baseClassFqns.length > 0) {
                JSTextReferenceCompletionProvider.setCompletionFilter(resultSink, baseClassFqns, containingFile);
            }
            ActionScriptTextReferenceResolver.processToSink(reference, containingFile, resultSink);
            localResults = resultSink.getResultsAsObjects();
            resultSet.addAllElements(localResults);
            JSTextReferenceCompletionProvider.forceQualifyIfNeeded(reference, localResults);
        }
        if (!newResolveAndCompletion || element instanceof JSLiteralExpression) {
            PsiElement parent;
            JSSmartCompletionContributor contributor;
            List<LookupElement> stringLiteralVariants;
            ArrayList<LookupElement> smartResults = new ArrayList<LookupElement>();
            if (element instanceof JSLiteralExpression && (stringLiteralVariants = (contributor = (JSSmartCompletionContributor)JSSmartCompletionContributor.EP_NAME.forLanguage(DialectDetector.languageOfElement(element))).getStringLiteralVariants((JSExpression)element, true)) != null) {
                smartResults.addAll(stringLiteralVariants);
            }
            if ((parent = element.getParent()) instanceof JSIndexedPropertyAccessExpression) {
                TextReferencePropertiesCollector innerSet = new TextReferencePropertiesCollector(resultSet.getPrefixMatcher(), (Consumer<CompletionResult>)((Consumer)result2 -> {}));
                JSReferenceCompletionUtil.calcDefaultVariants((JSExpression)parent, containingFile, containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4, new HashSet<String>(), completionParameters, innerSet);
                smartResults.addAll(innerSet.getCollectedItems());
            }
            JSTextReferenceCompletionProvider.calcDefaultVariants(reference, containingFile, localResults, smartResults, completionParameters, resultSet);
            if (reference instanceof JSDocReference) {
                JSTextReferenceCompletionProvider.addJSDocPredefinedTypes(reference, resultSet);
            }
        }
    }

    private static void addJSDocPredefinedTypes(JSTextReference reference, CompletionResultSet set) {
        PsiElement element = reference.getElement();
        if (element instanceof JSDocTagValue && reference.isPrimary()) {
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"boolean"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"function"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"number"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"string"), JSLookupPriority.SMART_PRIORITY));
            if (DialectDetector.hasFeature(element, JSLanguageFeature.IMPORT_DECLARATIONS)) {
                set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((Object)((Object)JSCompletionKeyword.IMPORT_WITH_BRACES)).withInsertHandler(JSInsertHandler.DEFAULT), JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY));
            }
        }
    }

    public static void calcDefaultVariants(@NotNull JSTextReference reference, PsiFile containingFile, List<LookupElement> localResults, List<? extends LookupElement> smartResults, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        PsiReference ref;
        if (reference == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(7);
        }
        if (resultSet == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(8);
        }
        PsiElement referenceElement = reference.getElement();
        boolean hasSmartItems = smartResults.size() > 0;
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)referenceElement);
        String originalQualifiedName = null;
        if (originalElement != null && (ref = originalElement.findReferenceAt(reference.getRangeInElement().getStartOffset())) != null) {
            originalQualifiedName = ref.getCanonicalText();
        }
        final String finalOriginalQualifiedName = originalQualifiedName;
        VariantsProcessor processor = new VariantsProcessor(containingFile, referenceElement, false, parameters, resultSet){

            @Override
            protected boolean isOriginalElement(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.isOriginalElement(element) || finalOriginalQualifiedName != null && finalOriginalQualifiedName.equals(element.getQualifiedName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSTextReferenceCompletionProvider$1", "isOriginalElement"));
            }
        };
        JSQualifiedName qualifier = reference.getQualifiedName().getParent();
        if (qualifier != null) {
            JSNamespace ns = JSNamedTypeFactory.createNamespace(qualifier, JSContext.UNKNOWN, reference.getElement(), true);
            processor.addTypeHierarchy(ns);
        } else if (!DialectDetector.isActionScript((PsiElement)containingFile)) {
            processor.getTypeInfo().addGlobalType();
        }
        if (hasSmartItems) {
            processor.populateCompletionList(smartResults, false, resultSet);
        }
        processor.setAddOnlyCompleteMatches();
        if (localResults != null) {
            if (hasSmartItems) {
                JSTextReferenceCompletionProvider.patchResultPrioritiesAndDecorations(containingFile, localResults);
            }
            processor.populateCompletionList(localResults, false, resultSet);
        }
        if (referenceElement instanceof JSLiteralExpression && JSTypeUtils.containsLiteralTypes(JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)referenceElement, JSExpectedTypeKind.EXPECTED))) {
            return;
        }
        if (reference.isPrimary() && reference instanceof JSDocReference) {
            CompletionResultSink sink = new CompletionResultSink(referenceElement, resultSet.getPrefixMatcher());
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            reference.processLocalVariants(localProcessor);
            List<LookupElement> processorResults = sink.getResultsAsObjects();
            if (processorResults.size() > 0) {
                if (hasSmartItems) {
                    JSTextReferenceCompletionProvider.patchResultPrioritiesAndDecorations(containingFile, processorResults);
                }
                processor.populateCompletionList(processorResults, false, resultSet);
            }
        }
        if (!smartResults.isEmpty() && !parameters.isExtendedCompletion()) {
            return;
        }
        if (!(reference instanceof JSLiteralTextReference) || !((JSLiteralTextReference)reference).isTextOnlyReference()) {
            boolean stop;
            ArrayList populatedResults = new ArrayList();
            boolean bl = stop = !JSSymbolCompletionUtil.processIndexedSymbols(referenceElement, processor, resultSet, populatedResults);
            if (stop) {
                return;
            }
        }
        ArrayList<LookupElement> results = new ArrayList<LookupElement>(processor.getFinalResults());
        if (referenceElement instanceof JSLiteralExpression && !parameters.getProcess().isAutopopupCompletion()) {
            JSTextReferenceCompletionProvider.addWordsFromStringLiterals(reference, results, resultSet);
        }
        if (hasSmartItems) {
            JSTextReferenceCompletionProvider.patchResultPrioritiesAndDecorations(containingFile, results);
        }
        processor.populateCompletionList(results, false, resultSet);
    }

    private static void patchResultPrioritiesAndDecorations(PsiFile containingFile, List<LookupElement> results) {
        if (!DialectDetector.isActionScript((PsiElement)containingFile)) {
            for (int i = 0; i < results.size(); ++i) {
                LookupElement element = results.get(i);
                results.set(i, JSCompletionUtil.withJSLookupPriority(element, JSLookupPriority.LOWEST_PRIORITY));
            }
        }
    }

    private static void forceQualifyIfNeeded(JSTextReference reference, List<LookupElement> results) {
        boolean isOnlyFqns;
        boolean bl = isOnlyFqns = reference instanceof ActionScriptTextReference && ((ActionScriptTextReference)reference).isOnlyFqns();
        if (isOnlyFqns && reference.isPrimary()) {
            for (LookupElement result2 : results) {
                JSLookupUtilImpl.setForceQualify(result2);
            }
        }
    }

    private static void setCompletionFilter(CompletionResultSink resultSink, String @NotNull [] baseClassFqns, PsiFile containingFile) {
        Module module;
        if (baseClassFqns == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(9);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile)) != null) {
            Condition filter;
            GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
            if (baseClassFqns.length == 1) {
                filter = new PublicInheritorFilter(module.getProject(), baseClassFqns[0], scope, false);
            } else {
                List conditions = ContainerUtil.map((Object[])baseClassFqns, fqn -> new PublicInheritorFilter(module.getProject(), (String)fqn, scope, false));
                filter = aClass -> {
                    for (Condition condition : conditions) {
                        if (!condition.value(aClass)) continue;
                        return true;
                    }
                    return false;
                };
            }
            resultSink.acceptOnlyClasses((Condition<? super JSClass>)filter);
        }
    }

    private static void addWordsFromStringLiterals(@NotNull JSTextReference reference, @NotNull List<LookupElement> otherResults, @NotNull CompletionResultSet resultSet) {
        if (reference == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(10);
        }
        if (otherResults == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(11);
        }
        if (resultSet == null) {
            JSTextReferenceCompletionProvider.$$$reportNull$$$0(12);
        }
        PsiElement context = reference.getElement();
        HashSet keys = new HashSet();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        FileBasedIndex.getInstance().processAllKeys(JSStringLiteralWordsIndex.INDEX_ID, s -> {
            if (s.length() > 0 && resultSet.getPrefixMatcher().prefixMatches(s)) {
                keys.add(s);
            }
            return true;
        }, scope, null);
        keys.removeAll(ContainerUtil.map(otherResults, LookupElement::getLookupString));
        String currentWord = StringUtil.replace((String)reference.getCanonicalText(), (String)"IntellijIdeaRulezzz ", (String)"");
        int currentWordOffset = reference.getAbsoluteRange().getStartOffset();
        VirtualFile currentFile = context.getContainingFile().getOriginalFile().getVirtualFile();
        Project project = context.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        int count = 0;
        for (String key : keys) {
            if (count++ > JSCompletionUtil.getCompletionLimit()) {
                JSCompletionUtil.handleOverflow(resultSet);
                return;
            }
            FileBasedIndex.getInstance().processValues(JSStringLiteralWordsIndex.INDEX_ID, (Object)key, null, (file2, offset) -> {
                if (offset == currentWordOffset && file2.equals(currentFile)) {
                    if (!currentWord.equals(key)) {
                        Logger.getInstance(JSTextReferenceCompletionProvider.class).warn("Outdated value in JSStringLiteralWordsIndex");
                    }
                    return true;
                }
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) {
                    resultSet.addElement((LookupElement)LookupElementBuilder.create((String)key));
                } else {
                    JSOffsetBasedImplicitElement element = new JSOffsetBasedImplicitElement(new JSImplicitElementImpl.Builder(key, null), (int)offset, psiFile);
                    resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((PsiNamedElement)element), (double)JSLookupPriority.LOWEST_PRIORITY.getPriorityValue()));
                }
                return false;
            }, scope);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionParameters";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassFqns";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherResults";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSTextReferenceCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariants";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "calcDefaultVariants";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setCompletionFilter";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addWordsFromStringLiterals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

