/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.generation.TypeScriptImplementMembersHandler;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6DecoratorDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import icons.JavaScriptPsiIcons;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLookupUtilImpl {
    static final Key<JSLookupElementFunctionData> POSSIBLE_FUNCTION_DATA_KEY = Key.create((String)"js.completion.possible.function.and.has.signature");
    private static final JSLookupPriority MY_LAST_VALUE_WITHOUT_PRIORITY = JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY;
    @NotNull
    private static final InsertHandler<LookupElement> PARAM_LIST_INSERT_HANDLER = (context, item) -> {
        int startOffset = context.getTailOffset();
        int endOffset = CharArrayUtil.shiftForwardUntil((CharSequence)context.getDocument().getImmutableCharSequence(), (int)startOffset, (String)")");
        context.getDocument().deleteString(startOffset, endOffset);
    };
    public static final Icon SEVERAL_DEFINITIONS_ICON = AllIcons.Nodes.MultipleTypeDefinitions;

    @NotNull
    public static LookupElement createMultiparamCompletionItem(PsiElement element, String lookupString) {
        LookupElementBuilder lookupElementBuilder = (element == null ? LookupElementBuilder.create((String)lookupString) : LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)element)).withIcon(IconHolder.ourParamParamIcon).withInsertHandler(PARAM_LIST_INSERT_HANDLER);
        if (lookupElementBuilder == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(0);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static TypeAndTail getTypeAndTailTexts(@NotNull PsiElement element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(1);
        }
        return JSLookupUtilImpl.getTypeAndTailTexts(null, element, typeSubstitutor);
    }

    @NotNull
    public static TypeAndTail getTypeAndTailTexts(@Nullable LookupElement lookupElement, @NotNull PsiElement element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        String s;
        JSFunctionItem original;
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(2);
        }
        String typeText = null;
        String tailText = null;
        String location = null;
        JSFunctionItem possibleFunction = JSPsiImplUtils.calculatePossibleFunction(element, null, false);
        JSType type = null;
        if (possibleFunction != null && possibleFunction.isValid() && (original = (JSFunctionItem)CompletionUtil.getOriginalElement((PsiElement)possibleFunction)) != null) {
            possibleFunction = original;
        }
        boolean fallbackToDefault = false;
        if (possibleFunction != null && possibleFunction.isValid()) {
            JSType typeFromSetAccessor;
            JSType returnType = JSLookupUtilImpl.expandAndOptimizeTypeRecursive(possibleFunction.getReturnType(), DialectDetector.isTypeScript(element));
            if ((returnType instanceof JSVoidType || returnType == null) && possibleFunction.isSetProperty() && (typeFromSetAccessor = JSResolveUtil.getTypeFromSetAccessor(possibleFunction)) != null) {
                returnType = typeFromSetAccessor;
            }
            if (JSLookupUtilImpl.isTypeAcceptableForLookupElement(returnType)) {
                returnType = JSTypeUtils.applyGenericArguments(returnType, typeSubstitutor);
                typeText = returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
        } else if (element instanceof JSClass || element instanceof JSNamespaceDeclaration) {
            if (DialectDetector.isActionScript(element)) {
                typeText = JSItemPresentation.getFileName(element.getContainingFile());
            }
        } else if (element instanceof JSImplicitElement && element instanceof JSTypeOwner && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Function) {
            List funcTypes;
            type = ((JSTypeOwner)element).getJSType();
            List list2 = funcTypes = type == null ? ContainerUtil.emptyList() : type.getFunctionTypes(new ProcessingContext(), false).collect(Collectors.toList());
            if (funcTypes.size() == 1 && funcTypes.get(0) instanceof JSFunctionType) {
                JSFunctionType functionType = (JSFunctionType)funcTypes.get(0);
                StringBuilder result2 = new StringBuilder();
                result2.append("(");
                List parameters = functionType.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    JSParameterItem parameter = (JSParameterItem)parameters.get(i);
                    if (i != 0) {
                        result2.append(", ");
                    }
                    result2.append(JSParameterInfoHandler.getSignatureForParameter(parameter, typeSubstitutor, JSParameterInfoHandler.TYPE_DESCRIBER));
                }
                result2.append(")");
                tailText = result2.toString();
                JSType returnType = functionType.getReturnType();
                typeText = returnType == null ? "any" : returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            } else {
                fallbackToDefault = true;
            }
        } else {
            fallbackToDefault = true;
        }
        if (fallbackToDefault && JSLookupUtilImpl.isTypeAcceptableForLookupElement(type = JSLookupUtilImpl.expandAndOptimizeTypeRecursive(JSLookupUtilImpl.getElementType(element), DialectDetector.isTypeScript(element)))) {
            type = JSTypeUtils.applyGenericArguments(type, typeSubstitutor);
            if (element instanceof JSOptionalOwner && ((JSOptionalOwner)element).isOptional()) {
                type = TypeScriptTypeGuard.wrapWithUndefined(type, type.getSource());
            }
            typeText = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }
        if (possibleFunction != null && possibleFunction.isValid() && (s = JSLookupUtilImpl.getFunctionTailText(possibleFunction, typeSubstitutor)) != null) {
            tailText = s;
        }
        location = JSLookupUtilImpl.getPackageLocationString(element);
        if (lookupElement != null) {
            JSLookupElementFunctionData data = JSLookupUtilImpl.getPossibleFunctionData(element, possibleFunction, type);
            lookupElement.putUserData(POSSIBLE_FUNCTION_DATA_KEY, (Object)data);
        }
        return new TypeAndTail(typeText, tailText, location);
    }

    @Nullable
    private static JSType getElementType(@NotNull PsiElement element) {
        JSType type;
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(3);
        }
        if ((type = JSTypeUtils.getTypeOfElement(element)) == null && DialectDetector.isTypeScript(element) && JSTypeGuardUtil.isAcceptableForTypeGuard(element)) {
            type = JSResolveUtil.getElementJSType(element);
        }
        return type;
    }

    @NotNull
    private static JSLookupElementFunctionData getPossibleFunctionData(@NotNull PsiElement element, @Nullable JSFunctionItem possibleFunction, @Nullable JSType type) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(4);
        }
        if (element instanceof TypeScriptPropertySignature) {
            JSLookupElementFunctionData jSLookupElementFunctionData = JSLookupElementFunctionData.EMPTY;
            if (jSLookupElementFunctionData == null) {
                JSLookupUtilImpl.$$$reportNull$$$0(5);
            }
            return jSLookupElementFunctionData;
        }
        boolean hasOtherNonEmptySignature = false;
        if (possibleFunction == null && type != null) {
            List candidates = JSTypeUtils.removeNullableComponents(type).getFunctionTypes(new ProcessingContext(), false).filter(t -> t instanceof JSFunctionType).map(t -> ((JSFunctionType)t).getSourceFunctionItem()).filter(t -> t != null).limit(2L).collect(Collectors.toList());
            if (!candidates.isEmpty()) {
                possibleFunction = (JSFunctionItem)candidates.get(0);
            }
            if (candidates.size() > 1) {
                hasOtherNonEmptySignature = true;
            }
        }
        if (possibleFunction == null || !possibleFunction.isValid()) {
            JSLookupElementFunctionData jSLookupElementFunctionData = JSLookupElementFunctionData.EMPTY;
            if (jSLookupElementFunctionData == null) {
                JSLookupUtilImpl.$$$reportNull$$$0(6);
            }
            return jSLookupElementFunctionData;
        }
        boolean hasPropertySignature = false;
        if (type != null) {
            JSRecordType record = type.asRecordType();
            for (JSRecordType.TypeMember member : record.getTypeMembers()) {
                if (TypeScriptPsiUtil.isObjectBuiltInTypeProperty(member) || member instanceof JSRecordType.CallSignature) continue;
                hasPropertySignature = true;
                break;
            }
        }
        return new JSLookupElementFunctionData(possibleFunction, hasPropertySignature, hasOtherNonEmptySignature);
    }

    @Nullable
    private static JSType expandAndOptimizeTypeRecursive(@Nullable JSType sourceType, boolean typeScript) {
        return typeScript ? TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(sourceType) : sourceType;
    }

    @Contract(value="null -> false")
    private static boolean isTypeAcceptableForLookupElement(@Nullable JSType type) {
        if (type instanceof JSNamedType) {
            String text = type.getTypeText();
            return !text.endsWith("Constructor") || !JSCorePredefinedLibrariesProvider.isLibraryElement(type.getSourceElement());
        }
        return type != null && !JSTypeUtils.hasTypes(type, JSEvaluableType.class, JSRecordType.class);
    }

    @Nullable
    public static String getPackageLocationString(@NotNull PsiElement original) {
        JSQualifiedName namespace;
        if (original == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(7);
        }
        if (!(original instanceof JSQualifiedNamedElement)) {
            return JSLookupUtilImpl.getLocationStringFromPresentation(original);
        }
        JSElementBase elt = (JSElementBase)original;
        PsiElement parent = JSResolveUtil.findParent(original);
        if ((parent instanceof JSPackageStatement || parent instanceof JSFile || elt instanceof XmlBackedJSClass) && (namespace = elt.getNamespace()) != null) {
            String namespaceName = namespace.getQualifiedName();
            return "(" + namespaceName + ")";
        }
        return JSLookupUtilImpl.getLocationStringFromPresentation(original);
    }

    @Nullable
    public static Icon getLookupElementIcon(@Nullable PsiElement element) {
        if (element instanceof JSClass) {
            if (element instanceof TypeScriptInterface) {
                return PlatformIcons.INTERFACE_ICON;
            }
            if (element instanceof TypeScriptTypeAlias) {
                return JavaScriptPsiIcons.Classes.Alias;
            }
            return PlatformIcons.CLASS_ICON;
        }
        return element instanceof JSElement || element instanceof CssClass || element instanceof PsiFile ? element.getIcon(0) : (element instanceof XmlElement ? JSIconProvider.HTML_TAG_ICON : JSLookupUtilImpl.getEmptyIcon());
    }

    @Nullable
    public static String getFunctionTailText(JSFunctionItem function2, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (!function2.isGetProperty() && !function2.isSetProperty()) {
            Object[] typeParameters;
            StringBuilder result2 = new StringBuilder();
            if (function2 instanceof TypeScriptTypeParameterListOwner && (typeParameters = ((TypeScriptTypeParameterListOwner)function2).getTypeParameters()).length > 0 && !JSLookupUtilImpl.hasAllSubstitutions(typeSubstitutor, (TypeScriptTypeParameter[])typeParameters)) {
                result2.append('<').append(StringUtil.join((Object[])typeParameters, PsiNamedElement::getName, (String)", ")).append('>');
            }
            result2.append("(");
            JSParameterItem[] parameters = function2.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                JSParameterItem parameter = parameters[i];
                if (i != 0) {
                    result2.append(", ");
                }
                result2.append(JSParameterInfoHandler.getSignatureForParameter(parameter, typeSubstitutor, JSParameterInfoHandler.TYPE_DESCRIBER));
            }
            result2.append(")");
            return result2.toString();
        }
        return null;
    }

    private static boolean hasAllSubstitutions(@Nullable JSTypeSubstitutor typeSubstitutor, TypeScriptTypeParameter[] typeParameters) {
        if (typeSubstitutor == null) {
            return false;
        }
        for (TypeScriptTypeParameter p : typeParameters) {
            if (typeSubstitutor.containsId(p.getGenericId())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getLocationStringFromPresentation(@Nullable PsiElement element) {
        if (!(element instanceof NavigationItem)) {
            return null;
        }
        ItemPresentation presentation = ((NavigationItem)element).getPresentation();
        if (presentation != null) {
            Object locationString;
            Object object = locationString = presentation instanceof JSItemPresentation ? ((JSItemPresentation)presentation).getLocationString(true) : presentation.getLocationString();
            if (locationString != null) {
                boolean needBraces;
                boolean bl = needBraces = !((String)locationString).startsWith("(");
                if (needBraces) {
                    locationString = "(" + (String)locationString + ")";
                }
                return locationString;
            }
        }
        return "";
    }

    public static boolean willCreateLookupElement(@NotNull JSLookupPriority priority) {
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(8);
        }
        return priority.compareTo(MY_LAST_VALUE_WITHOUT_PRIORITY) > 0 || !JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction();
    }

    public static String getShortName(String qName) {
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(qName);
        Object textToRender = signature != null ? "Vector.<" + JSLookupUtilImpl.getShortName(signature.genericType) + ">" : (!StringUtil.containsAnyChar((String)qName, (String)"<[(={") ? qName.substring(qName.lastIndexOf(46) + 1) : qName);
        return textToRender;
    }

    @NotNull
    public static LookupElementBuilder createLookupElement(@NotNull PsiNamedElement element) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(9);
        }
        return JSLookupUtilImpl.createLookupElement((PsiElement)element, StringUtil.notNullize((String)element.getName()));
    }

    @NotNull
    public static LookupElementBuilder createLookupElement(@NotNull PsiElement element, String name) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(10);
        }
        LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element);
        LookupElementBuilder lookupElementBuilder = new JSLookupElementRenderer(name, JSLookupPriority.MAX_PRIORITY, false, null).applyToBuilder(builder);
        if (lookupElementBuilder == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(11);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElement createPrioritizedLookupElement(@NotNull PsiNamedElement element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(12);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(13);
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)JSLookupUtilImpl.createLookupElement(element), (double)priority.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(14);
        }
        return lookupElement;
    }

    public static LookupElement toBoldLookupElement(@NotNull Object lookupElement) {
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(15);
        }
        if (lookupElement instanceof LookupElement) {
            return JSLookupUtilImpl.setBold((LookupElement)lookupElement, true);
        }
        return LookupElementBuilder.create((String)lookupElement.toString()).bold();
    }

    @Contract(value="null, _ -> true; _, null -> true")
    public static boolean matchElementWithContext(@Nullable PsiElement element, @Nullable PsiElement place) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(place);
        if (holder == null) {
            return true;
        }
        return !(element instanceof ES6DecoratorDeclaration) || holder.hasFeature(JSLanguageFeature.DECORATOR_DECLARATIONS) && JSUtils.isDecoratorAccessContext(place);
    }

    @NotNull
    public static LookupElement createLookupItemForStaticCall(@NotNull JSElement methodElement, @NotNull JSElement ownerElement) {
        if (methodElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(16);
        }
        if (ownerElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(17);
        }
        LookupElementBuilder builder = JSLookupUtilImpl.createLookupElement((PsiElement)methodElement, ownerElement.getName() + "." + methodElement.getName());
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withInsertHandler((c, i) -> {
            JSInsertHandler.insertBracesIfNeeded(c, 1);
            new ShowParameterInfoHandler().invoke(c.getProject(), c.getEditor(), c.getFile());
        }), (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(18);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createImplementAbstractOrInterfaceLookupItem(@NotNull PsiElement namedElement, @NotNull String className2) {
        if (namedElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(19);
        }
        if (className2 == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(20);
        }
        String extendsWord = namedElement instanceof JSClass && ((JSClass)namedElement).isInterface() ? "implements" : "extends";
        LookupElementBuilder builder = JSLookupUtilImpl.createLookupElement(namedElement, "class " + extendsWord + " " + className2 + " {}");
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withLookupString(className2).withPresentableText(className2 + "{...}").withInsertHandler((c, i) -> JSLookupUtilImpl.generateMissingMembersForItem(c)), (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(21);
        }
        return lookupElement;
    }

    private static String elementOrNullDesc(Object element) {
        return element == null ? "(null)" : element.getClass().getName();
    }

    private static void generateMissingMembersForItem(@NotNull InsertionContext c) {
        if (c == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(22);
        }
        Editor editor = c.getEditor();
        int startOffset = c.getStartOffset();
        editor.getCaretModel().moveToOffset(startOffset);
        PsiElement element = c.getFile().findElementAt(startOffset);
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
        if (jsClass == null) {
            Logger.getInstance(JSLookupUtilImpl.class).error("Class not found, element: " + JSLookupUtilImpl.elementOrNullDesc(element) + "context: " + JSLookupUtilImpl.elementOrNullDesc(PsiTreeUtil.getParentOfType((PsiElement)element, JSExecutionScope.class)));
            return;
        }
        TypeScriptImplementMembersHandler handler = new TypeScriptImplementMembersHandler();
        handler.setSkipMemberChooserDialog(true);
        handler.invoke(c.getProject(), editor, c.getFile());
        editor.getCaretModel().moveToOffset(jsClass.getTextRange().getEndOffset());
    }

    public static boolean isBold(@Nullable LookupElement element) {
        if (element instanceof PrioritizedLookupElement) {
            element = ((PrioritizedLookupElement)element).getDelegate();
        }
        if (element instanceof LookupElementBuilder) {
            BoldCheckingLookupElementPresentation presentation = new BoldCheckingLookupElementPresentation();
            element.renderElement((LookupElementPresentation)presentation);
            return presentation.isItemTextBold();
        }
        return false;
    }

    @NotNull
    public static LookupElement withPartial(@NotNull LookupElement element, boolean partial) {
        LookupElementRenderer renderer;
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(23);
        }
        LookupElement delegate = element;
        if (element instanceof PrioritizedLookupElement) {
            delegate = ((PrioritizedLookupElement)element).getDelegate();
        }
        if (delegate instanceof LookupElementBuilder && (renderer = ((LookupElementBuilder)delegate).getRenderer()) instanceof JSLookupElementRenderer) {
            LookupElementBuilder newElement = ((JSLookupElementRenderer)renderer).applyToBuilderWithPartial((LookupElementBuilder)delegate, partial);
            if (newElement == delegate) {
                LookupElement lookupElement = element;
                if (lookupElement == null) {
                    JSLookupUtilImpl.$$$reportNull$$$0(24);
                }
                return lookupElement;
            }
            LookupElement lookupElement = JSLookupUtilImpl.wrapWithPriority(element, newElement);
            if (lookupElement == null) {
                JSLookupUtilImpl.$$$reportNull$$$0(25);
            }
            return lookupElement;
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(26);
        }
        return lookupElement;
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> !null")
    public static LookupElement setBold(@Nullable LookupElement lookupElement, boolean boldness) {
        if (JSLookupUtilImpl.isBold(lookupElement) == boldness) {
            return lookupElement;
        }
        LookupElement actualElement = lookupElement;
        if (lookupElement instanceof PrioritizedLookupElement) {
            lookupElement = ((PrioritizedLookupElement)lookupElement).getDelegate();
        }
        if (lookupElement instanceof LookupElementBuilder) {
            LookupElementBuilder newElement = ((LookupElementBuilder)lookupElement).withBoldness(boldness);
            return JSLookupUtilImpl.wrapWithPriority(actualElement, newElement);
        }
        return actualElement;
    }

    public static LookupElement wrapWithPriority(@NotNull LookupElement oldActualElement, @NotNull LookupElementBuilder newElement) {
        if (oldActualElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(27);
        }
        if (newElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(28);
        }
        if (!(oldActualElement instanceof PrioritizedLookupElement)) {
            return newElement;
        }
        return PrioritizedLookupElement.withExplicitProximity((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)PrioritizedLookupElement.withPriority((LookupElement)newElement, (double)((PrioritizedLookupElement)oldActualElement).getPriority()), (int)((PrioritizedLookupElement)oldActualElement).getGrouping()), (int)((PrioritizedLookupElement)oldActualElement).getExplicitProximity());
    }

    public static void setForceQualify(@Nullable LookupElement lookupElement) {
        InsertHandler handler;
        if (lookupElement instanceof PrioritizedLookupElement) {
            lookupElement = ((PrioritizedLookupElement)lookupElement).getDelegate();
        }
        if (lookupElement instanceof LookupElementBuilder && (handler = ((LookupElementBuilder)lookupElement).getInsertHandler()) instanceof JSLookupElementInsertHandler) {
            ((JSLookupElementInsertHandler)handler).setForceQualify(true);
        }
    }

    public static Icon getEmptyIcon() {
        return IconHolder.ourEmptyIcon;
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, JSLookupPriority priority) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(29);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, false, null);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean partial, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(30);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(31);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, partial, typeSubstitutor, false);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean partial, @Nullable JSTypeSubstitutor typeSubstitutor, boolean insertAsIndexer) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(32);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(33);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, partial, typeSubstitutor, insertAsIndexer, null);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean partial, @Nullable JSTypeSubstitutor typeSubstitutor, boolean insertAsIndexer, @Nullable String lookupString) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(34);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(35);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, partial, typeSubstitutor, insertAsIndexer, lookupString, null);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean partial, @Nullable JSTypeSubstitutor typeSubstitutor, boolean insertAsIndexer, @Nullable String lookupString, @Nullable Runnable insertHandlerAction) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(36);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(37);
        }
        if (!JSLookupUtilImpl.willCreateLookupElement(priority)) {
            return null;
        }
        ProgressManager.checkCanceled();
        if (insertAsIndexer) {
            priority = JSLookupUtilImpl.getIndexerPriority(priority);
        }
        if (value instanceof JSImplicitPrototypeElement && priority.getPriorityValue() > JSLookupPriority.NESTING_LEVEL_REST.getPriorityValue()) {
            priority = JSLookupPriority.NESTING_LEVEL_REST;
        }
        LookupElementBuilder builder = value == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)value);
        builder = new JSLookupElementRenderer(name, priority, partial, typeSubstitutor).applyToBuilder(builder).withInsertHandler((InsertHandler)new JSLookupElementInsertHandler(insertAsIndexer, insertHandlerAction));
        if (lookupString == null && StringUtil.isQuotedString((String)name)) {
            lookupString = StringUtil.unquoteString((String)name);
        }
        if (lookupString != null) {
            builder = builder.withLookupString(lookupString);
        }
        return JSCompletionUtil.withJSLookupPriority((LookupElement)builder, priority);
    }

    public static boolean isExoticName(String name) {
        return name.startsWith("'") || name.startsWith("\"") || name.startsWith("[");
    }

    @NotNull
    public static JSLookupPriority getIndexerPriority(@NotNull JSLookupPriority priority) {
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(38);
        }
        if (priority.getPriorityValue() >= JSLookupPriority.NESTING_LEVEL_REST.getPriorityValue()) {
            JSLookupPriority jSLookupPriority = JSLookupPriority.NESTING_LEVEL_REST;
            if (jSLookupPriority == null) {
                JSLookupUtilImpl.$$$reportNull$$$0(39);
            }
            return jSLookupPriority;
        }
        JSLookupPriority jSLookupPriority = JSLookupPriority.LOWEST_PRIORITY;
        if (jSLookupPriority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(40);
        }
        return jSLookupPriority;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSLookupUtilImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 8: 
            case 13: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldActualElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiparamCompletionItem";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSLookupUtilImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleFunctionData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrioritizedLookupElement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupItemForStaticCall";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementAbstractOrInterfaceLookupItem";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "withPartial";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexerPriority";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAndTailTexts";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFunctionData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPackageLocationString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "willCreateLookupElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPrioritizedLookupElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toBoldLookupElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItemForStaticCall";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createImplementAbstractOrInterfaceLookupItem";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateMissingMembersForItem";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withPartial";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPriority";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createPrioritizedLookupItem";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getIndexerPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JSLookupElementFunctionData {
        static final JSLookupElementFunctionData EMPTY = new JSLookupElementFunctionData(null, false, false);
        @Nullable
        final SmartPsiElementPointer<JSFunctionItem> possibleFunction;
        final boolean hasProperty;
        final boolean hasOtherNonEmptySignature;

        JSLookupElementFunctionData(@Nullable JSFunctionItem possibleFunction, boolean hasProperty, boolean hasOtherNonEmptySignature) {
            this.possibleFunction = possibleFunction != null ? SmartPointerManager.createPointer((PsiElement)possibleFunction) : null;
            this.hasProperty = hasProperty;
            this.hasOtherNonEmptySignature = hasOtherNonEmptySignature;
        }
    }

    public static final class IconHolder {
        public static final Icon ourEmptyIcon = EmptyIcon.create((Icon)PlatformIcons.CLASS_ICON);
        public static final Icon ourParamParamIcon = PlatformIcons.PARAMETER_ICON;
    }

    public static class BoldCheckingLookupElementPresentation
    extends LookupElementPresentation {
    }

    public static class TypeAndTail {
        final String typeText;
        final String tailText;
        final String location;

        public TypeAndTail(String typeText, String tailText, String location) {
            this.typeText = typeText;
            this.tailText = tailText;
            this.location = location;
        }

        public String toString() {
            return this.typeText + ";" + this.tailText + "@" + this.location;
        }

        public String getTailAndType() {
            return this.tailText + ":" + this.typeText;
        }
    }
}

