/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementInfo;
import com.intellij.lang.javascript.completion.JSLookupElementInfoImpl;
import com.intellij.lang.javascript.completion.JSLookupElementMerger;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSPlaceElementFilter;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSImportCompletionUtil {
    public static final JSLookupPriority IMPORT_PRIORITY = JSLookupPriority.LOWEST_PRIORITY;

    public static void addExportedVariants(@NotNull JSReferenceExpression expression, @NotNull Collection<LookupElement> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (expression == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(0);
        }
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(1);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(2);
        }
        assert (expression.getQualifier() == null);
        JSImportCompletionUtil.addExportedVariants((PsiElement)expression, sinkResults, completionResultSet);
    }

    public static void addExportedVariants(@NotNull ES6ImportExportDeclarationPart specifier, @NotNull Collection<LookupElement> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (specifier == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(3);
        }
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(4);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(5);
        }
        JSImportCompletionUtil.addExportedVariants((PsiElement)specifier, sinkResults, completionResultSet);
    }

    private static void addExportedVariants(@NotNull PsiElement place, @NotNull Collection<LookupElement> localAndGlobalElements, @NotNull CompletionResultSet completionResultSet) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(6);
        }
        if (localAndGlobalElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(7);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(8);
        }
        if (JSImportCompletionUtil.skipPlace(place)) {
            return;
        }
        int count = localAndGlobalElements.size();
        if (!JSImportCompletionUtil.checkLimit(completionResultSet, JSCompletionUtil.getCompletionLimit(), count)) {
            return;
        }
        PsiElement originalPlace = CompletionUtilCoreImpl.getOriginalElement((PsiElement)place);
        if (originalPlace != null) {
            place = originalPlace;
        }
        PrefixMatcher matcher = completionResultSet.getPrefixMatcher();
        Set<String> localAndProcessedElements = JSImportCompletionUtil.getLocalElementNames(localAndGlobalElements, place, matcher);
        JSImportPlaceInfo info = new JSImportPlaceInfo(place);
        AtomicInteger counter = new AtomicInteger(count);
        JSImportCompletionUtil.processExportedElements(place, completionResultSet, counter, localAndProcessedElements, info);
    }

    private static void processExportedElements(@NotNull PsiElement place, @NotNull CompletionResultSet completionResultSet, @NotNull AtomicInteger counter, @NotNull Set<String> localElements, @NotNull JSImportPlaceInfo info) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(9);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(10);
        }
        if (counter == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(11);
        }
        if (localElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(12);
        }
        if (info == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(13);
        }
        int limit = JSCompletionUtil.getCompletionLimit();
        PsiFile containingFile = place.getContainingFile().getOriginalFile();
        PrefixMatcher prefixMatcher = completionResultSet.getPrefixMatcher();
        boolean excludeNonLatin = JSImportCompletionUtil.isExcludeWithNonLatinFirstSymbol(completionResultSet);
        JSCompletionPlaceFilter completionPlaceFilter = JSCompletionPlaceFilter.forPlace(place);
        Predicate<String> keyFilter = el -> !el.isEmpty() && !localElements.contains(el) && prefixMatcher.prefixMatches(el) && (!excludeNonLatin || JSImportCompletionUtil.isLatin(el.charAt(0)));
        JSLookupElementMerger merger = new JSLookupElementMerger(place, (el, priority) -> el instanceof JSPsiElementBase && completionPlaceFilter.isAcceptable((JSPsiElementBase)el), limit, true);
        List<JSImportCandidatesProvider> candidates = JSImportCandidatesProvider.getProviders(info);
        JSImportCompletionUtil.processExportedElements(place, candidates, keyFilter, (PairProcessor<? super Collection<? extends JSImportCandidate>, ? super String>)((PairProcessor)(elements, name) -> {
            localElements.add((String)name);
            InsertHandler<LookupElement> insertHandler = JSImportCompletionUtil.getImportInsertHandler(containingFile, elements);
            JSImportCompletionUtil.fillLookupItemForElements(completionResultSet, insertHandler, name, elements, merger);
            counter.incrementAndGet();
            return JSImportCompletionUtil.checkLimit(completionResultSet, limit, counter.get());
        }));
    }

    public static boolean processExportedElements(@NotNull PsiElement place, @NotNull List<JSImportCandidatesProvider> providers, @NotNull Predicate<String> keyFilter, @NotNull PairProcessor<? super Collection<? extends JSImportCandidate>, ? super String> processor) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(14);
        }
        if (providers == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(15);
        }
        if (keyFilter == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(17);
        }
        ProgressManager.checkCanceled();
        HashSet<String> allKeys = new HashSet<String>();
        ArrayList<Pair> listOfProviders = new ArrayList<Pair>();
        for (JSImportCandidatesProvider candidate : providers) {
            Set<String> names = candidate.getNames(keyFilter);
            allKeys.addAll(names);
            listOfProviders.add(Pair.create(names, (Object)candidate));
        }
        for (String name : allKeys.stream().sorted().collect(Collectors.toList())) {
            List<? extends JSImportCandidate> elements;
            ProgressManager.checkCanceled();
            JSCandidatesProcessor collector = new JSCandidatesProcessor();
            for (Pair provider : listOfProviders) {
                if (!((Set)provider.first).contains(name) || ((JSImportCandidatesProvider)provider.second).processCandidates(name, collector, true)) continue;
                break;
            }
            if ((elements = JSPlaceElementFilter.DEFAULT_FILTER.filterCandidates(place, collector.getResults())).isEmpty() || processor.process(elements, (Object)name)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static InsertHandler<LookupElement> getImportInsertHandler(@NotNull PsiFile containingFile, @NotNull Collection<? extends JSImportCandidate> elements) {
        if (containingFile == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(18);
        }
        if (elements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(19);
        }
        if (containingFile instanceof JSExpressionCodeFragment) {
            InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
            if (insertHandler == null) {
                JSImportCompletionUtil.$$$reportNull$$$0(20);
            }
            return insertHandler;
        }
        JSImportCandidate item = (JSImportCandidate)ContainerUtil.getFirstItem(elements);
        if (item == null || elements.stream().noneMatch(JSImportCandidate::useAutoImport)) {
            InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
            if (insertHandler == null) {
                JSImportCompletionUtil.$$$reportNull$$$0(21);
            }
            return insertHandler;
        }
        List psiElements = StreamEx.of(elements).map(el -> el.getElement()).nonNull().toList();
        JSElement element = item.getElement();
        JSElement toImport = element != null && psiElements.size() == elements.size() ? JSLookupElementMerger.mergeOverloads(psiElements, element) : null;
        JSImportCandidate candidate = toImport == null ? null : (JSImportCandidate)ContainerUtil.find(elements, el -> toImport == el.getElement());
        return new ImportInsertHandler(candidate);
    }

    private static boolean isExcludeWithNonLatinFirstSymbol(@NotNull CompletionResultSet completionResultSet) {
        PrefixMatcher matcher;
        String prefix;
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(22);
        }
        if ((prefix = (matcher = completionResultSet.getPrefixMatcher()).getPrefix()).isEmpty()) {
            completionResultSet.restartCompletionOnAnyPrefixChange();
            return true;
        }
        return JSImportCompletionUtil.isLatin(prefix.charAt(0));
    }

    private static boolean checkLimit(@NotNull CompletionResultSet completionResultSet, int limit, int count) {
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(23);
        }
        if (count <= limit) {
            return true;
        }
        JSCompletionUtil.handleOverflow(completionResultSet);
        return false;
    }

    private static boolean skipPlace(@NotNull PsiElement place) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(24);
        }
        return TypeScriptPsiUtil.isTsIndexerType(place) || place.getContext() instanceof JSExportAssignment;
    }

    @NotNull
    public static Set<String> getLocalElementNames(@NotNull Collection<LookupElement> sinkResults, @NotNull PsiElement place, @NotNull PrefixMatcher matcher) {
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(25);
        }
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(26);
        }
        if (matcher == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(27);
        }
        THashSet localElements = new THashSet();
        JSImportCompletionUtil.fillImportedElements(place, (Set<String>)localElements);
        PsiFile containingFile = place.getContainingFile();
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllLibraries(containingFile.getProject());
        for (LookupElement lookupElement : sinkResults) {
            PsiFile currentFile;
            PsiElement currentElement = lookupElement.getPsiElement();
            if (currentElement != null && (currentFile = currentElement.getContainingFile()) != null && currentFile.getOriginalFile() != containingFile) {
                double priority = JSCompletionUtil.getLookupElementPriority(lookupElement);
                if (libraries.contains(currentFile.getVirtualFile()) || (double)JSLookupPriority.SMART_MATCHED_PARAMETER_NAME.getPriorityValue() > priority) continue;
            }
            if (!matcher.prefixMatches(lookupElement)) continue;
            localElements.add((Object)lookupElement.getLookupString());
        }
        THashSet tHashSet = localElements;
        if (tHashSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(28);
        }
        return tHashSet;
    }

    private static void fillImportedElements(@NotNull PsiElement place, @NotNull Set<String> localElements) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(29);
        }
        if (localElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(30);
        }
        JSElement scope = ES6PsiUtil.getExportScope(place);
        while (scope != null) {
            List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations((PsiElement)scope);
            for (ES6ImportDeclaration declaration : declarations) {
                String name;
                ES6ImportedBinding[] bindings;
                ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
                for (ES6ImportedBinding eS6ImportedBinding : bindings = declaration.getImportedBindings()) {
                    name = eS6ImportedBinding.getDeclaredName();
                    localElements.add(name);
                }
                for (ES6ImportedBinding eS6ImportedBinding : specifiers) {
                    name = eS6ImportedBinding.getDeclaredName();
                    localElements.add(name);
                }
            }
            if (scope instanceof PsiFile) break;
            scope = ES6PsiUtil.getExportScope((PsiElement)scope);
        }
    }

    private static void fillLookupItemForElements(@NotNull CompletionResultSet completionResultSet, @NotNull InsertHandler<LookupElement> insertImportHandler, @NotNull String name, @NotNull Collection<? extends JSImportCandidate> candidates, @NotNull JSLookupElementMerger merger) {
        Collection<LookupElement> merged;
        LookupElement item;
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(31);
        }
        if (insertImportHandler == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(32);
        }
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(33);
        }
        if (candidates == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(34);
        }
        if (merger == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(35);
        }
        List elements = StreamEx.of(candidates).map(el -> el.getElement()).select(JSElement.class).nonNull().toList();
        Collection<JSLookupElementInfo> infos = JSImportCompletionUtil.createInfos(name, elements);
        if (candidates.size() > 0 && infos.size() == 0) {
            infos = Collections.singleton(JSImportCompletionUtil.createInfo(name, null));
        }
        if ((item = (LookupElement)ContainerUtil.getFirstItem(merged = merger.merge(name, infos, true))) != null) {
            if (item instanceof PrioritizedLookupElement) {
                item = ((PrioritizedLookupElement)item).getDelegate();
            }
            if (item instanceof LookupElementBuilder) {
                item = ((LookupElementBuilder)item).withInsertHandler(insertImportHandler);
            }
            item = JSCompletionUtil.withJSLookupPriority(item, IMPORT_PRIORITY);
            completionResultSet.addElement(item);
        }
    }

    @NotNull
    private static Set<PsiElement> expandElements(Collection<JSElement> elements) {
        Set<PsiElement> set = elements.stream().flatMap(el -> {
            if (el instanceof ES6ExportSpecifier || el instanceof ES6ExportSpecifierAlias || el instanceof ES6ExportDefaultAssignment && (((ES6ExportDefaultAssignment)el).getStubSafeElement() != null || ((ES6ExportDefaultAssignment)el).getInitializerReference() != null)) {
                return ES6PsiUtil.expandElements((PsiElement)el, Collections.singleton(el)).stream();
            }
            return Stream.of(el);
        }).collect(Collectors.toSet());
        if (set == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(36);
        }
        return set;
    }

    private static boolean isLatin(char symbol) {
        return symbol >= 'A' && symbol <= 'Z' || symbol >= 'a' && symbol <= 'z';
    }

    private static void importForElement(@NotNull InsertionContext context, @NotNull LookupElement item, @Nullable JSImportCandidate candidate) {
        if (context == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(37);
        }
        if (item == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(38);
        }
        JSImportCompletionUtil.insertLookupItem(context, item, candidate, (Consumer<? super JSImportCandidate>)((Consumer)importedElement -> {
            if (importedElement == null) {
                return;
            }
            JSElement elementToHandle = importedElement.getElement();
            if (elementToHandle == null) {
                return;
            }
            PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
            if (originalElement != null) {
                PsiElement toProcessPlace;
                PsiElement psiElement = toProcessPlace = originalElement.getNode().getElementType() == JSTokenTypes.IDENTIFIER ? originalElement.getParent() : originalElement;
                if (toProcessPlace instanceof JSReferenceExpression && toProcessPlace.isValid()) {
                    context.commitDocument();
                    PsiElement resolved = ((JSReferenceExpression)toProcessPlace).resolve();
                    if (resolved != null) {
                        elementToHandle = resolved;
                    }
                }
            }
            PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
            if (item.getPsiElement() != null) {
                new JSInsertHandler().handleInsert(context, item);
            } else if (item instanceof LookupElementBuilder) {
                new JSInsertHandler().handleInsert(context, (LookupElement)((LookupElementBuilder)item).withPsiElement((PsiElement)elementToHandle));
            }
        }));
    }

    @NotNull
    private static Collection<JSLookupElementInfo> createInfos(@NotNull String name, Collection<JSElement> elements) {
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(39);
        }
        Set<PsiElement> expandedElements = JSImportCompletionUtil.expandElements(elements);
        List list2 = ContainerUtil.map(expandedElements, el -> JSImportCompletionUtil.createInfo(name, el));
        if (list2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(40);
        }
        return list2;
    }

    private static JSLookupElementInfo createInfo(final @NotNull String name, final @Nullable PsiElement element) {
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(41);
        }
        return new JSLookupElementInfoImpl(element, name, IMPORT_PRIORITY, BaseJSSymbolProcessor.MatchType.COMPLETE, null){

            @Override
            public LookupElement toLookupElement() {
                LookupElementBuilder builder = element == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)element, (String)name);
                return new JSLookupElementRenderer(name, IMPORT_PRIORITY, false, null).applyToBuilder(builder);
            }
        };
    }

    public static void insertLookupItem(@NotNull InsertionContext context, @NotNull LookupElement item, @Nullable JSImportCandidate candidate, @Nullable Consumer<? super JSImportCandidate> afterInsert) {
        if (context == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(42);
        }
        if (item == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(43);
        }
        context.commitDocument();
        CaretModel model = context.getEditor().getCaretModel();
        if (model.getCaretCount() > 1 && model.getPrimaryCaret() != model.getCurrentCaret()) {
            return;
        }
        PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
        if (originalElement == null || !JSImportCompletionUtil.shouldAddImportFromCompletion(originalElement)) {
            return;
        }
        if (originalElement instanceof LeafElement) {
            originalElement = originalElement.getParent();
        }
        String name = item.getLookupString();
        JSImportAction action = new JSImportAction(context.getEditor(), originalElement, name, JSPlaceElementFilter.DEFAULT_FILTER);
        if (candidate != null) {
            action.executeFor(candidate, afterInsert);
        } else {
            action.executeForAllVariants(afterInsert);
        }
    }

    private static boolean shouldAddImportFromCompletion(@NotNull PsiElement element) {
        if (element == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(44);
        }
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return DialectDetector.isTypeScript(element) ? settings.hasTSImportCompletionEffective(element.getProject()) : settings.isUseJavaScriptAutoImport();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 36: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 36: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinkResults";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 22: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localAndGlobalElements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localElements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertImportHandler";
                break;
            }
            case 33: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "merger";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportInsertHandler";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalElementNames";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExportedVariants";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processExportedElements";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImportInsertHandler";
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 36: 
            case 40: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isExcludeWithNonLatinFirstSymbol";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkLimit";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "skipPlace";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElementNames";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fillImportedElements";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "fillLookupItemForElements";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "importForElement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createInfos";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "insertLookupItem";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddImportFromCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 36: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ImportInsertHandler
    implements InsertHandler<LookupElement> {
        private final JSImportCandidate myElement;

        private ImportInsertHandler(@Nullable JSImportCandidate element) {
            this.myElement = element;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                ImportInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                ImportInsertHandler.$$$reportNull$$$0(1);
            }
            JSImportCompletionUtil.importForElement(context, item, this.myElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil$ImportInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

