/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.webpack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfig;
import com.intellij.lang.javascript.buildTools.webpack.WebPackNotifier;
import com.intellij.lang.javascript.buildTools.webpack.WebPackStampedConfig;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackExecutor;", "", "()V", "MARKER", "", "createGson", "Lcom/google/gson/Gson;", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "errorNotify", "", "project", "Lcom/intellij/openapi/project/Project;", "configPath", "stdErr", "extractErrorDetails", "getInterpreter", "getWorkingDir", "path", "loadConfig", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackStampedConfig;", "timestamp", "", "run", "Lcom/intellij/execution/process/ProcessOutput;", "Companion", "intellij.javascript.impl"})
public final class WebPackExecutor {
    private final String MARKER;
    @NotNull
    public static final String EXECUTION_TIMEOUT_KEY = "webpack.execution.timeout.ms";
    public static final int version = 7;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final ProcessOutput run(Project project, NodeJsInterpreter interpreter, String path) {
        void it;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(Charsets.UTF_8);
        Map map2 = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"commandLine.environment");
        map2.put("NODE_ENV", "development");
        String string = this.getWorkingDir(project, path);
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string;
        GeneralCommandLine generalCommandLine = commandLine;
        boolean bl3 = false;
        LOG.info("Working directory: " + (String)it);
        Unit unit = Unit.INSTANCE;
        String string3 = string;
        generalCommandLine.setWorkDirectory(new File(string3));
        commandLine.addParameter("-e");
        String loader = "";
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)".babel.", (boolean)false, (int)2, null)) {
            loader = "try {\n  require('@babel/register');\n} catch (e) {\n  require('babel-register');\n}";
        } else if (StringsKt.endsWith$default((String)path, (String)".ts", (boolean)false, (int)2, null)) {
            loader = "require('ts-node/register');";
        }
        String string4 = NodeInterpreterUtil.convertLocalPathToRemote(FileUtil.toSystemDependentName((String)path), interpreter);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"NodeInterpreterUtil.conv\u2026tName(path), interpreter)");
        String targetPath = string4;
        commandLine.addParameter(StringsKt.trimIndent((String)("\n      require.main = { require: require };\n      " + loader + "\n      function mergeConfigs(array){\n        var result = {};\n        for (var i = 0; i < array.length; i++) {\n          var obj = array[i];\n          result.output = result.output || obj.output;\n          if (!result.resolve) {\n            result.resolve = obj.resolve;\n          } else if (obj.resolve) {\n            if (!result.resolve.alias) {\n              result.resolve.alias = obj.resolve.alias;\n            } else if (obj.resolve.alias) {\n              result.resolve.alias = Object.assign(result.resolve.alias, obj.resolve.alias);\n            }\n            if (!result.resolve.extensions) {\n              result.resolve.extensions = obj.resolve.extensions;\n            } else if (obj.resolve.extensions) {\n              result.resolve.extensions = result.resolve.extensions.concat(obj.resolve.extensions);\n            }\n            if (!result.resolve.modules) {\n              result.resolve.modules = obj.resolve.modules;\n            } else if (obj.resolve.modules) {\n              result.resolve.modules = result.resolve.modules.concat(obj.resolve.modules);\n            }\n            if (!result.resolve.modulesDirectories) {\n              result.resolve.modulesDirectories = obj.resolve.modulesDirectories;\n            } else if (obj.resolve.modulesDirectories) {\n              result.resolve.modulesDirectories = result.resolve.modulesDirectories.concat(obj.resolve.modulesDirectories);\n            }\n            result.resolve.root = result.resolve.root || obj.resolve.root;\n          }\n        }\n        return result;\n      }\n      var config = require('" + StringUtil.escapeBackSlashes((String)targetPath) + "');\n      function printConfig(config, resolvePromise) {\n        if (config.default !== undefined) config = config.default;\n        if (typeof config === 'function') config = config({development: true}, {});\n        if (resolvePromise && typeof Promise !== 'undefined') {\n          config = Promise.resolve(config).then(function(value) {\n            printConfig(value, false)\n          })\n          return;\n        }\n        if (Array.isArray(config)) {\n          config = mergeConfigs(config);\n        }\n        config = {resolve: config.resolve, output: config.output}\n        if (config.resolve) config.resolve.plugins = undefined;\n        console.log(\"" + this.MARKER + "\")\n        console.log(JSON.stringify(config, null, 1));\n        process.exit(0);\n      }\n      printConfig(config, true)\n      ")));
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine, NodeCommandLineConfigurator.defaultOptions(project));
        return NodeCommandLineUtil.execute(commandLine, Registry.intValue((String)EXECUTION_TIMEOUT_KEY, (int)20000));
    }

    private final String getWorkingDir(Project project, String path) {
        VirtualFile webpack = VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)path));
        if (webpack != null) {
            VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(webpack);
            while (packageJson != null && JSLibraryUtil.hasDirectoryInPath(packageJson, "node_modules", null)) {
                VirtualFile virtualFile = packageJson.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"packageJson.parent");
                packageJson = PackageJsonUtil.findUpPackageJson(virtualFile.getParent());
            }
            if (packageJson != null) {
                VirtualFile virtualFile = packageJson.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"packageJson.parent");
                String string = virtualFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageJson.parent.path");
                return string;
            }
        }
        String string = project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final NodeJsInterpreter getInterpreter(Project project) {
        NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
        NodeJsInterpreter interpreter = nodeJsInterpreterManager.getInterpreter();
        return interpreter != null && interpreter.validate(project) == null ? interpreter : null;
    }

    @NotNull
    public final WebPackStampedConfig loadConfig(@NotNull Project project, @NotNull String configPath, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        CharSequence charSequence = configPath;
        boolean bl = false;
        if (charSequence.length() == 0) {
            LOG.warn("Empty path provided to webpack executor");
            return new WebPackStampedConfig(null, 0L, 7, null, 11, null);
        }
        NodeJsInterpreter interpreter = this.getInterpreter(project);
        if (interpreter == null) {
            String string = JavaScriptBundle.message((String)"webpack.failed.to.load", (Object[])new Object[]{PathUtil.getFileName((String)configPath)});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaScriptBundle.message\u2026.getFileName(configPath))");
            MessageType messageType = MessageType.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.WARNING");
            WebPackNotifier.INSTANCE.notify(project, string, messageType, configPath, new AnAction(project, JavaScriptBundle.message((String)"node.js.configure", (Object[])new Object[0])){
                final /* synthetic */ Project $project;

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    NodeSettingsConfigurable.showSettingsDialog(this.$project);
                }
                {
                    this.$project = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            });
            return new WebPackStampedConfig(null, 0L, 7, configPath, 3, null);
        }
        ProcessOutput run = this.run(project, interpreter, configPath);
        if (run != null && run.getExitCode() == 0) {
            String string;
            int lastNewLine;
            String string2 = run.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"run.stdout");
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String stdOut = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("stdout: " + stdOut + "\nstderr: " + run.getStderr());
            }
            if ((lastNewLine = StringsKt.lastIndexOf$default((CharSequence)stdOut, (String)this.MARKER, (int)0, (boolean)false, (int)6, null)) >= 0) {
                String string5 = stdOut;
                int n = lastNewLine + this.MARKER.length() + 1;
                boolean bl3 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = stdOut;
            }
            String result2 = string;
            try {
                Gson gson = this.createGson(interpreter);
                Object object = gson.fromJson(result2, WebPackConfig.class);
                Intrinsics.checkNotNull((Object)object);
                WebPackConfig config2 = (WebPackConfig)object;
                return new WebPackStampedConfig(config2, timestamp, 7, configPath);
            }
            catch (RuntimeException e) {
                LOG.debug(e.getMessage() + "\nstdout: " + run.getStdout() + "\nstderr: " + run.getStderr(), (Throwable)e);
                String string8 = run.getStderr();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"run.stderr");
                this.errorNotify(project, configPath, string8);
                return new WebPackStampedConfig(new WebPackConfig(null, null, 3, null), timestamp, 7, configPath);
            }
        }
        if (run != null) {
            LOG.warn("Failed to evaluate webpack config. exit code: " + run.getExitCode() + (run.isTimeout() ? ", timed out" : "") + '\n' + "stdout: " + run.getStdout() + "\nstderr: " + run.getStderr());
            String string = run.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"run.stderr");
            this.errorNotify(project, configPath, string);
            return new WebPackStampedConfig(new WebPackConfig(null, null, 3, null), timestamp, 7, configPath);
        }
        return new WebPackStampedConfig(null, 0L, 7, configPath, 3, null);
    }

    private final Gson createGson(NodeJsInterpreter interpreter) {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)String.class), new JsonDeserializer<String>(interpreter){
            final /* synthetic */ NodeJsInterpreter $interpreter;

            public final String deserialize(JsonElement json, Type $noName_1, JsonDeserializationContext $noName_2) {
                String string = JsonUtil.getString((JsonElement)json);
                if (string == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JsonUtil.getString(json)\u2026urn@JsonDeserializer null");
                String path = string;
                return NodeInterpreterUtil.convertRemotePathToLocal(path, this.$interpreter);
            }
            {
                this.$interpreter = nodeJsInterpreter;
            }
        }).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().registerTy\u2026erpreter)\n    }).create()");
        return gson;
    }

    private final String extractErrorDetails(String stdErr) {
        for (String part : StringsKt.split$default((CharSequence)stdErr, (char[])new char[]{'\n', '\r'}, (boolean)false, (int)0, (int)6, null)) {
            int indexOfErrorMessage = StringsKt.indexOf$default((CharSequence)part, (String)"Error:", (int)0, (boolean)false, (int)6, null);
            if (indexOfErrorMessage < 0) continue;
            String string = part;
            int n = indexOfErrorMessage + "Error:".length();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return "";
    }

    private final void errorNotify(Project project, String configPath, String stdErr) {
        String errorDetails = this.extractErrorDetails(stdErr);
        String details = StringUtil.isEmpty((String)errorDetails) ? "" : '\n' + JavaScriptBundle.message((String)"dialog.title.error.details", (Object[])new Object[0]) + ": " + errorDetails;
        String message = JavaScriptBundle.message((String)"webpack.cannot.analyze", (Object[])new Object[]{"<a href=\"#\">" + PathUtil.getFileName((String)configPath) + "</a>"}) + details;
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.WARNING");
        WebPackNotifier.notify$default(WebPackNotifier.INSTANCE, project, message, messageType, configPath, null, 16, null);
    }

    public WebPackExecutor() {
        StringBuilder stringBuilder = new StringBuilder().append("!!!");
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        this.MARKER = stringBuilder.append(applicationNamesInfo.getFullProductName()).append(" webpack loader!!!").toString();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WebPackExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackExecutor$Companion;", "", "()V", "EXECUTION_TIMEOUT_KEY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "version", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

