/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.debugger.DebugPortConfigurator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebuggableRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class NpmRunProfileState
implements RunProfileState,
NodeLocalDebuggableRunProfileState {
    private static final String NODE_DEBUG_OPTION = "NODE_DEBUG_OPTION";
    private final NpmRunSettings myRunSettings;
    private final NodeJsInterpreter myNodeInterpreter;
    private final ExecutionEnvironment myEnvironment;

    public NpmRunProfileState(@NotNull NpmRunSettings runSettings, @NotNull ExecutionEnvironment environment) throws com.intellij.execution.ExecutionException {
        if (runSettings == null) {
            NpmRunProfileState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            NpmRunProfileState.$$$reportNull$$$0(1);
        }
        this.myNodeInterpreter = runSettings.getInterpreterRef().resolveNotNull(environment.getProject());
        this.myRunSettings = runSettings;
        this.myEnvironment = environment;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws com.intellij.execution.ExecutionException {
        if (runner == null) {
            NpmRunProfileState.$$$reportNull$$$0(2);
        }
        try {
            Promise<ExecutionResult> promise = this.execute(null);
            if (promise.getState() == Promise.State.PENDING) {
                Logger.getInstance(NpmRunProfileState.class).error("resolved promise must be returned");
            }
            return (ExecutionResult)promise.blockingGet(10);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public Promise<ExecutionResult> execute(@Nullable CommandLineDebugConfigurator configurator) {
        OSProcessHandler processHandler;
        GeneralCommandLine commandLine;
        try {
            commandLine = this.createCommandLine(configurator);
            processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
        }
        catch (Exception e) {
            Promise promise = Promises.rejectedPromise((Throwable)e);
            if (promise == null) {
                NpmRunProfileState.$$$reportNull$$$0(3);
            }
            return promise;
        }
        this.checkTasksForNodeDebugOption((ProcessHandler)processHandler);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ConsoleView console = this.createConsole((ProcessHandler)processHandler, commandLine.getWorkDirectory());
        console.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(console, (ProcessHandler)processHandler);
        Promise promise = Promises.resolvedPromise((Object)new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler));
        if (promise == null) {
            NpmRunProfileState.$$$reportNull$$$0(4);
        }
        return promise;
    }

    private void checkTasksForNodeDebugOption(@NotNull ProcessHandler processHandler) {
        VirtualFile packageJson;
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(5);
        }
        if ((packageJson = LocalFileSystem.getInstance().findFileByPath(this.myRunSettings.getPackageJsonSystemIndependentPath())) == null) {
            return;
        }
        ArrayList<String> hasNodeDebugOption = new ArrayList<String>();
        ArrayList<String> noNodeDebugOption = new ArrayList<String>();
        for (String scriptName : this.myRunSettings.getScriptNames()) {
            if (NpmRunProfileState.hasNodeDebugOption(scriptName, packageJson, this.myEnvironment.getProject())) {
                hasNodeDebugOption.add(scriptName);
                continue;
            }
            noNodeDebugOption.add(scriptName);
        }
        this.myNodeInterpreter.provideCachedVersionOrFetch().onSuccess(version -> {
            String variableRefName = SystemInfo.isWindows ? "%NODE_DEBUG_OPTION%" : "$NODE_DEBUG_OPTION";
            SmartList messages = new SmartList();
            if (NodeInterpreterUtil.supportsNodeOptions(this.myNodeInterpreter, version) && !hasNodeDebugOption.isEmpty()) {
                messages.add(variableRefName + " is no longer required for debugging npm scripts.");
            }
            if (!NodeInterpreterUtil.supportsNodeOptions(this.myNodeInterpreter, version) && !noNodeDebugOption.isEmpty()) {
                for (String task : noNodeDebugOption) {
                    messages.add("To debug the \"" + task + "\" script, make sure the " + variableRefName + " string is specified as the first argument for the node command you'd like to debug.\nFor example:\n  \"scripts\": {\n    \"start\": \"node " + variableRefName + " server.js\"\n  }");
                }
            }
            if (!messages.isEmpty()) {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter((List)messages, processHandler){
                    final /* synthetic */ List val$messages;
                    final /* synthetic */ ProcessHandler val$processHandler;
                    {
                        this.val$messages = list2;
                        this.val$processHandler = processHandler;
                    }

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (String message : this.val$messages) {
                            this.val$processHandler.notifyTextAvailable("\n" + message + "\n", ProcessOutputTypes.SYSTEM);
                        }
                        this.val$processHandler.removeProcessListener((ProcessListener)this);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState$1", "startNotified"));
                    }
                });
            }
        });
    }

    static boolean hasNodeDebugOption(@NotNull NpmRunSettings runSettings, @NotNull Project project) {
        VirtualFile packageJson;
        if (runSettings == null) {
            NpmRunProfileState.$$$reportNull$$$0(6);
        }
        if (project == null) {
            NpmRunProfileState.$$$reportNull$$$0(7);
        }
        if ((packageJson = LocalFileSystem.getInstance().findFileByPath(runSettings.getPackageJsonSystemIndependentPath())) == null) {
            return false;
        }
        for (String scriptName : runSettings.getScriptNames()) {
            if (!NpmRunProfileState.hasNodeDebugOption(scriptName, packageJson, project)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNodeDebugOption(@NotNull String scriptName, @NotNull VirtualFile packageJson, @NotNull Project project) {
        JsonProperty property;
        if (scriptName == null) {
            NpmRunProfileState.$$$reportNull$$$0(8);
        }
        if (packageJson == null) {
            NpmRunProfileState.$$$reportNull$$$0(9);
        }
        if (project == null) {
            NpmRunProfileState.$$$reportNull$$$0(10);
        }
        if ((property = NpmScriptsUtil.findScriptProperty(project, packageJson, scriptName)) != null) {
            JsonValue value = property.getValue();
            String text = value == null ? null : value.getText();
            return text != null && text.contains(NODE_DEBUG_OPTION);
        }
        return false;
    }

    @NotNull
    private ConsoleView createConsole(@NotNull ProcessHandler processHandler, @Nullable File cwd) {
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(11);
        }
        ConsoleView console = NodeCommandLineUtil.createConsole(processHandler, this.myEnvironment.getProject(), false);
        console.addMessageFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), cwd));
        console.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), cwd));
        console.addMessageFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = console;
        if (consoleView == null) {
            NpmRunProfileState.$$$reportNull$$$0(12);
        }
        return consoleView;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@Nullable CommandLineDebugConfigurator configurator) throws com.intellij.execution.ExecutionException {
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine(true);
        if (configurator != null) {
            configurator.beforeBaseConfiguring(commandLine);
        }
        if (configurator instanceof DebugPortConfigurator) {
            commandLine.getEnvironment().put(NODE_DEBUG_OPTION, StringUtil.join((Collection)commandLine.getParametersList().getList(), (String)" "));
            commandLine.getParametersList().clearAll();
        } else if (configurator != null && SystemInfo.isWindows) {
            commandLine.getEnvironment().putIfAbsent(NODE_DEBUG_OPTION, " ");
        }
        NpmRunProfileState.configureCommandLine(commandLine, this.myNodeInterpreter, this.myRunSettings.getNodeOptions(), this.myRunSettings.getPackageManagerPackageRef(), this.myRunSettings.getPackageJsonSystemDependentPath(), this.getExecutionCommand(), this.myRunSettings.getScriptNames(), this.myRunSettings.getArguments(), this.myRunSettings.getEnvData(), this.myEnvironment.getProject());
        if (configurator != null) {
            configurator.afterBaseConfiguring(commandLine);
        }
        NodeCommandLineConfigurator.find(this.myNodeInterpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NpmRunProfileState.$$$reportNull$$$0(13);
        }
        return generalCommandLine;
    }

    public static void configureCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter nodeInterpreter, @NotNull String nodeOptions, @NotNull NodePackageRef npmPackageRef, @NotNull String packageJsonPath, @NotNull NpmCommand command, @NotNull List<String> scriptNames, @NotNull String scriptArguments, @NotNull EnvironmentVariablesData envData, @NotNull Project project) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NpmRunProfileState.$$$reportNull$$$0(14);
        }
        if (nodeInterpreter == null) {
            NpmRunProfileState.$$$reportNull$$$0(15);
        }
        if (nodeOptions == null) {
            NpmRunProfileState.$$$reportNull$$$0(16);
        }
        if (npmPackageRef == null) {
            NpmRunProfileState.$$$reportNull$$$0(17);
        }
        if (packageJsonPath == null) {
            NpmRunProfileState.$$$reportNull$$$0(18);
        }
        if (command == null) {
            NpmRunProfileState.$$$reportNull$$$0(19);
        }
        if (scriptNames == null) {
            NpmRunProfileState.$$$reportNull$$$0(20);
        }
        if (scriptArguments == null) {
            NpmRunProfileState.$$$reportNull$$$0(21);
        }
        if (envData == null) {
            NpmRunProfileState.$$$reportNull$$$0(22);
        }
        if (project == null) {
            NpmRunProfileState.$$$reportNull$$$0(23);
        }
        commandLine.withCharset(StandardCharsets.UTF_8);
        File workingDirectory = new File(packageJsonPath).getParentFile();
        commandLine.withWorkDirectory(workingDirectory.getAbsolutePath());
        envData.configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.addParameters(ParametersListUtil.parse((String)nodeOptions.trim()));
        NodePackage pkg = NpmUtil.resolveRef(npmPackageRef, project, nodeInterpreter);
        if (pkg == null) {
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message((String)"npm.dialog.message.cannot.resolve.package.manager", (Object[])new Object[]{npmPackageRef.getIdentifier()}));
        }
        commandLine.addParameter(NpmUtil.getValidNpmCliJsFilePath(pkg));
        boolean yarn = NpmUtil.isYarnAlikePackage(pkg);
        if (command == NpmCommand.PUBLISH && yarn) {
            commandLine.addParameters(new String[]{"npm", "publish"});
        } else {
            commandLine.addParameter(command.getCliOption(yarn));
        }
        if (command == NpmCommand.RUN_SCRIPT) {
            commandLine.addParameters(scriptNames);
        }
        if ((command == NpmCommand.RUN_SCRIPT || command == NpmCommand.TEST || command == NpmCommand.INSTALL || command == NpmCommand.UPDATE) && pkg.getName().equals("npm")) {
            commandLine.addParameter("--scripts-prepend-node-path=auto");
        }
        commandLine.addParameters(ProgramParametersConfigurator.expandMacrosAndParseParameters((String)scriptArguments));
    }

    @NotNull
    private NpmCommand getExecutionCommand() {
        List<String> scripts;
        if (this.myRunSettings.getCommand() == NpmCommand.RUN_SCRIPT && (scripts = this.myRunSettings.getScriptNames()).size() == 1 && "test".equals(ContainerUtil.getFirstItem(scripts))) {
            NpmCommand npmCommand = NpmCommand.TEST;
            if (npmCommand == null) {
                NpmRunProfileState.$$$reportNull$$$0(24);
            }
            return npmCommand;
        }
        NpmCommand npmCommand = this.myRunSettings.getCommand();
        if (npmCommand == null) {
            NpmRunProfileState.$$$reportNull$$$0(25);
        }
        return npmCommand;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        List arguments;
        if (consoleView == null) {
            NpmRunProfileState.$$$reportNull$$$0(26);
        }
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(27);
        }
        NodePackageRef npmRef = NpmUtil.DESCRIPTOR.dereferenceIfProjectRef(this.myEnvironment.getProject(), this.myRunSettings.getPackageManagerPackageRef());
        boolean yarn = NpmUtil.isYarnAlikePackageRef(npmRef);
        ConsoleCommandLineFolder folder = new ConsoleCommandLineFolder(NpmManager.getNpmPackagePresentableName(npmRef));
        NpmCommand command = this.getExecutionCommand();
        folder.addPlaceholderText(command.getCliOption(yarn));
        if (command == NpmCommand.RUN_SCRIPT) {
            folder.addPlaceholderTexts(this.myRunSettings.getScriptNames());
        }
        if (!(arguments = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)this.myRunSettings.getArguments().trim())).isEmpty()) {
            folder.addPlaceholderText(ParametersListUtil.join((List)arguments));
        }
        folder.foldCommandLine(consoleView, processHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState";
                break;
            }
            case 5: 
            case 11: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeInterpreter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackageRef";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptNames";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptArguments";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkTasksForNodeDebugOption";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasNodeDebugOption";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

