/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageJsonUtil {
    public static final String FILE_NAME = "package.json";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "devDependencies";
    private static final String TEMPLATE_NAME = "package.json";
    private static final List<String> DEPENDENCIES_KEY = ContainerUtil.newArrayList((Object[])new String[]{"dependencies", "devDependencies", "optionalDependencies", "peerDependencies", "bundledDependencies", "bundleDependencies"});

    private PackageJsonUtil() {
    }

    public static boolean isInsidePackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(0);
        }
        return PackageJsonUtil.getContainingPackageJsonFile(element) != null;
    }

    @Nullable
    public static JsonFile getContainingPackageJsonFile(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(1);
        }
        return PackageJsonUtil.isPackageJsonFile(file2 = element.getContainingFile()) ? (JsonFile)file2 : null;
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable PsiFile file2) {
        return file2 instanceof JsonFile && "package.json".equals(file2.getName());
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable VirtualFile file2) {
        return file2 != null && !file2.isDirectory() && StringUtil.equals((CharSequence)"package.json", (CharSequence)file2.getNameSequence());
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFileName(@Nullable CharSequence fileName) {
        return StringUtil.equals((CharSequence)"package.json", (CharSequence)fileName);
    }

    public static boolean isTopLevelProperty(@NotNull JsonProperty property) {
        PsiElement parent;
        if (property == null) {
            PackageJsonUtil.$$$reportNull$$$0(2);
        }
        return (parent = property.getParent()) != null && parent.getParent() instanceof JsonFile;
    }

    @Nullable
    public static JsonProperty findContainingProperty(@NotNull PsiElement element) {
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(3);
        }
        if (PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    public static JsonProperty findContainingTopLevelProperty(@Nullable PsiElement element) {
        if (element == null || !PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return null;
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        while (property != null && !PackageJsonUtil.isTopLevelProperty(property)) {
            property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class, (boolean)true);
        }
        return property;
    }

    public static boolean isPackageDependencyProperty(@NotNull JsonProperty property) {
        JsonObject obj;
        if (property == null) {
            PackageJsonUtil.$$$reportNull$$$0(4);
        }
        if ((obj = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            JsonProperty dependenciesProperty = (JsonProperty)ObjectUtils.tryCast((Object)obj.getParent(), JsonProperty.class);
            return dependenciesProperty != null && DEPENDENCIES_KEY.contains(dependenciesProperty.getName()) && PackageJsonUtil.isTopLevelProperty(dependenciesProperty);
        }
        return false;
    }

    public static boolean isPackageDependenciesProperty(@Nullable JsonProperty property) {
        return property != null && DEPENDENCIES_KEY.contains(property.getName());
    }

    public static void processUpPackageJsonFiles(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> processor) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(5);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(7);
        }
        JSProjectUtil.processDirectoriesUpToContentRoot(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)directory -> {
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(directory);
            return packageJson == null || processor.process((Object)packageJson);
        }));
    }

    @Nullable
    public static <T> T processUpPackageJsonFilesAndFindFirst(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Function<? super VirtualFile, T> packageJsonProcessor) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(8);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(9);
        }
        if (packageJsonProcessor == null) {
            PackageJsonUtil.$$$reportNull$$$0(10);
        }
        Ref result2 = Ref.create();
        PackageJsonUtil.processUpPackageJsonFiles(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)packageJson -> {
            result2.set(packageJsonProcessor.fun(packageJson));
            return result2.isNull();
        }));
        return (T)result2.get();
    }

    @Nullable
    public static VirtualFile findUpPackageJson(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(11);
        }
        Ref ref = Ref.create();
        PackageJsonUtil.processUpPackageJsonFilesInAllScope(fileOrDir, (Processor<? super VirtualFile>)((Processor)file2 -> {
            ref.set(file2);
            return false;
        }));
        return (VirtualFile)ref.get();
    }

    public static void processUpPackageJsonFilesInAllScope(@NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> processor) {
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(13);
        }
        ReadAction.run(() -> {
            VirtualFile dir;
            VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
            if (dir == null) {
                return;
            }
            while (dir != null) {
                VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
                if (packageJson != null && !processor.process((Object)packageJson)) {
                    return;
                }
                dir = dir.getParent();
            }
        });
    }

    @NotNull
    public static List<JsonProperty> listAllPackageProperties(@NotNull JsonFile file2) {
        if (file2 == null) {
            PackageJsonUtil.$$$reportNull$$$0(14);
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)file2.getTopLevelValue(), JsonObject.class);
        ArrayList<JsonProperty> result2 = new ArrayList<JsonProperty>();
        if (obj != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonObject depObj;
                if (!DEPENDENCIES_KEY.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) continue;
                result2.addAll(depObj.getPropertyList());
            }
        }
        ArrayList<JsonProperty> arrayList = result2;
        if (arrayList == null) {
            PackageJsonUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    public static JsonProperty findDependencyByName(@NotNull JsonFile packageJson, @NotNull String dependencyName) {
        JsonObject obj;
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(16);
        }
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(17);
        }
        if ((obj = (JsonObject)ObjectUtils.tryCast((Object)packageJson.getTopLevelValue(), JsonObject.class)) != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonObject depObj;
                if (!DEPENDENCIES_KEY.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) continue;
                return depObj.findProperty(dependencyName);
            }
        }
        return null;
    }

    public static boolean isPackageJsonWithTopLevelProperty(@NotNull VirtualFile packageJson, String property) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(18);
        }
        return PackageJsonUtil.isPackageJsonFile(packageJson) && PackageJsonData.getOrCreate(packageJson).getTopLevelProperties().contains(property);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(19);
        }
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
        if (packageJsonData == null) {
            PackageJsonUtil.$$$reportNull$$$0(20);
        }
        return packageJsonData;
    }

    @Nullable
    public static PsiFile createPackageJson(final @NotNull PsiDirectory psiDir, final boolean openFile) {
        if (psiDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(21);
        }
        ElementCreator elementCreator = new ElementCreator(psiDir.getProject(), CommonBundle.getErrorTitle()){

            protected PsiElement[] create(@NotNull String newName) {
                PsiElement[] psiElementArray;
                PsiFile file2;
                if (newName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((file2 = PackageJsonUtil.doCreatePackageJson(psiDir, openFile)) != null) {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = file2;
                } else {
                    psiElementArray = PsiElement.EMPTY_ARRAY;
                }
                return psiElementArray;
            }

            @NlsContexts.Command
            protected String getActionName(String newName) {
                return JavaScriptBundle.message((String)"action.PackageJsonNewFile.text", (Object[])new Object[]{"package.json"});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$1", "create"));
            }
        };
        Object[] elements = elementCreator.tryCreate("package.json");
        return (PsiFile)ArrayUtil.getFirstElement((Object[])elements);
    }

    @Nullable
    private static PsiFile doCreatePackageJson(@NotNull PsiDirectory psiDir, boolean openFile) {
        if (psiDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(22);
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)psiDir.getProject()).getInternalTemplate("package.json");
        Map defaultValues = ContainerUtil.newHashMap((Pair)Pair.create((Object)"name", (Object)psiDir.getName()), (Pair[])new Pair[]{Pair.create((Object)"version", (Object)"1.0.0")});
        if (!openFile) {
            String text = template.getText();
            for (Map.Entry entry : defaultValues.entrySet()) {
                text = text.replace("#[[$" + (String)entry.getKey() + "$]]#", (CharSequence)entry.getValue());
            }
            template = template.clone();
            template.setText(text.replace("#[[$END$]]#", ""));
        }
        return CreateFileFromTemplateAction.createFileFromTemplate((String)"package.json", (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)openFile, (Map)defaultValues);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static PackageJsonData getTopLevelPackageJsonData(@NotNull Project project) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(23);
        }
        if (project.isDefault() || project.getBaseDir() == null || project.isDisposed()) {
            return null;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(project.getBaseDir());
        return packageJson == null ? null : PackageJsonData.getOrCreate(packageJson);
    }

    public static ThreeState isVersionGreaterOrEqualMajor(@NotNull String versionText, int major) {
        if (versionText == null) {
            PackageJsonUtil.$$$reportNull$$$0(24);
        }
        if ("latest".equals(versionText)) {
            return ThreeState.YES;
        }
        String[] parts = versionText.split("\\s-\\s");
        if (parts.length == 2) {
            String part = parts[1];
            if (PackageJsonUtil.isAny((part = StringUtil.trimStart((String)part, (String)"v")).charAt(0))) {
                return ThreeState.YES;
            }
            int parsedMajor = PackageJsonUtil.getMajorVersion(part);
            if (parsedMajor >= 0) {
                return parsedMajor >= major ? ThreeState.YES : ThreeState.NO;
            }
            return ThreeState.UNSURE;
        }
        ArrayList<Pair> versionWords = new ArrayList<Pair>();
        StringBuilder sb = new StringBuilder();
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < versionText.length(); ++i) {
            char ch = versionText.charAt(i);
            if (Character.isDigit(ch) || '.' == ch || '*' == ch || 'v' == ch || 'x' == ch || 'X' == ch) {
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) {
                versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
                sb.setLength(0);
                prefixBuilder.setLength(0);
            }
            prefixBuilder.append(ch);
        }
        if (sb.length() > 0) {
            versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
        }
        if (versionWords.isEmpty()) {
            return ThreeState.UNSURE;
        }
        boolean greaterThanLess = false;
        boolean lessThanGreater = false;
        for (Pair pair : versionWords) {
            int parsedMajor;
            String word = (String)pair.getSecond();
            word = StringUtil.trimStart((String)word, (String)"v");
            String prefix = (String)pair.getFirst();
            if (!PackageJsonUtil.isPrefixValid(prefix)) {
                return ThreeState.UNSURE;
            }
            if (word.isEmpty()) continue;
            if (PackageJsonUtil.isAny(word.charAt(0))) {
                lessThanGreater = true;
            }
            if ((parsedMajor = PackageJsonUtil.getMajorVersion(word)) < 0) continue;
            if (parsedMajor >= major) {
                char before;
                if (parsedMajor == major && (before = PackageJsonUtil.getVersionComparator(prefix)) == '<') {
                    return ThreeState.NO;
                }
                lessThanGreater = true;
                continue;
            }
            if (PackageJsonUtil.getVersionComparator(prefix) != '>') continue;
            greaterThanLess = true;
        }
        if (greaterThanLess || lessThanGreater) {
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    private static int getMajorVersion(@NotNull String version) {
        int idx;
        if (version == null) {
            PackageJsonUtil.$$$reportNull$$$0(25);
        }
        if ((idx = version.indexOf(".")) < 0) {
            return StringUtil.parseInt((String)version, (int)-1);
        }
        return StringUtil.parseInt((String)version.substring(0, idx), (int)-1);
    }

    private static boolean isPrefixValid(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(26);
        }
        if (prefix.isEmpty()) {
            return true;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch) || ch == '<' || ch == '>' || ch == '=' || ch == '~' || ch == '^' || ch == '|') continue;
            return false;
        }
        return true;
    }

    private static boolean isAny(char first) {
        return first == '*' || first == 'x' || first == 'X';
    }

    private static char getVersionComparator(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(27);
        }
        for (int i = prefix.length() - 1; i >= 0; --i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '=' && i > 0) {
                return prefix.charAt(i - 1);
            }
            return ch;
        }
        return ' ';
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findChildPackageJsonFile(@Nullable VirtualFile dir) {
        VirtualFile packageJson;
        if (dir != null && dir.isValid() && (packageJson = dir.findChild("package.json")) != null && packageJson.isValid() && !packageJson.isDirectory()) {
            return packageJson;
        }
        return null;
    }

    @NotNull
    public static String guessDefaultBinaryNameOfDependency(@NotNull NodePackage pkg) {
        if (pkg == null) {
            PackageJsonUtil.$$$reportNull$$$0(28);
        }
        VirtualFile packageJson = LocalFileSystem.getInstance().findFileByIoFile(new File(pkg.getSystemDependentPath(), "package.json"));
        return PackageJsonUtil.guessDefaultBinaryNameOfDependency(packageJson, pkg.getName());
    }

    @NotNull
    public static String guessDefaultBinaryNameOfDependency(@Nullable VirtualFile dependencyPackageJson, @NotNull String dependencyName) {
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(29);
        }
        List<String> declaredBinaryNames = PackageJsonUtil.getDeclaredBinaryNames(dependencyPackageJson);
        List<String> candidateBinaryNames = PackageJsonUtil.getCandidateBinaryNames(dependencyName);
        for (String candidateBinaryName : candidateBinaryNames) {
            if (!declaredBinaryNames.contains(candidateBinaryName)) continue;
            String string = candidateBinaryName;
            if (string == null) {
                PackageJsonUtil.$$$reportNull$$$0(30);
            }
            return string;
        }
        if (declaredBinaryNames.size() == 1) {
            String string = Objects.requireNonNull((String)ContainerUtil.getFirstItem(declaredBinaryNames));
            if (string == null) {
                PackageJsonUtil.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = Objects.requireNonNull((String)ContainerUtil.getFirstItem(candidateBinaryNames));
        if (string == null) {
            PackageJsonUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static List<String> getDeclaredBinaryNames(@Nullable VirtualFile packageJson) {
        if (packageJson == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PackageJsonUtil.$$$reportNull$$$0(33);
            }
            return list2;
        }
        PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
        List list3 = ContainerUtil.filter(data.getBinaryNameToPathMap().keySet(), Objects::nonNull);
        if (list3 == null) {
            PackageJsonUtil.$$$reportNull$$$0(34);
        }
        return list3;
    }

    @NotNull
    private static List<String> getCandidateBinaryNames(@NotNull String dependencyName) {
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(35);
        }
        if (!NodeModuleSearchUtil.isScopedPackageName(dependencyName)) {
            List<String> list2 = Collections.singletonList(dependencyName);
            if (list2 == null) {
                PackageJsonUtil.$$$reportNull$$$0(36);
            }
            return list2;
        }
        String scope = Objects.requireNonNull(NodeModuleSearchUtil.getScopeByScopedPackageName(dependencyName));
        String name = Objects.requireNonNull(NodeModuleSearchUtil.getNameByScopedPackageName(dependencyName));
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{name, scope + "-" + name});
        if (arrayList == null) {
            PackageJsonUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 20: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 20: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 20: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 17: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionText";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllPackageProperties";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateData";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDefaultBinaryNameOfDependency";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBinaryNames";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateBinaryNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePackageJsonFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPackageJsonFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDependencyProperty";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFilesAndFindFirst";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findUpPackageJson";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFilesInAllScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "listAllPackageProperties";
                break;
            }
            case 15: 
            case 20: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyByName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPackageJsonWithTopLevelProperty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createPackageJson";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doCreatePackageJson";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelPackageJsonData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isVersionGreaterOrEqualMajor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMajorVersion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixValid";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getVersionComparator";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "guessDefaultBinaryNameOfDependency";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateBinaryNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 20: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

