/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.activity.RunAnythingAnActionProvider;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskRunAction;
import com.intellij.lang.javascript.buildTools.npm.NpmCommandRunAnythingProvider;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptRunAnythingProvider;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonBuildFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NpmRunAnythingProvider
extends RunAnythingAnActionProvider<NpmAction> {
    public static final String HELP_GROUP_TITLE = "Node.js";
    private final NpmScriptRunAnythingProvider myScriptsProvider;
    private final NpmCommandRunAnythingProvider myCommandProvider;
    @Nls
    private final String myPackageManagerName;

    private NpmRunAnythingProvider(@NotNull @Nls String packageManagerName) {
        if (packageManagerName == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(0);
        }
        this.myPackageManagerName = packageManagerName;
        this.myScriptsProvider = new NpmScriptRunAnythingProvider(packageManagerName);
        this.myCommandProvider = new NpmCommandRunAnythingProvider(packageManagerName);
    }

    public static boolean hasPackageNamePrefix(@NotNull String pattern, @NotNull String packageName) {
        if (pattern == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(1);
        }
        if (packageName == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(2);
        }
        return pattern.startsWith(packageName) && (pattern.length() == packageName.length() || pattern.charAt(packageName.length()) == ' ');
    }

    @Nullable
    public NpmAction findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        JsbtTaskRunAction value;
        if (dataContext == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(4);
        }
        if ((value = (JsbtTaskRunAction)((Object)this.myScriptsProvider.findMatchingValue(dataContext, pattern))) != null) {
            return new NpmAction(value);
        }
        NpmCommandRunAnythingProvider.NpmCommandAction value1 = (NpmCommandRunAnythingProvider.NpmCommandAction)((Object)this.myCommandProvider.findMatchingValue(dataContext, pattern));
        return value1 != null ? new NpmAction(value1) : null;
    }

    @NotNull
    public Collection<NpmAction> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(6);
        }
        ArrayList<NpmAction> result2 = new ArrayList<NpmAction>();
        for (JsbtTaskRunAction action : this.myScriptsProvider.getValues(dataContext, pattern)) {
            result2.add(new NpmAction(action));
        }
        for (NpmCommandRunAnythingProvider.NpmCommandAction commandAction : this.myCommandProvider.getValues(dataContext, pattern)) {
            result2.add(new NpmAction(commandAction));
        }
        ArrayList<NpmAction> arrayList = result2;
        if (arrayList == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    protected static VirtualFile getPackageJson(@NotNull Project project, @NotNull DataContext dataContext) {
        RunAnythingContext context;
        if (project == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(8);
        }
        if (dataContext == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(9);
        }
        if ((context = (RunAnythingContext)dataContext.getData(EXECUTING_CONTEXT)) instanceof RunAnythingContext.RecentDirectoryContext) {
            String path = ((RunAnythingContext.RecentDirectoryContext)context).getPath();
            return PackageJsonUtil.findChildPackageJsonFile(LocalFileSystem.getInstance().findFileByPath(path));
        }
        List<VirtualFile> packageJsonFiles = PackageJsonBuildFileManager.getInstance(project).getPackageJsonSortedByImportanceDesc();
        return (VirtualFile)ContainerUtil.getFirstItem(packageJsonFiles);
    }

    @NotNull
    public String getCommand(@NotNull NpmAction value) {
        if (value == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(10);
        }
        String string = value.isNpmScriptAction() ? this.myScriptsProvider.getCommand(value.getJsbtAction()) : this.myCommandProvider.getCommand(value.getCommandAction());
        if (string == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public String getCompletionGroupTitle() {
        return this.myPackageManagerName;
    }

    @Nullable
    public String getHelpGroupTitle() {
        return HELP_GROUP_TITLE;
    }

    @Nullable
    public Icon getHelpIcon() {
        return NpmRunAnythingProvider.getIcon(NpmRunAnythingProvider.isYarn(this.myPackageManagerName));
    }

    static Icon getIcon(boolean yarn) {
        return yarn ? JavaScriptLanguageIcons.Nodejs.Yarn : JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
    }

    @Nullable
    public String getHelpCommandPlaceholder() {
        return this.myPackageManagerName + " <command>";
    }

    @Nullable
    public String getHelpCommand() {
        return this.myPackageManagerName;
    }

    @NotNull
    public static NodePackageRef getPackageRef(@NotNull Project project, @NotNull String packageName) {
        if (project == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(12);
        }
        if (packageName == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(13);
        }
        NodePackageRef packageRef = NpmManager.getInstance(project).getPackageRef();
        if (NpmRunAnythingProvider.isYarn(packageName) == NpmUtil.isYarnAlikePackageRef(packageRef)) {
            NodePackageRef nodePackageRef = NpmUtil.createProjectPackageManagerPackageRef();
            if (nodePackageRef == null) {
                NpmRunAnythingProvider.$$$reportNull$$$0(14);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = NodePackageRef.create(packageName);
        if (nodePackageRef == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(15);
        }
        return nodePackageRef;
    }

    static boolean isYarn(@NotNull String packageManagerName) {
        if (packageManagerName == null) {
            NpmRunAnythingProvider.$$$reportNull$$$0(16);
        }
        return "yarn".equals(packageManagerName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerName";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmRunAnythingProvider";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmRunAnythingProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasPackageNamePrefix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJson";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPackageRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isYarn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Yarn
    extends NpmRunAnythingProvider {
        Yarn() {
            super("yarn");
        }
    }

    static final class Npm
    extends NpmRunAnythingProvider {
        Npm() {
            super("npm");
        }
    }

    class NpmAction
    extends DumbAwareAction {
        private final JsbtTaskRunAction myJsbtAction;
        private final NpmCommandRunAnythingProvider.NpmCommandAction myCommandAction;

        NpmAction(JsbtTaskRunAction jsbtAction) {
            if (jsbtAction == null) {
                NpmAction.$$$reportNull$$$0(0);
            }
            super(jsbtAction.getTemplateText(), jsbtAction.getTemplatePresentation().getDescription(), jsbtAction.getTemplatePresentation().getIcon());
            this.myJsbtAction = jsbtAction;
            this.myCommandAction = null;
        }

        NpmAction(NpmCommandRunAnythingProvider.NpmCommandAction commandAction) {
            if (commandAction == null) {
                NpmAction.$$$reportNull$$$0(1);
            }
            super(commandAction.getTemplateText(), commandAction.getTemplatePresentation().getDescription(), commandAction.getTemplatePresentation().getIcon());
            this.myJsbtAction = null;
            this.myCommandAction = commandAction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NpmAction.$$$reportNull$$$0(2);
            }
            if (this.myJsbtAction != null) {
                Project project = e.getProject();
                NodePackageRef packageRef = project != null ? NpmRunAnythingProvider.getPackageRef(project, NpmRunAnythingProvider.this.myPackageManagerName) : NodePackageRef.create(NpmRunAnythingProvider.this.myPackageManagerName);
                NpmScriptsService.NpmScriptsApplicationService.getInstance().runWithPreferredNpmPackage(packageRef, () -> this.myJsbtAction.actionPerformed(e));
            } else {
                this.myCommandAction.actionPerformed(e);
            }
        }

        public boolean isNpmScriptAction() {
            return this.myJsbtAction != null;
        }

        @NotNull
        JsbtTaskRunAction getJsbtAction() {
            JsbtTaskRunAction jsbtTaskRunAction = this.myJsbtAction;
            if (jsbtTaskRunAction == null) {
                NpmAction.$$$reportNull$$$0(3);
            }
            return jsbtTaskRunAction;
        }

        @NotNull
        NpmCommandRunAnythingProvider.NpmCommandAction getCommandAction() {
            NpmCommandRunAnythingProvider.NpmCommandAction npmCommandAction = this.myCommandAction;
            if (npmCommandAction == null) {
                NpmAction.$$$reportNull$$$0(4);
            }
            return npmCommandAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsbtAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmRunAnythingProvider$NpmAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmRunAnythingProvider$NpmAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJsbtAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

