/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.ide.CopyPasteDelegator;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtTree
extends Tree
implements DataProvider {
    private final Project myProject;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private final JsbtTaskTreeView myView;

    public JsbtTree(@NotNull Project project, @NotNull TreeModel model, @NotNull JsbtTaskTreeView view) {
        if (project == null) {
            JsbtTree.$$$reportNull$$$0(0);
        }
        if (model == null) {
            JsbtTree.$$$reportNull$$$0(1);
        }
        if (view == null) {
            JsbtTree.$$$reportNull$$$0(2);
        }
        super(model);
        this.myProject = project;
        this.myCopyPasteDelegator = new CopyPasteDelegator(project, (JComponent)((Object)this));
        this.myView = view;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String result2;
        if (value instanceof DefaultMutableTreeNode && this.myView != null && (result2 = this.myView.getPresentableName((DefaultMutableTreeNode)value)) != null) {
            return result2;
        }
        return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    protected boolean shouldShowBusyIconIfNeeded() {
        return true;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            JsbtTree.$$$reportNull$$$0(3);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getSelectedBuildfiles();
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            Object[] files = this.getSelectedBuildfiles();
            return ContainerUtil.map((Object[])files, file2 -> PsiManager.getInstance((Project)this.myProject).findFile(file2), (Object[])PsiElement.EMPTY_ARRAY);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        return null;
    }

    private VirtualFile @NotNull [] getSelectedBuildfiles() {
        JsbtFileStructure structure;
        List<DefaultMutableTreeNode> nodes = JsbtTree.getSelectedNodes((JTree)((Object)this));
        if (nodes.size() == 1 && (structure = JsbtTree.getUserObject(nodes.get(0), JsbtFileStructure.class)) != null) {
            VirtualFile[] virtualFileArray = new VirtualFile[]{structure.getBuildfile()};
            if (virtualFileArray == null) {
                JsbtTree.$$$reportNull$$$0(4);
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            JsbtTree.$$$reportNull$$$0(5);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @NotNull
    public static List<DefaultMutableTreeNode> getSelectedNodes(@NotNull JTree tree) {
        if (tree == null) {
            JsbtTree.$$$reportNull$$$0(6);
        }
        if (tree.getSelectionCount() <= 1) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)JsbtTree.toNode(tree.getSelectionPath()));
            if (list2 == null) {
                JsbtTree.$$$reportNull$$$0(7);
            }
            return list2;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            List<DefaultMutableTreeNode> list3 = Collections.emptyList();
            if (list3 == null) {
                JsbtTree.$$$reportNull$$$0(8);
            }
            return list3;
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(paths.length);
        for (TreePath path : paths) {
            DefaultMutableTreeNode treeNode = JsbtTree.toNode(path);
            if (treeNode == null) continue;
            nodes.add(treeNode);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = nodes;
        if (arrayList == null) {
            JsbtTree.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    public static <T> T getUserObject(@Nullable DefaultMutableTreeNode node, @NotNull Class<T> clazz) {
        if (clazz == null) {
            JsbtTree.$$$reportNull$$$0(10);
        }
        if (node == null) {
            return null;
        }
        return (T)ObjectUtils.tryCast((Object)node.getUserObject(), clazz);
    }

    @Nullable
    public static DefaultMutableTreeNode toNode(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        return (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTree";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedBuildfiles";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

