/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower.browsePackages;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.javascript.bower.BowerPackageBasicInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerPackageSearcher {
    private static final Logger LOG = Logger.getInstance(BowerPackageSearcher.class);
    private static final String FILE_NAME = "popular-bower-packages.json";
    static final String NAME_PROP = "name";
    static final String DESCRIPTION_PROP = "description";
    private static final BowerPackageSearcher INSTANCE = new BowerPackageSearcher();
    private volatile WeakReference<List<BowerPackageBasicInfo>> myInfosRef;

    @NotNull
    public static BowerPackageSearcher getInstance() {
        BowerPackageSearcher bowerPackageSearcher = INSTANCE;
        if (bowerPackageSearcher == null) {
            BowerPackageSearcher.$$$reportNull$$$0(0);
        }
        return bowerPackageSearcher;
    }

    public List<BowerPackageBasicInfo> findPopularPackagesByPrefix(@NotNull String packageNamePrefix, int limit, @NotNull Condition<? super BowerPackageBasicInfo> filter) {
        List<BowerPackageBasicInfo> infos;
        if (packageNamePrefix == null) {
            BowerPackageSearcher.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            BowerPackageSearcher.$$$reportNull$$$0(2);
        }
        if ((infos = (List<BowerPackageBasicInfo>)SoftReference.dereference(this.myInfosRef)) == null) {
            try {
                long startTime = System.nanoTime();
                infos = BowerPackageSearcher.loadPopularPackages();
                LOG.info("Popular bower package list (" + infos.size() + ") loaded in " + TimeoutUtil.getDurationMillis((long)startTime) + " ms");
            }
            catch (IOException e) {
                LOG.warn("Cannot parse popular bower package list from popular-bower-packages.json", (Throwable)e);
                infos = Collections.emptyList();
            }
            this.myInfosRef = new WeakReference<List<BowerPackageBasicInfo>>(infos);
        }
        ArrayList<BowerPackageBasicInfo> result2 = new ArrayList<BowerPackageBasicInfo>();
        for (BowerPackageBasicInfo info : infos) {
            if (!info.getName().startsWith(packageNamePrefix) || !filter.value((Object)info)) continue;
            result2.add(info);
            if (result2.size() < limit) continue;
            break;
        }
        return result2;
    }

    public void findPackagesByPrefix(@Nullable ProgressIndicator indicator, @NotNull String packageNamePrefix, int limit, @NotNull Condition<? super BowerPackageBasicInfo> filter, @NotNull Consumer<? super BowerPackageBasicInfo> consumer) throws IOException {
        List result2;
        if (packageNamePrefix == null) {
            BowerPackageSearcher.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            BowerPackageSearcher.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            BowerPackageSearcher.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                result2 = (List)ApplicationUtil.runWithCheckCanceled(() -> BowerPackageSearcher.doFindPackagesByPrefix(indicator, packageNamePrefix, limit), (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)indicator));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            result2 = BowerPackageSearcher.doFindPackagesByPrefix(indicator, packageNamePrefix, limit);
        }
        for (BowerPackageBasicInfo info : result2) {
            if (!filter.value((Object)info)) continue;
            consumer.consume((Object)info);
        }
    }

    @NotNull
    static List<BowerPackageBasicInfo> doFindPackagesByPrefix(@Nullable ProgressIndicator indicator, @NotNull String packageNamePrefix, int limit) throws IOException {
        List<BowerPackageBasicInfo> list2;
        if (packageNamePrefix == null) {
            BowerPackageSearcher.$$$reportNull$$$0(6);
        }
        String url = "https://libraries.io/api/bower-search?q=" + URLUtil.encodeURIComponent((String)packageNamePrefix) + "&per_page=" + limit;
        try {
            long startNano = System.nanoTime();
            String content = HttpRequests.request((String)url).readString(indicator);
            List<BowerPackageBasicInfo> infos = BowerPackageSearcher.parse(content);
            LOG.info("Found " + infos.size() + " packages matching '" + packageNamePrefix + "*' in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms (" + url + ")");
            list2 = infos;
        }
        catch (IOException e) {
            throw new IOException("Failed to fetch packages for '" + packageNamePrefix + "'", e);
        }
        if (list2 == null) {
            BowerPackageSearcher.$$$reportNull$$$0(7);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<BowerPackageBasicInfo> loadPopularPackages() throws IOException {
        InputStream stream = BowerPackageSearcher.class.getResourceAsStream(FILE_NAME);
        if (stream != null) {
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            List<BowerPackageBasicInfo> list2 = BowerPackageSearcher.parse(new String(FileUtil.adaptiveLoadText((Reader)reader)));
            List<BowerPackageBasicInfo> list3 = list2;
            if (list3 == null) {
                BowerPackageSearcher.$$$reportNull$$$0(8);
            }
            return list3;
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close stream", (Throwable)e);
                }
            }
        }
        throw new IOException("Cannot find popular-bower-packages.json");
    }

    @NotNull
    private static List<BowerPackageBasicInfo> parse(@NotNull String text) throws IOException {
        JsonReader reader;
        if (text == null) {
            BowerPackageSearcher.$$$reportNull$$$0(9);
        }
        if ((reader = new JsonReader((Reader)new StringReader(text))).peek() != JsonToken.BEGIN_ARRAY) {
            reader.skipValue();
            List<BowerPackageBasicInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                BowerPackageSearcher.$$$reportNull$$$0(10);
            }
            return list2;
        }
        reader.beginArray();
        ArrayList<BowerPackageBasicInfo> result2 = new ArrayList<BowerPackageBasicInfo>();
        while (reader.hasNext()) {
            BowerPackageBasicInfo info = BowerPackageSearcher.readPackage(reader);
            if (info == null) continue;
            result2.add(info);
        }
        reader.endArray();
        ArrayList<BowerPackageBasicInfo> arrayList = result2;
        if (arrayList == null) {
            BowerPackageSearcher.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static BowerPackageBasicInfo readPackage(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            BowerPackageSearcher.$$$reportNull$$$0(12);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        String name = null;
        String description = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if (NAME_PROP.equals(key)) {
                name = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if (DESCRIPTION_PROP.equals(key)) {
                description = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return name != null ? new BowerPackageBasicInfo(name, description) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNamePrefix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/browsePackages/BowerPackageSearcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindPackagesByPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPopularPackages";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPopularPackagesByPrefix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesByPrefix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFindPackagesByPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

