/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;

public final class JSLexerUtil {
    public static boolean canBeGenericArgumentList(FlexLexer lexer, boolean isFlow) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next == JSTokenTypes.GT || next == JSTokenTypes.COMMA || !isFlow && next == JSTokenTypes.EXTENDS_KEYWORD || isFlow && next == JSTokenTypes.COLON;
    }

    public static boolean shouldLexTag(boolean isFlow, FlexLexer lexer) throws IOException {
        IElementType next;
        block11: {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            if (next == JSTokenTypes.PLUS || next == JSTokenTypes.MINUS) {
                return false;
            }
            if (!JSKeywordSets.IDENTIFIER_NAMES.contains(next)) {
                return true;
            }
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            if (next == JSTokenTypes.EXTENDS_KEYWORD) {
                next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
                return next == JSTokenTypes.EQ;
            }
            if (next == JSTokenTypes.COLON) {
                next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
                if (next == JSTokenTypes.TYPEOF_KEYWORD || !JSKeywordSets.IDENTIFIER_NAMES.contains(next)) {
                    return false;
                }
                do {
                    if ((next = JSLexerUtil.skipCommentsAndWhitespaces(lexer)) == JSTokenTypes.MINUS) {
                        return true;
                    }
                    if (next == JSTokenTypes.DOT) continue;
                    if (next != JSTokenTypes.GT && !JSKeywordSets.IDENTIFIER_NAMES.contains(next)) {
                        return false;
                    }
                    break block11;
                } while (JSKeywordSets.IDENTIFIER_NAMES.contains(next = JSLexerUtil.skipCommentsAndWhitespaces(lexer)));
                return false;
            }
            if (next == JSTokenTypes.EQ || next == JSTokenTypes.COMMA) {
                return false;
            }
        }
        if (next == JSTokenTypes.GT) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            if (next != JSTokenTypes.LPAR) {
                return true;
            }
            return !JSLexerUtil.isParameterListAfterGenericParams(isFlow, lexer);
        }
        return true;
    }

    private static boolean isParameterListAfterGenericParams(boolean isFlow, FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        int balance = 1;
        if (next == JSTokenTypes.LBRACE || next == JSTokenTypes.LBRACKET) {
            if (!isFlow) {
                return false;
            }
            if (next == JSTokenTypes.LBRACKET) {
                return true;
            }
            return JSLexerUtil.isFlowGenericObjectDestructuringLambda(lexer);
        }
        boolean wasIdentifier = false;
        if (next == JSTokenTypes.IDENTIFIER) {
            wasIdentifier = true;
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            if (next == JSTokenTypes.QUEST) {
                next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            }
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA) {
            return wasIdentifier;
        }
        if (isFlow && next == JSTokenTypes.LPAR) {
            return true;
        }
        if (next != JSTokenTypes.RPAR && !isFlow) {
            return false;
        }
        boolean isLt = next == JSTokenTypes.LT;
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (!isFlow) {
            if (next != JSTokenTypes.LT) {
                return true;
            }
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            return !JSLexerUtil.startsWithDiv(next);
        }
        if (isLt && JSLexerUtil.startsWithDiv(next)) {
            return false;
        }
        if (next != JSTokenTypes.LT) {
            while (balance > 0 && next != null) {
                if (next == JSTokenTypes.LPAR) {
                    ++balance;
                }
                if (next == JSTokenTypes.RPAR) {
                    --balance;
                }
                isLt = next == JSTokenTypes.LT;
                next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
                if (!isLt || !JSLexerUtil.startsWithDiv(next)) continue;
                return false;
            }
        }
        if (next != JSTokenTypes.LT) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return JSLexerUtil.checkFlowToken(lexer, next);
    }

    private static boolean startsWithDiv(IElementType next) {
        return next == JSTokenTypes.REGEXP_LITERAL || next == JSTokenTypes.DIV;
    }

    private static boolean isFlowGenericObjectDestructuringLambda(FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        int balance = 1;
        while (next != null) {
            if (next == JSTokenTypes.LBRACE) {
                ++balance;
            }
            if (next == JSTokenTypes.RBRACE && --balance == 0) break;
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        }
        if (balance != 0) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.RPAR) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return JSTokenTypes.ARROWS.contains(next);
    }

    private static boolean checkFlowToken(FlexLexer lexer, IElementType next) throws IOException {
        if (next != JSTokenTypes.IDENTIFIER) {
            return next != JSTokenTypes.REGEXP_LITERAL;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next != JSTokenTypes.COMMA && next != JSTokenTypes.EXTENDS_KEYWORD && next != JSTokenTypes.GT;
    }

    private static IElementType skipCommentsAndWhitespaces(FlexLexer lexer) throws IOException {
        IElementType next = lexer.advance();
        while (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(next)) {
            next = lexer.advance();
        }
        return next;
    }
}

