/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.stubs.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ExportDefaultAssignmentImpl;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ExportDefaultAssignmentStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedMembersByKindIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSTypeHolderOwner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportDefaultAssignmentStubImpl
extends JSStubBase<ES6ExportDefaultAssignment>
implements ES6ExportDefaultAssignmentStub,
JSTypeHolderOwner {
    private static final BooleanStructureElement HAS_INITIALIZER_REFERENCE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement TYPE_STRICT_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_TYPE_FROM_JSDOC = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(HAS_INITIALIZER_REFERENCE_FLAG, HAS_TYPE_FLAG, TYPE_STRICT_FLAG, IS_TYPE_FROM_JSDOC);
    @Nullable
    private final String myInitializerReference;
    @Nullable
    private final JSStubElementTypeHolder myTypeHolder;

    public ES6ExportDefaultAssignmentStubImpl(ES6ExportDefaultAssignment psi, StubElement parent) {
        super(psi, parent, (IStubElementType)ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        String initializerReference = psi.getInitializerReference();
        this.writeFlag(HAS_INITIALIZER_REFERENCE_FLAG, initializerReference != null);
        this.myInitializerReference = initializerReference;
        JSType jsType = psi.getJSType();
        this.writeFlag(HAS_TYPE_FLAG, jsType != null);
        this.writeFlag(TYPE_STRICT_FLAG, jsType != null && jsType.isSourceStrict());
        this.writeFlag(IS_TYPE_FROM_JSDOC, JSStubIndexingUtils.isAstBasedTypeFromJSDoc(jsType));
        this.myTypeHolder = JSStubElementTypeHolder.fromJSType(jsType);
    }

    public ES6ExportDefaultAssignmentStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        this.myInitializerReference = this.readFlag(HAS_INITIALIZER_REFERENCE_FLAG) != false ? dataStream.readNameString() : null;
        this.myTypeHolder = this.readFlag(HAS_TYPE_FLAG) != false ? JSStubElementTypeHolder.fromDataStream(dataStream) : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_INITIALIZER_REFERENCE_FLAG).booleanValue()) {
            dataStream.writeName(this.myInitializerReference);
        }
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            JSStubElementTypeHolder.serialize(this.myTypeHolder, dataStream);
        }
    }

    public ES6ExportDefaultAssignment createPsi() {
        return new ES6ExportDefaultAssignmentImpl(this);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            ES6ExportDefaultAssignmentStubImpl.$$$reportNull$$$0(0);
        }
        return flagsStructure;
    }

    @Override
    public void index(IndexSink sink) {
        PsiFile containingFile;
        String name;
        String ownName;
        super.index(sink);
        ES6ExportDefaultAssignment psi = (ES6ExportDefaultAssignment)this.getPsi();
        String reference = this.getInitializerReference();
        JSElement element = psi.getStubSafeElement();
        String string = ownName = element instanceof JSQualifiedNamedElement ? element.getName() : null;
        if (ownName == null) {
            sink.occurrence(ES6ExportedMembersByKindIndex.KEY, (Object)"def");
        }
        PsiElement parent = psi.getContext();
        String exactFileName = null;
        if (!(!ES6PsiUtil.isExternalModule(parent) || parent instanceof TypeScriptModule || StringUtil.isEmpty((String)(name = (containingFile = parent.getContainingFile()).getName())) || name.endsWith(".d.ts") && reference != null || !StringUtil.isJavaIdentifier((String)(exactFileName = JSFileReference.getFileNameWithoutExtension(name, JSFileReference.IMPLICIT_EXTENSIONS))) || StringUtil.equalsIgnoreCase((CharSequence)exactFileName, (CharSequence)reference) || StringUtil.equalsIgnoreCase((CharSequence)exactFileName, (CharSequence)"index"))) {
            sink.occurrence(ES6DefaultAssignmentModuleIndex.KEY, (Object)exactFileName);
        }
        if (element instanceof JSCallExpression) {
            String name2;
            Map strings;
            JSElementIndexingData data = ((JSCallExpression)element).getIndexingData();
            Map map2 = strings = data != null ? data.getUserStrings() : null;
            if (strings != null && (name2 = (String)strings.get("alt.default.name")) != null && !name2.equals(exactFileName)) {
                sink.occurrence(ES6DefaultAssignmentModuleIndex.KEY, (Object)name2);
            }
        }
    }

    @Nullable
    public String getInitializerReference() {
        return this.myInitializerReference;
    }

    @Nullable
    public String getTypeString() {
        return this.myTypeHolder != null ? this.myTypeHolder.getTypeString() : null;
    }

    public boolean isTypeStrict() {
        return this.readFlag(TYPE_STRICT_FLAG);
    }

    @Override
    @Nullable
    public JSStubElementTypeHolder getJSTypeHolder() {
        return this.myTypeHolder;
    }

    public boolean isTypeFromJSDoc() {
        return this.readFlag(IS_TYPE_FROM_JSDOC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/stubs/impl/ES6ExportDefaultAssignmentStubImpl", "getFlagsStructure"));
    }
}

