/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFileReferenceCache {
    private static final Key<SoftReference<Map<String, CachedValue<Collection<PsiElement>>>>> KEY = Key.create((String)"module.ref.map.key");
    @NotNull
    private final ProjectRootManager myProjectRoot;
    @NotNull
    private final NotNullLazyValue<GlobalSearchScope> myIndexedFilesInProjectScope;

    public static JSFileReferenceCache getInstance(@NotNull Project project) {
        if (project == null) {
            JSFileReferenceCache.$$$reportNull$$$0(0);
        }
        return (JSFileReferenceCache)ServiceManager.getService((Project)project, JSFileReferenceCache.class);
    }

    public JSFileReferenceCache(@NotNull Project project) {
        if (project == null) {
            JSFileReferenceCache.$$$reportNull$$$0(1);
        }
        this.myProjectRoot = ProjectRootManager.getInstance((Project)project);
        this.myIndexedFilesInProjectScope = NotNullLazyValue.lazy(() -> new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project), (IndexableFileSet)new AdditionalIndexableFileSet(project)));
    }

    @NotNull
    Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement referenceOwner, boolean includeUnindexedFiles) {
        String referenceText;
        if (referenceOwner == null) {
            JSFileReferenceCache.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(referenceText = JSFileReferencesUtil.getReferenceModuleText(referenceOwner)))) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferenceCache.$$$reportNull$$$0(3);
            }
            return list2;
        }
        Collection<PsiElement> collection = this.resolveModuleReference(referenceOwner, referenceText, includeUnindexedFiles);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> resolveModuleReference(@Nullable PsiElement context, @NotNull String referenceText, boolean includeUnindexedFiles) {
        if (referenceText == null) {
            JSFileReferenceCache.$$$reportNull$$$0(5);
        }
        if (context == null || StringUtil.isEmpty((String)referenceText)) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferenceCache.$$$reportNull$$$0(6);
            }
            return list2;
        }
        PsiElement moduleContext = JSFileReferenceCache.getModuleContext(context);
        if (moduleContext == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JSFileReferenceCache.$$$reportNull$$$0(7);
            }
            return set;
        }
        Collection<PsiElement> directModules = this.resolveDirectModules(moduleContext, referenceText, includeUnindexedFiles);
        Collection<PsiElement> collection = JSFileReferencesUtil.mergeWithAugmentations(context, directModules);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> resolveDirectModules(@NotNull PsiElement moduleReference) {
        String referenceText;
        if (moduleReference == null) {
            JSFileReferenceCache.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)(referenceText = JSFileReferencesUtil.getReferenceModuleText(moduleReference)))) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferenceCache.$$$reportNull$$$0(10);
            }
            return list2;
        }
        PsiElement context = JSFileReferenceCache.getModuleContext(moduleReference);
        if (context == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JSFileReferenceCache.$$$reportNull$$$0(11);
            }
            return set;
        }
        return this.resolveDirectModules(context, referenceText, false);
    }

    @Nullable
    private static PsiElement getModuleContext(@NotNull PsiElement moduleReference) {
        PsiFile containingFile;
        if (moduleReference == null) {
            JSFileReferenceCache.$$$reportNull$$$0(12);
        }
        if ((containingFile = moduleReference.getContainingFile()) == null) {
            return null;
        }
        PsiFile file2 = containingFile.getOriginalFile();
        if (file2 instanceof JSFile) {
            return file2;
        }
        PsiElement module = ES6PsiUtil.findExternalModule(moduleReference);
        if (module != null) {
            return module instanceof PsiFile ? ((PsiFile)module).getOriginalFile() : module;
        }
        return file2;
    }

    @NotNull
    private Collection<PsiElement> resolveDirectModules(@NotNull PsiElement element, @NotNull String quotedRef, boolean includeUnindexedFiles) {
        List result2;
        if (element == null) {
            JSFileReferenceCache.$$$reportNull$$$0(13);
        }
        if (quotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(14);
        }
        String unquotedRef = JSStringUtil.unquoteStringLiteralValue(quotedRef);
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        Collection<Object> collection = file2 == null ? JSFileReferenceCache.resolveDirectModulesNoCache(element, unquotedRef) : (result2 = JSFileReferencesUtil.isLibraryElement(element) ? this.getLibraryCachedModules(element, unquotedRef) : JSFileReferenceCache.getCachedModules(element, unquotedRef));
        if (!includeUnindexedFiles) {
            result2 = ContainerUtil.filter(result2, it -> !this.isUnindexedJSFile(it.getContainingFile()));
        }
        List list2 = result2;
        if (list2 == null) {
            JSFileReferenceCache.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private static Collection<PsiElement> getCachedModules(@NotNull PsiElement context, @NotNull String ref) {
        ConcurrentMap map2;
        Collection<PsiElement> elements;
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(16);
        }
        if (ref == null) {
            JSFileReferenceCache.$$$reportNull$$$0(17);
        }
        if ((elements = (Collection<PsiElement>)(map2 = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)context, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}))).get(ref)) != null) {
            return elements;
        }
        elements = JSFileReferenceCache.resolveDirectModulesNoCache(context, ref);
        map2.putIfAbsent(ref, elements);
        return elements;
    }

    private Collection<PsiElement> getLibraryCachedModules(@NotNull PsiElement element, @NotNull String unquotedRef) {
        if (element == null) {
            JSFileReferenceCache.$$$reportNull$$$0(18);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(19);
        }
        Map<String, CachedValue<Collection<PsiElement>>> map2 = JSFileReferenceCache.getLibraryFilesMap(element);
        return (Collection)this.getLibraryCachedValue(element, unquotedRef, map2).getValue();
    }

    @NotNull
    private CachedValue<Collection<PsiElement>> getLibraryCachedValue(@NotNull PsiElement context, @NotNull String unquotedRef, @NotNull Map<String, CachedValue<Collection<PsiElement>>> map2) {
        CachedValue<Collection<PsiElement>> value;
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(20);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(21);
        }
        if (map2 == null) {
            JSFileReferenceCache.$$$reportNull$$$0(22);
        }
        if ((value = map2.get(unquotedRef)) != null) {
            CachedValue<Collection<PsiElement>> cachedValue = value;
            if (cachedValue == null) {
                JSFileReferenceCache.$$$reportNull$$$0(23);
            }
            return cachedValue;
        }
        value = this.createLibraryCachedValueForText(context, unquotedRef);
        CachedValue<Collection<PsiElement>> prev = map2.putIfAbsent(unquotedRef, value);
        if (prev != null) {
            value = prev;
        }
        CachedValue<Collection<PsiElement>> cachedValue = value;
        if (cachedValue == null) {
            JSFileReferenceCache.$$$reportNull$$$0(24);
        }
        return cachedValue;
    }

    @NotNull
    private CachedValue<Collection<PsiElement>> createLibraryCachedValueForText(@NotNull PsiElement context, @NotNull String unquotedRef) {
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(25);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(26);
        }
        Project project = context.getProject();
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Object[] dependencies;
            Collection<PsiElement> allResolveResults = JSFileReferenceCache.resolveDirectModulesNoCache(context, unquotedRef);
            ProjectFileIndex index = this.myProjectRoot.getFileIndex();
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)context);
            boolean allResolveResultsFromLibrary = allResolveResults.stream().allMatch(element -> {
                VirtualFile curr;
                if (element instanceof JSFile && (curr = PsiUtilCore.getVirtualFile((PsiElement)element)) != null) {
                    boolean isInLibrary = index.isInLibrary(curr);
                    boolean isUnindexed = this.isUnindexedJSFile((PsiFile)((JSFile)element));
                    if (isInLibrary || isUnindexed) {
                        return true;
                    }
                }
                return false;
            });
            if (allResolveResultsFromLibrary) {
                ArrayList<Object> deps = new ArrayList<Object>(allResolveResults.size() + 2);
                deps.add(file2);
                deps.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
                deps.addAll(allResolveResults);
                dependencies = deps.toArray();
            } else {
                dependencies = new Object[]{JSTypeUtils.getTypeInvalidationDependency()};
            }
            return CachedValueProvider.Result.create(allResolveResults, (Object[])dependencies);
        }, false);
        if (cachedValue == null) {
            JSFileReferenceCache.$$$reportNull$$$0(27);
        }
        return cachedValue;
    }

    @NotNull
    private static Map<String, CachedValue<Collection<PsiElement>>> getLibraryFilesMap(@NotNull PsiElement context) {
        SoftReference data;
        ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> result2;
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(28);
        }
        if ((result2 = (ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>>)SoftReference.deref((Getter)(data = (SoftReference)context.getUserData(KEY)))) != null) {
            ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> concurrentHashMap = result2;
            if (concurrentHashMap == null) {
                JSFileReferenceCache.$$$reportNull$$$0(29);
            }
            return concurrentHashMap;
        }
        result2 = new ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>>();
        context.putUserData(KEY, (Object)new SoftReference(result2));
        ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> concurrentHashMap = result2;
        if (concurrentHashMap == null) {
            JSFileReferenceCache.$$$reportNull$$$0(30);
        }
        return concurrentHashMap;
    }

    @NotNull
    private static Collection<PsiElement> resolveDirectModulesNoCache(@NotNull PsiElement context, @NotNull String unquotedRef) {
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(31);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(32);
        }
        Collection<PsiElement> collection = JSFileReferencesUtil.INSTANCE.calculateMainModules(context, unquotedRef);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(33);
        }
        return collection;
    }

    private boolean isUnindexedJSFile(@Nullable PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        Boolean value = (Boolean)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            boolean isJSFile = JavaScriptIndex.getFileTypesToIndexJS().contains(file2.getFileType());
            if (!isJSFile) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            boolean isIndexed = virtualFile != null && JavaScriptIndex.isAcceptableFile(virtualFile) && ((GlobalSearchScope)this.myIndexedFilesInProjectScope.getValue()).contains(virtualFile);
            return CachedValueProvider.Result.create((Object)(!isIndexed ? 1 : 0), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, file2});
        });
        return Boolean.TRUE.equals(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReference";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedRef";
                break;
            }
            case 16: 
            case 20: 
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 19: 
            case 21: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRef";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReferences";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReference";
                break;
            }
            case 10: 
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectModules";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryCachedValue";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryCachedValueForText";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFilesMap";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectModulesNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReferences";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReference";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectModules";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedModules";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryCachedModules";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryCachedValue";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryCachedValueForText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFilesMap";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectModulesNoCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

