/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.refactoring.FilePathWithCompletionFieldKt;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldUtil;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ComboboxEditorTextField;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/ecmascript6/refactoring/FilePathWithCompletionField;", "Lcom/intellij/ui/EditorComboBox;", "project", "Lcom/intellij/openapi/project/Project;", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "text", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;Ljava/lang/String;)V", "createEditorTextField", "Lcom/intellij/ui/ComboboxEditorTextField;", "document", "Lcom/intellij/openapi/editor/Document;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "isViewer", "", "preselectLastPathComponent", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "EditorBasedDocumentOwner", "FilePathCompletionListProvider", "intellij.javascript.impl"})
public final class FilePathWithCompletionField
extends EditorComboBox {
    private final void preselectLastPathComponent(EditorEx editor) {
        String text = FileUtil.toCanonicalPath((String)this.getText());
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        String string = text;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        int separator = StringsKt.lastIndexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null);
        int length = text.length();
        if (separator > 0 && separator + 1 < length) {
            editor.getSelectionModel().setSelection(separator + 1, length);
        }
    }

    @NotNull
    protected ComboboxEditorTextField createEditorTextField(@NotNull Document document2, @NotNull Project project, @NotNull FileType fileType, boolean isViewer) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return new ComboboxEditorTextField(this, document2, project, fileType, isViewer, document2, project, fileType, isViewer){
            final /* synthetic */ FilePathWithCompletionField this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ Project $project;
            final /* synthetic */ FileType $fileType;
            final /* synthetic */ boolean $isViewer;

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"super.createEditor()");
                EditorEx editor = editorEx;
                FilePathWithCompletionField.access$preselectLastPathComponent(this.this$0, editor);
                return editor;
            }
            {
                this.this$0 = this$0;
                this.$document = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$fileType = $captured_local_variable$3;
                this.$isViewer = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
    }

    public FilePathWithCompletionField(@NotNull Project project, @NotNull FileChooserDescriptor fileChooserDescriptor, @NlsSafe @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor, (String)"fileChooserDescriptor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(FilePathWithCompletionFieldKt.access$createDocument(fileChooserDescriptor).createDocument(text, (Language)PlainTextLanguage.INSTANCE, project), project, (FileType)PlainTextFileType.INSTANCE);
        this.addItem(text);
        this.setSelectedItem(text);
    }

    public static final /* synthetic */ void access$preselectLastPathComponent(FilePathWithCompletionField $this, EditorEx editor) {
        $this.preselectLastPathComponent(editor);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/ecmascript6/refactoring/FilePathWithCompletionField$FilePathCompletionListProvider;", "Lcom/intellij/util/textCompletion/TextCompletionProvider;", "myLookupFilter", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFilter;", "(Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFilter;)V", "myFinder", "Lcom/intellij/openapi/fileChooser/ex/LocalFsFinder;", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "applyPrefixMatcher", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "result", "prefix", "", "createLookupBuilder", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "file", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFile;", "tempResult", "Lcom/intellij/openapi/fileChooser/ex/FileTextFieldImpl$CompletionResult;", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getAdvertisement", "getPrefix", "text", "offset", "", "intellij.javascript.impl"})
    public static final class FilePathCompletionListProvider
    implements TextCompletionProvider {
        private final LocalFsFinder myFinder;
        private final FileLookup.LookupFilter myLookupFilter;

        @Nullable
        public String getAdvertisement() {
            return null;
        }

        @NotNull
        public CharFilter.Result acceptChar(char c) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }

        @NotNull
        public String getPrefix(@NotNull String text, int offset) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)FileUtil.toSystemIndependentName((String)text).subSequence(0, offset), (char)'/', (int)0, (boolean)false, (int)6, null);
            if (lastIndexOf >= 0 && lastIndexOf < text.length() - 1) {
                String string = text;
                int n = lastIndexOf + 1;
                boolean bl = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                return string2;
            }
            return "";
        }

        @NotNull
        public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            CompletionResultSet activeResult = result2;
            PrefixMatcher prefixMatcher = activeResult.getPrefixMatcher();
            Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"activeResult.prefixMatcher");
            if (Intrinsics.areEqual((Object)prefixMatcher.getPrefix(), (Object)prefix) ^ true) {
                CompletionResultSet completionResultSet = activeResult.withPrefixMatcher(prefix);
                Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"activeResult.withPrefixMatcher(prefix)");
                activeResult = completionResultSet;
            }
            CompletionResultSet completionResultSet = activeResult.caseInsensitive();
            Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"activeResult.caseInsensitive()");
            return completionResultSet;
        }

        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            int offset = parameters.getOffset();
            Editor editor = parameters.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"parameters.editor");
            Document document2 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"parameters.editor.document");
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.editor.document.text");
            String string2 = string;
            int n = 0;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, offset);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String substring = string4;
            FileTextFieldImpl.CompletionResult tempResult = new FileTextFieldImpl.CompletionResult();
            String string5 = this.myFinder.getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"myFinder.separator");
            CharSequence charSequence = string5;
            Object object = "\\\\";
            boolean bl2 = false;
            object = new Regex((String)object);
            String string6 = "\\\\\\\\";
            boolean bl3 = false;
            String fileSpitRegExp = object.replace(charSequence, string6);
            tempResult.myCompletionBase = substring;
            FileTextFieldUtil.processCompletion((FileTextFieldImpl.CompletionResult)tempResult, (FileLookup.Finder)((FileLookup.Finder)this.myFinder), (FileLookup.LookupFilter)this.myLookupFilter, (String)fileSpitRegExp, (Map)new HashMap());
            object = tempResult.myToComplete.iterator();
            while (object.hasNext()) {
                FileLookup.LookupFile file2;
                FileLookup.LookupFile lookupFile = file2 = (FileLookup.LookupFile)object.next();
                Intrinsics.checkNotNullExpressionValue((Object)lookupFile, (String)"file");
                result2.addElement((LookupElement)this.createLookupBuilder(lookupFile, tempResult).withIcon(file2.getIcon()).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(this, parameters){
                    final /* synthetic */ FilePathCompletionListProvider this$0;
                    final /* synthetic */ CompletionParameters $parameters;

                    public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                        Editor editor = context.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"context.editor");
                        Editor editor2 = editor;
                        EditorBasedDocumentOwner owner = new EditorBasedDocumentOwner(editor2, (FileLookup.Finder)FilePathCompletionListProvider.access$getMyFinder$p(this.this$0));
                        Object object = item.getObject();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.fileChooser.ex.FileLookup.LookupFile");
                        }
                        FileLookup.LookupFile lookupFile = (FileLookup.LookupFile)object;
                        FileTextFieldUtil.processChosenFromCompletion((FileLookup.LookupFile)lookupFile, (FileTextFieldUtil.DocumentOwner)owner, (FileLookup.Finder)((FileLookup.Finder)FilePathCompletionListProvider.access$getMyFinder$p(this.this$0)), (context.getCompletionChar() == '\t' ? 1 : 0) != 0);
                        if (lookupFile.isDirectory()) {
                            PsiFile psiFile = this.$parameters.getOriginalFile();
                            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"parameters.originalFile");
                            AutoPopupController.getInstance((Project)psiFile.getProject()).autoPopupMemberLookup(editor2, null);
                        }
                    }
                    {
                        this.this$0 = filePathCompletionListProvider;
                        this.$parameters = completionParameters;
                    }
                }));
            }
            result2.stopHere();
        }

        private final LookupElementBuilder createLookupBuilder(FileLookup.LookupFile file2, FileTextFieldImpl.CompletionResult tempResult) {
            String string = FileTextFieldUtil.getLookupString((FileLookup.LookupFile)file2, (FileLookup.Finder)((FileLookup.Finder)this.myFinder), (FileTextFieldImpl.CompletionResult)tempResult);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(file, myFinder, tempResult)");
            String lookupString = string;
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)file2, (String)lookupString);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.create(file, lookupString)");
            return lookupElementBuilder;
        }

        public FilePathCompletionListProvider(@NotNull FileLookup.LookupFilter myLookupFilter) {
            Intrinsics.checkNotNullParameter((Object)myLookupFilter, (String)"myLookupFilter");
            this.myLookupFilter = myLookupFilter;
            this.myFinder = new LocalFsFinder();
        }

        public static final /* synthetic */ LocalFsFinder access$getMyFinder$p(FilePathCompletionListProvider $this) {
            return $this.myFinder;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/ecmascript6/refactoring/FilePathWithCompletionField$EditorBasedDocumentOwner;", "Lcom/intellij/openapi/fileChooser/ex/FileTextFieldUtil$DocumentOwner;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "finder", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$Finder;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/fileChooser/ex/FileLookup$Finder;)V", "myDocument", "Lcom/intellij/openapi/editor/Document;", "myFinder", "getCaretPosition", "", "getLength", "getText", "", "offset", "length", "insertString", "", "str", "remove", "offs", "len", "removeSelection", "setCaretPosition", "position", "setText", "text", "setTextToFile", "file", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFile;", "intellij.javascript.impl"})
    public static final class EditorBasedDocumentOwner
    implements FileTextFieldUtil.DocumentOwner {
        private final Document myDocument;
        private final FileLookup.Finder myFinder;
        private final Editor myEditor;

        @NotNull
        public String getText(int offset, int length) {
            if (offset >= this.myDocument.getTextLength()) {
                return "";
            }
            String string = this.myDocument.getText(new TextRange(offset, RangesKt.coerceAtMost((int)(offset + length), (int)this.myDocument.getTextLength())));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myDocument.getText(TextR\u2026(myDocument.textLength)))");
            return string;
        }

        public void remove(int offs, int len) {
            this.myDocument.deleteString(offs, offs + len);
        }

        public void insertString(int offset, @NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.myDocument.insertString(offset, (CharSequence)str);
        }

        public int getLength() {
            return this.myDocument.getTextLength();
        }

        public void removeSelection() {
            this.myEditor.getSelectionModel().removeSelection();
        }

        public void setCaretPosition(int position) {
            this.myEditor.getCaretModel().moveToOffset(position);
        }

        public int getCaretPosition() {
            CaretModel caretModel = this.myEditor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"myEditor.caretModel");
            return caretModel.getOffset();
        }

        public void setText(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.myDocument.setText((CharSequence)text);
        }

        public void setTextToFile(@NotNull FileLookup.LookupFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            FileTextFieldUtil.setTextToFile((FileLookup.LookupFile)file2, (FileLookup.Finder)this.myFinder, (FileTextFieldUtil.DocumentOwner)this);
            this.myEditor.getCaretModel().moveToOffset(this.myDocument.getTextLength());
        }

        public EditorBasedDocumentOwner(@NotNull Editor myEditor, @NotNull FileLookup.Finder finder) {
            Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
            Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
            this.myEditor = myEditor;
            Document document2 = this.myEditor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"myEditor.document");
            this.myDocument = document2;
            this.myFinder = finder;
        }
    }
}

