/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.amd.JSModuleReference;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u0015\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\bH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\bH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\"\u001a\u00020\bH\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfigurationImpl;", "Lcom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfiguration;", "place", "Lcom/intellij/psi/PsiElement;", "elementToImport", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "useExistingImports", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "importedName", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/vfs/VirtualFile;ZLjava/lang/String;)V", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/vfs/VirtualFile;)V", "myElementToImport", "myFileToImport", "myImportedName", "myPlace", "myTsConfig", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "myUseExistingImports", "config", "Lorg/jetbrains/annotations/Nullable;", "extensions", "", "()[Ljava/lang/String;", "forceExtension", "getElementToImport", "getFileToImport", "getImportedName", "getPlace", "getTsConfig", "isProcessRootPaths", "relativeForSamePathMappings", "usePathMappings", "intellij.javascript.impl"})
public class JSImportPathConfigurationImpl
implements JSImportPathConfiguration {
    private final VirtualFile myFileToImport;
    private final boolean myUseExistingImports;
    private final PsiElement myPlace;
    private final PsiElement myElementToImport;
    private final TypeScriptConfig myTsConfig;
    private final String myImportedName;

    private final TypeScriptConfig config(PsiElement place) {
        TypeScriptConfig typeScriptConfig;
        if (DialectDetector.isTypeScript(place)) {
            PsiFile psiFile = place.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"place.containingFile");
            typeScriptConfig = TypeScriptConfigUtil.getConfigForPsiFile(psiFile.getOriginalFile());
        } else {
            typeScriptConfig = null;
        }
        return typeScriptConfig;
    }

    @Override
    public boolean forceExtension() {
        return false;
    }

    @Override
    @Nullable
    public String getImportedName() {
        return this.myImportedName;
    }

    @Override
    public boolean isProcessRootPaths() {
        return JSCodeStyleSettings.isUseAbsolutePath(this.myPlace);
    }

    @Override
    @NotNull
    public VirtualFile getFileToImport() {
        return this.myFileToImport;
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        return this.myPlace;
    }

    @Override
    @Nullable
    public PsiElement getElementToImport() {
        return this.myElementToImport;
    }

    @Override
    @Nullable
    public TypeScriptConfig getTsConfig() {
        return this.myTsConfig;
    }

    @Override
    public boolean useExistingImports() {
        return this.myUseExistingImports;
    }

    @Override
    public boolean usePathMappings() {
        return JSCodeStyleSettings.getSettings((PsiElement)this.myPlace).USE_PATH_MAPPING != JSCodeStyleSettings.PathMappingOption.NEVER;
    }

    @Override
    public boolean relativeForSamePathMappings() {
        return JSCodeStyleSettings.getSettings((PsiElement)this.myPlace).USE_PATH_MAPPING == JSCodeStyleSettings.PathMappingOption.DIFFERENT_PATHS;
    }

    @Override
    @NotNull
    public String[] extensions() {
        if (DialectDetector.isTypeScript(this.myPlace)) {
            List<String> list2 = TypeScriptImportsResolverProvider.getAllFileExtensionsWithDot();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"TypeScriptImportsResolve\u2026llFileExtensionsWithDot()");
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray;
        }
        String[] stringArray = JSModuleReference.getExtensionsWithPlatforms(this.myPlace, JSFileReference.IMPLICIT_EXTENSIONS);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"JSModuleReference.getExt\u2026ence.IMPLICIT_EXTENSIONS)");
        return stringArray;
    }

    public JSImportPathConfigurationImpl(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile virtualFile, boolean useExistingImports) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.myUseExistingImports = useExistingImports;
        this.myElementToImport = elementToImport;
        this.myPlace = place;
        this.myFileToImport = virtualFile;
        this.myTsConfig = this.config(place);
        this.myImportedName = elementToImport instanceof JSElement ? ES6ImportPsiUtil.getExportedElementName((JSElement)elementToImport) : null;
    }

    public /* synthetic */ JSImportPathConfigurationImpl(PsiElement psiElement, PsiElement psiElement2, VirtualFile virtualFile, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(psiElement, psiElement2, virtualFile, bl);
    }

    public JSImportPathConfigurationImpl(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile virtualFile, boolean useExistingImports, @Nullable String importedName) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.myUseExistingImports = useExistingImports;
        this.myElementToImport = elementToImport;
        this.myPlace = place;
        this.myFileToImport = virtualFile;
        this.myTsConfig = this.config(place);
        String string = importedName;
        if (string == null) {
            string = elementToImport instanceof JSElement ? ES6ImportPsiUtil.getExportedElementName((JSElement)elementToImport) : null;
        }
        this.myImportedName = string;
    }

    public JSImportPathConfigurationImpl(@NotNull PsiElement place, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.myUseExistingImports = false;
        this.myElementToImport = null;
        this.myFileToImport = virtualFile;
        this.myPlace = place;
        this.myTsConfig = this.config(place);
        this.myImportedName = null;
    }
}

