/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6AddImportExecutor {
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiElement myPlace;
    @NotNull
    private final Project myProject;

    public ES6AddImportExecutor(@Nullable Editor editor, @NotNull PsiElement place) {
        if (place == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        this.myPlace = place;
        this.myProject = place.getProject();
    }

    public final void execute(@NotNull String importedName, @NotNull JSElement elementToImport) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(1);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(2);
        }
        this.createImports(this.createDescriptors(importedName, elementToImport, JSImportPlaceInfo.ImportContext.SIMPLE));
    }

    public void createImports(@NotNull JSImportCandidate candidate) {
        if (candidate == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(3);
        }
        this.createImports(candidate.getDescriptors());
    }

    public void createImports(@NotNull List<JSImportDescriptor> descriptors) {
        if (descriptors == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile file2 = this.myPlace.getContainingFile();
        if (descriptors.isEmpty()) {
            TypeScriptAutoImportUtil.showError(this.myProject, this.myEditor);
        }
        for (JSImportDescriptor descriptor2 : descriptors) {
            this.createImportOrUseExisting(descriptor2);
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file2);
    }

    public final List<JSImportDescriptor> createDescriptors(@NotNull String importedName, @NotNull JSElement elementToImport, @NotNull JSImportPlaceInfo.ImportContext importContext) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(5);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(6);
        }
        if (importContext == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(7);
        }
        List<JSImportDescriptor> descriptors = this.createDescriptorsImpl(importedName, elementToImport);
        return ContainerUtil.filter(descriptors, descriptor2 -> {
            JSImportExportType type = descriptor2.getImportType();
            switch (importContext) {
                case BINDING: {
                    return type.isDefault();
                }
                case SPECIFIER: {
                    return type.isSpecifier();
                }
            }
            return true;
        });
    }

    private List<JSImportDescriptor> executeForNamespaceAndModuleImport(@NotNull String importedName, @NotNull JSElement elementToImport) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(8);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(9);
        }
        PsiElement current = elementToImport.getParent();
        PsiElement lastElement = null;
        while (current != null) {
            PsiElement parent = current.getParent();
            if (parent != null && ES6PsiUtil.isExternalModule(parent)) {
                lastElement = current;
                break;
            }
            current = parent;
        }
        if (!(lastElement instanceof JSQualifiedNamedElement)) {
            return Collections.emptyList();
        }
        JSQualifiedNamedElement element = (JSQualifiedNamedElement)lastElement;
        String moduleName = element.getName();
        if (moduleName == null) {
            return Collections.emptyList();
        }
        SmartList descriptors = new SmartList();
        if (!this.hasImportForNamespace(element, moduleName)) {
            descriptors.addAll(this.createDescriptorsImpl(moduleName, (JSElement)element));
            if (descriptors.isEmpty()) {
                return Collections.emptyList();
            }
        }
        descriptors.addAll(this.createDescriptorsForImportType(importedName, elementToImport, ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE));
        return descriptors;
    }

    private boolean hasImportForNamespace(@NotNull JSQualifiedNamedElement element, @NotNull String name) {
        PsiElement scope;
        if (element == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(10);
        }
        if (name == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(11);
        }
        if ((scope = ES6CreateImportUtil.getScopeToAdd(this.myPlace, false)) == null) {
            return false;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(name, this.myPlace);
        return result2.getElements().contains(element);
    }

    @NotNull
    private List<JSImportDescriptor> createDescriptorsImpl(@NotNull String importedName, @NotNull JSElement elementToImport) {
        JSImportExportType importType;
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(12);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(13);
        }
        if ((importType = this.getImportType((PsiElement)elementToImport)) == null) {
            List<JSImportDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6AddImportExecutor.$$$reportNull$$$0(14);
            }
            return list2;
        }
        List<JSImportDescriptor> list3 = this.createDescriptorsForImportType(importedName, elementToImport, importType);
        if (list3 == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(15);
        }
        return list3;
    }

    @Nullable
    public JSImportExportType getImportType(@NotNull PsiElement candidate) {
        JSFile.ModuleStatus status;
        if (candidate == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(16);
        }
        if (!(candidate instanceof JSElement)) {
            return null;
        }
        JSElement elementToImport = (JSElement)candidate;
        JSElement elementContainer = ES6AddImportExecutor.getExportContainer(elementToImport);
        JSElement placeContainer = ES6PsiUtil.getExportScope(this.myPlace);
        if (elementContainer == null || elementContainer.isEquivalentTo((PsiElement)placeContainer)) {
            return null;
        }
        if (elementContainer instanceof JSFile && ((status = ((JSFile)elementContainer).getModuleStatus()) == JSFile.ModuleStatus.COMMONJS || status == JSFile.ModuleStatus.MAYBE_COMMONJS)) {
            return ES6AddImportExecutor.getImportTypeForCommonJS((JSElement)candidate);
        }
        return this.getImportType(elementToImport, (PsiElement)elementContainer);
    }

    @Nullable
    private static JSImportExportType getImportTypeForCommonJS(@NotNull JSElement candidate) {
        if (candidate == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(17);
        }
        if (!(candidate instanceof JSPsiElementBase)) {
            return null;
        }
        return CommonJSUtil.isExportedWithModuleExports((JSPsiElementBase)candidate) ? ES6ImportPsiUtil.ImportExportType.DEFAULT : (Objects.equals(((JSPsiElementBase)candidate).getQualifiedName(), "exports") ? ES6ImportPsiUtil.ImportExportType.SPECIFIER : null);
    }

    @Nullable
    private static JSQualifiedName getElementNamespace(@NotNull JSElement elementToImport) {
        String name;
        PsiElement module;
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(18);
        }
        if (elementToImport instanceof JSQualifiedNamedElement) {
            return ((JSQualifiedNamedElement)elementToImport).getNamespace();
        }
        if (elementToImport instanceof ES6ImportExportDeclarationPart && (module = ES6PsiUtil.findExternalModule((PsiElement)elementToImport)) instanceof TypeScriptModule && ((TypeScriptModule)module).isExternal() && !((TypeScriptModule)module).isAugmentation() && (name = ((TypeScriptModule)module).getName()) != null) {
            return JSQualifiedNameImpl.fromQualifiedName(name);
        }
        return null;
    }

    public List<JSImportDescriptor> createDescriptorsForImportType(@NotNull String importedName, @NotNull JSElement elementToImport, @NotNull JSImportExportType importType) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(19);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(20);
        }
        if (importType == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(21);
        }
        if (importType.isComposite()) {
            return this.executeForNamespaceAndModuleImport(importedName, elementToImport);
        }
        JSQualifiedName namespace = ES6AddImportExecutor.getElementNamespace(elementToImport);
        JSElement elementContainer = ES6AddImportExecutor.getExportContainer(elementToImport);
        if (elementContainer == null) {
            return Collections.emptyList();
        }
        JSModuleDescriptor.SimpleModuleDescriptor descriptor2 = null;
        if (importType.isNamespace()) {
            String moduleOrNamespaceName = namespace == null ? importedName : namespace + "." + importedName;
            descriptor2 = new JSModuleDescriptor.SimpleModuleDescriptor(null, moduleOrNamespaceName);
        } else {
            PsiElement rawExternalModule = this.getRawExternalModule(elementToImport, (PsiElement)elementContainer, namespace);
            if (rawExternalModule == null) {
                return Collections.emptyList();
            }
            if (rawExternalModule instanceof PsiFile) {
                PsiFile moduleFile = (PsiFile)rawExternalModule;
                JSImportDescriptor importDescriptor = ES6CreateImportUtil.getImportDescriptor(importedName, (PsiElement)elementToImport, moduleFile.getVirtualFile(), this.myPlace, true);
                if (importDescriptor != null) {
                    return Collections.singletonList(importDescriptor);
                }
            } else if (rawExternalModule instanceof TypeScriptModule) {
                String rawName = ((TypeScriptModule)rawExternalModule).getExternalModuleText();
                if (rawName == null) {
                    return Collections.emptyList();
                }
                descriptor2 = new JSModuleDescriptor.SimpleModuleDescriptor(rawExternalModule, StringUtil.unquoteString((String)rawName));
            }
        }
        if (descriptor2 == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createDescriptor(importedName, elementToImport.getName(), descriptor2, importType, ES6AddImportExecutor.detectPrefixKind((PsiElement)elementToImport, this.myPlace)));
    }

    @Nullable
    public static JSElement getExportContainer(@NotNull JSElement elementToImport) {
        JSElement scope;
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(22);
        }
        if (!((scope = ES6PsiUtil.getExportScope((PsiElement)elementToImport)) instanceof TypeScriptModule) || !((TypeScriptModule)scope).isInternal() || elementToImport instanceof TypeScriptModule) {
            return scope;
        }
        String name = scope.getName();
        if (name == null) {
            return scope;
        }
        PsiElement parent = scope.getContext();
        if (!(parent instanceof JSFile)) {
            return scope;
        }
        List modules = ((StreamEx)StreamEx.of(JSStubBasedPsiTreeUtil.getFileOrModuleChildrenStream(parent)).select(TypeScriptModule.class).filter(TypeScriptModule::isExternal)).toList();
        for (TypeScriptModule module : modules) {
            List<PsiElement> elements;
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment((PsiElement)module);
            if (assignment == null || !name.equals(assignment.getInitializerReference()) || !(elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, (PsiElement)module)).contains(scope)) continue;
            return module;
        }
        return scope;
    }

    @Nullable
    public PsiElement getRawExternalModule(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer, @Nullable JSQualifiedName namespace) {
        PsiElement externalModuleForContainer;
        boolean isDefaultExport;
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(23);
        }
        if (elementContainer == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(24);
        }
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return elementToImport;
        }
        if (elementContainer instanceof TypeScriptModule && ((TypeScriptModule)elementContainer).isAugmentation()) {
            return elementContainer.getParent();
        }
        boolean bl = isDefaultExport = elementToImport instanceof JSPsiElementBase && ((JSPsiElementBase)elementToImport).isExportedWithDefault();
        if (namespace == null && !isDefaultExport) {
            return elementContainer.getContainingFile();
        }
        PsiElement psiElement = externalModuleForContainer = ES6PsiUtil.isExternalModule(elementContainer) ? elementContainer : elementContainer.getParent();
        if (!ES6PsiUtil.isExternalModule(externalModuleForContainer)) {
            return null;
        }
        if (externalModuleForContainer instanceof TypeScriptModule) {
            String currentModuleName = ((TypeScriptModule)externalModuleForContainer).getExternalModuleText();
            if (currentModuleName == null) {
                return null;
            }
            return externalModuleForContainer;
        }
        return elementContainer.getContainingFile();
    }

    @NotNull
    public static ES6ImportExportDeclaration.ImportExportPrefixKind detectPrefixKind(@Nullable PsiElement element, @NotNull PsiElement place) {
        if (place == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(25);
        }
        if (element == null) {
            ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT;
            if (importExportPrefixKind == null) {
                ES6AddImportExecutor.$$$reportNull$$$0(26);
            }
            return importExportPrefixKind;
        }
        boolean isTypeContext = element instanceof TypeScriptCompileTimeType;
        if (!isTypeContext) {
            ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT;
            if (importExportPrefixKind == null) {
                ES6AddImportExecutor.$$$reportNull$$$0(27);
            }
            return importExportPrefixKind;
        }
        PsiElement externalModule = ES6PsiUtil.findExternalModule(element);
        if (externalModule != null && DialectDetector.isFlow(externalModule)) {
            ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE;
            if (importExportPrefixKind == null) {
                ES6AddImportExecutor.$$$reportNull$$$0(28);
            }
            return importExportPrefixKind;
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(place.getContainingFile());
        ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = config2 != null && config2.importsNotUsedAsValues() == TypeScriptConfig.ImportsValues.ERROR ? ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE : ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE_OR_SIMPLE;
        if (importExportPrefixKind == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(29);
        }
        return importExportPrefixKind;
    }

    @NotNull
    public JSImportDescriptor createDescriptor(@NotNull String importedName, @Nullable String exportedName, @NotNull JSModuleDescriptor moduleDescriptor, @NotNull JSImportExportType importType, @NotNull ES6ImportExportDeclaration.ImportExportPrefixKind prefixKind) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(30);
        }
        if (moduleDescriptor == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(31);
        }
        if (importType == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(32);
        }
        if (prefixKind == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(33);
        }
        return new JSSimpleImportDescriptor(moduleDescriptor, new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, importType, prefixKind));
    }

    public boolean createImportOrUseExisting(@NotNull ES6ImportPsiUtil.CreateImportExportInfo info, @Nullable PsiElement externalModule, @NotNull String quotedModuleOrNamespaceName) {
        if (info == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(34);
        }
        if (quotedModuleOrNamespaceName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(35);
        }
        return this.createImportOrUseExisting(new JSSimpleImportDescriptor(externalModule, quotedModuleOrNamespaceName, info));
    }

    public boolean createImportOrUseExisting(@NotNull JSImportDescriptor descriptor2) {
        JSImportExportType type;
        PsiElement scope;
        if (descriptor2 == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(36);
        }
        if ((scope = ES6CreateImportUtil.getScopeToAdd(this.myPlace, !(type = descriptor2.getImportType()).isNamespace())) == null) {
            return false;
        }
        if (this.tryToUseExistingImport(descriptor2, scope)) {
            return true;
        }
        PsiElement importPsi = this.createTypeScriptOrES6Import(descriptor2);
        if (importPsi instanceof ES6ImportDeclaration && !type.isBare()) {
            ES6CreateImportUtil.findPlaceAndInsertES6Import(scope, importPsi, descriptor2.getModuleName(), this.myEditor);
        } else {
            ES6CreateImportUtil.findPlaceAndInsertAnyImport(scope, importPsi, this.myEditor);
        }
        return true;
    }

    @NotNull
    private PsiElement createTypeScriptOrES6Import(@NotNull JSImportDescriptor info) {
        if (info == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(37);
        }
        JSSourceElement jSSourceElement = ES6ImportPsiUtil.createImportOrExport(this.myPlace, info);
        if (jSSourceElement == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(38);
        }
        return jSSourceElement;
    }

    @Nullable
    public ES6ImportPsiUtil.ImportExportType getImportType(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer) {
        TypeScriptModule container;
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(39);
        }
        if (elementContainer == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(40);
        }
        JSQualifiedName namespace = ES6AddImportExecutor.getElementNamespace(elementToImport);
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        }
        if (elementToImport instanceof ES6ExportSpecifierAlias) {
            elementToImport = ((ES6ExportSpecifierAlias)elementToImport).findSpecifierElement();
        }
        if (elementToImport instanceof ES6ExportedDefaultBinding) {
            boolean isDefault = "default".equals(elementToImport.getName());
            return isDefault ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
        }
        if (elementToImport instanceof ES6ExportSpecifier) {
            return ((ES6ExportSpecifier)elementToImport).isExportDefault() ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
        }
        if (elementContainer instanceof TypeScriptModule && (container = (TypeScriptModule)elementContainer).isAugmentation()) {
            if (TypeScriptAutoImportUtil.isSelfExportedAugmentationModule(container)) {
                return ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
            return null;
        }
        boolean isExported = ES6ImportHandler.checkExportedOrCalculate((PsiElement)elementToImport);
        boolean isExportedDefault = ES6ImportHandler.checkExportedWithDefaultOrCalculate((PsiElement)elementToImport);
        JSExportAssignment exportAssignment = TypeScriptAutoImportUtil.getExportAssignment(elementContainer);
        if (exportAssignment instanceof TypeScriptExportAssignment) {
            if (isExported && !PsiTreeUtil.isAncestor((PsiElement)elementContainer, (PsiElement)elementToImport, (boolean)true)) {
                return ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
            TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(this.myPlace.getContainingFile());
            if (config2 != null && config2.allowSyntheticDefaultImports()) {
                return ES6ImportPsiUtil.ImportExportType.DEFAULT;
            }
            if (elementToImport instanceof TypeScriptModule) {
                return DialectDetector.isTypeScript(this.myPlace) ? ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL : ES6ImportPsiUtil.ImportExportType.DEFAULT;
            }
            return ES6ImportPsiUtil.ImportExportType.TS_REQUIRE_IMPORT;
        }
        if (namespace != null && elementContainer instanceof TypeScriptModule && !ES6PsiUtil.isExternalModule(elementContainer)) {
            PsiElement module = ES6PsiUtil.findExternalModule(elementContainer);
            if (module == null) {
                return ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE;
            }
            JSExportAssignment externalModuleExportAssignment = TypeScriptAutoImportUtil.getExportAssignment(module);
            if (!(externalModuleExportAssignment instanceof TypeScriptExportAssignment) || elementContainer.getParent() != module) {
                return ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE;
            }
        }
        if (isExportedDefault) {
            return ES6ImportPsiUtil.ImportExportType.DEFAULT;
        }
        ES6ImportPsiUtil.ImportExportType resultKind = ES6ImportPsiUtil.ImportExportType.DEFAULT;
        if (elementToImport != null && !(elementToImport.getContext() instanceof JSExportAssignment) && isExported) {
            resultKind = ES6ImportPsiUtil.ImportExportType.SPECIFIER;
        }
        return resultKind;
    }

    public boolean tryToUseExistingImport(@NotNull JSImportDescriptor descriptor2, @NotNull PsiElement scope) {
        ES6ImportExportDeclaration grandParent;
        PsiElement parent;
        if (descriptor2 == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(42);
        }
        PsiElement psiElement = parent = this.myPlace instanceof ES6ImportExportDeclarationPart ? this.myPlace : this.myPlace.getParent();
        if (parent instanceof ES6ImportExportDeclarationPart && (grandParent = ((ES6ImportExportDeclarationPart)parent).getDeclaration()) instanceof ES6ImportDeclaration && grandParent.getFromClause() == null) {
            String quote = JSCodeStyleSettings.getQuote(scope);
            String name = quote + descriptor2.getModuleName() + quote;
            ES6CreateImportUtil.insertFromClause((ES6ImportExportDeclarationPart)parent, grandParent, name);
            return true;
        }
        JSImportExportType importType = descriptor2.getImportType();
        if (JSCodeStyleSettings.isMergeImports(this.myPlace) && importType.isES6()) {
            ES6ImportDeclaration possibleImport = ES6ImportPsiUtil.findExistingES6Import(scope, descriptor2);
            return possibleImport != null && ES6ImportPsiUtil.tryToAddImportToExistingDeclaration(possibleImport, descriptor2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 3: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/actions/ES6AddImportExecutor";
                break;
            }
            case 21: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importType";
                break;
            }
            case 24: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementContainer";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixKind";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedModuleOrNamespaceName";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/actions/ES6AddImportExecutor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptorsImpl";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "detectPrefixKind";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeScriptOrES6Import";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createImports";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeForNamespaceAndModuleImport";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasImportForNamespace";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorsImpl";
                break;
            }
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: {
                break;
            }
            case 16: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getImportType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getImportTypeForCommonJS";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getElementNamespace";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorsForImportType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExportContainer";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRawExternalModule";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "detectPrefixKind";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createImportOrUseExisting";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptOrES6Import";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "tryToUseExistingImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

