/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.webTypes.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.javascript.web.webTypes.json.GenericContributionsHost;
import com.intellij.javascript.web.webTypes.json.NamePatternBase;
import com.intellij.javascript.web.webTypes.json.Reference;
import com.intellij.javascript.web.webTypes.json.SourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "description", "doc-url", "source", "deprecated", "experimental", "priority", "virtual", "abstract", "extends", "aliases", "selector", "pattern"})
public class BaseContribution
extends GenericContributionsHost {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Short description to be rendered in documentation popup. It will be rendered according to description-markup setting.")
    private String description;
    @JsonProperty(value="doc-url")
    @JsonPropertyDescription(value="Link to online documentation.")
    private String docUrl;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="Allows to specify the source of the entity. For Vue.js component this may be for instance a class.")
    private SourceBase source;
    @JsonProperty(value="deprecated")
    private Boolean deprecated = false;
    @JsonProperty(value="experimental")
    private Boolean experimental = false;
    @JsonProperty(value="priority")
    private Priority priority;
    @JsonProperty(value="virtual")
    private Boolean virtual;
    @JsonProperty(value="abstract")
    private Boolean _abstract;
    @JsonProperty(value="extends")
    @JsonPropertyDescription(value="A reference to an element in web-types model.")
    private Reference _extends;
    @JsonProperty(value="aliases")
    @JsonPropertyDescription(value="List of symbol aliases")
    private List<String> aliases = new ArrayList<String>();
    @JsonProperty(value="selector")
    private String selector;
    @JsonProperty(value="pattern")
    private NamePatternBase pattern;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="doc-url")
    public String getDocUrl() {
        return this.docUrl;
    }

    @JsonProperty(value="doc-url")
    public void setDocUrl(String docUrl) {
        this.docUrl = docUrl;
    }

    @JsonProperty(value="source")
    public SourceBase getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(SourceBase source) {
        this.source = source;
    }

    @JsonProperty(value="deprecated")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @JsonProperty(value="experimental")
    public Boolean getExperimental() {
        return this.experimental;
    }

    @JsonProperty(value="experimental")
    public void setExperimental(Boolean experimental) {
        this.experimental = experimental;
    }

    @JsonProperty(value="priority")
    public Priority getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @JsonProperty(value="virtual")
    public Boolean getVirtual() {
        return this.virtual;
    }

    @JsonProperty(value="virtual")
    public void setVirtual(Boolean virtual) {
        this.virtual = virtual;
    }

    @JsonProperty(value="abstract")
    public Boolean getAbstract() {
        return this._abstract;
    }

    @JsonProperty(value="abstract")
    public void setAbstract(Boolean _abstract) {
        this._abstract = _abstract;
    }

    @JsonProperty(value="extends")
    public Reference getExtends() {
        return this._extends;
    }

    @JsonProperty(value="extends")
    public void setExtends(Reference _extends) {
        this._extends = _extends;
    }

    @JsonProperty(value="aliases")
    public List<String> getAliases() {
        return this.aliases;
    }

    @JsonProperty(value="aliases")
    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @JsonProperty(value="selector")
    public String getSelector() {
        return this.selector;
    }

    @JsonProperty(value="selector")
    public void setSelector(String selector) {
        this.selector = selector;
    }

    @JsonProperty(value="pattern")
    public NamePatternBase getPattern() {
        return this.pattern;
    }

    @JsonProperty(value="pattern")
    public void setPattern(NamePatternBase pattern) {
        this.pattern = pattern;
    }

    public static enum Priority {
        LOWEST("lowest"),
        LOW("low"),
        NORMAL("normal"),
        HIGH("high"),
        HIGHEST("highest");

        private final String value;
        private static final Map<String, Priority> CONSTANTS;

        private Priority(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Priority fromValue(String value) {
            Priority constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Priority>();
            for (Priority c : Priority.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

