/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.css.refs;

import com.intellij.javascript.web.css.refs.CssClassInJSLiteralOrIdentifierReferenceProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/web/css/refs/CssClassInJSLiteralOrIdentifierReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "Companion", "intellij.javascript.web"})
public final class CssClassInJSLiteralOrIdentifierReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String text = null;
        int offset = 0;
        if (element instanceof JSLiteralExpression) {
            text = ((JSLiteralExpression)element).getStringValue();
            offset = 1;
        } else {
            PsiElement psiElement;
            PsiElement nameSource = element;
            if (element instanceof JSProperty) {
                PsiElement psiElement2;
                PsiElement psiElement3 = ((JSProperty)element).getNameIdentifier();
                if (psiElement3 != null) {
                    psiElement = psiElement3;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement it = psiElement;
                    boolean bl3 = false;
                    PsiElement psiElement4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"it");
                    nameSource = psiElement4;
                    psiElement2 = psiElement;
                } else {
                    psiElement2 = null;
                }
                if (psiElement2 != null) {
                    offset = nameSource.getStartOffsetInParent();
                }
            }
            ASTNode aSTNode = nameSource.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"nameSource.node");
            psiElement = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)psiElement, (Object)JSTokenTypes.STRING_LITERAL)) {
                text = StringUtil.unquoteString((String)nameSource.getText());
                ++offset;
            } else if (Intrinsics.areEqual((Object)psiElement, (Object)JSTokenTypes.IDENTIFIER) || Intrinsics.areEqual((Object)psiElement, (Object)JSElementTypes.REFERENCE_EXPRESSION)) {
                text = nameSource.getText();
            }
        }
        if (text == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        int finalOffset = offset;
        CssResolveUtil.consumeClassNames((String)text, (PsiElement)element, (PairConsumer)((PairConsumer)new PairConsumer<String, TextRange>(element, finalOffset, result2){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ int $finalOffset;
            final /* synthetic */ SmartList $result;

            public final void consume(String $noName_0, TextRange range) {
                CssElementDescriptorProvider cssElementDescriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)this.$element);
                Intrinsics.checkNotNull((Object)cssElementDescriptorProvider);
                Intrinsics.checkNotNullExpressionValue((Object)cssElementDescriptorProvider, (String)"CssDescriptorsUtil.findD\u2026riptorProvider(element)!!");
                CssElementDescriptorProvider descriptorProvider = cssElementDescriptorProvider;
                TextRange textRange = range.shiftRight(this.$finalOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range.shiftRight(finalOffset)");
                TextRange finalRange = textRange;
                this.$result.add((Object)descriptorProvider.getStyleReference(this.$element, finalRange.getStartOffset(), finalRange.getEndOffset(), true));
            }
            {
                this.$element = psiElement;
                this.$finalOffset = n;
                this.$result = smartList;
            }
        }));
        Collection $this$toTypedArray$iv = (Collection)result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiReference[] psiReferenceArray = thisCollection$iv.toArray(new PsiReference[0]);
        if (psiReferenceArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiReferenceArray;
    }

    @JvmStatic
    public static final void register(@NotNull PsiReferenceRegistrar registrar, @NotNull Language language, @NotNull Class<? extends JSEmbeddedContent> embeddedContentClass, @NotNull Function<XmlAttribute, Boolean> attributeFilter) {
        Companion.register(registrar, language, embeddedContentClass, attributeFilter);
    }

    @JvmStatic
    @NotNull
    public static final String getClassesFromEmbeddedContent(@Nullable JSEmbeddedContent binding) {
        return Companion.getClassesFromEmbeddedContent(binding);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0002J\"\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0002J9\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\"\u0010\u000e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b0\u000f\"\n\u0012\u0006\b\u0001\u0012\u00020\u00060\bH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0007J<\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00040\u001bH\u0007\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/web/css/refs/CssClassInJSLiteralOrIdentifierReferenceProvider$Companion;", "", "()V", "acceptJSLiteral", "", "literal", "Lcom/intellij/psi/PsiElement;", "embeddedContentClass", "Ljava/lang/Class;", "Lcom/intellij/lang/javascript/psi/JSEmbeddedContent;", "acceptJSProperty", "property", "checkHierarchy", "element", "classes", "", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/Class;)Z", "getClassesFromEmbeddedContent", "", "binding", "register", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "language", "Lcom/intellij/lang/Language;", "attributeFilter", "Ljava/util/function/Function;", "Lcom/intellij/psi/xml/XmlAttribute;", "intellij.javascript.web"})
    public static final class Companion {
        @JvmStatic
        public final void register(@NotNull PsiReferenceRegistrar registrar, @NotNull Language language, @NotNull Class<? extends JSEmbeddedContent> embeddedContentClass, @NotNull Function<XmlAttribute, Boolean> attributeFilter) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(embeddedContentClass, (String)"embeddedContentClass");
            Intrinsics.checkNotNullParameter(attributeFilter, (String)"attributeFilter");
            registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).withLanguage(language)).and((ElementPattern)new FilterPattern(new ElementFilter(attributeFilter, embeddedContentClass){
                final /* synthetic */ Function $attributeFilter;
                final /* synthetic */ Class $embeddedContentClass;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean isAcceptable(@NotNull Object element, @Nullable PsiElement context) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
                    if (xmlAttribute == null) return false;
                    XmlAttribute xmlAttribute2 = xmlAttribute;
                    boolean bl = false;
                    boolean bl2 = false;
                    XmlAttribute it = xmlAttribute2;
                    boolean bl3 = false;
                    if ((Boolean)this.$attributeFilter.apply(it) != true) return false;
                    if (!com.intellij.javascript.web.css.refs.CssClassInJSLiteralOrIdentifierReferenceProvider$Companion.access$acceptJSLiteral(CssClassInJSLiteralOrIdentifierReferenceProvider.Companion, context, this.$embeddedContentClass)) return false;
                    return true;
                }

                public boolean isClassAcceptable(@NotNull Class<?> hintClass) {
                    Intrinsics.checkNotNullParameter(hintClass, (String)"hintClass");
                    return true;
                }
                {
                    this.$attributeFilter = $captured_local_variable$0;
                    this.$embeddedContentClass = $captured_local_variable$1;
                }
            })), (PsiReferenceProvider)new CssClassInJSLiteralOrIdentifierReferenceProvider());
            registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSProperty.class).withLanguage(language)).and((ElementPattern)new FilterPattern(new ElementFilter(attributeFilter, embeddedContentClass){
                final /* synthetic */ Function $attributeFilter;
                final /* synthetic */ Class $embeddedContentClass;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean isAcceptable(@NotNull Object element, @Nullable PsiElement context) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
                    if (xmlAttribute == null) return false;
                    XmlAttribute xmlAttribute2 = xmlAttribute;
                    boolean bl = false;
                    boolean bl2 = false;
                    XmlAttribute it = xmlAttribute2;
                    boolean bl3 = false;
                    if ((Boolean)this.$attributeFilter.apply(it) != true) return false;
                    if (!com.intellij.javascript.web.css.refs.CssClassInJSLiteralOrIdentifierReferenceProvider$Companion.access$acceptJSProperty(CssClassInJSLiteralOrIdentifierReferenceProvider.Companion, context, this.$embeddedContentClass)) return false;
                    return true;
                }

                public boolean isClassAcceptable(@NotNull Class<?> hintClass) {
                    Intrinsics.checkNotNullParameter(hintClass, (String)"hintClass");
                    return true;
                }
                {
                    this.$attributeFilter = $captured_local_variable$0;
                    this.$embeddedContentClass = $captured_local_variable$1;
                }
            })), (PsiReferenceProvider)new CssClassInJSLiteralOrIdentifierReferenceProvider());
        }

        @JvmStatic
        @NotNull
        public final String getClassesFromEmbeddedContent(@Nullable JSEmbeddedContent binding) {
            StringBuilder result2 = new StringBuilder();
            Sequence sequence = binding;
            if (sequence != null && (sequence = sequence.getChildren()) != null && (sequence = ArraysKt.asSequence((Object[])sequence)) != null && (sequence = SequencesKt.filter((Sequence)sequence, (Function1)getClassesFromEmbeddedContent.1.INSTANCE)) != null && (sequence = (PsiElement)SequencesKt.firstOrNull((Sequence)sequence)) != null) {
                sequence.accept((PsiElementVisitor)new JSElementVisitor(result2){
                    final /* synthetic */ StringBuilder $result;

                    public void visitJSArrayLiteralExpression(@NotNull JSArrayLiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        for (JSExpression expression : node.getExpressions()) {
                            expression.accept((PsiElementVisitor)this);
                        }
                    }

                    public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node.isQuotedLiteral()) {
                            this.$result.append(node.getStringValue());
                            this.$result.append(' ');
                        }
                    }

                    public void visitJSObjectLiteralExpression(@NotNull JSObjectLiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        for (JSProperty property : node.getProperties()) {
                            property.accept((PsiElementVisitor)this);
                        }
                    }

                    public void visitJSProperty(@NotNull JSProperty node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.$result.append(node.getName());
                        this.$result.append(' ');
                    }
                    {
                        this.$result = $captured_local_variable$0;
                    }
                });
            }
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
            return string;
        }

        private final boolean acceptJSLiteral(PsiElement literal, Class<? extends JSEmbeddedContent> embeddedContentClass) {
            return literal instanceof JSLiteralExpression && ((JSLiteralExpression)literal).isQuotedLiteral() && (embeddedContentClass.isInstance(((JSLiteralExpression)literal).getParent()) || this.checkHierarchy(literal, JSArrayLiteralExpression.class, embeddedContentClass));
        }

        private final boolean acceptJSProperty(PsiElement property, Class<? extends JSEmbeddedContent> embeddedContentClass) {
            return property instanceof JSProperty && this.checkHierarchy(property, JSObjectLiteralExpression.class, embeddedContentClass);
        }

        private final boolean checkHierarchy(PsiElement element, Class<? extends PsiElement> ... classes) {
            PsiElement parent = element;
            for (Class<? extends PsiElement> cls : classes) {
                Intrinsics.checkNotNullExpressionValue((Object)parent.getParent(), (String)"parent.parent");
                if (parent != null && cls.isInstance(parent)) continue;
                return false;
            }
            return true;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$acceptJSLiteral(Companion $this, PsiElement literal, Class embeddedContentClass) {
            return $this.acceptJSLiteral(literal, embeddedContentClass);
        }

        public static final /* synthetic */ boolean access$acceptJSProperty(Companion $this, PsiElement property, Class embeddedContentClass) {
            return $this.acceptJSProperty(property, embeddedContentClass);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

