/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.actions.CompatibleRunConfigurationProducer;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testing.JSTestRunnerManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsTestRunConfigurationProducer<T extends RunConfiguration>
extends CompatibleRunConfigurationProducer<T> {
    private static final Logger LOG = Logger.getInstance(JsTestRunConfigurationProducer.class);
    private final NodePackageDescriptor myTestRunnerPackageDescriptor;
    private final NodePackageDescriptor myStopPackageDescriptor;

    protected JsTestRunConfigurationProducer(@NotNull List<String> testRunnerPackageNames) {
        if (testRunnerPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        this(testRunnerPackageNames, (List<String>)ImmutableList.of());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected JsTestRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull List<String> testRunnerPackageNames) {
        if (configurationType == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (testRunnerPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        this(configurationType, testRunnerPackageNames, Collections.emptyList());
    }

    @Deprecated
    protected JsTestRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull List<String> testRunnerPackageNames, @NotNull List<String> stopPackageNames) {
        if (configurationType == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (testRunnerPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (stopPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        super(configurationType);
        this.myTestRunnerPackageDescriptor = new NodePackageDescriptor(testRunnerPackageNames);
        this.myStopPackageDescriptor = new NodePackageDescriptor(stopPackageNames);
        LOG.warn("Deprecated constructor is still used by " + ((Object)((Object)this)).getClass());
    }

    protected JsTestRunConfigurationProducer(@NotNull List<String> testRunnerPackageNames, @NotNull List<String> stopPackageNames) {
        if (testRunnerPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (stopPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        this(new NodePackageDescriptor(testRunnerPackageNames), stopPackageNames);
    }

    protected JsTestRunConfigurationProducer(@NotNull NodePackageDescriptor testRunnerPackageDescriptor, @NotNull List<String> stopPackageNames) {
        if (testRunnerPackageDescriptor == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (stopPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        this.myTestRunnerPackageDescriptor = testRunnerPackageDescriptor;
        this.myStopPackageDescriptor = new NodePackageDescriptor(stopPackageNames);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean isTestRunnerPackageAvailableFor(@NotNull PsiElement element) {
        if (element == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        return JSTestRunnerManager.getInstance().findProducers(element).contains((Object)this);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean isTestRunnerPackageAvailableFor(@NotNull Project project, @Nullable VirtualFile fileOrDir) {
        PsiFileSystemItem element;
        if (project == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        return (element = PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)fileOrDir)) != null && this.isTestRunnerPackageAvailableFor((PsiElement)element);
    }

    protected boolean isTestRunnerPackageAvailableFor(@NotNull PsiElement element, @NotNull ConfigurationContext context) {
        RunConfiguration contextRunConfiguration;
        if (element == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if ((contextRunConfiguration = context.getOriginalConfiguration(this.getConfigurationType())) != null && contextRunConfiguration.getType().equals(this.getConfigurationType())) {
            return true;
        }
        return JSTestRunnerManager.getInstance().findProducers(element).contains((Object)this);
    }

    @NotNull
    NodePackageDescriptor getTestRunnerPackageDescriptor() {
        NodePackageDescriptor nodePackageDescriptor = this.myTestRunnerPackageDescriptor;
        if (nodePackageDescriptor == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        return nodePackageDescriptor;
    }

    @NotNull
    NodePackageDescriptor getStopPackageDescriptor() {
        NodePackageDescriptor nodePackageDescriptor = this.myStopPackageDescriptor;
        if (nodePackageDescriptor == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        return nodePackageDescriptor;
    }

    @Nullable
    public static VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull String contextFilePath) {
        String dirPath;
        if (project == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (contextFilePath == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmptyOrSpaces((String)(dirPath = PathUtil.getParentPath((String)contextFilePath)))) {
            return project.getBaseDir();
        }
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(dirPath);
        if (dir == null) {
            return project.getBaseDir();
        }
        Ref ref = Ref.create();
        PackageJsonUtil.processUpPackageJsonFiles(project, dir, (Processor<? super VirtualFile>)((Processor)packageJson -> {
            ref.set(packageJson);
            return false;
        }));
        VirtualFile packageJson2 = (VirtualFile)ref.get();
        VirtualFile result2 = packageJson2 != null ? packageJson2.getParent() : null;
        return (VirtualFile)ObjectUtils.notNull((Object)result2, (Object)dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerPackageNames";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPackageNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerPackageDescriptor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JsTestRunConfigurationProducer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JsTestRunConfigurationProducer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunnerPackageDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStopPackageDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isTestRunnerPackageAvailableFor";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "guessWorkingDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

