/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTestRunnerUtil {
    private static final String NAME_SEP = " ";

    private JSTestRunnerUtil() {
    }

    @NotNull
    public static String getTestPattern(@NotNull List<String> testNames, boolean suite) {
        if (testNames == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(0);
        }
        return JSTestRunnerUtil.getTestNamesPattern(Collections.singletonList(JSTestNamePattern.toLiteralList(testNames)), suite);
    }

    @NotNull
    public static String getTestsPattern(@NotNull Collection<List<String>> testNamesCollection, boolean suite) {
        if (testNamesCollection == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(1);
        }
        return JSTestRunnerUtil.getTestNamesPattern(ContainerUtil.map(testNamesCollection, JSTestNamePattern::toLiteralList), suite);
    }

    @NotNull
    public static String getTestNamesPattern(@NotNull Collection<List<JSTestNamePattern>> testNamesCollection, boolean suite) {
        List patterns;
        if (testNamesCollection == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(2);
        }
        if (testNamesCollection.size() > 1) {
            testNamesCollection = new LinkedHashSet<List<JSTestNamePattern>>(testNamesCollection);
        }
        if ((patterns = ContainerUtil.map(testNamesCollection, testFqn -> StringUtil.join((Collection)ContainerUtil.map((Collection)testFqn, name -> JSTestRunnerUtil.createPattern(name)), (String)NAME_SEP))).isEmpty()) {
            return "$^";
        }
        Object pattern = patterns.size() == 1 ? (String)patterns.get(0) : "(" + StringUtil.join((Collection)patterns, (String)"|") + ")";
        String string = "^" + (String)pattern + (suite ? NAME_SEP : "$");
        if (string == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String createPattern(@NotNull JSTestNamePattern namePattern) {
        if (namePattern == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(4);
        }
        StringBuilder builder = new StringBuilder();
        for (JSTestNamePattern.Range range : namePattern.getRanges()) {
            if (range instanceof JSTestNamePattern.Literal) {
                builder.append(JSTestRunnerUtil.escapeJavaScriptRegexp(((JSTestNamePattern.Literal)range).getLiteral()));
                continue;
            }
            builder.append(".*");
        }
        String string = builder.toString();
        if (string == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String escapeJavaScriptRegexp(@NotNull String str) {
        if (str == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(6);
        }
        return JSTestRunnerUtil.escapeJavaScriptRegexp(str, "\\.?*+^$[](){}|");
    }

    @NotNull
    public static String escapeJavaScriptRegexp(@NotNull String str, @NotNull String charsToEscape) {
        if (str == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(7);
        }
        if (charsToEscape == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < charsToEscape.length(); ++i) {
            char ch = charsToEscape.charAt(i);
            str = str.replace(String.valueOf(ch), "\\" + ch);
        }
        String string = str;
        if (string == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String buildTestNamesPattern(@NotNull Project project, @NotNull String testFilePath, @NotNull List<String> parsedTestNames, boolean suite) {
        List patterns;
        if (project == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(10);
        }
        if (testFilePath == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(11);
        }
        if (parsedTestNames == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(12);
        }
        if ((patterns = JSTestRunnerUtil.findTestNamesPatterns(project, testFilePath, parsedTestNames, suite)) == null) {
            patterns = JSTestNamePattern.toLiteralList(parsedTestNames);
        }
        return JSTestRunnerUtil.getTestNamesPattern(Collections.singletonList(patterns), suite);
    }

    @Nullable
    private static List<JSTestNamePattern> findTestNamesPatterns(@NotNull Project project, @NotNull String testFilePath, @NotNull List<String> parsedTestNames, boolean suite) {
        VirtualFile testFile;
        if (project == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(13);
        }
        if (testFilePath == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(14);
        }
        if (parsedTestNames == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(15);
        }
        if ((testFile = LocalFileSystem.getInstance().findFileByPath(testFilePath)) == null) {
            return null;
        }
        JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(testFile);
        if (psiFile instanceof JSFile) {
            JasmineFileStructure jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile);
            AbstractJasmineElement jasmineElement = jasmineFileStructure.findJasmineElement(parsedTestNames, null);
            return jasmineElement != null ? jasmineElement.getTestTreePathPatterns() : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNamesCollection";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JSTestRunnerUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsToEscape";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePath";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedTestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JSTestRunnerUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamesPattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPattern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeJavaScriptRegexp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestPattern";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTestsPattern";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamesPattern";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPattern";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "escapeJavaScriptRegexp";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildTestNamesPattern";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findTestNamesPatterns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

