/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonInstallTypesIntention
extends BaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"package.json.install.types.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        VirtualFile packageJson;
        JsonStringLiteral literal;
        if (project == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(1);
        }
        if ((literal = PackageJsonInstallTypesIntention.getModuleNameLiteral(editor, file2)) == null) {
            return false;
        }
        String packageName = literal.getValue();
        if (!TypeScriptDefinitionsUtils.isTypeDefinitionsInstallAvailable(packageName, packageJson = file2.getVirtualFile(), project)) {
            return false;
        }
        String typesPackageName = TypeScriptDefinitionsUtils.getTypingsPackageName(packageName);
        this.setText(JavaScriptBundle.message((String)"node.js.quickfix.install.node.module.text", (Object[])new Object[]{typesPackageName}));
        return true;
    }

    @Nullable
    private static JsonStringLiteral getModuleNameLiteral(@Nullable Editor editor, @Nullable PsiFile file2) {
        if (file2 == null || !PackageJsonUtil.isPackageJsonFile(file2) || editor == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        if (element instanceof LeafPsiElement) {
            element = element.getParent();
        }
        if (!(element instanceof JsonStringLiteral)) {
            return null;
        }
        JsonProperty property = (JsonProperty)ObjectUtils.tryCast((Object)element.getParent(), JsonProperty.class);
        if (property == null) {
            return null;
        }
        if (property.getNameElement() != element) {
            return null;
        }
        if (!PackageJsonUtil.isPackageDependencyProperty(property)) {
            return null;
        }
        return (JsonStringLiteral)element;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(2);
        }
        final JsonStringLiteral literal = PackageJsonInstallTypesIntention.getModuleNameLiteral(editor, file2);
        FileDocumentManager.getInstance().saveAllDocuments();
        if (literal == null) {
            return;
        }
        String value = literal.getValue();
        final String packageName = TypeScriptDefinitionsUtils.getTypingsPackageName(value);
        final NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        if (interpreter == null) {
            return;
        }
        final VirtualFile packageJson = file2.getVirtualFile();
        final VirtualFile parent = packageJson.getParent();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaScriptBundle.message((String)"progress.title.install", (Object[])new Object[]{packageName}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                AvailablePackageVersions versions;
                List<SemVer> allVersions;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((allVersions = (versions = NpmRegistryService.getInstance().getCachedOrFetchPackageVersions(indicator, packageName)).getVersions()).isEmpty()) {
                    return;
                }
                String expectedVersion = (String)ReadAction.compute(() -> PackageJsonInstallTypesIntention.getVersionUnderReadAction(literal, allVersions));
                String extraOptions = InstallNodeModuleQuickFix.buildExtraOptions(project, true);
                PackageManagementService.Listener listener2 = InstallNodeModuleQuickFix.createListener(project, packageJson, packageName);
                new PackageInstaller(project, interpreter, packageName, expectedVersion, new File(parent.getPath()), listener2, extraOptions).run(indicator);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{packageJson});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention$1", "run"));
            }
        });
    }

    @Nullable
    private static String getVersionUnderReadAction(@NotNull JsonStringLiteral literal, @NotNull List<SemVer> allVersions) {
        JsonProperty property;
        if (literal == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(3);
        }
        if (allVersions == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(4);
        }
        if ((property = (JsonProperty)ObjectUtils.tryCast((Object)literal.getParent(), JsonProperty.class)) == null) {
            return null;
        }
        JsonStringLiteral value = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (value == null) {
            return null;
        }
        String version = value.getValue();
        SemVer matchedVersion = TypeScriptDefinitionsUtils.getMatchedVersion(version, allVersions);
        return matchedVersion == null ? null : matchedVersion.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVersionUnderReadAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

