/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NamePrefixSearchQuery
extends NpmRegistryService.SearchQuery {
    private final String myBaseUrl;
    private final String myStartKey;
    private final String myEndKey;

    NamePrefixSearchQuery(@NotNull String prefix) {
        if (prefix == null) {
            NamePrefixSearchQuery.$$$reportNull$$$0(0);
        }
        super(prefix);
        this.myBaseUrl = prefix.startsWith("@") ? "https://replicate.npmjs.com" : "https://skimdb.npmjs.com";
        this.myStartKey = URLUtil.encodeURIComponent((String)("[\"" + prefix + "\"]"));
        this.myEndKey = URLUtil.encodeURIComponent((String)("[\"" + prefix + "z\",{}]"));
    }

    @Override
    @NotNull
    public String getQueryUrl(int from, int limit) {
        String string = this.myBaseUrl + "/registry/_design/app/_view/browseAll?group_level=2&skip=" + from + "&limit=" + limit + "&start_key=" + this.myStartKey + "&end_key=" + this.myEndKey;
        if (string == null) {
            NamePrefixSearchQuery.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public int getMaxQueryBatchSize() {
        return 10000;
    }

    @Override
    @NotNull
    public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
        if (content == null) {
            NamePrefixSearchQuery.$$$reportNull$$$0(2);
        }
        JsonReader reader = new JsonReader((Reader)new StringReader(content));
        List<NodePackageBasicInfo> list2 = new PrefixPackageListJsonReader(reader).read();
        List<NodePackageBasicInfo> list3 = list2;
        if (list3 == null) {
            NamePrefixSearchQuery.$$$reportNull$$$0(3);
        }
        return list3;
        finally {
            reader.close();
        }
    }

    public String toString() {
        return "'" + this.myText + "*' (Prefix)";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/NamePrefixSearchQuery";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NamePrefixSearchQuery";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PrefixPackageListJsonReader {
        private final JsonReader myReader;
        private final List<NodePackageBasicInfo> myResult;

        PrefixPackageListJsonReader(@NotNull JsonReader reader) {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(0);
            }
            this.myResult = new ArrayList<NodePackageBasicInfo>();
            this.myReader = reader;
        }

        @NotNull
        public List<NodePackageBasicInfo> read() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                List<NodePackageBasicInfo> list2 = Collections.emptyList();
                if (list2 == null) {
                    PrefixPackageListJsonReader.$$$reportNull$$$0(1);
                }
                return list2;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if ("rows".equals(name)) {
                    this.readPackagesInsideRows();
                    break;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
            List<NodePackageBasicInfo> list3 = this.myResult;
            if (list3 == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(2);
            }
            return list3;
        }

        private void readPackagesInsideRows() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                NodePackageBasicInfo info = PrefixPackageListJsonReader.readSinglePackage(this.myReader);
                if (info == null) continue;
                this.myResult.add(info);
            }
            this.myReader.endArray();
        }

        @Nullable
        private static NodePackageBasicInfo readSinglePackage(@NotNull JsonReader reader) throws IOException {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(3);
            }
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                reader.skipValue();
                return null;
            }
            reader.beginObject();
            NodePackageBasicInfo info = null;
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("key".equals(name)) {
                    info = PrefixPackageListJsonReader.readArrayInsideKey(reader);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return info;
        }

        @Nullable
        private static NodePackageBasicInfo readArrayInsideKey(@NotNull JsonReader reader) throws IOException {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(4);
            }
            if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                reader.skipValue();
                return null;
            }
            reader.beginArray();
            String name = null;
            String description = null;
            int i = 0;
            while (reader.hasNext()) {
                if (i < 2 && reader.peek() == JsonToken.STRING) {
                    String str = reader.nextString();
                    if (i == 0) {
                        name = str;
                    } else {
                        description = str;
                    }
                } else {
                    reader.skipValue();
                }
                ++i;
            }
            reader.endArray();
            return name != null ? new NodePackageBasicInfo(name, description) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/NamePrefixSearchQuery$PrefixPackageListJsonReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NamePrefixSearchQuery$PrefixPackageListJsonReader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readSinglePackage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readArrayInsideKey";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

