/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NpmPackageDescriptor
extends NodePackageDescriptor {
    private final boolean myProjectField;

    NpmPackageDescriptor(boolean projectField) {
        super("npm", "yarn", "pnpm");
        this.myProjectField = projectField;
    }

    @Override
    @NotNull
    public NodePackageRef createPackageRef(@NotNull String text) {
        if (text == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(0);
        }
        if (this.getPackageNames().contains(text) || "Project".equals(text)) {
            NodePackageRef nodePackageRef = NodePackageRef.create(text);
            if (nodePackageRef == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(1);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = super.createPackageRef(text);
        if (nodePackageRef == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(2);
        }
        return nodePackageRef;
    }

    @Override
    @NotNull
    public NodePackage createPackage(@NotNull String path) {
        NpmUtil.YarnSnapPackage yarnSnapPkg;
        if (path == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(3);
        }
        NodePackage nodePackage = (yarnSnapPkg = NpmUtil.YarnSnapPackage.createIfPathMatched(path)) != null ? yarnSnapPkg : super.createPackage(path);
        if (nodePackage == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(4);
        }
        return nodePackage;
    }

    @Override
    @NotNull
    public NodePackageRef dereferenceIfProjectRef(@NotNull Project project, @NotNull NodePackageRef ref) {
        if (project == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(5);
        }
        if (ref == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(6);
        }
        if (NpmUtil.isProjectPackageManagerPackageRef(ref)) {
            NodePackageRef nodePackageRef = NpmManager.getInstance(project).getPackageRef();
            if (nodePackageRef == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(7);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = ref;
        if (nodePackageRef == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(8);
        }
        return nodePackageRef;
    }

    @Override
    @NotNull
    public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(9);
        }
        ArrayList<NodePackageRef> result2 = new ArrayList<NodePackageRef>();
        if (!this.myProjectField) {
            result2.add(NpmUtil.createProjectPackageManagerPackageRef());
        }
        for (String pkgName : this.getPackageNames()) {
            result2.add(NodePackageRef.create(pkgName));
        }
        if (interpreter instanceof NodeJsLocalInterpreter) {
            String globalNodeModules;
            NodeJsLocalInterpreter localInterpreter = (NodeJsLocalInterpreter)interpreter;
            String bundledNodeModules = FileUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)localInterpreter.getNpmPackageDir()));
            VirtualFile dir = localInterpreter.getGlobalNodeModulesVirtualDir();
            String string = globalNodeModules = dir != null ? dir.getPath() : null;
            if (bundledNodeModules.equals(globalNodeModules)) {
                interpreter = null;
            }
        }
        List<NodePackageRef> refs = super.listPackageRefs(project, interpreter, contextFileOrDirectory);
        result2.addAll(refs);
        List<NodePackage> systemPackages = this.detectSystemWideInstallations((NodeJsLocalInterpreter)ObjectUtils.tryCast((Object)interpreter, NodeJsLocalInterpreter.class));
        for (NodePackage systemPkg : systemPackages) {
            NodePackageRef systemPkgRef = NodePackageRef.create(systemPkg);
            if (result2.contains(systemPkgRef)) continue;
            result2.add(systemPkgRef);
        }
        ArrayList<NodePackageRef> arrayList = result2;
        if (arrayList == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private List<NodePackage> listBrewInstallations(@NotNull String packageName) {
        if (packageName == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(11);
        }
        if (!SystemInfo.isUnix) {
            List<NodePackage> list2 = Collections.emptyList();
            if (list2 == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(12);
            }
            return list2;
        }
        String cellarDirPath = NpmPackageDescriptor.findCellarDirPath();
        File formulaDir = new File(cellarDirPath, packageName);
        if (!formulaDir.isDirectory()) {
            List<NodePackage> list3 = Collections.emptyList();
            if (list3 == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(13);
            }
            return list3;
        }
        File[] versions = (File[])ObjectUtils.notNull((Object)formulaDir.listFiles(), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY);
        ArrayList<NodePackage> result2 = new ArrayList<NodePackage>();
        for (File version : versions) {
            if (this.tryAdd(result2, new File(version, "libexec"))) continue;
            this.tryAdd(result2, new File(version, "libexec/lib/node_modules/" + packageName));
        }
        ArrayList<NodePackage> arrayList = result2;
        if (arrayList == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static String findCellarDirPath() {
        String cellarPath = EnvironmentUtil.getValue((String)"HOMEBREW_CELLAR");
        if (cellarPath == null) {
            cellarPath = SystemInfo.isLinux ? "/home/linuxbrew/.linuxbrew/Cellar" : "/usr/local/Cellar";
        }
        String string = cellarPath;
        if (string == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private List<NodePackage> detectSystemWideInstallations(@Nullable NodeJsLocalInterpreter interpreter) {
        ArrayList<NodePackage> result2 = new ArrayList<NodePackage>();
        if (SystemInfo.isWindows) {
            this.tryAdd(result2, new File("C:\\Program Files (x86)\\Yarn"));
            this.tryAdd(result2, new File("C:\\Program Files\\Yarn"));
        } else {
            this.tryAdd(result2, new File("/usr/share/yarn"));
            this.tryAdd(result2, new File("/opt/local/libexec/yarn"));
            result2.addAll(this.listBrewInstallations("yarn"));
            result2.addAll(this.listBrewInstallations("pnpm"));
        }
        if (interpreter != null && interpreter.isSnapInstallation()) {
            ContainerUtil.addIfNotNull(result2, (Object)NpmUtil.YarnSnapPackage.createIfInstalled());
        }
        ArrayList<NodePackage> arrayList = result2;
        if (arrayList == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private boolean tryAdd(@NotNull List<NodePackage> packages, @NotNull File packageDir2) {
        File packageJson;
        if (packages == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(17);
        }
        if (packageDir2 == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(18);
        }
        if (packageDir2.isDirectory() && (packageJson = new File(packageDir2, "package.json")).isFile()) {
            packages.add(this.createPackage(packageDir2.getAbsolutePath()));
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmPackageDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmPackageDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dereferenceIfProjectRef";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "listPackageRefs";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "listBrewInstallations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findCellarDirPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "detectSystemWideInstallations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPackageRef";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPackage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceIfProjectRef";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "listPackageRefs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listBrewInstallations";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryAdd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

