/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.google.common.collect.ImmutableMap;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesIndexingRulesProvider;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpResolvedDependencyTree;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpSyntheticLibrary;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspaceList;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class YarnPnpWorkspace {
    private final String myLocation;
    private final ImmutableMap<String, YarnPnpDependency> myDeps;
    private final NotNullLazyValue<YarnPnpResolvedDependencyTree> myResolvedDependencyTreeValue;
    private volatile String myLibraryName;
    private YarnPnpWorkspaceList myWorkspaceList;

    private YarnPnpWorkspace(@NotNull String location, @Nullable String libraryName, @NotNull Map<String, YarnPnpDependency> deps) {
        if (location == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(0);
        }
        if (deps == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(1);
        }
        this.myResolvedDependencyTreeValue = NotNullLazyValue.atomicLazy(() -> (YarnPnpResolvedDependencyTree)ReadAction.compute(() -> YarnPnpResolvedDependencyTree.create(this)));
        this.myLocation = location;
        this.myLibraryName = libraryName;
        this.myDeps = ImmutableMap.copyOf(deps);
    }

    @NotNull
    String getLocation() {
        String string = this.myLocation;
        if (string == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    String getLibraryName() {
        return this.myLibraryName;
    }

    @NotNull
    ImmutableMap<String, YarnPnpDependency> getDeps() {
        ImmutableMap<String, YarnPnpDependency> immutableMap = this.myDeps;
        if (immutableMap == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(3);
        }
        return immutableMap;
    }

    boolean isVirtualResolved() {
        return this.myWorkspaceList.isVirtualResolved();
    }

    @NotNull
    public YarnPnpResolvedDependencyTree getResolvedDependencyTree() {
        YarnPnpResolvedDependencyTree yarnPnpResolvedDependencyTree = (YarnPnpResolvedDependencyTree)this.myResolvedDependencyTreeValue.getValue();
        if (yarnPnpResolvedDependencyTree == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(4);
        }
        return yarnPnpResolvedDependencyTree;
    }

    @Nullable
    public YarnPnpSyntheticLibrary createLibrary(@NotNull YarnPnpFile pnpFile) {
        if (pnpFile == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(5);
        }
        ArrayList<VirtualFile> roots2 = new ArrayList<VirtualFile>();
        NodeModulesIndexingRulesProvider indexingRulesProvider = NodeModulesIndexingRulesProvider.Companion.getManager(pnpFile.getProject());
        for (YarnPnpResolvedDependencyTree.ResolvedDependency resolvedDependency : this.getResolvedDependencyTree().getResolvedDependencies()) {
            VirtualFile dependencyRoot;
            if (!this.isDependencyIndexed(indexingRulesProvider, resolvedDependency.getDependency()) || (dependencyRoot = resolvedDependency.getDependencyRoot()) == null || !this.shouldBeAddedAsLibraryRoot(dependencyRoot, resolvedDependency.getLocation(), pnpFile.getProject())) continue;
            roots2.add(dependencyRoot);
        }
        return !roots2.isEmpty() ? new YarnPnpSyntheticLibrary(pnpFile, this, this.myLibraryName, roots2) : null;
    }

    private boolean shouldBeAddedAsLibraryRoot(@NotNull VirtualFile dependencyLocationFile, @NotNull String dependencyLocationPath, @NotNull Project project) {
        if (dependencyLocationFile == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(6);
        }
        if (dependencyLocationPath == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(7);
        }
        if (project == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(8);
        }
        if (this.myWorkspaceList.isWorkspaceLocation(dependencyLocationPath)) {
            return false;
        }
        if (JSLibraryUtil.hasDirectoryInPath(dependencyLocationFile, new String[]{".yarn"}, null)) {
            return true;
        }
        return !NodeModulesDirectoryManager.getInstance(project).isUnderContentRoots(dependencyLocationFile);
    }

    public boolean isDependencyIndexed(@NotNull NodeModulesIndexingRulesProvider indexingRulesProvider, @NotNull YarnPnpDependency dependency) {
        if (indexingRulesProvider == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(9);
        }
        if (dependency == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(10);
        }
        return indexingRulesProvider.isDependencyIndexed(dependency.getName());
    }

    public void calcLibraryName(@NotNull Project project) {
        if (project == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(11);
        }
        ReadAction.run(() -> {
            this.myLibraryName = this.findLibraryName(project);
        });
    }

    @NotNull
    private String findLibraryName(@NotNull Project project) {
        Object locationPresentablePath;
        if (project == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(12);
        }
        if (!((String)(locationPresentablePath = this.getLocationPresentablePath(project))).isEmpty()) {
            locationPresentablePath = (String)locationPresentablePath + "/";
        }
        String string = "Dependencies from " + (String)locationPresentablePath + "package.json";
        if (string == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String getLocationPresentablePath(@NotNull Project project) {
        VirtualFile location;
        if (project == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(14);
        }
        if ((location = LocalFileSystem.getInstance().findFileByPath(this.myLocation)) != null) {
            String string = JsbtUtil.getRelativePath(project, location, false);
            if (string == null) {
                YarnPnpWorkspace.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)this.myLocation);
        if (string == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    VirtualFile findPackageJson() {
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(this.myLocation);
        return PackageJsonUtil.findChildPackageJsonFile(root);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YarnPnpWorkspace other = (YarnPnpWorkspace)o;
        return this.myLocation.equals(other.myLocation) && Objects.equals(this.myLibraryName, other.myLibraryName) && this.myDeps.equals(other.myDeps);
    }

    public int hashCode() {
        return Objects.hash(this.myLocation, this.myLibraryName, this.myDeps);
    }

    public String toString() {
        return "deps=" + this.myDeps.values();
    }

    void setWorkspaceList(@NotNull YarnPnpWorkspaceList workspaceList) {
        if (workspaceList == null) {
            YarnPnpWorkspace.$$$reportNull$$$0(17);
        }
        this.myWorkspaceList = workspaceList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpWorkspace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyLocationFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyLocationPath";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingRulesProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpWorkspace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedDependencyTree";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findLibraryName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationPresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeAddedAsLibraryRoot";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyIndexed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcLibraryName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocationPresentablePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setWorkspaceList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private String myLocation;
        private String myLibraryName;
        private final LinkedHashMap<String, YarnPnpDependency> myDeps = new LinkedHashMap();

        public void setLocation(@NotNull String location) {
            if (location == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myLocation = location;
        }

        public void setLibraryName(@NotNull String libraryName) {
            if (libraryName == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myLibraryName = libraryName;
        }

        public void addDependency(@NotNull String name, @NotNull String requireableLocation, @Nullable String requireableLocationWithVirtualResolved) {
            if (name == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (requireableLocation == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myDeps.put(name, new YarnPnpDependency(name, requireableLocation, requireableLocationWithVirtualResolved));
        }

        @NotNull
        public YarnPnpWorkspace build() {
            return new YarnPnpWorkspace(this.myLocation, this.myLibraryName, this.myDeps);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requireableLocation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpWorkspace$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLocation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLibraryName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDependency";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

