/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryUtil;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesSnapshot;
import com.intellij.javascript.nodejs.library.core.NodeTypingsDownloadSession;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreSyntheticLibraryProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(0);
        }
        SyntheticLibrary library = NodeCoreSyntheticLibraryProvider.getSyntheticLibrary(project);
        List list2 = ContainerUtil.createMaybeSingletonList((Object)library);
        if (list2 == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    public static SyntheticLibrary getSyntheticLibrary(@NotNull Project project) {
        if (project == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List<VirtualFile> coreModuleFiles = NodeCoreLibraryConfigurator.getInstance((Project)project).myTestCoreModuleFiles;
            if (coreModuleFiles == null) {
                return null;
            }
            return SyntheticLibrary.newImmutableLibrary(coreModuleFiles);
        }
        NodeCoreLibraryConfigurator.NodeLibraryVersion version = NodeCoreLibraryConfigurator.getConfiguredCoreLibraryVersion(project);
        if (version == null) {
            return null;
        }
        NodeCoreLibraryManager coreLibraryManager = NodeCoreLibraryManager.getInstance(project);
        NodeCoreSourcesSnapshot snapshot = coreLibraryManager.getSnapshot();
        if (snapshot == null) {
            return null;
        }
        if (!coreLibraryManager.hasAssociatedRoots()) {
            return null;
        }
        SyntheticLibrary library = NodeCoreSyntheticLibraryProvider.createLibrary(version, snapshot);
        return new NodeCoreSyntheticLibrary(project, version.getNodeVersion().getRawVersion(), library);
    }

    @NotNull
    private static SyntheticLibrary createLibrary(@NotNull NodeCoreLibraryConfigurator.NodeLibraryVersion version, @NotNull NodeCoreSourcesSnapshot snapshot) {
        if (version == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(3);
        }
        if (snapshot == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(4);
        }
        Set<VirtualFile> excluded = NodeCoreSyntheticLibraryProvider.getExcludedSources(snapshot);
        ArrayList<VirtualFile> sourceRoots = new ArrayList<VirtualFile>(NodeCoreSyntheticLibraryProvider.getPredefinedNodeLibraryFiles(version));
        ContainerUtil.addAllNotNull(sourceRoots, (Object[])new VirtualFile[]{snapshot.getCoreModulesSrcDir()});
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(sourceRoots, excluded, null);
        if (syntheticLibrary == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(5);
        }
        return syntheticLibrary;
    }

    @NotNull
    private static List<VirtualFile> getPredefinedNodeLibraryFiles(@NotNull NodeCoreLibraryConfigurator.NodeLibraryVersion version) {
        VirtualFile typesNodePackageDir;
        if (version == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(6);
        }
        if (NodeCoreLibraryManager.shouldUseNodeTypings() && (typesNodePackageDir = NodeTypingsDownloadSession.findNodeTypingsPackageDir(version)) != null) {
            List<VirtualFile> list2 = Collections.singletonList(typesNodePackageDir.getParent());
            if (list2 == null) {
                NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(7);
            }
            return list2;
        }
        return new ArrayList<VirtualFile>(NodeCoreLibraryUtil.getNodeGlobalStubFiles());
    }

    @NotNull
    private static Set<VirtualFile> getExcludedSources(@NotNull NodeCoreSourcesSnapshot snapshot) {
        VirtualFile coreModulesSrcDir;
        if (snapshot == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(8);
        }
        if (!(coreModulesSrcDir = snapshot.getCoreModulesSrcDir()).isValid()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(9);
            }
            return set;
        }
        HashSet excluded = ContainerUtil.newHashSet((Object[])VfsUtil.getChildren((VirtualFile)coreModulesSrcDir));
        Set<VirtualFile> filesToIndex = snapshot.getFilesToIndex();
        excluded.removeAll(filesToIndex);
        HashSet hashSet = excluded;
        if (hashSet == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedNodeLibraryFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticLibrary";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedNodeLibraryFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeCoreSyntheticLibrary
    extends SyntheticLibrary
    implements ItemPresentation,
    NavigatableWithText {
        private final Project myProject;
        private final String myVersion;
        private final SyntheticLibrary myDelegate;

        NodeCoreSyntheticLibrary(@NotNull Project project, @NotNull String version, @NotNull SyntheticLibrary delegate) {
            if (project == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(0);
            }
            if (version == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(1);
            }
            if (delegate == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myVersion = version;
            this.myDelegate = delegate;
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            Collection collection = this.myDelegate.getSourceRoots();
            if (collection == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        public Collection<VirtualFile> getBinaryRoots() {
            Collection collection = this.myDelegate.getBinaryRoots();
            if (collection == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @NotNull
        public Set<VirtualFile> getExcludedRoots() {
            Set set = this.myDelegate.getExcludedRoots();
            if (set == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(5);
            }
            return set;
        }

        @Nullable
        public Condition<VirtualFile> getExcludeFileCondition() {
            return this.myDelegate.getExcludeFileCondition();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            return this.myDelegate.equals((Object)((NodeCoreSyntheticLibrary)((Object)o)).myDelegate);
        }

        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        @Nullable
        public String getPresentableText() {
            return "Node.js Core";
        }

        @Nullable
        public String getLocationString() {
            return this.myVersion;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return JavaScriptLanguageIcons.Nodejs.Nodejs;
        }

        public void navigate(boolean requestFocus) {
            NodeSettingsConfigurable.showSettingsDialog(this.myProject);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return JavaScriptBundle.message((String)"node.core.navigate_action_text.text", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider$NodeCoreSyntheticLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider$NodeCoreSyntheticLibrary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceRoots";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinaryRoots";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExcludedRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

