/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.google.common.collect.ImmutableSet;
import com.intellij.ProjectTopics;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryChecker;
import com.intellij.javascript.nodejs.library.NodeModulesLibrariesSnapshot;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.javascript.nodejs.library.NodeModulesPackageJsonListener;
import com.intellij.javascript.nodejs.library.NodeModulesRequestMerger;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonUpdateNotifier;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeModulesDirectoryManager", storages={@Storage(value="$CACHE_FILE$")})
public final class NodeModulesDirectoryManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(NodeModulesDirectoryManager.class);
    private static final String HANDLED_PATH = "handled-path";
    private final Project myProject;
    private final Set<VirtualFile> myHandledNodeModulesDirs;
    private final Map<VirtualFile, Options> myNodeModulesDirsToOptions;
    private final CachedValue<Set<VirtualFile>> myProjectModelExcludedDirsCache;
    private final CachedValue<Set<VirtualFile>> myContentRootsCachedValue;
    private final AtomicReference<NodeModulesLibrariesSnapshot> mySnapshotRef;
    private final Map<VirtualFile, PackageJsonData> myDataByPackageJsonMap;
    private final ProjectFileIndex myFileIndex;
    private final RecursionGuard<NodeModulesDirectoryManager> myRecursionGuard;
    private final PackageJsonUpdateNotifier myPackageJsonUpdateNotifier;
    private final PackageJsonFileManager myPackageJsonFileManager;
    private List<Runnable> myTestQueue;
    private final Object myTestQueueLock;
    private final List<NodeModulesPackageJsonListener> myNodeModulesPackageJsonListeners;
    private final SimpleModificationTracker myNodeModulesDirChangeTracker;
    private JSLibraryManager myLibraryManager;
    private final NodeModulesDirectoryChecker myDirectoryChecker;

    public NodeModulesDirectoryManager(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(0);
        }
        this.myHandledNodeModulesDirs = ContainerUtil.newConcurrentSet();
        this.myNodeModulesDirsToOptions = new ConcurrentHashMap<VirtualFile, Options>();
        this.mySnapshotRef = new AtomicReference();
        this.myDataByPackageJsonMap = new ConcurrentHashMap<VirtualFile, PackageJsonData>();
        this.myRecursionGuard = RecursionManager.createGuard((String)this.getClass().getName());
        this.myTestQueueLock = new Object();
        this.myNodeModulesPackageJsonListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myNodeModulesDirChangeTracker = new SimpleModificationTracker();
        this.myDirectoryChecker = new NodeModulesDirectoryChecker();
        this.myProject = project;
        this.myFileIndex = ProjectFileIndex.getInstance((Project)project);
        this.myPackageJsonFileManager = PackageJsonFileManager.getInstance(project);
        this.myPackageJsonUpdateNotifier = PackageJsonUpdateNotifier.getInstance(project);
        this.myProjectModelExcludedDirsCache = NodeModulesDirectoryManager.createProjectModelExcludedDirsCache(project);
        this.myContentRootsCachedValue = NodeModulesDirectoryManager.createContentRootsCachedValue(project);
        if (!this.myProject.isDefault()) {
            final NodeModulesRequestMerger rootsChangedMerger = new NodeModulesRequestMerger(this, Alarm.ThreadToUse.POOLED_THREAD, 100L, () -> this.rootsChanged());
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    rootsChangedMerger.request();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$1", "rootsChanged"));
                }
            });
            VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new MyFileListener(), (Disposable)this);
            this.addNodeModulesPackageJsonListener((pkgName, file2, modType) -> this.myNodeModulesDirChangeTracker.incModificationCount(), null);
        }
    }

    @NotNull
    private static CachedValue<Set<VirtualFile>> createProjectModelExcludedDirsCache(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(1);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Set excluded = (Set)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return Collections.emptySet();
                }
                HashSet dirs = new HashSet();
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    ContainerUtil.addAll(dirs, (Object[])ModuleRootManager.getInstance((Module)module).getExcludeRoots());
                }
                return dirs;
            });
            return CachedValueProvider.Result.create((Object)excluded, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }, false);
        if (cachedValue == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(2);
        }
        return cachedValue;
    }

    @NotNull
    private static CachedValue<Set<VirtualFile>> createContentRootsCachedValue(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(3);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Set excluded = (Set)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return Collections.emptySet();
                }
                return ImmutableSet.copyOf((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots());
            });
            return CachedValueProvider.Result.create((Object)excluded, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }, false);
        if (cachedValue == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(4);
        }
        return cachedValue;
    }

    protected void rootsChanged() {
        this.myPackageJsonFileManager.rootsChanged();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            Set excluded = (Set)this.myProjectModelExcludedDirsCache.getValue();
            SmartList toRemove = new SmartList();
            for (VirtualFile dir : this.myHandledNodeModulesDirs) {
                if (!dir.isValid()) {
                    toRemove.add(Pair.create((Object)dir, (Object)"invalid directory"));
                    continue;
                }
                VirtualFile contentRoot = JSLibraryUtil.getContentRootForFile(this.myFileIndex, dir);
                Options options = this.myNodeModulesDirsToOptions.get(dir);
                if (options != null && options.isEnabledOutsideOfContentRoots()) continue;
                if (contentRoot == null) {
                    toRemove.add(Pair.create((Object)dir, (Object)"out of content roots"));
                    continue;
                }
                if (dir.equals(contentRoot)) {
                    toRemove.add(Pair.create((Object)dir, (Object)"no library if node_modules is a content root"));
                    continue;
                }
                VirtualFile parent = dir.getParent();
                if ((parent == null || !this.myFileIndex.isExcluded(parent)) && !excluded.contains(dir)) continue;
                toRemove.add(Pair.create((Object)dir, (Object)"under excluded roots"));
            }
            if (!toRemove.isEmpty()) {
                for (Pair info : toRemove) {
                    this.myHandledNodeModulesDirs.remove(info.first);
                    LOG.info("Removed " + ((VirtualFile)info.first).getPath() + ": " + (String)info.second);
                }
                this.resetSnapshot();
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ApplicationManager.getApplication().invokeLater(() -> this.requestLibrariesUpdate(), this.myProject.getDisposed());
                } else {
                    this.requestLibrariesUpdate();
                }
            }
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public NodeModulesDirectoryChecker getChecker() {
        NodeModulesDirectoryChecker nodeModulesDirectoryChecker = this.myDirectoryChecker;
        if (nodeModulesDirectoryChecker == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(6);
        }
        return nodeModulesDirectoryChecker;
    }

    @NotNull
    public ModificationTracker getNodeModulesDirChangeTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myNodeModulesDirChangeTracker;
        if (simpleModificationTracker == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(7);
        }
        return simpleModificationTracker;
    }

    @Nullable
    public <T> T computeFileIndexExtensionPreventingRecursion(@NotNull Computable<T> computation) {
        Object result2;
        if (computation == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(8);
        }
        if ((result2 = this.myRecursionGuard.doPreventingRecursion((Object)this, false, computation)) == null) {
            LOG.error(new Throwable("Recursion prevented when computing FileIndex extension"));
        }
        return (T)result2;
    }

    @NotNull
    public static NodeModulesDirectoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(9);
        }
        NodeModulesDirectoryManager nodeModulesDirectoryManager = (NodeModulesDirectoryManager)ServiceManager.getService((Project)project, NodeModulesDirectoryManager.class);
        if (nodeModulesDirectoryManager == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(10);
        }
        return nodeModulesDirectoryManager;
    }

    @NotNull
    public Element getState() {
        Element root = new Element("x");
        ArrayList<String> paths = new ArrayList<String>();
        for (VirtualFile file2 : this.myHandledNodeModulesDirs) {
            if (!file2.isValid()) continue;
            paths.add(file2.getPath());
        }
        Collections.sort(paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)HANDLED_PATH, paths);
        Element element = root;
        if (element == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(11);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(12);
        }
        ArrayList<String> paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)HANDLED_PATH);
        paths = new ArrayList<String>(paths);
        NodeModulesDirectoryManager.removeNestedNodeModulesPaths(paths);
        this.myHandledNodeModulesDirs.clear();
        for (String path : paths) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null || !file2.isValid() || !NodeModulesDirectoryManager.isNodeModulesDir(file2)) continue;
            this.myHandledNodeModulesDirs.add(file2);
        }
    }

    public void addNodeModulesPackageJsonListener(final @NotNull NodeModulesPackageJsonListener listener2, @Nullable Disposable disposable) {
        if (listener2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(13);
        }
        this.myNodeModulesPackageJsonListeners.add(listener2);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    NodeModulesDirectoryManager.this.removeNodeModulesPackageJsonListener(listener2);
                }
            });
        }
    }

    public void removeNodeModulesPackageJsonListener(@NotNull NodeModulesPackageJsonListener listener2) {
        if (listener2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(14);
        }
        this.myNodeModulesPackageJsonListeners.remove(listener2);
    }

    private static void removeNestedNodeModulesPaths(@NotNull List<String> paths) {
        if (paths == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(15);
        }
        Collections.sort(paths);
        String prevPath = null;
        Iterator<String> i = paths.iterator();
        while (i.hasNext()) {
            String path = i.next();
            if (prevPath != null && path.startsWith(prevPath)) {
                LOG.warn("Removing descendant " + path);
                i.remove();
                continue;
            }
            prevPath = StringUtil.trimEnd((String)path, (String)"/") + "/";
        }
    }

    @NotNull
    public List<NodeModulesLibraryDirectory> getNodeModulesDirectories() {
        List list2 = ContainerUtil.filter(this.getOrCreateSnapshot().getLibraryDirs(), dir -> dir.getNodeModulesDir().isValid());
        if (list2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(16);
        }
        return list2;
    }

    public boolean isNodeModulesLibraryDirWithMappings(@NotNull VirtualFile nodeModulesDir) {
        NodeModulesLibraryDirectory dir;
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(17);
        }
        return (dir = this.getOrCreateSnapshot().findLibraryDir(nodeModulesDir)) != null && !dir.isForApplicationSourceCode() && this.isLibraryWithMappings(dir);
    }

    public boolean isLibraryWithMappings(@NotNull NodeModulesLibraryDirectory libraryDirectory) {
        JSLibraryMappings mappings;
        if (libraryDirectory == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(18);
        }
        return !(mappings = this.getLibraryMappings()).getMappingsByLibraryName(libraryDirectory.getLibraryName()).isEmpty();
    }

    @NotNull
    private JSLibraryMappings getLibraryMappings() {
        JSLibraryMappings jSLibraryMappings = (JSLibraryMappings)this.getLibraryManager().getLibraryMappings();
        if (jSLibraryMappings == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(19);
        }
        return jSLibraryMappings;
    }

    @Contract(value="null -> false")
    public static boolean isNodeModulesDir(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && NodeModulesDirectoryManager.isNodeModulesDirName(dir.getNameSequence());
    }

    private static boolean isNodeModulesDirName(@Nullable CharSequence fileName) {
        return fileName != null && StringUtil.equals((CharSequence)"node_modules", (CharSequence)fileName);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public void onProjectOpened() {
    }

    @Nullable
    private VirtualFile findTopLevelNodeModulesDirInsideContentRoots(@Nullable VirtualFile nodeModulesDir) {
        VirtualFile result2 = null;
        while (nodeModulesDir != null && this.myFileIndex.getContentRootForFile(nodeModulesDir, false) != null) {
            result2 = nodeModulesDir;
            nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(nodeModulesDir);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryAddLibrariesOnBackgroundThread(@NotNull List<VirtualFile> nodeModulesDirs, @NotNull Options options) {
        if (nodeModulesDirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(20);
        }
        if (options == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(21);
        }
        SmartList dirsToProcess = new SmartList();
        for (VirtualFile nodeModulesDir : nodeModulesDirs) {
            if (!this.myHandledNodeModulesDirs.add(nodeModulesDir)) continue;
            this.myNodeModulesDirsToOptions.put(nodeModulesDir, options);
            dirsToProcess.add(nodeModulesDir);
        }
        if (dirsToProcess.isEmpty()) {
            return;
        }
        this.resetSnapshot();
        NodeModulesLibrariesSnapshot snapshot = this.getOrCreateSnapshot();
        Application application = ApplicationManager.getApplication();
        for (VirtualFile dir : dirsToProcess) {
            NodeModulesLibraryDirectory libraryDir = snapshot.findLibraryDir(dir);
            if (libraryDir == null) continue;
            ReadAction.run(() -> libraryDir.getLibrary());
        }
        Runnable task = () -> this.lambda$tryAddLibrariesOnBackgroundThread$12((List)dirsToProcess, snapshot);
        if (application.isUnitTestMode()) {
            boolean done = false;
            Object object = this.myTestQueueLock;
            synchronized (object) {
                if (this.myTestQueue != null) {
                    this.myTestQueue.add(task);
                    done = true;
                }
            }
            if (!done) {
                if (application.isDispatchThread()) {
                    task.run();
                } else if (application.isReadAccessAllowed()) {
                    application.invokeLater(task);
                } else {
                    application.invokeAndWait(task);
                }
            }
        } else {
            application.invokeLaterOnWriteThread(task, ModalityState.defaultModalityState(), this.myProject.getDisposed());
        }
    }

    @NotNull
    private NodeModulesLibrariesSnapshot getOrCreateSnapshot() {
        NodeModulesLibrariesSnapshot snapshot = this.mySnapshotRef.get();
        while (snapshot == null) {
            snapshot = new NodeModulesLibrariesSnapshot(this, this.myHandledNodeModulesDirs, this.myPackageJsonFileManager.getValidPackageJsonFiles());
            this.mySnapshotRef.compareAndSet(null, snapshot);
            snapshot = this.mySnapshotRef.get();
        }
        NodeModulesLibrariesSnapshot nodeModulesLibrariesSnapshot = snapshot;
        if (nodeModulesLibrariesSnapshot == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(22);
        }
        return nodeModulesLibrariesSnapshot;
    }

    public void setProvidedPackageJsonRoots(@NotNull VirtualFile packageJson, @NotNull PackageJsonData data) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(23);
        }
        if (data == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(24);
        }
        this.myDataByPackageJsonMap.put(packageJson, data);
    }

    private void handleAddingPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(25);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson)) {
            this.myPackageJsonFileManager.onPackageJsonAdded(packageJson, !this.myHandledNodeModulesDirs.isEmpty());
            this.myPackageJsonUpdateNotifier.onPackageJsonUpdated(packageJson, this.myFileIndex);
            this.handleNodeModulesPackageJsonChange(packageJson, NodeModulesPackageJsonListener.ChangeType.ADDED);
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            if (nodeModulesDir != null && nodeModulesDir.isValid()) {
                this.handleAddingNodeModulesDir(nodeModulesDir);
            }
        }
    }

    private void handleRemovingPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(26);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson)) {
            this.doRemovePackageJson(packageJson, null);
        }
    }

    private void doRemovePackageJson(@NotNull VirtualFile packageJson, @Nullable VirtualFile packageJsonParent) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(27);
        }
        this.myPackageJsonFileManager.onPackageJsonRemoved(packageJson);
        this.handleNodeModulesPackageJsonChange(packageJson, NodeModulesPackageJsonListener.ChangeType.REMOVED);
        if (this.myDataByPackageJsonMap.remove(packageJson) != null) {
            VirtualFile nodeModulesDir;
            VirtualFile virtualFile = nodeModulesDir = packageJsonParent != null ? NodeModuleUtil.findChildNodeModulesDir(packageJsonParent) : NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            if (nodeModulesDir != null && nodeModulesDir.isValid()) {
                LOG.info("Removing node_modules library as " + packageJson.getPath() + " removed");
                this.myHandledNodeModulesDirs.remove(nodeModulesDir);
                this.resetSnapshot();
                this.requestLibrariesUpdate();
            }
        }
    }

    private void handlePackageJsonContentChanged(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(28);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson) && !this.myProject.isDisposed()) {
            PackageJsonData newData;
            PackageJsonData oldData;
            this.myPackageJsonFileManager.onPackageJsonContentChanged(packageJson);
            this.myPackageJsonUpdateNotifier.onPackageJsonUpdated(packageJson, this.myFileIndex);
            this.handleNodeModulesPackageJsonChange(packageJson, NodeModulesPackageJsonListener.ChangeType.CONTENT_CHANGED);
            NodeModulesLibrariesSnapshot snapshot = this.mySnapshotRef.get();
            if (snapshot != null) {
                snapshot.onPackageJsonFileChanged(packageJson);
            }
            if ((oldData = this.myDataByPackageJsonMap.get(packageJson)) != null && !(newData = PackageJsonData.getOrCreate(packageJson)).getAllDependencies().equals(oldData.getAllDependencies())) {
                LOG.info("Updating node_modules library as " + packageJson.getPath() + " changed");
                this.myDataByPackageJsonMap.put(packageJson, newData);
                this.requestLibrariesUpdate();
            }
        }
    }

    private void handleNodeModulesPackageJsonChange(VirtualFile packageJson, NodeModulesPackageJsonListener.ChangeType changeType) {
        String packageName = NodeModuleUtil.inferNodeModulePackageName(packageJson);
        if (packageName != null) {
            for (NodeModulesPackageJsonListener listener2 : this.myNodeModulesPackageJsonListeners) {
                try {
                    listener2.onPackageJsonChanged(packageName, packageJson, changeType);
                }
                catch (ProcessCanceledException ex) {
                    LOG.error("Listener " + listener2 + " invoked code, which threw ProcessCanceledException.Listeners should not invoke long running operations on notification thread.", (Throwable)ex);
                }
                catch (RuntimeException ex) {
                    LOG.error("Listener " + listener2 + " failed to process notification: " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void handleAddingNodeModulesDir(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(29);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(file2) && !this.myProject.isDisposed()) {
            this.addNodeModulesDir(file2);
        }
    }

    public void addNodeModulesDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(30);
        }
        this.addNodeModulesDirs(List.of(nodeModulesDir));
    }

    public void addNodeModulesDirs(@NotNull List<VirtualFile> nodeModulesDirs) {
        if (nodeModulesDirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(31);
        }
        this.addNodeModulesDirs(nodeModulesDirs, Options.DEFAULT);
    }

    public void addNodeModulesDirs(@NotNull List<VirtualFile> nodeModulesDirs, @NotNull Options options) {
        List filtered;
        if (nodeModulesDirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(32);
        }
        if (options == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(33);
        }
        if (!(filtered = ContainerUtil.filter(nodeModulesDirs, nodeModulesDir -> this.canAddNodeModulesDir((VirtualFile)nodeModulesDir, options))).isEmpty()) {
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || !application.isDispatchThread()) {
                this.tryAddLibrariesOnBackgroundThread(filtered, options);
            } else {
                application.executeOnPooledThread(() -> this.tryAddLibrariesOnBackgroundThread(filtered, options));
            }
        }
    }

    public boolean canAddNodeModulesDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(34);
        }
        return this.canAddNodeModulesDir(nodeModulesDir, Options.DEFAULT);
    }

    public boolean canAddNodeModulesDir(@NotNull VirtualFile nodeModulesDir, @NotNull Options options) {
        VirtualFile contentRoot;
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(35);
        }
        if (options == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(36);
        }
        if (!nodeModulesDir.isValid()) {
            return false;
        }
        if (options.isEnabledOutsideOfContentRoots()) {
            return true;
        }
        VirtualFile topLevelNodeModulesDir = this.findTopLevelNodeModulesDirInsideContentRoots(nodeModulesDir);
        if (topLevelNodeModulesDir != null && nodeModulesDir.equals(topLevelNodeModulesDir) && this.myFileIndex.isInContent(nodeModulesDir) && !this.myFileIndex.isInLibrary(nodeModulesDir) && (contentRoot = this.myFileIndex.getContentRootForFile(nodeModulesDir, false)) != null && !topLevelNodeModulesDir.equals(contentRoot)) {
            return !this.myDirectoryChecker.isForApplicationSourceCode(nodeModulesDir);
        }
        return false;
    }

    public boolean isAdded(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(37);
        }
        return this.myHandledNodeModulesDirs.contains(nodeModulesDir);
    }

    private void handleRemovingNodeModulesDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(38);
        }
        if (this.myHandledNodeModulesDirs.remove(nodeModulesDir)) {
            this.resetSnapshot();
            this.requestLibrariesUpdate();
        }
    }

    public void resetSnapshot() {
        this.mySnapshotRef.set(null);
    }

    public void requestLibrariesUpdate() {
        this.getLibraryManager().scheduleCommitChanges();
    }

    @NotNull
    private JSLibraryManager getLibraryManager() {
        JSLibraryManager libraryManager = this.myLibraryManager;
        if (libraryManager == null) {
            this.myLibraryManager = libraryManager = (JSLibraryManager)((Object)ReadAction.compute(() -> JSLibraryManager.getInstance(this.myProject)));
        }
        JSLibraryManager jSLibraryManager = libraryManager;
        if (jSLibraryManager == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(39);
        }
        return jSLibraryManager;
    }

    public boolean isUnderContentRoots(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(40);
        }
        return VfsUtilCore.isUnder((VirtualFile)file2, (Set)((Set)this.myContentRootsCachedValue.getValue()));
    }

    public void dispose() {
    }

    @Nullable
    private NodeModulesLibraryDirectory findUpNodeModules(@NotNull VirtualFile file2) {
        NodeModulesLibrariesSnapshot snapshot;
        if (file2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(41);
        }
        return (snapshot = this.mySnapshotRef.get()) != null ? snapshot.findNodeModulesDirectoryByTopLevelDependentFile(file2) : null;
    }

    private void onFileCreatedOrDeleted(@NotNull VirtualFile file2) {
        NodeModulesLibraryDirectory nodeModulesDir;
        if (file2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(42);
        }
        if ((nodeModulesDir = this.findUpNodeModules(file2)) != null) {
            if (file2.isDirectory()) {
                this.resetSnapshot();
                this.requestLibrariesUpdate();
            } else {
                nodeModulesDir.invalidateRoots();
            }
        }
    }

    private /* synthetic */ void lambda$tryAddLibrariesOnBackgroundThread$12(List dirsToProcess, NodeModulesLibrariesSnapshot snapshot) {
        WriteAction.run(() -> {
            ArrayList<Runnable> runnables;
            if (this.myProject.isDisposed()) {
                return;
            }
            Object object = this.myTestQueueLock;
            synchronized (object) {
                this.myTestQueue = new ArrayList<Runnable>();
            }
            JSLibraryManager libraryManager = this.getLibraryManager();
            libraryManager.commitChanges(false);
            for (VirtualFile nodeModulesDir : dirsToProcess) {
                String libraryName = snapshot.findLibraryName(nodeModulesDir);
                if (libraryName == null) {
                    LOG.warn("No library name calculated for " + nodeModulesDir.getPath());
                    continue;
                }
                List mappings = ContainerUtil.createMaybeSingletonList((Object)nodeModulesDir.getParent());
                if (!mappings.isEmpty()) {
                    if (libraryManager.getLibraryByName(libraryName) == null) {
                        LOG.warn("Cannot find library by name " + libraryName + ", " + nodeModulesDir.getPath());
                        continue;
                    }
                    for (VirtualFile mapping : mappings) {
                        libraryManager.getLibraryMappings().associate(mapping, libraryName, true);
                    }
                }
                LOG.info("Associate " + libraryName + " with " + mappings);
            }
            String addedNodeModulesPaths = StringUtil.join((Collection)ContainerUtil.map((Collection)dirsToProcess, dir -> dir.getPath()), (String)",");
            libraryManager.commitChanges(true, "adding " + dirsToProcess.size() + " " + StringUtil.pluralize((String)"library", (int)dirsToProcess.size()) + ": " + addedNodeModulesPaths);
            Iterator iterator = this.myTestQueueLock;
            synchronized (iterator) {
                runnables = new ArrayList<Runnable>(this.myTestQueue);
                this.myTestQueue = null;
            }
            for (Runnable runnable : runnables) {
                runnable.run();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 22: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 22: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 17: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDirectory";
                break;
            }
            case 20: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirs";
                break;
            }
            case 21: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 29: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectModelExcludedDirsCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentRootsCachedValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChecker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDirChangeTracker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDirectories";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMappings";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSnapshot";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createProjectModelExcludedDirsCache";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 22: 
            case 39: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createContentRootsCachedValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeFileIndexExtensionPreventingRecursion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesPackageJsonListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeNodeModulesPackageJsonListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedNodeModulesPaths";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isNodeModulesLibraryDirWithMappings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryWithMappings";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryAddLibrariesOnBackgroundThread";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setProvidedPackageJsonRoots";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "handleAddingPackageJson";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleRemovingPackageJson";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doRemovePackageJson";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "handlePackageJsonContentChanged";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "handleAddingNodeModulesDir";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesDir";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesDirs";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "canAddNodeModulesDir";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isAdded";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "handleRemovingNodeModulesDir";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isUnderContentRoots";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findUpNodeModules";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "onFileCreatedOrDeleted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 22: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Options {
        private static final Options DEFAULT = new Options(false);
        private final boolean myEnabledOutsideOfContentRoots;

        public Options(boolean enabledOutsideOfContentRoots) {
            this.myEnabledOutsideOfContentRoots = enabledOutsideOfContentRoots;
        }

        private boolean isEnabledOutsideOfContentRoots() {
            return this.myEnabledOutsideOfContentRoots;
        }
    }

    private class MyFileListener
    implements AsyncFileListener {
        private MyFileListener() {
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            List relevantEvents;
            if (events == null) {
                MyFileListener.$$$reportNull$$$0(0);
            }
            return (relevantEvents = ContainerUtil.filter(events, this::isRelevantEvent)).isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    for (VFileEvent event : relevantEvents) {
                        if (event instanceof VFileDeleteEvent) {
                            MyFileListener.this.fileDeleted((VFileDeleteEvent)event);
                            continue;
                        }
                        if (event instanceof VFileContentChangeEvent) {
                            MyFileListener.this.fileContentChanged((VFileContentChangeEvent)event);
                            continue;
                        }
                        if (event instanceof VFilePropertyChangeEvent) {
                            MyFileListener.this.filePropertyChanged((VFilePropertyChangeEvent)event);
                            continue;
                        }
                        if (event instanceof VFileMoveEvent) {
                            MyFileListener.this.fileMoved((VFileMoveEvent)event);
                            continue;
                        }
                        if (event instanceof VFileCreateEvent) {
                            MyFileListener.this.fileCreated((VFileCreateEvent)event);
                            continue;
                        }
                        if (!(event instanceof VFileCopyEvent)) continue;
                        MyFileListener.this.fileCopied((VFileCopyEvent)event);
                    }
                }
            };
        }

        private boolean isRelevantEvent(@NotNull VFileEvent event) {
            VirtualFile file2;
            if (event == null) {
                MyFileListener.$$$reportNull$$$0(1);
            }
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent e = (VFileCreateEvent)event;
                String fileName = e.getChildName();
                if (e.isDirectory()) {
                    if (NodeModulesDirectoryManager.this.findUpNodeModules(e.getParent()) != null) {
                        return true;
                    }
                    return NodeModulesDirectoryManager.isNodeModulesDirName(fileName);
                }
                return PackageJsonUtil.isPackageJsonFileName(fileName);
            }
            if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent e = (VFilePropertyChangeEvent)event;
                String oldName = (String)ObjectUtils.tryCast((Object)e.getOldValue(), String.class);
                String newName = (String)ObjectUtils.tryCast((Object)e.getNewValue(), String.class);
                if (!e.isRename() || Objects.equals(oldName, newName)) {
                    return false;
                }
                if (e.getFile().isDirectory()) {
                    return NodeModulesDirectoryManager.isNodeModulesDirName(oldName) || NodeModulesDirectoryManager.isNodeModulesDirName(newName);
                }
                return PackageJsonUtil.isPackageJsonFileName(oldName) || PackageJsonUtil.isPackageJsonFileName(newName);
            }
            if (event instanceof VFileDeleteEvent && (file2 = ((VFileDeleteEvent)event).getFile()).isDirectory() && NodeModulesDirectoryManager.this.findUpNodeModules(file2) != null) {
                return true;
            }
            file2 = event.getFile();
            return NodeModulesDirectoryManager.isNodeModulesDir(file2) || PackageJsonUtil.isPackageJsonFile(file2);
        }

        private void fileCreated(@NotNull VFileCreateEvent event) {
            VirtualFile file2;
            if (event == null) {
                MyFileListener.$$$reportNull$$$0(2);
            }
            if ((file2 = event.getFile()) == null) {
                return;
            }
            NodeModulesDirectoryManager.this.onFileCreatedOrDeleted(file2);
            NodeModulesDirectoryManager.this.handleAddingPackageJson(file2);
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(file2);
        }

        private void filePropertyChanged(@NotNull VFilePropertyChangeEvent event) {
            if (event == null) {
                MyFileListener.$$$reportNull$$$0(3);
            }
            VirtualFile file2 = event.getFile();
            if ("node_modules".equals(event.getOldValue())) {
                NodeModulesDirectoryManager.this.handleRemovingNodeModulesDir(file2);
            }
            if ("package.json".equals(event.getOldValue())) {
                NodeModulesDirectoryManager.this.doRemovePackageJson(file2, null);
            }
            NodeModulesDirectoryManager.this.handleAddingPackageJson(file2);
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(file2);
        }

        private void fileDeleted(@NotNull VFileDeleteEvent event) {
            if (event == null) {
                MyFileListener.$$$reportNull$$$0(4);
            }
            NodeModulesDirectoryManager.this.onFileCreatedOrDeleted(event.getFile());
            NodeModulesDirectoryManager.this.handleRemovingPackageJson(event.getFile());
            NodeModulesDirectoryManager.this.handleRemovingNodeModulesDir(event.getFile());
        }

        private void fileContentChanged(@NotNull VFileContentChangeEvent event) {
            if (event == null) {
                MyFileListener.$$$reportNull$$$0(5);
            }
            NodeModulesDirectoryManager.this.handlePackageJsonContentChanged(event.getFile());
        }

        private void fileMoved(@NotNull VFileMoveEvent event) {
            VirtualFile file2;
            if (event == null) {
                MyFileListener.$$$reportNull$$$0(6);
            }
            if (PackageJsonUtil.isPackageJsonFile(file2 = event.getFile())) {
                NodeModulesDirectoryManager.this.doRemovePackageJson(file2, event.getOldParent());
            }
            NodeModulesDirectoryManager.this.handleAddingPackageJson(file2);
            NodeModulesDirectoryManager.this.handleRemovingNodeModulesDir(file2);
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(file2);
        }

        private void fileCopied(@NotNull VFileCopyEvent event) {
            if (event == null) {
                MyFileListener.$$$reportNull$$$0(7);
            }
            NodeModulesDirectoryManager.this.handleAddingPackageJson(event.getFile());
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(event.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$MyFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRelevantEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "filePropertyChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileContentChanged";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

