/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.ui.WslDistributionComboBox;
import com.intellij.ide.IdeBundle;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddWslNodeInterpreterDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AddWslNodeInterpreterDialog.class);
    private static volatile File myWhichNodeShellScriptFile;
    private static volatile File myListNodesShellScriptFile;
    private final WslDistributionComboBox myDistComboBox;
    private final TextFieldWithHistory myNodePathComponent;
    private final JPanel myPanel;
    private final Map<WSLDistribution, List<String>> myCachedInterpreters;
    private final Map<WSLDistribution, Ref<String>> myLatestWslNodePath;
    private boolean myValidateNodePath;
    private String myAutoDetectedNodePath;

    protected AddWslNodeInterpreterDialog(@NotNull Project project, @Nullable WslNodeInterpreter interpreter) {
        if (project == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myCachedInterpreters = new HashMap<WSLDistribution, List<String>>();
        this.myLatestWslNodePath = new HashMap<WSLDistribution, Ref<String>>();
        this.myValidateNodePath = false;
        this.myAutoDetectedNodePath = "";
        this.setTitle(JavaScriptBundle.message((String)"dialog.title.wsl.node.interpreter", (Object[])new Object[]{interpreter != null ? JavaScriptBundle.message((String)"dialog.title.wsl.node.interpreter.edit", (Object[])new Object[0]) : JavaScriptBundle.message((String)"dialog.title.wsl.node.interpreter.edit.add", (Object[])new Object[0])}));
        this.myDistComboBox = new WslDistributionComboBox(interpreter != null ? interpreter.getDistribution() : null, false);
        this.myNodePathComponent = new TextFieldWithHistory();
        this.myNodePathComponent.setEditor((ComboBoxEditor)new FixedComboBoxEditor());
        this.myNodePathComponent.setHistorySize(-1);
        this.setNodePath(interpreter != null ? interpreter.getWslInterpreterPath() : "");
        this.myDistComboBox.addItemListener(e -> {
            this.myValidateNodePath = false;
            WSLDistribution distribution = (WSLDistribution)ObjectUtils.tryCast((Object)e.getItem(), WSLDistribution.class);
            if (e.getStateChange() == 1) {
                this.updateNodePathOnDistributionChanged(distribution);
            } else if (e.getStateChange() == 2 && distribution != null) {
                this.myLatestWslNodePath.put(distribution, (Ref<String>)Ref.create((Object)this.myNodePathComponent.getText()));
            }
        });
        this.loadAvailableInterpretersOnExpansion(this.myNodePathComponent);
        FormBuilder formBuilder = new FormBuilder(){

            protected int getFill(JComponent component) {
                return 2;
            }
        };
        this.myPanel = formBuilder.setAlignLabelOnRight(false).addLabeledComponent(IdeBundle.message((String)"wsl.linux.distribution.label", (Object[])new Object[0]), (JComponent)this.myDistComboBox).addLabeledComponent(JavaScriptBundle.message((String)"label.wsl.node.interpreter", (Object[])new Object[0]), (JComponent)this.myNodePathComponent).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
        this.configurePreferredWidth();
        this.init();
    }

    private void updateNodePathOnDistributionChanged(@Nullable WSLDistribution selected) {
        String text = StringUtil.notNullize((String)this.myNodePathComponent.getText());
        if (!text.isEmpty() && !text.equals(this.myAutoDetectedNodePath)) {
            return;
        }
        this.setNodePath("");
        StatusText emptyText = this.getNodePathEmptyText();
        if (emptyText != null) {
            emptyText.clear();
        }
        if (selected == null) {
            return;
        }
        Ref<String> lastPathRef = this.myLatestWslNodePath.get(selected);
        if (lastPathRef != null) {
            if (!lastPathRef.isNull()) {
                this.setNodePath((String)lastPathRef.get());
            }
            return;
        }
        if (emptyText != null) {
            emptyText.setText(JavaScriptBundle.message((String)"status.text.running.which.node", (Object[])new Object[0]));
            this.myLatestWslNodePath.put(selected, (Ref<String>)Ref.create());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String whichNodeResult = AddWslNodeInterpreterDialog.runWhichNode(selected);
                ApplicationManager.getApplication().invokeLater(() -> {
                    Ref<String> last = Objects.requireNonNull(this.myLatestWslNodePath.get(selected));
                    if (last.get() != null) {
                        return;
                    }
                    if (this.myNodePathComponent.isShowing() && selected.equals((Object)this.myDistComboBox.getSelected())) {
                        emptyText.clear();
                        if (whichNodeResult != null && StringUtil.isEmpty((String)this.myNodePathComponent.getText())) {
                            this.setNodePath(whichNodeResult);
                            this.myAutoDetectedNodePath = whichNodeResult;
                        }
                    }
                }, ModalityState.any());
            });
        }
    }

    private void setNodePath(@NlsSafe @NotNull String wslNodePath) {
        if (wslNodePath == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(1);
        }
        this.myNodePathComponent.setSelectedItem((Object)wslNodePath);
    }

    @Nullable
    private StatusText getNodePathEmptyText() {
        JBTextField field = (JBTextField)ObjectUtils.tryCast((Object)this.myNodePathComponent.getTextEditor(), JBTextField.class);
        return field != null ? field.getEmptyText() : null;
    }

    public void loadAvailableInterpretersOnExpansion(final @NotNull TextFieldWithHistory textFieldWithHistory) {
        if (textFieldWithHistory == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(2);
        }
        textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                WSLDistribution distribution = AddWslNodeInterpreterDialog.this.myDistComboBox.getSelected();
                if (distribution == null) {
                    AddWslNodeInterpreterDialog.this.setAvailableNodePaths(Collections.emptyList());
                    return;
                }
                List<String> paths = AddWslNodeInterpreterDialog.this.myCachedInterpreters.get(distribution);
                if (paths != null) {
                    AddWslNodeInterpreterDialog.this.setAvailableNodePaths(paths);
                    return;
                }
                AddWslNodeInterpreterDialog.this.setAvailableNodePaths(Collections.emptyList());
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    List<String> history = AddWslNodeInterpreterDialog.getAvailableInterpreters(distribution);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        AddWslNodeInterpreterDialog.this.myCachedInterpreters.put(distribution, history);
                        if (distribution.equals((Object)AddWslNodeInterpreterDialog.this.myDistComboBox.getSelected()) && textFieldWithHistory.isShowing()) {
                            AddWslNodeInterpreterDialog.this.setAvailableNodePaths(history);
                            if (textFieldWithHistory.isPopupVisible()) {
                                textFieldWithHistory.setPopupVisible(false);
                                textFieldWithHistory.setPopupVisible(true);
                            }
                        }
                    }, ModalityState.any());
                });
            }
        });
    }

    private void setAvailableNodePaths(@NotNull List<String> availableNodePaths) {
        if (availableNodePaths == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(3);
        }
        SwingHelper.setHistory((TextFieldWithHistory)this.myNodePathComponent, availableNodePaths, (boolean)false);
    }

    @Nullable
    private static String runWhichNode(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(4);
        }
        try {
            String prefix = "node_path_start:";
            String suffix = ":node_path_end";
            File whichNodeShellScriptFile = AddWslNodeInterpreterDialog.getOrCreateWhichNodeShellScriptFile(prefix, suffix);
            if (whichNodeShellScriptFile == null) {
                return null;
            }
            String scriptPath = distribution.getWslPath(whichNodeShellScriptFile.getAbsolutePath());
            ProcessOutput output = distribution.executeOnWsl(5000, new String[]{scriptPath});
            String stdout = output.getStdout();
            int startInd = stdout.indexOf(prefix);
            int endInd = stdout.indexOf(suffix, startInd);
            if (startInd >= 0 && endInd > 0) {
                return stdout.substring(startInd + prefix.length(), endInd);
            }
            return null;
        }
        catch (ExecutionException ignored) {
            return null;
        }
    }

    @Nullable
    private static File getOrCreateWhichNodeShellScriptFile(@NotNull String prefix, @NotNull String suffix) {
        File file2;
        if (prefix == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(5);
        }
        if (suffix == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(6);
        }
        if ((file2 = myWhichNodeShellScriptFile) == null) {
            myWhichNodeShellScriptFile = file2 = AddWslNodeInterpreterDialog.writeFile("which-node.sh", (ThrowableComputable<String, IOException>)((ThrowableComputable)() -> "/bin/bash -i -c 'echo " + prefix + "$(which node)" + suffix + "'"));
        }
        return file2;
    }

    @NotNull
    private static List<String> getAvailableInterpreters(@NotNull WSLDistribution distribution) {
        List<String> list2;
        File installationFile;
        HashSet<String> lines;
        String prefix;
        block8: {
            if (distribution == null) {
                AddWslNodeInterpreterDialog.$$$reportNull$$$0(7);
            }
            prefix = "node_path:";
            lines = new HashSet<String>();
            installationFile = AddWslNodeInterpreterDialog.getFileListingInstallations();
            if (installationFile != null) break block8;
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                AddWslNodeInterpreterDialog.$$$reportNull$$$0(8);
            }
            return list3;
        }
        try {
            ProcessOutput output = distribution.executeOnWsl(5000, new String[]{distribution.getWslPath(installationFile.getAbsolutePath())});
            for (String line : output.getStdoutLines()) {
                String path;
                if (!line.startsWith(prefix) || (path = line.substring(prefix.length()).trim()).isEmpty()) continue;
                lines.add(path);
            }
            list2 = lines.stream().sorted().collect(Collectors.toList());
        }
        catch (ExecutionException ignored) {
            List<String> list4 = Collections.emptyList();
            if (list4 == null) {
                AddWslNodeInterpreterDialog.$$$reportNull$$$0(10);
            }
            return list4;
        }
        if (list2 == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nullable
    private static File getFileListingInstallations() {
        VirtualFile file2;
        File result2 = myListNodesShellScriptFile;
        if (result2 != null) {
            return result2;
        }
        long startTime = System.nanoTime();
        String name = "find_node_installations.sh";
        URL url = AddWslNodeInterpreterDialog.class.getResource(name);
        if (url == null) {
            LOG.error("Installation is possibly broken. Cannot find " + name);
            return null;
        }
        SettableFuture future = SettableFuture.create();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                future.set((Object)((VirtualFile)WriteAction.compute(() -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.convertFromUrl((URL)url)))));
            }
            catch (Throwable e) {
                future.setException(e);
            }
        }, ModalityState.any());
        try {
            file2 = (VirtualFile)future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Cannot refresh " + url, (Throwable)e);
            return null;
        }
        if (file2 == null || !file2.isValid()) {
            LOG.error("Cannot refreshAndFind " + url);
            return null;
        }
        myListNodesShellScriptFile = result2 = AddWslNodeInterpreterDialog.writeFile(name, (ThrowableComputable<String, IOException>)((ThrowableComputable)() -> VfsUtilCore.loadText((VirtualFile)file2)));
        if (result2 != null) {
            LOG.info(result2.getAbsolutePath() + " written in " + TimeoutUtil.getDurationMillis((long)startTime) + " ms");
        }
        return result2;
    }

    @Nullable
    private static File writeFile(@NotNull String name, @NotNull ThrowableComputable<String, IOException> textComputable) {
        if (name == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(11);
        }
        if (textComputable == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(12);
        }
        try {
            Object extension = FileUtilRt.getExtension((String)name);
            if (!((String)extension).isEmpty()) {
                extension = "." + (String)extension;
            }
            File file2 = FileUtil.createTempFile((String)FileUtilRt.getNameWithoutExtension((String)name), (String)extension, (boolean)true);
            String text = (String)textComputable.compute();
            text = StringUtil.convertLineSeparators((String)text, (String)LineSeparator.LF.getSeparatorString());
            FileUtil.writeToFile((File)file2, (String)text);
            return file2;
        }
        catch (IOException e) {
            LOG.error("Cannot write temp file " + name);
            return null;
        }
    }

    private void configurePreferredWidth() {
        this.myNodePathComponent.setMinimumAndPreferredWidth(-1);
        SwingHelper.setPreferredWidth((Component)this.myNodePathComponent, (int)JBUIScale.scale((int)400));
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.myDistComboBox.isSelectedValid()) {
            return new ValidationInfo(JavaScriptBundle.message((String)"dialog.message.please.select.distribution", (Object[])new Object[0]), (JComponent)this.myDistComboBox);
        }
        if (this.myValidateNodePath && this.myNodePathComponent.getText().isEmpty()) {
            return new ValidationInfo(JavaScriptBundle.message((String)"dialog.message.please.specify.wsl.path.to.node.js.interpreter", (Object[])new Object[0]), (JComponent)this.myNodePathComponent);
        }
        return null;
    }

    @NotNull
    protected Action getOKAction() {
        return new DialogWrapper.OkAction(){

            protected void doAction(ActionEvent e) {
                AddWslNodeInterpreterDialog.this.myValidateNodePath = true;
                super.doAction(e);
            }
        };
    }

    @Nullable
    public WslNodeInterpreter showAndGetInterpreter() {
        if (this.showAndGet()) {
            WSLDistribution distribution = this.myDistComboBox.getSelected();
            String path = this.myNodePathComponent.getText();
            if (distribution != null && StringUtil.isNotEmpty((String)path)) {
                return new WslNodeInterpreter(distribution.getMsId(), path);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslNodePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWithHistory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableNodePaths";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/AddWslNodeInterpreterDialog";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComputable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/AddWslNodeInterpreterDialog";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableInterpreters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNodePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadAvailableInterpretersOnExpansion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAvailableNodePaths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runWhichNode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateWhichNodeShellScriptFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableInterpreters";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

