/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.ide.DataManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRefList;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpretersDialog;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterField
extends ComponentWithBrowseButton<ComboBox<NodeJsInterpreterRef>> {
    private static final Logger LOG = Logger.getInstance(NodeJsInterpreterField.class);
    private static final NodeJsInterpreterRef ADD_INTERPRETER = NodeJsInterpreterRef.create("#Add interpreter");
    static final NodeJsInterpreterRef NO_INTERPRETER_REF = NodeJsInterpreterRef.create("");
    private final Project myProject;
    private final KeyEventAwareComboBox myComboBox;
    private final NodeJsInterpreterComboBoxModel myModel;
    private final boolean myWithRemote;
    private final boolean myWithDownload;
    private final List<NodeJsInterpreterChangeListener> myChangeListeners;
    private NodeJsInterpreterRef myLastSelectedItem;
    private boolean myDropDownListUpdateRequested;

    public NodeJsInterpreterField(@NotNull Project project, boolean withRemote) {
        if (project == null) {
            NodeJsInterpreterField.$$$reportNull$$$0(0);
        }
        this(project, withRemote, false);
    }

    public NodeJsInterpreterField(@NotNull Project project, boolean withRemote, boolean withDownload) {
        if (project == null) {
            NodeJsInterpreterField.$$$reportNull$$$0(1);
        }
        super((JComponent)((Object)new KeyEventAwareComboBox()), null);
        this.myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLastSelectedItem = NO_INTERPRETER_REF;
        this.myDropDownListUpdateRequested = false;
        this.addActionListener(e -> this.showInterpretersDialog());
        this.myProject = project;
        this.myWithRemote = withRemote;
        this.myWithDownload = withDownload;
        this.myComboBox = (KeyEventAwareComboBox)((Object)this.getChildComponent());
        this.myModel = new NodeJsInterpreterComboBoxModel();
        this.myComboBox.setModel(this.myModel);
        this.myComboBox.setRenderer(new DelegatingListCellRenderer());
        this.myComboBox.setMinimumAndPreferredWidth(0);
        this.myModel.addElement(NO_INTERPRETER_REF);
        this.myModel.setSelectedItem(NO_INTERPRETER_REF);
        this.requestDropDownListUpdate();
        this.myComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.handleSelectedItemChange();
            }
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NodeJsInterpreterField.$$$reportNull$$$0(2);
        }
        return project;
    }

    private void handleSelectedItemChange() {
        NodeJsInterpreterRef selectedItem = this.getInterpreterRef();
        if (selectedItem == ADD_INTERPRETER) {
            this.myComboBox.setSelectedItem(this.myLastSelectedItem);
            if (!this.myComboBox.myKeyEventProcessing) {
                ApplicationManager.getApplication().invokeLater(this::showPopup, ModalityState.current());
            }
        } else if (this.myLastSelectedItem != selectedItem) {
            this.myLastSelectedItem = selectedItem;
            NodeJsInterpreter interpreter = selectedItem.resolve(this.myProject);
            for (NodeJsInterpreterChangeListener listener2 : this.myChangeListeners) {
                listener2.interpreterChanged(interpreter);
            }
        }
    }

    private void showPopup() {
        JBPopup popup = NodeJsInterpretersDialog.createAddPopup(this.myProject, this.myWithRemote, DataManager.getInstance().getDataContext((Component)((Object)this.myComboBox)), (Consumer<? super NodeJsInterpreter>)((Consumer)interpreter -> {
            NodeJsInterpreterType<? extends NodeJsInterpreter> type = interpreter.getType();
            ArrayList<? extends NodeJsInterpreter> interpreters = new ArrayList<NodeJsInterpreter>(type.getInterpreters());
            if (!interpreters.contains(interpreter)) {
                interpreters.add((NodeJsInterpreter)interpreter);
                type.setInterpreters(interpreters);
            }
            this.setInterpreterRef(interpreter.toRef());
            this.requestDropDownListUpdate();
        }));
        popup.showUnderneathOf((Component)((Object)this.myComboBox));
    }

    public boolean isDefaultProjectInterpreterField() {
        return false;
    }

    public void addChangeListener(@NotNull NodeJsInterpreterChangeListener listener2) {
        if (listener2 == null) {
            NodeJsInterpreterField.$$$reportNull$$$0(3);
        }
        this.myChangeListeners.add(listener2);
    }

    private void showInterpretersDialog() {
        NodeJsInterpretersDialog dialog = new NodeJsInterpretersDialog(this.myProject, this.isDefaultProjectInterpreterField(), this.myWithRemote, this.myWithDownload);
        Ref<NodeJsInterpreterRef> value = dialog.showAndGetSelected((NodeJsInterpreterRef)this.myModel.getSelectedItem());
        if (value != null) {
            if (value.get() != null) {
                this.setInterpreterRef((NodeJsInterpreterRef)value.get());
            }
            this.myModel.repaintSelectedElementIfMatches(this.getInterpreterRef());
            this.requestDropDownListUpdate();
        }
    }

    private void requestDropDownListUpdate() {
        if (!this.myDropDownListUpdateRequested) {
            this.myDropDownListUpdateRequested = true;
            this.myComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    NodeJsInterpreterField.this.myComboBox.removePopupMenuListener((PopupMenuListener)((Object)this));
                    NodeJsInterpreterField.this.updateDropDownList();
                    NodeJsInterpreterField.this.myDropDownListUpdateRequested = false;
                }
            });
        }
    }

    private void updateDropDownList() {
        NodeJsInterpreterRefList refList = NodeJsInterpreterRefList.create(this.myWithRemote, this.myWithDownload);
        NodeJsInterpreterRef selectedInterpreterRef = this.getInterpreterRef();
        refList.addIfMissing(selectedInterpreterRef);
        List<NodeJsInterpreterRef> refs = refList.getAllAvailableAsRefs(!this.isDefaultProjectInterpreterField());
        this.myComboBox.doWithItemStateChangedEventsDisabled(() -> {
            SwingHelper.updateItems((JComboBox)((Object)this.myComboBox), (List)refs, null);
            this.myComboBox.addItem(ADD_INTERPRETER);
        });
        if (!Objects.equals(this.myComboBox.getSelectedItem(), selectedInterpreterRef)) {
            LOG.warn("Actual selected item:" + this.myComboBox.getSelectedItem() + ", expected: " + selectedInterpreterRef);
            this.myComboBox.setSelectedItem(selectedInterpreterRef);
            this.handleSelectedItemChange();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void setInterpreter(@Nullable NodeJsInterpreter interpreter) {
        this.setInterpreterRef(NodeJsInterpreterRef.create(interpreter));
    }

    public void setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            NodeJsInterpreterField.$$$reportNull$$$0(4);
        }
        if (this.isDefaultProjectInterpreterField() && interpreterRef.isProjectRef()) {
            throw new IllegalStateException("Project default interpreter field cannot be set to '" + interpreterRef + "' value");
        }
        this.myModel.setSelectedItem(interpreterRef);
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef interpreterRef = (NodeJsInterpreterRef)this.myComboBox.getSelectedItem();
        if (interpreterRef == null) {
            LOG.warn("No interpreter ref");
            interpreterRef = NO_INTERPRETER_REF;
        }
        NodeJsInterpreterRef nodeJsInterpreterRef = interpreterRef;
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterField.$$$reportNull$$$0(5);
        }
        return nodeJsInterpreterRef;
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.getInterpreterRef().resolve(this.myProject);
    }

    public void setPreferredWidthToFitText() {
        Object item = this.myComboBox.getSelectedItem();
        if (item instanceof NodeJsInterpreterRef) {
            this.myComboBox.setMinimumAndPreferredWidth(-1);
            NodeJsInterpreterRef prevPrototype = (NodeJsInterpreterRef)this.myComboBox.getPrototypeDisplayValue();
            this.myComboBox.setPrototypeDisplayValue((NodeJsInterpreterRef)item);
            Dimension size = this.getPreferredSize();
            this.setPreferredSize(size);
            this.myComboBox.setMinimumAndPreferredWidth(0);
            this.myComboBox.setPrototypeDisplayValue(prevPrototype);
        }
    }

    @NotNull
    @NlsContexts.Label
    public static String getLabelTextForComponent() {
        String string = JavaScriptBundle.message((String)"node.interpreter.label", (Object[])new Object[0]);
        if (string == null) {
            NodeJsInterpreterField.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelTextForComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NodeJsInterpreterComboBoxModel
    extends DefaultComboBoxModel<NodeJsInterpreterRef> {
        NodeJsInterpreterComboBoxModel() {
        }

        void repaintSelectedElementIfMatches(@NotNull NodeJsInterpreterRef expectedSelectedElement) {
            if (expectedSelectedElement == null) {
                NodeJsInterpreterComboBoxModel.$$$reportNull$$$0(0);
            }
            if (this.getSelectedItem() == expectedSelectedElement) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedSelectedElement", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField$NodeJsInterpreterComboBoxModel", "repaintSelectedElementIfMatches"));
        }
    }

    private class DelegatingListCellRenderer
    implements ListCellRenderer<NodeJsInterpreterRef> {
        private final AddInterpreterRenderer myAddInterpreterRenderer = new AddInterpreterRenderer();
        private final NodeJsInterpreterRenderer myInterpreterRenderer;

        DelegatingListCellRenderer() {
            this.myInterpreterRenderer = new NodeJsInterpreterRenderer(NodeJsInterpreterField.this.myProject, true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends NodeJsInterpreterRef> list2, NodeJsInterpreterRef value, int index, boolean isSelected, boolean cellHasFocus) {
            Object renderer = value == ADD_INTERPRETER ? this.myAddInterpreterRenderer : this.myInterpreterRenderer;
            list2.setEnabled(NodeJsInterpreterField.this.isEnabled());
            return renderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
        }
    }

    private static class AddInterpreterRenderer
    extends ColoredListCellRenderer<NodeJsInterpreterRef> {
        AddInterpreterRenderer() {
            this.setIpad((Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0));
            NodeJsInterpreterRenderer.adjustBorderHeight((SimpleColoredComponent)this);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends NodeJsInterpreterRef> list2, NodeJsInterpreterRef value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                AddInterpreterRenderer.$$$reportNull$$$0(0);
            }
            if (value == ADD_INTERPRETER) {
                this.append(" " + JavaScriptBundle.message((String)"node.interpreter.field.add.item.text", (Object[])new Object[0]), new SimpleTextAttributes(0, (Color)JBColor.darkGray));
            } else {
                this.append(JavaScriptBundle.message((String)"node.interpreter.field.unexpected_value.text", (Object[])new Object[]{value}), new SimpleTextAttributes(0, (Color)JBColor.RED));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField$AddInterpreterRenderer", "customizeCellRenderer"));
        }
    }

    private static class KeyEventAwareComboBox
    extends ComboBox<NodeJsInterpreterRef> {
        private boolean myKeyEventProcessing = false;
        private boolean myItemStateChangedEventsAllowed = true;

        private KeyEventAwareComboBox() {
        }

        public void processKeyEvent(KeyEvent e) {
            this.myKeyEventProcessing = true;
            super.processKeyEvent(e);
            this.myKeyEventProcessing = false;
        }

        protected void selectedItemChanged() {
            if (this.myItemStateChangedEventsAllowed) {
                super.selectedItemChanged();
            }
        }

        public void doWithItemStateChangedEventsDisabled(@NotNull Runnable runnable) {
            if (runnable == null) {
                KeyEventAwareComboBox.$$$reportNull$$$0(0);
            }
            this.myItemStateChangedEventsAllowed = false;
            try {
                runnable.run();
            }
            finally {
                this.myItemStateChangedEventsAllowed = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField$KeyEventAwareComboBox", "doWithItemStateChangedEventsDisabled"));
        }
    }
}

